/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.eventhandler.plugin;

import com.sos.exception.SOSNoResponseException;
import com.sos.jitl.eventhandler.handler.EventHandlerSettings;
import com.sos.jitl.eventhandler.handler.ILoopEventHandler;
import com.sos.jitl.eventhandler.plugin.notifier.Mailer;
import com.sos.jitl.eventhandler.plugin.notifier.Notifier;
import com.sos.scheduler.engine.kernel.Scheduler;
import com.sos.scheduler.engine.kernel.plugin.AbstractPlugin;
import com.sos.scheduler.engine.kernel.scheduler.SchedulerXmlCommandExecutor;
import com.sos.scheduler.engine.kernel.variable.VariableSet;
import java.io.FileNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Configurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import scala.collection.JavaConversions;
import scala.collection.Map;
import sos.util.SOSString;

public class LoopEventHandlerPlugin
extends AbstractPlugin {
    public static final String DUMMY_COMMAND = "<show_state subsystems=\"folder\" what=\"folders cluster no_subfolders\" path=\"/any/path/that/does/not/exists\" />";
    private static final Logger LOGGER = LoggerFactory.getLogger(LoopEventHandlerPlugin.class);
    private static final boolean isDebugEnabled = LOGGER.isDebugEnabled();
    private static final boolean isTraceEnabled = LOGGER.isTraceEnabled();
    private static final String CLASS_NAME = LoopEventHandlerPlugin.class.getSimpleName();
    private long AWAIT_TERMINATION_TIMEOUT_EVENTHANDLER = 3L;
    private long AWAIT_TERMINATION_TIMEOUT_PLUGIN = 30L;
    private static List<ILoopEventHandler> activeHandlers = new ArrayList<ILoopEventHandler>();
    private final Scheduler scheduler;
    private final SchedulerXmlCommandExecutor xmlCommandExecutor;
    private final VariableSet variableSet;
    private final ExecutorService threadPool;
    private String identifier;
    private String schedulerParamProxyUrl;
    private String schedulerParamHibernateScheduler;
    private String schedulerParamHibernateReporting;
    private volatile Throwable exceptionOnPrepare;

    public LoopEventHandlerPlugin(Scheduler engineScheduler, SchedulerXmlCommandExecutor executor, VariableSet variables) {
        this.scheduler = engineScheduler;
        this.xmlCommandExecutor = executor;
        this.variableSet = variables;
        this.threadPool = Executors.newSingleThreadExecutor();
    }

    public void onPrepare(final ILoopEventHandler eventHandler) {
        MDC.put((String)"plugin", (String)eventHandler.getIdentifier());
        final String method = this.getMethodName("onPrepare");
        this.readJobSchedulerVariables();
        Runnable thread = new Runnable(){

            @Override
            public void run() {
                LoopEventHandlerPlugin.setPluginLoggers();
                MDC.put((String)"plugin", (String)eventHandler.getIdentifier());
                String name = Thread.currentThread().getName();
                LOGGER.info(String.format("%s[run][thread]%s", method, name));
                try {
                    eventHandler.onPrepare(LoopEventHandlerPlugin.this.getSettings());
                }
                catch (Throwable e) {
                    LOGGER.error(String.format("%s[exception]%s", method, e.toString()), e);
                    LoopEventHandlerPlugin.this.exceptionOnPrepare = e;
                }
                LOGGER.info(String.format("%s[end][thread]%s", method, name));
            }
        };
        this.threadPool.submit(thread);
        super.onPrepare();
        MDC.remove((String)"plugin");
    }

    public void onActivate(final ILoopEventHandler eventHandler) {
        MDC.put((String)"plugin", (String)eventHandler.getIdentifier());
        final String method = this.getMethodName("onActivate");
        activeHandlers.add(eventHandler);
        if (eventHandler.getSettings() == null) {
            this.readJobSchedulerVariables();
        }
        final Mailer mailer = this.getMailer();
        final Class<?> clazz = ((Object)((Object)this)).getClass();
        Runnable thread = new Runnable(){

            @Override
            public void run() {
                LoopEventHandlerPlugin.setPluginLoggers();
                MDC.put((String)"plugin", (String)eventHandler.getIdentifier());
                String name = Thread.currentThread().getName();
                LOGGER.info(String.format("%s[run][thread]%s", method, name));
                try {
                    if (LoopEventHandlerPlugin.this.exceptionOnPrepare != null) {
                        mailer.sendOnError(CLASS_NAME, "onPrepare", LoopEventHandlerPlugin.this.exceptionOnPrepare);
                        LoopEventHandlerPlugin.this.exceptionOnPrepare = null;
                    }
                    if (eventHandler.getSettings() == null) {
                        eventHandler.setSettings(LoopEventHandlerPlugin.this.getSettings());
                    }
                    eventHandler.onActivate(new Notifier(mailer, clazz));
                }
                catch (Throwable e) {
                    LOGGER.error(String.format("%s[exception]%s", method, e.toString()), e);
                    mailer.sendOnError(CLASS_NAME, "onActivate", e);
                }
                LOGGER.info(String.format("%s[end][thread]%s", method, name));
            }
        };
        this.threadPool.submit(thread);
        super.onActivate();
        MDC.remove((String)"plugin");
    }

    public void close() {
        String method = this.getMethodName("close");
        LOGGER.debug(method);
        this.closeEventHandlers();
        this.shutdownThreadPool(method, this.threadPool, this.AWAIT_TERMINATION_TIMEOUT_PLUGIN);
        super.close();
    }

    private Mailer getMailer() {
        java.util.Map mailDefaults = JavaConversions.mapAsJavaMap((Map)this.scheduler.mailDefaults());
        Mailer mailer = new Mailer(this.identifier, mailDefaults);
        if (isDebugEnabled) {
            LOGGER.debug(String.format("%s[mailDefaults]%s", this.getMethodName("onActivate"), mailDefaults));
        }
        return mailer;
    }

    private void closeEventHandlers() {
        final String method = this.getMethodName("closeEventHandlers");
        int size = activeHandlers.size();
        if (size > 0) {
            ExecutorService threadPool = Executors.newFixedThreadPool(size);
            for (int i = 0; i < size; ++i) {
                final ILoopEventHandler eh = activeHandlers.get(i);
                Runnable thread = new Runnable(){

                    @Override
                    public void run() {
                        LoopEventHandlerPlugin.setPluginLoggers();
                        MDC.put((String)"plugin", (String)eh.getIdentifier());
                        String name = Thread.currentThread().getName();
                        if (isDebugEnabled) {
                            LOGGER.debug(String.format("%s[%s][run][thread]%s", method, eh.getIdentifier(), name));
                        }
                        eh.close();
                        if (isDebugEnabled) {
                            LOGGER.debug(String.format("%s[%s][end][thread]%s", method, eh.getIdentifier(), name));
                        }
                        MDC.remove((String)"plugin");
                    }
                };
                threadPool.submit(thread);
            }
            this.shutdownThreadPool(method, threadPool, this.AWAIT_TERMINATION_TIMEOUT_EVENTHANDLER);
            activeHandlers = new ArrayList<ILoopEventHandler>();
        } else if (isDebugEnabled) {
            LOGGER.debug(String.format("%s[skip]already closed", method));
        }
    }

    private void shutdownThreadPool(String callerMethod, ExecutorService threadPool, long awaitTerminationTimeout) {
        try {
            threadPool.shutdown();
            boolean shutdown = threadPool.awaitTermination(awaitTerminationTimeout, TimeUnit.SECONDS);
            if (isDebugEnabled) {
                if (shutdown) {
                    LOGGER.debug(String.format("%sthread has been shut down correctly", callerMethod));
                } else {
                    LOGGER.debug(String.format("%sthread has ended due to timeout of %ss on shutdown", callerMethod, awaitTerminationTimeout));
                }
            }
        }
        catch (InterruptedException e) {
            LOGGER.error(String.format("%s[exception]%s", callerMethod, e.toString()), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private EventHandlerSettings getSettings() throws Exception {
        String method = this.getMethodName("getSettings");
        if (this.xmlCommandExecutor == null) {
            throw new Exception("xmlCommandExecutor is null");
        }
        EventHandlerSettings settings = new EventHandlerSettings();
        for (int i = 0; i < 120; ++i) {
            block22: {
                String answer = this.xmlCommandExecutor.executeXml(DUMMY_COMMAND);
                if (SOSString.isEmpty((String)answer)) break block22;
                settings.setSchedulerAnswer(answer);
                String state = settings.getSchedulerAnswer("/spooler/answer/state/@state");
                if (isTraceEnabled) {
                    LOGGER.trace(String.format("%s[%s][state]%s", method, i, state));
                }
                if (!"loading,running,waiting_for_activation,waiting_for_activation_paused,paused".contains(state)) break block22;
                try {
                    Thread.sleep(1000L);
                }
                catch (Throwable e) {
                    LOGGER.error(String.format("%s[exception]%s", method, e.toString()), e);
                }
                break;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (Throwable e) {
                LOGGER.error(String.format("%s[exception]%s", method, e.toString()), e);
            }
            continue;
            catch (Throwable e) {
                try {
                    LOGGER.error(String.format("%s[exception]%s", method, e.toString()), e);
                }
                catch (Throwable throwable) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Throwable e2) {
                        LOGGER.error(String.format("%s[exception]%s", method, e2.toString()), e2);
                    }
                    throw throwable;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (Throwable e3) {
                    LOGGER.error(String.format("%s[exception]%s", method, e3.toString()), e3);
                }
                continue;
            }
        }
        if (SOSString.isEmpty((String)settings.getSchedulerAnswer())) {
            throw new SOSNoResponseException(String.format("%s[error]missing JobScheduler answer", method));
        }
        if (isTraceEnabled) {
            LOGGER.trace(String.format("%s[answer]%s", method, settings.getSchedulerAnswer()));
        }
        settings.setSchedulerXml(Paths.get(settings.getSchedulerAnswer("/spooler/answer/state/@config_file"), new String[0]));
        if (settings.getSchedulerXml() == null || !Files.exists(settings.getSchedulerXml(), new LinkOption[0])) {
            throw new FileNotFoundException(String.format("not found settings.xml file %s", settings.getSchedulerXml()));
        }
        settings.setConfigDirectory(settings.getSchedulerXml().getParent());
        settings.setHibernateConfigurationScheduler(this.getHibernateConfigurationScheduler(settings.getConfigDirectory()));
        settings.setHibernateConfigurationReporting(this.getHibernateConfigurationReporting(settings.getConfigDirectory(), settings.getHibernateConfigurationScheduler()));
        if (isDebugEnabled) {
            LOGGER.debug(String.format("%s[scheduler=%s][reporting=%s]", method, settings.getHibernateConfigurationScheduler(), settings.getHibernateConfigurationReporting()));
        }
        settings.setLiveDirectory(settings.getConfigDirectory().resolve("live"));
        settings.setSchedulerId(settings.getSchedulerAnswer("/spooler/answer/state/@spooler_id"));
        settings.setHost(settings.getSchedulerAnswer("/spooler/answer/state/@host"));
        HostPort http = new HostPort(settings.getSchedulerAnswer("/spooler/answer/state/@http_port", "40444"));
        settings.setHttpHost(http.getHost());
        settings.setHttpPort(http.getPort());
        HostPort https = new HostPort(settings.getSchedulerAnswer("/spooler/answer/state/@https_port"));
        settings.setHttpsHost(https.getHost());
        settings.setHttpsPort(https.getPort());
        settings.setTcpPort(settings.getSchedulerAnswer("/spooler/answer/state/@tcp_port"));
        settings.setUdpPort(settings.getSchedulerAnswer("/spooler/answer/state/@udp_port"));
        settings.setRunningSince(settings.getSchedulerAnswer("/spooler/answer/state/@spooler_running_since"));
        settings.setTime(settings.getSchedulerAnswer("/spooler/answer/state/@time"));
        settings.setTimezone(settings.getSchedulerAnswer("/spooler/answer/state/@time_zone"));
        settings.setVersion(settings.getSchedulerAnswer("/spooler/answer/state/@version"));
        settings.setState(settings.getSchedulerAnswer("/spooler/answer/state/@state"));
        if (SOSString.isEmpty((String)settings.getSchedulerId())) {
            throw new Exception(String.format("%s missing @spooler_id in the scheduler answer", method));
        }
        if (SOSString.isEmpty((String)settings.getHost())) {
            throw new Exception(String.format("%s missing @host in the scheduler answer", method));
        }
        if (SOSString.isEmpty((String)settings.getHttpPort())) {
            throw new Exception(String.format("%s missing @http_port in the scheduler answer", method));
        }
        return settings;
    }

    private Path getHibernateConfigurationScheduler(Path configDirectory) throws Exception {
        String method = this.getMethodName("getHibernateConfigurationScheduler");
        Path file = null;
        if (SOSString.isEmpty((String)this.schedulerParamHibernateScheduler)) {
            if (isTraceEnabled) {
                LOGGER.trace(String.format("%s[%s is null or empty]use %s", method, "sos.hibernate_configuration_scheduler", "hibernate.cfg.xml"));
            }
            file = configDirectory.resolve("hibernate.cfg.xml");
        } else {
            if (isTraceEnabled) {
                LOGGER.trace(String.format("%s[%s]use %s", method, "sos.hibernate_configuration_scheduler", this.schedulerParamHibernateScheduler));
            }
            file = Paths.get(this.schedulerParamHibernateScheduler, new String[0]);
        }
        if (!Files.exists(file, new LinkOption[0])) {
            throw new FileNotFoundException(String.format("%s not found scheduler hibernate file %s", method, file.toString()));
        }
        return file;
    }

    private Path getHibernateConfigurationReporting(Path configDirectory, Path hibernateScheduler) throws Exception {
        String method = this.getMethodName("getHibernateConfigurationReporting");
        Path file = null;
        if (SOSString.isEmpty((String)this.schedulerParamHibernateReporting)) {
            if (isTraceEnabled) {
                LOGGER.trace(String.format("%s[%s is null or empty]use %s", method, "sos.hibernate_configuration_reporting", "reporting.hibernate.cfg.xml"));
            }
            if (!Files.exists(file = configDirectory.resolve("reporting.hibernate.cfg.xml"), new LinkOption[0])) {
                if (isTraceEnabled) {
                    LOGGER.trace(String.format("%s[%s not founded]use %s", method, "sos.hibernate_configuration_reporting", hibernateScheduler));
                }
                file = hibernateScheduler;
            }
        } else {
            if (isTraceEnabled) {
                LOGGER.trace(String.format("%s[%s]use %s", method, "sos.hibernate_configuration_reporting", this.schedulerParamHibernateReporting));
            }
            if (!Files.exists(file = Paths.get(this.schedulerParamHibernateReporting, new String[0]), new LinkOption[0])) {
                throw new FileNotFoundException(String.format("%s not found reporting hibernate file %s", method, file.toString()));
            }
        }
        return file;
    }

    private void readJobSchedulerVariables() {
        this.schedulerParamProxyUrl = this.getJobSchedulerVariable("sos.proxy_url");
        this.schedulerParamHibernateScheduler = this.getJobSchedulerVariable("sos.hibernate_configuration_scheduler");
        this.schedulerParamHibernateReporting = this.getJobSchedulerVariable("sos.hibernate_configuration_reporting");
    }

    public String getJobSchedulerVariable(String name) {
        String val = this.variableSet.apply(name);
        if (val != null && !val.isEmpty()) {
            return val;
        }
        return null;
    }

    private String getMethodName(String name) {
        String prefix = this.identifier == null ? "" : String.format("[%s]", this.identifier);
        return String.format("%s[%s]", prefix, name);
    }

    public void setIdentifier(String val) {
        this.identifier = val;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public static void setPluginLoggers() {
        try {
            LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
            Configuration configuration = context.getConfiguration();
            Optional<AppenderRef> appenderRef = configuration.getRootLogger().getAppenderRefs().stream().filter(a -> "Plugins".equalsIgnoreCase(a.getRef())).findAny();
            if (appenderRef.isPresent() && appenderRef.get().getLevel().isLessSpecificThan(Level.OFF) && context.getRootLogger().getLevel().isMoreSpecificThan(appenderRef.get().getLevel())) {
                Configurator.setRootLevel((Level)appenderRef.get().getLevel());
                if (appenderRef.get().getLevel().isLessSpecificThan(Level.INFO)) {
                    Configurator.setLevel((String)"com.mchange", (Level)Level.INFO);
                    Configurator.setLevel((String)"org.hibernate", (Level)Level.INFO);
                    LOGGER.info("Adjust the log level of 'org.hibernate' to INFO");
                    Configurator.setLevel((String)"org.hibernate.persister.entity.AbstractEntityPersister", (Level)Level.DEBUG);
                    Configurator.setLevel((String)"org.hibernate.SQL", (Level)Level.DEBUG);
                    Configurator.setLevel((String)"org.hibernate.loader.entity.plan.EntityLoader", (Level)Level.DEBUG);
                } else if (appenderRef.get().getLevel().isLessSpecificThan(Level.DEBUG)) {
                    Configurator.setLevel((String)"com.mchange", (Level)Level.INFO);
                    Configurator.setLevel((String)"org.hibernate", (Level)Level.INFO);
                    LOGGER.info("Adjust the log level of 'org.hibernate' to INFO");
                    Configurator.setLevel((String)"org.hibernate.persister.entity.AbstractEntityPersister", (Level)Level.DEBUG);
                    Configurator.setLevel((String)"org.hibernate.SQL", (Level)Level.DEBUG);
                    Configurator.setLevel((String)"org.hibernate.loader.entity.plan.EntityLoader", (Level)Level.DEBUG);
                    Configurator.setLevel((String)"org.hibernate.type.descriptor.sql", (Level)Level.TRACE);
                }
                LOGGER.info("Adjust the root log level to the plugin's log level: " + context.getRootLogger().getLevel());
            }
        }
        catch (Exception e) {
            LOGGER.warn("Failed to adjust the root log level to the plugin's log level", (Throwable)e);
        }
    }

    private class HostPort {
        private String host;
        private String port;

        public HostPort(String hostAdnPort) {
            if (hostAdnPort != null) {
                this.host = "localhost";
                String[] arr = hostAdnPort.split(":");
                switch (arr.length) {
                    case 1: {
                        this.port = hostAdnPort;
                        break;
                    }
                    default: {
                        if (!arr[0].equalsIgnoreCase(this.host) && !arr[0].equals("0.0.0.0")) {
                            this.host = arr[0];
                        }
                        this.port = arr[1];
                    }
                }
            }
        }

        public String getHost() {
            return this.host;
        }

        public String getPort() {
            return this.port;
        }
    }
}

