/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.eventhandler.plugin.notifier;

import com.sos.jitl.eventhandler.plugin.notifier.Mailer;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.util.SOSDate;
import sos.util.SOSString;

public class Notifier {
    private static final Logger LOGGER = LoggerFactory.getLogger(Notifier.class);
    private static final boolean isDebugEnabled = LOGGER.isDebugEnabled();
    private final Mailer mailer;
    private final String caller;
    private boolean notifyFirstErrorAsWarning;
    private ErrorNotifier errorNotifier = new ErrorNotifier();
    private int notifyInterval = 5;

    public Notifier(Mailer pluginMailer, Class<?> clazz) {
        this.mailer = pluginMailer;
        this.caller = clazz.getSimpleName();
    }

    private Notifier(Mailer pluginMailer, String clazzName) {
        this.mailer = pluginMailer;
        this.caller = clazzName;
    }

    public Notifier newInstance() {
        return new Notifier(this.mailer, this.caller);
    }

    public boolean smartNotifyOnError(Class<?> clazz, Throwable e) {
        return this.smartNotifyOnError(clazz, null, e);
    }

    public boolean smartNotifyOnError(Class<?> clazz, String bodyPart, Throwable e) {
        return this.smartNotifyOnError(clazz, bodyPart, e, this.notifyInterval);
    }

    public boolean smartNotifyOnError(Class<?> clazz, String bodyPart, Throwable e, int notifyInterval) {
        if (this.errorNotifier.getException() != null && e != null && !this.errorNotifier.getException().getClass().equals(e.getClass())) {
            this.reset();
        }
        this.errorNotifier.addCounter();
        if (this.errorNotifier.calculate()) {
            if (this.notifyFirstErrorAsWarning && this.errorNotifier.getCounter() == 1L) {
                if (isDebugEnabled) {
                    LOGGER.debug(String.format("[%s][sendOnWarning]%s", this.caller, e.toString()));
                }
                this.mailer.sendOnWarning(this.caller, clazz.getSimpleName(), bodyPart, e);
            } else {
                if (isDebugEnabled) {
                    LOGGER.debug(String.format("[%s][sendOnError]%s", this.caller, e.toString()));
                }
                if (this.errorNotifier.getCounter() > 1L) {
                    String msg = "This error has now occurs " + this.errorNotifier.getCounter() + " times.";
                    if (SOSString.isEmpty((String)bodyPart)) {
                        bodyPart = msg;
                    } else {
                        StringBuilder sb = new StringBuilder(msg);
                        sb.append(String.format("%s", "\r\n"));
                        sb.append(bodyPart);
                        bodyPart = sb.toString();
                    }
                }
                this.mailer.sendOnError(this.caller, clazz.getSimpleName(), bodyPart, e);
            }
            this.errorNotifier.setException(e);
            this.errorNotifier.setCaller(clazz);
            return true;
        }
        LOGGER.error(String.format("[%s][reoccurred][%s]%s", clazz.getSimpleName(), this.errorNotifier.getCounter(), e.toString()));
        return false;
    }

    public boolean smartNotifyOnRecovery() {
        if (this.errorNotifier.getCounter() > 0L) {
            if (isDebugEnabled) {
                LOGGER.debug(String.format("[%s][smartNotifyOnRecovery]%s", this.caller, this.errorNotifier.getException() == null ? "lastException is null" : this.errorNotifier.getException().toString()));
            }
            this.mailer.sendOnRecovery(this.caller, this.errorNotifier.getCaller().getSimpleName(), this.errorNotifier.getException());
            this.reset();
            return true;
        }
        return false;
    }

    public void notifyOnError(String callerMethod, Throwable e) {
        this.notifyOnError(callerMethod, null, e);
    }

    public void notifyOnError(String callerMethod, String bodyPart, Throwable e) {
        this.mailer.sendOnError(this.caller, callerMethod, bodyPart, e);
    }

    public void setNotifyFirstErrorAsWarning(boolean val) {
        this.notifyFirstErrorAsWarning = val;
    }

    public boolean geNotifyFirstErrorAsWarning() {
        return this.notifyFirstErrorAsWarning;
    }

    public void setNotifyInterval(int val) {
        this.notifyInterval = val;
    }

    public int getNotifyInterval() {
        return this.notifyInterval;
    }

    private void reset() {
        this.errorNotifier = new ErrorNotifier();
    }

    private class ErrorNotifier {
        private long counter = 0L;
        private Long last = new Long(0L);
        private Throwable exception;
        private Class<?> caller;

        private ErrorNotifier() {
        }

        public void addCounter() {
            ++this.counter;
        }

        public long getCounter() {
            return this.counter;
        }

        public boolean calculate() {
            Long current = SOSDate.getMinutes((Date)new Date());
            if (isDebugEnabled) {
                LOGGER.debug(String.format("[%s][notifyInterval=%sm][diff=%sm][current=%sm, last=%sm]", this.caller, Notifier.this.notifyInterval, current - this.last, current, this.last));
            }
            if (current - this.last >= (long)Notifier.this.notifyInterval) {
                this.last = current;
                return true;
            }
            return false;
        }

        public Throwable getException() {
            return this.exception;
        }

        public void setException(Throwable val) {
            this.exception = val;
        }

        public void setCaller(Class<?> val) {
            this.caller = val;
        }

        public Class<?> getCaller() {
            return this.caller;
        }
    }
}

