/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.eventing.db;

import com.sos.hibernate.classes.DbItem;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@Table(name="REPORTING_CUSTOM_EVENTS")
@SequenceGenerator(name="REPORTING_CUSTOM_EVENTS", sequenceName="REPORTING_RCE_ID_SEQ", allocationSize=1)
public class SchedulerEventDBItem
extends DbItem {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchedulerEventDBItem.class);
    private long id;
    private String schedulerId;
    private String remoteUrl;
    private String remoteSchedulerHost;
    private Integer remoteSchedulerPort;
    private String jobChain;
    private String orderId;
    private String jobName;
    private String eventClass;
    private String eventId;
    private Integer exitCode = 0;
    private String parameters;
    private Date created;
    private Date expires;

    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="REPORTING_CUSTOM_EVENTS")
    @Column(name="[ID]", nullable=false)
    public Long getId() {
        return this.id;
    }

    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="REPORTING_CUSTOM_EVENTS")
    @Column(name="[ID]", nullable=false)
    public void setId(Long id) {
        this.id = id;
    }

    @Column(name="[SCHEDULER_ID]", nullable=false)
    public void setSchedulerId(String schedulerId) {
        this.schedulerId = schedulerId;
    }

    @Column(name="[SCHEDULER_ID]", nullable=true)
    public String getSchedulerId() {
        return this.schedulerId;
    }

    @Column(name="[REMOTE_URL]", nullable=true)
    public String getRemoteUrl() {
        return this.remoteUrl;
    }

    @Column(name="[REMOTE_URL]", nullable=true)
    public void setRemoteUrl(String remoteUrl) {
        this.remoteUrl = remoteUrl;
    }

    @Column(name="[REMOTE_SCHEDULER_HOST]", nullable=true)
    public void setRemoteSchedulerHost(String remoteSchedulerHost) {
        this.remoteSchedulerHost = remoteSchedulerHost;
    }

    @Column(name="[REMOTE_SCHEDULER_HOST]", nullable=true)
    public String getRemoteSchedulerHost() {
        return this.remoteSchedulerHost;
    }

    @Column(name="[REMOTE_SCHEDULER_PORT]", nullable=true)
    public void setRemoteSchedulerPort(Integer remoteSchedulerPort) {
        this.remoteSchedulerPort = remoteSchedulerPort;
    }

    public void setRemoteSchedulerPort(String remoteSchedulerPort) {
        try {
            this.remoteSchedulerPort = Integer.parseInt(remoteSchedulerPort);
        }
        catch (NumberFormatException e) {
            LOGGER.warn("NumberFormatException: could not set remoteSchedulerPort: " + this.exitCode);
        }
    }

    @Column(name="[REMOTE_SCHEDULER_PORT]", nullable=true)
    public Integer getRemoteSchedulerPort() {
        return this.remoteSchedulerPort;
    }

    @Column(name="[JOB_NAME]", nullable=true)
    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    @Column(name="[JOB_NAME]", nullable=true)
    public String getJobName() {
        return this.jobName;
    }

    @Transient
    public String getJobNotNull() {
        return this.null2Blank(this.jobName);
    }

    @Column(name="[ORDER_ID]", nullable=true)
    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    @Column(name="[ORDER_ID]", nullable=true)
    public String getOrderId() {
        return this.orderId;
    }

    @Transient
    public String getOrderIdNotNull() {
        return this.null2Blank(this.orderId);
    }

    @Column(name="[JOB_CHAIN]", nullable=true)
    public void setJobChain(String jobChain) {
        this.jobChain = jobChain;
    }

    @Column(name="[JOB_CHAIN]", nullable=true)
    public String getJobChain() {
        return this.jobChain;
    }

    @Transient
    public String getJobChainNotNull() {
        return this.null2Blank(this.jobChain);
    }

    @Column(name="[EVENT_CLASS]", nullable=true)
    public void setEventClass(String eventClass) {
        this.eventClass = eventClass;
    }

    @Column(name="[EVENT_CLASS]", nullable=true)
    public String getEventClass() {
        return this.eventClass;
    }

    @Column(name="[EVENT_ID]", nullable=true)
    public void setEventId(String eventId) {
        this.eventId = eventId;
    }

    @Column(name="[EVENT_ID]", nullable=true)
    public String getEventId() {
        return this.eventId;
    }

    @Column(name="[EXIT_CODE]", nullable=false)
    public void setExitCode(Integer exitCode) {
        this.exitCode = exitCode;
    }

    public void setExitCode(String exitCode) {
        try {
            this.exitCode = Integer.parseInt(exitCode);
        }
        catch (NumberFormatException e) {
            LOGGER.warn("NumberFormatException: could not set exit code: " + exitCode);
        }
    }

    @Column(name="[EXIT_CODE]", nullable=false)
    public Integer getExitCode() {
        return this.exitCode;
    }

    @Column(name="[CREATED]", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    public void setCreated(Date created) {
        this.created = created;
    }

    @Column(name="[CREATED]", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getCreated() {
        return this.created;
    }

    @Column(name="[EXPIRES]", nullable=true)
    @Temporal(value=TemporalType.TIMESTAMP)
    public void setExpires(Date expires) {
        this.expires = expires;
    }

    @Column(name="[EXPIRES]", nullable=true)
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getExpires() {
        return this.expires;
    }

    @Column(name="[PARAMETERS]", nullable=true)
    public String getParameters() {
        return this.parameters;
    }

    @Column(name="[PARAMETERS]", nullable=true)
    public void setParameters(String parameters) {
        this.parameters = parameters;
    }

    @Transient
    private HashMap<String, String> properties() {
        HashMap<String, String> attr = new HashMap<String, String>();
        attr.put("event_class", this.eventClass);
        attr.put("event_id", this.eventId);
        attr.put("job_name", this.jobName);
        attr.put("job_chain", this.jobChain);
        attr.put("order_id", this.orderId);
        attr.put("exit_code", String.valueOf(this.exitCode));
        attr.put("remote_scheduler_host", this.remoteSchedulerHost);
        attr.put("remote_scheduler_port", String.valueOf(this.remoteSchedulerPort));
        attr.put("scheduler_id", this.schedulerId);
        return attr;
    }

    @Transient
    public boolean isEqual(SchedulerEventDBItem eActive) {
        boolean erg = true;
        Iterator<String> iProperties = this.properties().keySet().iterator();
        while (iProperties.hasNext()) {
            String trigger = iProperties.next().toString();
            if ("".equals(this.properties().get(trigger)) || eActive.properties().get(trigger) == null || "expires".equalsIgnoreCase(trigger) || "created".equalsIgnoreCase(trigger) || eActive.properties().get(trigger).equals(this.properties().get(trigger))) continue;
            erg = false;
        }
        return erg;
    }

    @Transient
    public boolean isIn(List<SchedulerEventDBItem> listOfActiveEvents) {
        boolean erg = false;
        Iterator<SchedulerEventDBItem> i = listOfActiveEvents.iterator();
        while (i.hasNext() && !erg) {
            if (!this.isEqual(i.next())) continue;
            erg = true;
        }
        return erg;
    }

    @Transient
    public String getEventName() {
        if ("".equals(this.eventClass)) {
            return this.eventId;
        }
        return this.eventClass + "." + this.eventId;
    }

    @Transient
    public String getRemoteSchedulerPortAsString() {
        if (this.remoteSchedulerPort != null) {
            return String.valueOf(this.remoteSchedulerPort);
        }
        return null;
    }

    @Transient
    public String getExpiresAsString() {
        if (this.getExpires() == null) {
            return null;
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return formatter.format(this.getExpires());
    }

    @Transient
    public String getCreatedAsString() {
        if (this.getCreated() == null) {
            return "";
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return formatter.format(this.getCreated());
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.eventId).append((Object)this.eventClass).append((Object)this.exitCode).toHashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof SchedulerEventDBItem)) {
            return false;
        }
        SchedulerEventDBItem rhs = (SchedulerEventDBItem)((Object)other);
        return new EqualsBuilder().append((Object)this.eventId, (Object)rhs.eventId).append((Object)this.eventClass, (Object)rhs.eventClass).append((Object)this.exitCode, (Object)rhs.exitCode).isEquals();
    }

    @Transient
    public String getExitCodeAsString() {
        return String.valueOf(this.exitCode);
    }
}

