/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.housekeeping.cleanupdb;

import com.sos.JSHelper.Basics.JSJobUtilitiesClass;
import com.sos.JSHelper.Exceptions.JobSchedulerException;
import com.sos.hibernate.classes.SOSHibernateFactory;
import com.sos.hibernate.classes.SOSHibernateSession;
import com.sos.jitl.dailyplan.db.DailyPlanDBLayer;
import com.sos.jitl.housekeeping.cleanupdb.JobSchedulerCleanupSchedulerDbOptions;
import com.sos.jitl.reporting.db.DBLayer;
import com.sos.jitl.schedulerhistory.db.SchedulerOrderHistoryDBLayer;
import com.sos.jitl.schedulerhistory.db.SchedulerTaskHistoryDBLayer;
import com.sos.scheduler.messages.JSMessages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobSchedulerCleanupSchedulerDb
extends JSJobUtilitiesClass<JobSchedulerCleanupSchedulerDbOptions> {
    protected JobSchedulerCleanupSchedulerDbOptions objOptions = null;
    private final String conClassName = "JobSchedulerCleanupSchedulerDb";
    private static Logger logger = LoggerFactory.getLogger(JobSchedulerCleanupSchedulerDb.class);

    public JobSchedulerCleanupSchedulerDb() {
        super((Object)new JobSchedulerCleanupSchedulerDbOptions());
    }

    public JobSchedulerCleanupSchedulerDbOptions getOptions() {
        if (this.objOptions == null) {
            this.objOptions = new JobSchedulerCleanupSchedulerDbOptions();
        }
        return this.objOptions;
    }

    private SOSHibernateSession getSession(String confFile) throws Exception {
        SOSHibernateFactory sosHibernateFactory = new SOSHibernateFactory(confFile);
        sosHibernateFactory.addClassMapping(DBLayer.getReportingClassMapping());
        sosHibernateFactory.addClassMapping(DBLayer.getSchedulerClassMapping());
        sosHibernateFactory.addClassMapping(DBLayer.getYadeClassMapping());
        sosHibernateFactory.build();
        return sosHibernateFactory.openStatelessSession();
    }

    public JobSchedulerCleanupSchedulerDb Execute() throws Exception {
        SOSHibernateSession session;
        block11: {
            String conMethodName = "JobSchedulerCleanupSchedulerDb::Execute";
            logger.debug(String.format(JSMessages.JSJ_I_110.get(), "JobSchedulerCleanupSchedulerDb::Execute"));
            session = null;
            try {
                long i;
                this.getOptions().checkMandatory();
                logger.debug(this.getOptions().dirtyString());
                session = this.getSession(this.getOptions().hibernate_configuration_file_scheduler.getValue());
                if (this.getOptions().cleanup_job_scheduler_history_execute.isTrue()) {
                    SchedulerOrderHistoryDBLayer schedulerOrderHistoryDBLayer = new SchedulerOrderHistoryDBLayer(session);
                    if (!this.getOptions().delete_history_interval.isDirty()) {
                        this.getOptions().delete_history_interval.setValue(this.getOptions().delete_interval.getValue());
                    }
                    i = schedulerOrderHistoryDBLayer.deleteInterval(this.getOptions().delete_history_interval.value(), this.getOptions().cleanup_jobscheduler_history_limit.value());
                    logger.info(String.format("%s records deleted from SCHEDULER_ORDER_HISTORY that are older than %s days", i, this.getOptions().delete_history_interval.getValue()));
                    SchedulerTaskHistoryDBLayer schedulerTaskHistoryDBLayer = new SchedulerTaskHistoryDBLayer(session);
                    i = schedulerTaskHistoryDBLayer.deleteInterval(this.getOptions().delete_history_interval.value(), this.getOptions().cleanup_jobscheduler_history_limit.value());
                    logger.info(String.format("%s records deleted from SCHEDULER_HISTORY that are older than %s days", i, this.getOptions().delete_history_interval.getValue()));
                } else {
                    logger.info("Records in SCHEDULER_ORDER_HISTORY and SCHEDULER_HISTORY will not be deleted");
                }
                if (this.getOptions().cleanup_daily_plan_execute.isTrue()) {
                    DailyPlanDBLayer dailyPlanDBLayer = new DailyPlanDBLayer(session);
                    if (!this.getOptions().delete_daily_plan_interval.isDirty()) {
                        this.getOptions().delete_daily_plan_interval.setValue(this.getOptions().delete_interval.getValue());
                    }
                    i = dailyPlanDBLayer.deleteInterval(this.getOptions().delete_daily_plan_interval.value(), this.getOptions().cleanup_daily_plan_limit.value());
                    logger.info(String.format("%s records deleted from DAILY_PLAN that are older than %s days", i, this.getOptions().delete_history_interval.getValue()));
                    break block11;
                }
                logger.info("Records in DAILY_PLAN will not be deleted");
            }
            catch (Exception e) {
                try {
                    String strM = String.format(JSMessages.JSJ_F_107.get(), "JobSchedulerCleanupSchedulerDb::Execute");
                    throw new JobSchedulerException(strM, (Throwable)e);
                }
                catch (Throwable throwable) {
                    logger.debug(String.format(JSMessages.JSJ_I_111.get(), "JobSchedulerCleanupSchedulerDb::Execute"));
                    if (session != null) {
                        SOSHibernateFactory factory = session.getFactory();
                        session.close();
                        factory.close();
                    }
                    throw throwable;
                }
            }
        }
        logger.debug(String.format(JSMessages.JSJ_I_111.get(), "JobSchedulerCleanupSchedulerDb::Execute"));
        if (session != null) {
            SOSHibernateFactory factory = session.getFactory();
            session.close();
            factory.close();
        }
        return this;
    }
}

