/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.inventory.helper;

import com.google.common.base.Charsets;
import com.sos.exception.SOSBadRequestException;
import com.sos.exception.SOSNoResponseException;
import com.sos.jitl.inventory.helper.CallableAgent;
import com.sos.jitl.reporting.db.DBItemInventoryAgentInstance;
import com.sos.jitl.restclient.JobSchedulerRestApiClient;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.concurrent.Callable;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.utils.URIBuilder;

public class InventoryAgentCallable
implements Callable<CallableAgent> {
    private static final String MASTER_WEBSERVICE_URL_APPEND = "/jobscheduler/master/api/agent/";
    private static final String AGENT_WEBSERVICE_URL_APPEND = "/jobscheduler/agent/api";
    private static final String ACCEPT_HEADER = "Accept";
    private static final String CONTENT_TYPE_HEADER = "Content-Type";
    private static final String APPLICATION_HEADER_VALUE = "application/json";
    private final URIBuilder uriBuilder;
    private final DBItemInventoryAgentInstance agentInstance;
    private final String agentUrl;

    public InventoryAgentCallable(URIBuilder uriBuilder, DBItemInventoryAgentInstance agentInstance, String agentUrl) {
        this.uriBuilder = uriBuilder;
        this.agentInstance = agentInstance;
        this.agentUrl = agentUrl;
    }

    @Override
    public CallableAgent call() {
        CallableAgent ca = new CallableAgent();
        this.agentInstance.setUrl(this.agentUrl);
        try {
            JsonObject result = this.getJsonObjectFromResponse(this.uriBuilder.build());
            ca.setAgent(this.agentInstance);
            ca.setResult(result);
            return ca;
        }
        catch (SOSBadRequestException | SOSNoResponseException e) {
            this.agentInstance.setHostname(null);
            this.agentInstance.setOsId(0L);
            this.agentInstance.setStartedAt(null);
            this.agentInstance.setState(1);
            this.agentInstance.setVersion(null);
            ca.setAgent(this.agentInstance);
            ca.setResult(null);
            return ca;
        }
        catch (Exception e) {
            return null;
        }
    }

    private JsonObject getJsonObjectFromResponse(URI uri) throws Exception {
        HttpURLConnection connection = null;
        try {
            JobSchedulerRestApiClient client = new JobSchedulerRestApiClient();
            connection = client.getHttpURLConnection(uri.toURL(), 5000, 5000);
            int responseCode = connection.getResponseCode();
            String contentType = connection.getContentType();
            String response = null;
            JsonReader json = null;
            switch (responseCode) {
                case 200: {
                    JsonReader rdr;
                    response = IOUtils.toString((InputStream)connection.getInputStream(), (Charset)Charsets.UTF_8);
                    if (contentType.contains(APPLICATION_HEADER_VALUE)) {
                        rdr = Json.createReader((Reader)new StringReader(response));
                        json = rdr.readObject();
                    }
                    if (json != null) {
                        rdr = json;
                        return rdr;
                    }
                    throw new Exception("Unexpected content type '" + contentType + "'. Response: " + response);
                }
                case 400: {
                    response = IOUtils.toString((InputStream)connection.getErrorStream(), (Charset)Charsets.UTF_8);
                    if (contentType.contains(APPLICATION_HEADER_VALUE)) {
                        JsonReader rdr = Json.createReader((Reader)new StringReader(response));
                        json = rdr.readObject();
                    }
                    if (json != null) {
                        throw new SOSBadRequestException(json.getString("message"));
                    }
                    throw new SOSBadRequestException("Unexpected content type '" + contentType + "'. Response: " + response);
                }
            }
            throw new SOSBadRequestException(responseCode + " " + client.getHttpResponse().getStatusLine().getReasonPhrase());
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }
}

