/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.inventory.helper;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sos.exception.SOSInvalidDataException;
import com.sos.exception.SOSMissingDataException;
import com.sos.hibernate.classes.DbItem;
import com.sos.hibernate.exceptions.SOSHibernateException;
import com.sos.jitl.inventory.db.DBLayerInventory;
import com.sos.jitl.reporting.db.DBItemInventoryClusterCalendar;
import com.sos.jitl.reporting.db.DBItemInventoryClusterCalendarUsage;
import com.sos.jitl.reporting.db.DBItemInventoryJob;
import com.sos.jitl.reporting.db.DBItemInventoryOrder;
import com.sos.jitl.reporting.db.DBItemInventorySchedule;
import com.sos.jitl.reporting.helper.EConfigFileExtensions;
import com.sos.jobscheduler.RuntimeCalendar;
import com.sos.jobscheduler.RuntimeResolver;
import com.sos.joc.classes.calendar.FrequencyResolver;
import com.sos.joc.model.calendar.Calendar;
import com.sos.joc.model.calendar.CalendarType;
import com.sos.joc.model.calendar.Calendars;
import com.sos.joc.model.calendar.Dates;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TreeSet;
import javax.xml.transform.TransformerException;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import sos.xml.SOSXMLXPath;

public class InventoryRuntimeHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(InventoryRuntimeHelper.class);
    private static final String RUN_TIME_NODE_NAME = "run_time";
    private static final String CALENDARS_NODE_NAME = "calendars";
    private static final ObjectMapper OM = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);

    public static void recalculateRuntime(DBLayerInventory inventoryDbLayer, String type, String path, String fileExtension, List<DBItemInventoryClusterCalendarUsage> dbCalendarUsages, Path liveDirectory, String timezone) throws Exception {
        InventoryRuntimeHelper.recalculateRuntime(inventoryDbLayer, type, path, fileExtension, dbCalendarUsages, liveDirectory, timezone, null, false);
    }

    public static void recalculateRuntime(DBLayerInventory inventoryDbLayer, String type, String path, String fileExtension, List<DBItemInventoryClusterCalendarUsage> dbCalendarUsages, Path liveDirectory, String timezone, String calendarsXML, boolean forceUpdateCalendarsElem) throws IOException, DocumentException, TransformerException, SOSHibernateException, SOSMissingDataException, SOSInvalidDataException {
        Long calendarId = null;
        DBItemInventoryClusterCalendar dbCalendar = null;
        Path filePath = liveDirectory.resolve(path.substring(1) + fileExtension);
        if (Files.exists(filePath, new LinkOption[0])) {
            String xml = new String(Files.readAllBytes(filePath));
            Document document = DocumentHelper.parseText((String)xml);
            TreeSet xmlRuntimes = RuntimeResolver.getCalendarDatesFromUTCYesterday((Document)document);
            TreeSet<RuntimeCalendar> usageRuntimes = new TreeSet<RuntimeCalendar>();
            if (dbCalendarUsages != null && !dbCalendarUsages.isEmpty()) {
                for (DBItemInventoryClusterCalendarUsage dbCalendarUsage : dbCalendarUsages) {
                    if (!dbCalendarUsage.getObjectType().equalsIgnoreCase(type) || !dbCalendarUsage.getPath().equalsIgnoreCase(path)) continue;
                    calendarId = dbCalendarUsage.getCalendarId();
                    Calendar calendarUsage = (Calendar)OM.readValue(dbCalendarUsage.getConfiguration(), Calendar.class);
                    RuntimeCalendar rc = null;
                    if (calendarId == null) continue;
                    dbCalendar = inventoryDbLayer.getCalendar(calendarId);
                    rc = new RuntimeCalendar();
                    if (dbCalendar != null) {
                        rc.setPath(dbCalendar.getName());
                        try {
                            rc.setType(CalendarType.fromValue((String)dbCalendar.getType()));
                        }
                        catch (IllegalArgumentException e) {
                            rc.setType(CalendarType.WORKING_DAYS);
                            LOGGER.warn("could not determine calendar type, falling back to default type:", (Throwable)e);
                        }
                        if (rc.getType() == CalendarType.WORKING_DAYS) {
                            if (calendarUsage.getPeriods() == null) {
                                rc.setPeriods(new ArrayList());
                            } else {
                                rc.setPeriods(calendarUsage.getPeriods());
                            }
                        }
                        Dates dates = null;
                        dates = dbCalendarUsage.getConfiguration() != null && !dbCalendarUsage.getConfiguration().isEmpty() ? new FrequencyResolver().resolveRestrictionsFromUTCYesterday((Calendar)OM.readValue(dbCalendar.getConfiguration(), Calendar.class), calendarUsage) : new FrequencyResolver().resolveFromUTCYesterday((Calendar)OM.readValue(dbCalendar.getConfiguration(), Calendar.class));
                        if (dates != null && dates.getDates() != null && !dates.getDates().isEmpty()) {
                            rc.setDates(dates.getDates());
                            usageRuntimes.add(rc);
                        }
                        if (!dbCalendarUsage.getEdited().booleanValue()) continue;
                        dbCalendarUsage.setEdited(false);
                        dbCalendarUsage.setModified(Date.from(Instant.now()));
                        inventoryDbLayer.getSession().update((Object)dbCalendarUsage);
                        continue;
                    }
                    inventoryDbLayer.getSession().delete((Object)dbCalendarUsage);
                }
            }
            document = InventoryRuntimeHelper.updateCalendarsCDATA(document, calendarsXML, type);
            if (!xmlRuntimes.equals(usageRuntimes)) {
                RuntimeResolver.updateCalendarInRuntimes((Document)document, (Writer)new FileWriter(filePath.toFile()), usageRuntimes);
            } else if (forceUpdateCalendarsElem) {
                InventoryRuntimeHelper.updateCalendarsInXMLOnly(document, new FileWriter(filePath.toFile()));
            }
        }
    }

    public static Document updateCalendarsCDATA(Document doc, String calendarsXML, String type) {
        if (calendarsXML == null) {
            return doc;
        }
        Element rootElement = doc.getRootElement();
        Element run_time = null;
        run_time = !"SCHEDULE".equals(type) ? rootElement.element(RUN_TIME_NODE_NAME) : rootElement;
        Element calendars = null;
        if (run_time != null) {
            calendars = run_time.element(CALENDARS_NODE_NAME);
            if (calendars == null) {
                calendars = run_time.addElement(CALENDARS_NODE_NAME);
            }
        } else if (run_time == null && !"SCHEDULE".equals(type)) {
            Element commands = rootElement.element("commands");
            Element newRuntime = null;
            if (commands != null) {
                newRuntime = DocumentHelper.createElement((String)RUN_TIME_NODE_NAME);
                List elements = commands.getParent().elements();
                elements.add(elements.indexOf(commands), newRuntime);
                calendars = newRuntime.addElement(CALENDARS_NODE_NAME);
            } else {
                newRuntime = rootElement.addElement(RUN_TIME_NODE_NAME);
                calendars = newRuntime.addElement(CALENDARS_NODE_NAME);
            }
        } else {
            calendars = doc.getRootElement().addElement(CALENDARS_NODE_NAME);
        }
        if (calendars.hasContent()) {
            calendars.content().clear();
        }
        calendars.addCDATA(calendarsXML);
        return doc;
    }

    public static void createOrUpdateCalendarUsage(SOSXMLXPath xPath, List<DBItemInventoryClusterCalendarUsage> dbCalendarUsages, DbItem dbItem, String type, DBLayerInventory dbLayer, Path liveDirectory, String schedulerId, String timezone, Boolean isCalendarEvent) throws Exception {
        boolean forceUpdateCalendarsElem;
        if (xPath == null) {
            return;
        }
        LOGGER.debug("*** Method createOrUpdateCalendarUsage started");
        String calendarUsagesFromConfigFile = null;
        Node falseNodeToDelete = null;
        if ("SCHEDULE".equals(type)) {
            calendarUsagesFromConfigFile = xPath.getNodeText(xPath.selectSingleNode("run_time/calendars"));
            if (calendarUsagesFromConfigFile != null && !calendarUsagesFromConfigFile.isEmpty()) {
                falseNodeToDelete = xPath.selectSingleNode("run_time/calendars");
            } else {
                calendarUsagesFromConfigFile = xPath.getNodeText(xPath.selectSingleNode(CALENDARS_NODE_NAME));
            }
        } else {
            calendarUsagesFromConfigFile = xPath.getNodeText(xPath.selectSingleNode("run_time/calendars"));
        }
        LOGGER.debug(calendarUsagesFromConfigFile);
        Calendars jsonCalendarsFromDB = new Calendars();
        ArrayList<Calendar> calendarUsageList = new ArrayList<Calendar>();
        if (dbCalendarUsages == null) {
            dbCalendarUsages = new ArrayList<DBItemInventoryClusterCalendarUsage>();
        }
        ArrayList<DBItemInventoryClusterCalendarUsage> deletedUsages = new ArrayList<DBItemInventoryClusterCalendarUsage>();
        for (DBItemInventoryClusterCalendarUsage dbUsages : dbCalendarUsages) {
            if (dbUsages.getConfiguration() != null) {
                Calendar cal = (Calendar)OM.readValue(dbUsages.getConfiguration(), Calendar.class);
                if (cal == null) continue;
                DBItemInventoryClusterCalendar dbCal = dbLayer.getCalendar(dbUsages.getCalendarId());
                cal.setType(CalendarType.fromValue((String)dbCal.getType()));
                cal.setBasedOn(dbCal.getName());
                calendarUsageList.add(cal);
                continue;
            }
            dbLayer.getSession().delete((Object)dbUsages);
            deletedUsages.add(dbUsages);
        }
        for (DBItemInventoryClusterCalendarUsage deletedUsage : deletedUsages) {
            dbCalendarUsages.remove(deletedUsage);
        }
        if (!calendarUsageList.isEmpty()) {
            jsonCalendarsFromDB.setCalendars(calendarUsageList);
            LOGGER.debug("*** [createOrUpdateCalendarUsage] calendar usages found in DB");
        }
        Calendars calendarsFromXML = null;
        if (calendarUsagesFromConfigFile != null && !calendarUsagesFromConfigFile.isEmpty()) {
            calendarsFromXML = (Calendars)OM.readValue(calendarUsagesFromConfigFile, Calendars.class);
            try {
                if (falseNodeToDelete != null) {
                    falseNodeToDelete.getParentNode().removeChild(falseNodeToDelete);
                }
            }
            catch (DOMException e) {
                LOGGER.warn(String.format("Unable to delete wrongly structured node, please remove the node\n %1$s \nby hand!", xPath.getNodeText(falseNodeToDelete)));
            }
        }
        String path = null;
        String fileExtension = null;
        if ("JOB".equals(type)) {
            fileExtension = EConfigFileExtensions.JOB.extension();
            path = ((DBItemInventoryJob)dbItem).getName();
        } else if ("ORDER".equals(type)) {
            fileExtension = EConfigFileExtensions.ORDER.extension();
            path = ((DBItemInventoryOrder)dbItem).getName();
        } else if ("SCHEDULE".equals(type)) {
            fileExtension = EConfigFileExtensions.SCHEDULE.extension();
            path = ((DBItemInventorySchedule)dbItem).getName();
        }
        boolean bl = forceUpdateCalendarsElem = !jsonCalendarsFromDB.equals((Object)calendarsFromXML);
        if (isCalendarEvent != null && isCalendarEvent.booleanValue()) {
            LOGGER.debug("*** [createOrUpdateCalendarUsage] processing Calendar event: " + path + fileExtension);
            InventoryRuntimeHelper.recalculateRuntime(dbLayer, type, path, fileExtension, dbCalendarUsages, liveDirectory, timezone, OM.writeValueAsString((Object)jsonCalendarsFromDB), forceUpdateCalendarsElem);
        } else if (!dbCalendarUsages.isEmpty()) {
            LOGGER.debug("*** [createOrUpdateCalendarUsage] referenced calendar and usage found in DB");
            LOGGER.debug("*** [createOrUpdateCalendarUsage] update metainfo in XML and recalculate runtimes");
            InventoryRuntimeHelper.recalculateRuntime(dbLayer, type, path, fileExtension, dbCalendarUsages, liveDirectory, timezone, OM.writeValueAsString((Object)jsonCalendarsFromDB), forceUpdateCalendarsElem);
        } else if (calendarsFromXML != null && calendarsFromXML.getCalendars() != null && !calendarsFromXML.getCalendars().isEmpty()) {
            LOGGER.debug("*** [createOrUpdateCalendarUsage] calendar usages found in XML but not in DB");
            for (Calendar calendarFromXML : calendarsFromXML.getCalendars()) {
                if (calendarFromXML.getBasedOn() == null || calendarFromXML.getBasedOn().isEmpty()) continue;
                DBItemInventoryClusterCalendar dbCal = dbLayer.getCalendar(schedulerId, calendarFromXML.getBasedOn());
                if (dbCal != null) {
                    LOGGER.debug("*** [createOrUpdateCalendarUsage] referenced calendar found in DB: " + calendarFromXML.getBasedOn());
                    LOGGER.debug("*** [createOrUpdateCalendarUsage] create new calendar usage in DB");
                    DBItemInventoryClusterCalendarUsage newCalendarUsage = new DBItemInventoryClusterCalendarUsage();
                    newCalendarUsage.setConfiguration(OM.writeValueAsString((Object)calendarFromXML));
                    newCalendarUsage.setSchedulerId(schedulerId);
                    newCalendarUsage.setObjectType(type);
                    newCalendarUsage.setPath(path);
                    newCalendarUsage.setCalendarId(dbCal.getId());
                    newCalendarUsage.setEdited(false);
                    newCalendarUsage.setCreated(Date.from(Instant.now()));
                    newCalendarUsage.setModified(newCalendarUsage.getCreated());
                    dbLayer.getSession().save((Object)newCalendarUsage);
                    LOGGER.debug("*** [createOrUpdateCalendarUsage] new calendar usage for DB saved!");
                    dbCalendarUsages.add(newCalendarUsage);
                    calendarUsageList.add(calendarFromXML);
                    continue;
                }
                LOGGER.debug("*** [createOrUpdateCalendarUsage] referenced calendar not found in DB: " + calendarFromXML.getBasedOn());
                LOGGER.debug("*** [createOrUpdateCalendarUsage] going to delete calendar usage from XML");
            }
            jsonCalendarsFromDB.setCalendars(calendarUsageList);
            boolean forceUpdateCalendarsElem2 = !jsonCalendarsFromDB.equals((Object)calendarsFromXML);
            InventoryRuntimeHelper.recalculateRuntime(dbLayer, type, path, fileExtension, dbCalendarUsages, liveDirectory, timezone, OM.writeValueAsString((Object)jsonCalendarsFromDB), forceUpdateCalendarsElem2);
        } else {
            LOGGER.debug("*** [createOrUpdateCalendarUsage] referenced calendar and usage not found in DB!");
            LOGGER.debug("*** [createOrUpdateCalendarUsage] no metainfo provided in XML. recalculating runtimes without using calendars.");
            InventoryRuntimeHelper.recalculateRuntime(dbLayer, type, path, fileExtension, dbCalendarUsages, liveDirectory, timezone);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateCalendarsInXMLOnly(Document document, Writer writer) throws IOException {
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setEncoding(document.getXMLEncoding());
        format.setXHTML(true);
        format.setIndentSize(4);
        format.setExpandEmptyElements(false);
        XMLWriter xmlWriter = null;
        try {
            xmlWriter = new XMLWriter(writer, format);
            xmlWriter.write(document);
            xmlWriter.flush();
            xmlWriter.close();
        }
        finally {
            if (xmlWriter != null) {
                try {
                    xmlWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

