/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.jobstreams;

import com.sos.hibernate.classes.ClassList;
import com.sos.jitl.eventhandler.handler.EventHandlerSettings;
import com.sos.jitl.jobstreams.db.DBItemConsumedInCondition;
import com.sos.jitl.jobstreams.db.DBItemEvent;
import com.sos.jitl.jobstreams.db.DBItemInCondition;
import com.sos.jitl.jobstreams.db.DBItemInConditionCommand;
import com.sos.jitl.jobstreams.db.DBItemJobStream;
import com.sos.jitl.jobstreams.db.DBItemJobStreamHistory;
import com.sos.jitl.jobstreams.db.DBItemJobStreamNode;
import com.sos.jitl.jobstreams.db.DBItemJobStreamParameter;
import com.sos.jitl.jobstreams.db.DBItemJobStreamStarter;
import com.sos.jitl.jobstreams.db.DBItemJobStreamStarterJob;
import com.sos.jitl.jobstreams.db.DBItemJobStreamTaskContext;
import com.sos.jitl.jobstreams.db.DBItemOutCondition;
import com.sos.jitl.jobstreams.db.DBItemOutConditionEvent;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Constants {
    private static final Logger LOGGER = LoggerFactory.getLogger(Constants.class);
    public static final String DBItemEvent = DBItemEvent.class.getSimpleName();
    public static final String EVENTS_TABLE_SEQUENCE = "JSTREAM_EVENTS_ID_SEQ";
    public static final String EVENTS_TABLE = "JSTREAM_EVENTS";
    public static final String DBItemConsumedInCondition = DBItemConsumedInCondition.class.getSimpleName();
    public static final String CONSUMED_IN_CONDITIONS_TABLE_SEQUENCE = "JSTREAM_CONSUMED_INCOND_ID_SEQ";
    public static final String CONSUMED_IN_CONDITIONS_TABLE = "JSTREAM_CONSUMED_IN_CONDITIONS";
    public static final String DBItemInCondition = DBItemInCondition.class.getSimpleName();
    public static final String IN_CONDITIONS_TABLE_SEQUENCE = "JSTREAM_IN_COND_ID_SEQ";
    public static final String IN_CONDITIONS_TABLE = "JSTREAM_IN_CONDITIONS";
    public static final String DBItemOutConditionEvent = DBItemOutConditionEvent.class.getSimpleName();
    public static final String OUT_CONDITION_EVENTS_TABLE_SEQUENCE = "JSTREAM_OUT_COND_EV_ID_SEQ";
    public static final String OUT_CONDITION_EVENTS_TABLE = "JSTREAM_OUT_CONDITION_EVENTS";
    public static final String DBItemOutCondition = DBItemOutCondition.class.getSimpleName();
    public static final String OUT_CONDITIONS_TABLE_SEQUENCE = "JSTREAM_OUT_COND_ID_SEQ";
    public static final String OUT_CONDITIONS_TABLE = "JSTREAM_OUT_CONDITIONS";
    public static final String DBItemInConditionCommand = DBItemInConditionCommand.class.getSimpleName();
    public static final String IN_CONDITION_COMMANDS_TABLE_SEQUENCE = "JSTREAM_IN_COND_CMD_ID_SEQ";
    public static final String IN_CONDITION_COMMANDS_TABLE = "JSTREAM_IN_CONDITION_COMMANDS";
    public static final String DBItemJobStream = DBItemJobStream.class.getSimpleName();
    public static final String JOB_STREAM_TABLE_SEQUENCE = "JSTREAM_JOBSTREAM_ID_SEQ";
    public static final String JOB_STREAM_TABLE = "JSTREAM_JOBSTREAMS";
    public static final String DBItemJobStreamHistory = DBItemJobStreamHistory.class.getSimpleName();
    public static final String JOB_STREAM_HISTORY_TABLE_SEQUENCE = "JSTREAM_HISTORY_ID_SEQ";
    public static final String JOB_STREAM_HISTORY_TABLE = "JSTREAM_HISTORY";
    public static final String DBItemJobStreamNode = DBItemJobStreamNode.class.getSimpleName();
    public static final String JOB_STREAM_NODE_TABLE_SEQUENCE = "JSTREAM_NODE_ID_SEQ";
    public static final String JOB_STREAM_NODE_TABLE = "JSTREAM_NODES";
    public static final String DBItemJobStreamParameter = DBItemJobStreamParameter.class.getSimpleName();
    public static final String JOB_STREAM_PARAMETER_TABLE_SEQUENCE = "JSTREAM_PARAMETER_ID_SEQ";
    public static final String JOB_STREAM_PARAMETER_TABLE = "JSTREAM_PARAMETERS";
    public static final String DBItemJobStreamStarter = DBItemJobStreamStarter.class.getSimpleName();
    public static final String JOB_STREAM_STARTER_TABLE_SEQUENCE = "JSTREAM_STARTER_ID_SEQ";
    public static final String JOB_STREAM_STARTER_TABLE = "JSTREAM_STARTERS";
    public static final String DBItemJobStreamTaskContext = DBItemJobStreamTaskContext.class.getSimpleName();
    public static final String JOB_STREAM_TASK_CONTEXT_TABLE_SEQUENCE = "JSTREAM_TASK_CONTEXT_ID_SEQ";
    public static final String JOB_STREAM_TASK_CONTEXT_TABLE = "JSTREAM_TASK_CONTEXT";
    public static final String DBItemJobStreamStarterJobs = DBItemJobStreamStarterJob.class.getSimpleName();
    public static final String JOB_STREAM_STARTER_JOBS_TABLE_SEQUENCE = "JSTREAM_STARTJOBS_ID_SEQ";
    public static final String JOB_STREAM_STARTER_JOBS_TABLE = "JSTREAM_STARTJOBS";
    public static EventHandlerSettings settings = null;
    public static String baseUrl;
    public static String periodBegin;
    public static Integer testDelay;
    public static Integer jobstreamCheckInterval;

    public static Calendar getSessionCalendar() {
        if (periodBegin == null) {
            periodBegin = "00:00";
        }
        LOGGER.debug("Timezone for period is " + settings.getTimezone());
        TimeZone timeZone = TimeZone.getTimeZone(settings.getTimezone());
        Calendar calendar = Calendar.getInstance(timeZone);
        String[] period = periodBegin.split(":");
        int hours = 0;
        int minutes = 0;
        if (period.length == 1) {
            try {
                hours = Integer.parseInt(period[0]);
            }
            catch (NumberFormatException e) {
                LOGGER.warn("Wrong time format for sos.jobstream_period_begin: " + periodBegin);
                hours = 0;
                minutes = 0;
                periodBegin = "00:00";
            }
        }
        if (period.length == 2) {
            try {
                hours = Integer.parseInt(period[0]);
                minutes = Integer.parseInt(period[1]);
            }
            catch (NumberFormatException e) {
                LOGGER.warn("Wrong time format for sos.jobstream_period_begin: " + periodBegin);
                hours = 0;
                minutes = 0;
                periodBegin = "00:00";
            }
        }
        calendar.add(11, hours * -1);
        calendar.add(12, minutes * -1);
        return calendar;
    }

    public static String getSession() {
        Calendar calendar = Constants.getSessionCalendar();
        int month = calendar.get(2) + 1;
        int dayOfMonth = calendar.get(5);
        LOGGER.debug("Period starts at  " + periodBegin + " " + settings.getTimezone());
        String result = String.valueOf(month) + "." + String.valueOf(dayOfMonth);
        LOGGER.debug("period session is: " + result);
        return result;
    }

    public static ClassList getConditionsClassMapping() {
        ClassList cl = new ClassList();
        cl.add(DBItemOutCondition.class);
        cl.add(DBItemOutConditionEvent.class);
        cl.add(DBItemInCondition.class);
        cl.add(DBItemInConditionCommand.class);
        cl.add(DBItemConsumedInCondition.class);
        cl.add(DBItemEvent.class);
        cl.add(DBItemJobStream.class);
        cl.add(DBItemJobStreamParameter.class);
        cl.add(DBItemJobStreamHistory.class);
        cl.add(DBItemJobStreamStarterJob.class);
        cl.add(DBItemJobStreamStarter.class);
        cl.add(DBItemJobStreamTaskContext.class);
        return cl;
    }

    public static LocalDate getToday() {
        return LocalDate.now(ZoneId.of(settings.getTimezone()));
    }

    static {
        testDelay = 0;
        jobstreamCheckInterval = 3;
    }

    public static enum OutConditionEventCommand {
        create,
        delete;

    }
}

