/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.jobstreams.classes;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sos.jitl.jobstreams.classes.JobStreamScheduler;
import com.sos.jitl.jobstreams.db.DBItemJobStreamStarter;
import com.sos.joc.model.joe.schedule.RunTime;
import java.io.IOException;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSStarter {
    private static final Logger LOGGER = LoggerFactory.getLogger(JSStarter.class);
    private DBItemJobStreamStarter itemJobStreamStarter;
    private Date nextStart;
    private JobStreamScheduler jobStreamScheduler;
    private ObjectMapper objectMapper;

    public JSStarter(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public DBItemJobStreamStarter getItemJobStreamStarter() {
        return this.itemJobStreamStarter;
    }

    public RunTime getRunTime() throws JsonParseException, JsonMappingException, IOException {
        if (this.itemJobStreamStarter.getRunTime() != null) {
            return (RunTime)this.objectMapper.readValue(this.itemJobStreamStarter.getRunTime(), RunTime.class);
        }
        return null;
    }

    public void setItemJobStreamStarter(Date from, Date to, DBItemJobStreamStarter itemJobStreamStarter, String timeZoneId) throws Exception {
        this.itemJobStreamStarter = itemJobStreamStarter;
        this.jobStreamScheduler = new JobStreamScheduler(timeZoneId);
        RunTime runtime = this.getRunTime();
        if (runtime != null) {
            LOGGER.debug("schedule for:" + this.itemJobStreamStarter.getStarterName());
            this.jobStreamScheduler.schedule(from, to, runtime, false);
        }
    }

    public JobStreamScheduler getJobStreamScheduler() {
        return this.jobStreamScheduler;
    }

    public void setNextStart(Date nextStart) {
        this.nextStart = nextStart;
    }

    public Date getNextStart() {
        return this.nextStart;
    }
}

