/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.latecomers;

import com.sos.JSHelper.Basics.JSJobUtilitiesClass;
import com.sos.jitl.latecomers.JobSchedulerStartLatecomersOptions;
import com.sos.jitl.latecomers.classes.DailyPlanExecuter;
import com.sos.jitl.latecomers.classes.JobChainStartExecuter;
import com.sos.jitl.latecomers.classes.JobStartExecuter;
import com.sos.jitl.latecomers.classes.LateComersHelper;
import com.sos.jitl.restclient.AccessTokenProvider;
import com.sos.jitl.restclient.JobSchedulerCredentialStoreJOCParameters;
import com.sos.jitl.restclient.WebserviceCredentials;
import com.sos.joc.model.plan.PlanItem;
import com.sos.scheduler.messages.JSMessages;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.spooler.Spooler;

public class JobSchedulerStartLatecomers
extends JSJobUtilitiesClass<JobSchedulerStartLatecomersOptions> {
    protected JobSchedulerStartLatecomersOptions jobSchedulerStartLatecomersOptions = null;
    private static final String CLASSNAME = "JobSchedulerStartLatecomers";
    private static final Logger LOGGER = LoggerFactory.getLogger(JobSchedulerStartLatecomers.class);
    private String jocUrl;
    private String schedulerId;
    private String xAccessToken;

    public JobSchedulerStartLatecomers() {
        super((Object)new JobSchedulerStartLatecomersOptions());
    }

    public JobSchedulerStartLatecomersOptions getOptions() {
        if (this.jobSchedulerStartLatecomersOptions == null) {
            this.jobSchedulerStartLatecomersOptions = new JobSchedulerStartLatecomersOptions();
        }
        return this.jobSchedulerStartLatecomersOptions;
    }

    public JobSchedulerStartLatecomersOptions getOptions(JobSchedulerStartLatecomersOptions options) {
        this.jobSchedulerStartLatecomersOptions = options;
        return this.jobSchedulerStartLatecomersOptions;
    }

    public JobSchedulerStartLatecomers execute() throws Exception {
        String METHODNAME = "JobSchedulerStartLatecomers::execute";
        LOGGER.debug(String.format(JSMessages.JSJ_I_110.get(), "JobSchedulerStartLatecomers::execute"));
        this.getOptions().checkMandatory();
        LOGGER.debug(this.getOptions().toString());
        LateComersHelper lateComersHelper = new LateComersHelper(this.jobSchedulerStartLatecomersOptions);
        JobSchedulerCredentialStoreJOCParameters jobSchedulerCredentialStoreJOCParameters = new JobSchedulerCredentialStoreJOCParameters();
        jobSchedulerCredentialStoreJOCParameters.setCredentialStoreEntryPath(this.jobSchedulerStartLatecomersOptions.credential_store_entry_path.getValue());
        jobSchedulerCredentialStoreJOCParameters.setCredentialStoreFile(this.jobSchedulerStartLatecomersOptions.credential_store_file.getValue());
        jobSchedulerCredentialStoreJOCParameters.setCredentialStoreKeyFile(this.jobSchedulerStartLatecomersOptions.credential_store_key_file.getValue());
        jobSchedulerCredentialStoreJOCParameters.setCredentialStorePassword(this.jobSchedulerStartLatecomersOptions.credential_store_password.getValue());
        jobSchedulerCredentialStoreJOCParameters.setJocUrl(this.jobSchedulerStartLatecomersOptions.jocUrl.getValue());
        jobSchedulerCredentialStoreJOCParameters.setPassword(this.jobSchedulerStartLatecomersOptions.password.getValue());
        jobSchedulerCredentialStoreJOCParameters.setUser(this.jobSchedulerStartLatecomersOptions.user.getValue());
        jobSchedulerCredentialStoreJOCParameters.setKeyPassword(this.jobSchedulerStartLatecomersOptions.keyPassword.getValue());
        jobSchedulerCredentialStoreJOCParameters.setKeyStorePassword(this.jobSchedulerStartLatecomersOptions.keystorePassword.getValue());
        jobSchedulerCredentialStoreJOCParameters.setKeyStorePath(this.jobSchedulerStartLatecomersOptions.keystorePath.getValue());
        jobSchedulerCredentialStoreJOCParameters.setKeyStoreType(this.jobSchedulerStartLatecomersOptions.keystoreType.getValue());
        jobSchedulerCredentialStoreJOCParameters.setTrustStorePassword(this.jobSchedulerStartLatecomersOptions.truststorePassword.getValue());
        jobSchedulerCredentialStoreJOCParameters.setTrustStorePath(this.jobSchedulerStartLatecomersOptions.truststorePath.getValue());
        jobSchedulerCredentialStoreJOCParameters.setTrustStoreType(this.jobSchedulerStartLatecomersOptions.truststoreType.getValue());
        AccessTokenProvider accessTokenProvider = new AccessTokenProvider(jobSchedulerCredentialStoreJOCParameters);
        WebserviceCredentials webserviceCredentials = new WebserviceCredentials();
        if (this.jocUrl == null) {
            Spooler schedulerInstance = (Spooler)this.objJSCommands.getSpoolerObject();
            if (schedulerInstance != null) {
                webserviceCredentials = accessTokenProvider.getAccessToken(schedulerInstance);
                this.jocUrl = schedulerInstance.variables().value("joc_url");
            }
        } else {
            webserviceCredentials.setAccessToken(this.xAccessToken);
            webserviceCredentials.setSchedulerId(this.schedulerId);
        }
        if (this.jocUrl == null) {
            this.jocUrl = "";
        }
        DailyPlanExecuter dailyPlanExecuter = null;
        JobStartExecuter jobStartExecuter = null;
        JobChainStartExecuter jobChainStartExecuter = null;
        dailyPlanExecuter = new DailyPlanExecuter(webserviceCredentials);
        dailyPlanExecuter.setSchedulerId(webserviceCredentials.getSchedulerId());
        dailyPlanExecuter.login(webserviceCredentials.getAccessToken());
        jobStartExecuter = new JobStartExecuter(webserviceCredentials);
        jobStartExecuter.setSchedulerId(webserviceCredentials.getSchedulerId());
        jobStartExecuter.login(dailyPlanExecuter.getAccessToken());
        jobChainStartExecuter = new JobChainStartExecuter(webserviceCredentials);
        jobChainStartExecuter.setSchedulerId(webserviceCredentials.getSchedulerId());
        jobChainStartExecuter.login(dailyPlanExecuter.getAccessToken());
        List<PlanItem> listOfPlanItems = dailyPlanExecuter.getDailyPlan(this.jobSchedulerStartLatecomersOptions.dayOffset.getValue());
        if (listOfPlanItems != null) {
            for (PlanItem plan : listOfPlanItems) {
                if (lateComersHelper.ignoreFolder(lateComersHelper.getParent(plan.getJob()))) {
                    LOGGER.info("Job: " + plan.getJob() + " is late but will not be started as in folder" + this.jobSchedulerStartLatecomersOptions.getIgnoreFolderList().getValue());
                    continue;
                }
                if (lateComersHelper.ignoreFolder(lateComersHelper.getParent(plan.getJobChain()))) {
                    LOGGER.info("JobChain: " + plan.getJobChain() + " is late but will not be started as in folder" + this.jobSchedulerStartLatecomersOptions.getIgnoreFolderList().getValue());
                    continue;
                }
                if (lateComersHelper.ignoreOrder(plan.getJobChain(), plan.getOrderId())) {
                    LOGGER.info("Order: " + plan.getJobChain() + ")" + plan.getOrderId() + ") is late but will not be started as in list of ignored orders:" + this.jobSchedulerStartLatecomersOptions.getIgnoreOrderList().getValue());
                    continue;
                }
                if (lateComersHelper.ignoreJob(plan.getJob())) {
                    LOGGER.info("Job: " + plan.getJob() + " is late but will not be started as in list of ignored jobs:" + this.jobSchedulerStartLatecomersOptions.getIgnoreJobList().getValue());
                    continue;
                }
                if (lateComersHelper.considerJob(plan.getJob())) {
                    if (this.jobSchedulerStartLatecomersOptions.onlyReport.value()) {
                        LOGGER.info("Job: " + plan.getJob() + " is late");
                    } else {
                        LOGGER.info("Job: " + plan.getJob() + " is late. Will be started now");
                        jobStartExecuter.startJob(plan.getJob());
                    }
                } else if (!plan.getJob().isEmpty()) {
                    LOGGER.info("Job: " + plan.getJob() + " is late but not considered in " + this.jobSchedulerStartLatecomersOptions.jobs.getValue());
                }
                if (lateComersHelper.considerOrder(plan.getJobChain(), plan.getOrderId())) {
                    if (this.jobSchedulerStartLatecomersOptions.onlyReport.value()) {
                        LOGGER.info("Order: " + plan.getJobChain() + "(" + plan.getOrderId() + ") is late");
                        continue;
                    }
                    LOGGER.info("Order: " + plan.getJobChain() + "(" + plan.getOrderId() + ") is late. Will be started now");
                    jobChainStartExecuter.startJobChain(plan.getJobChain(), plan.getOrderId());
                    continue;
                }
                if ((plan.getJobChain() + plan.getOrderId()).isEmpty()) continue;
                LOGGER.info("Order: " + plan.getJobChain() + "(" + plan.getOrderId() + ") is late but not considered in " + this.jobSchedulerStartLatecomersOptions.orders.getValue());
            }
        }
        return this;
    }

    public String replaceSchedulerVars(String pstrString2Modify) {
        LOGGER.debug("replaceSchedulerVars as Dummy-call executed. No Instance of JobUtilites specified.");
        return pstrString2Modify;
    }

    public void setJSParam(String pstrKey, String pstrValue) {
    }

    public void setJSParam(String pstrKey, StringBuilder pstrValue) {
    }

    public void setJocUrl(String jocUrl) {
        this.jocUrl = jocUrl;
    }

    public void setSchedulerId(String schedulerId) {
        this.schedulerId = schedulerId;
    }

    public void setxAccessToken(String xAccessToken) {
        this.xAccessToken = xAccessToken;
    }
}

