/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.mailprocessor;

import com.sos.JSHelper.Basics.JSJobUtilities;
import com.sos.JSHelper.Exceptions.JobSchedulerException;
import com.sos.jitl.mailprocessor.PostproccesingEntry;
import com.sos.jitl.mailprocessor.SOSMailProcessInbox;
import com.sos.jitl.mailprocessor.SOSMailProcessInboxOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.scheduler.command.SOSSchedulerCommand;
import sos.scheduler.job.JobSchedulerJobAdapter;
import sos.spooler.Job_chain;
import sos.spooler.Order;
import sos.spooler.Spooler;
import sos.spooler.Variable_set;

public class SOSMailProcessInboxJSAdapterClass
extends JobSchedulerJobAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSMailProcessInboxJSAdapterClass.class);
    private SOSMailProcessInboxOptions sosMailProcessInboxOptions;

    public boolean spooler_process() throws Exception {
        try {
            super.spooler_process();
            this.doProcessing();
            boolean bl = this.getSpoolerProcess().isOrderJob();
            return bl;
        }
        catch (Exception e) {
            throw new JobSchedulerException("Fatal Error:" + e.getMessage(), (Throwable)e);
        }
    }

    private void doProcessing() throws Exception {
        this.spooler_job.set_state_text("*** running ***");
        int httpPort = SOSSchedulerCommand.getHTTPPortFromScheduler((Spooler)this.spooler);
        SOSMailProcessInbox sosMailProcessInbox = new SOSMailProcessInbox();
        this.sosMailProcessInboxOptions = sosMailProcessInbox.getOptions();
        this.sosMailProcessInboxOptions.setCurrentNodeName(this.getCurrentNodeName(this.getSpoolerProcess().getOrder(), true));
        this.sosMailProcessInboxOptions.setAllOptions(this.getSchedulerParameterAsProperties(this.getSpoolerProcess().getOrder()));
        if (this.sosMailProcessInboxOptions.mailSchedulerHost.isNotDirty()) {
            this.sosMailProcessInboxOptions.mailSchedulerHost.setValue(this.spooler.hostname());
            if (this.sosMailProcessInboxOptions.mailSchedulerPort.isNotDirty()) {
                this.sosMailProcessInboxOptions.mailSchedulerPort.value(httpPort);
            }
        }
        this.sosMailProcessInboxOptions.checkMandatory();
        sosMailProcessInbox.setJSJobUtilites((JSJobUtilities)this);
        sosMailProcessInbox.execute();
        for (PostproccesingEntry postproccesingEntry : sosMailProcessInbox.getListOfPostprocessing()) {
            if (postproccesingEntry.isAddOrder()) {
                LOGGER.info("Will add order");
                this.startOrder(postproccesingEntry);
            }
            if (!postproccesingEntry.isExecuteCommand()) continue;
            LOGGER.info("Will execute command");
            this.executeCommand(postproccesingEntry);
        }
    }

    private void startOrder(PostproccesingEntry postproccesingEntry) throws Exception {
        String jobchain = this.sosMailProcessInboxOptions.mailJobchain.getValue();
        Variable_set returnParams = this.spooler.create_variable_set();
        this.spooler_log.debug("....merge");
        returnParams.merge(this.spooler_task.params());
        returnParams.set_var("mail_from", postproccesingEntry.getSosMimeMessage().getFrom());
        if (postproccesingEntry.getSosMimeMessage().getFromName() != null) {
            returnParams.set_var("mail_from_name", postproccesingEntry.getSosMimeMessage().getFromName());
        } else {
            returnParams.set_var("mail_from_name", "");
        }
        returnParams.set_var("mail_message_id", postproccesingEntry.getSosMimeMessage().getMessageId());
        returnParams.set_var("mail_subject", postproccesingEntry.getSosMimeMessage().getSubject());
        returnParams.set_var("mail_body", postproccesingEntry.getBody());
        returnParams.set_var("mail_send_at", postproccesingEntry.getSosMimeMessage().getSentDateAsString());
        Job_chain objJobChain = this.spooler.job_chain(jobchain);
        this.spooler_log.debug("...jobchain " + jobchain + " object created.");
        Order newOrder = this.spooler.create_order();
        newOrder.params().merge(returnParams);
        if (this.sosMailProcessInboxOptions.mailOrderState.isNotEmpty()) {
            newOrder.set_state(this.sosMailProcessInboxOptions.mailOrderState.getValue());
        }
        if (this.sosMailProcessInboxOptions.mailOrderTitle.isNotEmpty()) {
            newOrder.set_title(this.sosMailProcessInboxOptions.mailOrderTitle.getValue());
        }
        objJobChain.add_order(newOrder);
        this.spooler_log.debug("...order added to " + jobchain);
    }

    private void executeCommand(PostproccesingEntry postproccesingEntry) throws Exception {
        String body = postproccesingEntry.getBody();
        if (body != null && !body.isEmpty()) {
            this.spooler.execute_xml(body);
        }
    }
}

