/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.mailprocessor;

import com.sos.JSHelper.Exceptions.JobSchedulerException;
import com.sos.jitl.mailprocessor.PostproccesingEntry;
import com.sos.jitl.mailprocessor.SOSMailProcessInboxOptions;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.mail.Address;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.search.AndTerm;
import javax.mail.search.FromTerm;
import javax.mail.search.SearchTerm;
import javax.mail.search.SubjectTerm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.net.SOSMailReceiver;
import sos.net.SOSMimeMessage;

public class SOSMailProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSMailProcessor.class);
    private SOSMailProcessInboxOptions sosMailProcessInboxOptions = null;
    private Date dateMinAge = new Date();
    private List<PostproccesingEntry> listOfPostprocessing = new ArrayList<PostproccesingEntry>();
    Folder inFolder;
    Folder targetFolder;

    public List<PostproccesingEntry> getListOfPostprocessing() {
        return this.listOfPostprocessing;
    }

    public SOSMailProcessor(SOSMailProcessInboxOptions sosMailProcessInboxOptions) {
        this.sosMailProcessInboxOptions = sosMailProcessInboxOptions;
    }

    private boolean checkDate() {
        boolean result = false;
        if (this.sosMailProcessInboxOptions.minAge.isDirty()) {
            String strT = this.sosMailProcessInboxOptions.minAge.getValue();
            if (!strT.startsWith("-")) {
                this.sosMailProcessInboxOptions.minAge.setValue("-" + strT);
            }
            this.dateMinAge = this.sosMailProcessInboxOptions.minAge.getEndFromNow();
            LOGGER.info(String.format("Min Age defined: %1$s", this.dateMinAge.toString()));
            result = true;
        }
        return result;
    }

    private boolean isPerformMessage(SOSMimeMessage sosMimeMessage) throws Exception {
        Date messageDate = sosMimeMessage.getSentDate();
        boolean result = true;
        if (messageDate != null) {
            LOGGER.info(sosMimeMessage.getSubject() + " " + messageDate.toString());
        }
        if (this.checkDate() && messageDate != null && this.dateMinAge.before(messageDate)) {
            LOGGER.debug("message skipped due to date constraint: \n" + sosMimeMessage.getSubject() + " " + messageDate);
            result = false;
        }
        return result;
    }

    private void executeMessage(SOSMimeMessage sosMimeMessage) throws Exception {
        if (this.isPerformMessage(sosMimeMessage)) {
            this.performAction(sosMimeMessage);
        }
    }

    private void performAction(SOSMimeMessage message) throws Exception {
        String action = "";
        String actions = this.sosMailProcessInboxOptions.mailAction.getValue();
        boolean copyMail2File = this.sosMailProcessInboxOptions.getCopyMail2File().value();
        boolean createOrder = this.sosMailProcessInboxOptions.getCreateOrder().value();
        boolean executeCommand = this.sosMailProcessInboxOptions.getExecuteCommand().value();
        boolean deleteMessage = this.sosMailProcessInboxOptions.getDeleteMessage().value();
        boolean copyAttachmentsToFile = this.sosMailProcessInboxOptions.getCopyAttachmentsToFile().value();
        StringTokenizer t = new StringTokenizer(actions, ",");
        while (t.hasMoreTokens()) {
            action = t.nextToken();
            if ("dump".equalsIgnoreCase(action) || "copy_mail_to_file".equalsIgnoreCase(action)) {
                copyMail2File = true;
                continue;
            }
            if ("order".equalsIgnoreCase(action) || "create_order".equalsIgnoreCase(action)) {
                createOrder = true;
                continue;
            }
            if ("command".equalsIgnoreCase(action)) {
                executeCommand = true;
                continue;
            }
            if ("delete".equalsIgnoreCase(action)) {
                deleteMessage = true;
                continue;
            }
            if (!"copy_attachments_to_file".equalsIgnoreCase(action)) continue;
            copyAttachmentsToFile = true;
        }
        if (copyMail2File) {
            if (this.sosMailProcessInboxOptions.mailDirectoryName.IsEmpty()) {
                throw new JobSchedulerException("No output directory [parameter mail_directory_name] specified.");
            }
            this.dumpMessage(message, this.sosMailProcessInboxOptions.mailDirectoryName.getValue());
        }
        if (createOrder) {
            this.startOrder(message);
        }
        if (executeCommand) {
            this.executeCommand(message);
        }
        if (copyAttachmentsToFile) {
            this.copyAttachmentsToFile(message);
        }
        if (deleteMessage) {
            this.deleteMessage(message);
        } else {
            this.handleAfterProcessEmail(message);
        }
    }

    private void copyMailToFolder(SOSMimeMessage message) throws RuntimeException, Exception {
        if (this.targetFolder != null) {
            ArrayList<MimeMessage> tempList = new ArrayList<MimeMessage>();
            tempList.add(message.getMessage());
            Message[] m = tempList.toArray(new Message[tempList.size()]);
            this.inFolder.copyMessages(m, this.targetFolder);
        } else {
            this.dumpMessage(message, this.sosMailProcessInboxOptions.afterProcessEmailDirectoryName.getValue());
        }
    }

    private void handleAfterProcessEmail(SOSMimeMessage message) throws Exception {
        if ("markAsRead".equals(this.sosMailProcessInboxOptions.getAfterProcessEmail().getValue())) {
            message.setFlag(Flags.Flag.SEEN, true);
        }
        if ("delete".equals(this.sosMailProcessInboxOptions.getAfterProcessEmail().getValue())) {
            this.deleteMessage(message);
        }
        if ("move".equals(this.sosMailProcessInboxOptions.getAfterProcessEmail().getValue())) {
            if (this.sosMailProcessInboxOptions.afterProcessEmailDirectoryName.getValue().isEmpty()) {
                throw new JobSchedulerException("No output directory [parameter after_process_email_directory_name] specified.");
            }
            this.copyMailToFolder(message);
            this.deleteMessage(message);
        }
        if ("copy".equals(this.sosMailProcessInboxOptions.getAfterProcessEmail().getValue())) {
            if (this.sosMailProcessInboxOptions.afterProcessEmailDirectoryName.getValue().isEmpty()) {
                throw new JobSchedulerException("No output directory [parameter after_process_email_directory_name] specified.");
            }
            this.copyMailToFolder(message);
        }
    }

    private void executeCommand(SOSMimeMessage message) throws Exception {
        LOGGER.debug(String.format("execute command. subject=%s, date=%s", message.getSubject(), message.getSentDateAsString()));
        PostproccesingEntry postproccesingEntry = new PostproccesingEntry();
        postproccesingEntry.setAddOrder(false);
        postproccesingEntry.setExecuteCommand(true);
        postproccesingEntry.setSosMimeMessage(message);
        this.listOfPostprocessing.add(postproccesingEntry);
    }

    private void startOrder(SOSMimeMessage message) throws Exception {
        LOGGER.debug(String.format("add order. subject=%s, date=%s", message.getSubject(), message.getSentDateAsString()));
        PostproccesingEntry postproccesingEntry = new PostproccesingEntry();
        postproccesingEntry.setAddOrder(true);
        postproccesingEntry.setExecuteCommand(false);
        postproccesingEntry.setSosMimeMessage(message);
        postproccesingEntry.setBody(message.getPlainTextBody());
        this.listOfPostprocessing.add(postproccesingEntry);
    }

    private String getEmailFolderName(String folder) {
        String s = "";
        if (folder.toLowerCase().startsWith("email:")) {
            s = folder.replace("email:", "");
        }
        return s;
    }

    public void performMessagesInFolder(SOSMailReceiver mailReader, String messageFolder) throws Exception {
        FromTerm fromTerm;
        LOGGER.debug("reading " + messageFolder);
        this.inFolder = mailReader.openFolder(messageFolder, mailReader.READ_WRITE);
        String targetFolderName = this.getEmailFolderName(this.sosMailProcessInboxOptions.afterProcessEmailDirectoryName.getValue());
        if (!targetFolderName.isEmpty()) {
            this.targetFolder = mailReader.openFolder(targetFolderName, mailReader.READ_WRITE);
        }
        int maxObjectsToProcess = this.inFolder.getMessageCount();
        Message[] msgs = null;
        Message[] msgs2 = null;
        int intBufferSize = this.sosMailProcessInboxOptions.maxMailsToProcess.value();
        if (maxObjectsToProcess > intBufferSize && intBufferSize > 0) {
            maxObjectsToProcess = intBufferSize;
        }
        msgs = this.inFolder.getMessages(1, maxObjectsToProcess);
        Pattern subjectPattern = null;
        Pattern bodyPattern = null;
        if (this.sosMailProcessInboxOptions.mailSubjectPattern.isNotEmpty()) {
            this.sosMailProcessInboxOptions.mailSubjectPattern.setRegExpFlags(0);
            subjectPattern = this.sosMailProcessInboxOptions.mailSubjectPattern.getPattern();
        }
        if (this.sosMailProcessInboxOptions.mailBodyPattern.isNotEmpty()) {
            this.sosMailProcessInboxOptions.mailBodyPattern.setRegExpFlags(0);
            bodyPattern = this.sosMailProcessInboxOptions.mailBodyPattern.getPattern();
        }
        if (this.sosMailProcessInboxOptions.mailSubjectFilter.isNotEmpty() && this.sosMailProcessInboxOptions.mailFromFilter.isNotEmpty()) {
            LOGGER.debug("===>" + this.sosMailProcessInboxOptions.mailFromFilter.getValue());
            fromTerm = new FromTerm((Address)new InternetAddress(this.sosMailProcessInboxOptions.mailFromFilter.getValue()));
            SubjectTerm subjectTerm = new SubjectTerm(this.sosMailProcessInboxOptions.mailSubjectFilter.getValue());
            AndTerm searchTerm = new AndTerm((SearchTerm)subjectTerm, (SearchTerm)fromTerm);
            LOGGER.debug(String.format("looking for subject=%s and from=%s", this.sosMailProcessInboxOptions.mailSubjectFilter.getValue(), this.sosMailProcessInboxOptions.mailFromFilter.getValue()));
            msgs2 = this.inFolder.search((SearchTerm)searchTerm, msgs);
            LOGGER.debug(String.format("%s messages found with subject=%s and from=%s", msgs2.length, this.sosMailProcessInboxOptions.mailSubjectFilter.getValue(), this.sosMailProcessInboxOptions.mailFromFilter.getValue()));
        } else if (this.sosMailProcessInboxOptions.mailSubjectFilter.isNotEmpty()) {
            LOGGER.debug(String.format("looking for %1$s", this.sosMailProcessInboxOptions.mailSubjectFilter.getValue()));
            SubjectTerm subjectTerm = new SubjectTerm(this.sosMailProcessInboxOptions.mailSubjectFilter.getValue());
            msgs2 = this.inFolder.search((SearchTerm)subjectTerm, msgs);
            LOGGER.debug(String.format("%1$s messages found with subject=%2$s", msgs2.length, this.sosMailProcessInboxOptions.mailSubjectFilter.getValue()));
        } else if (this.sosMailProcessInboxOptions.mailFromFilter.isNotEmpty()) {
            fromTerm = new FromTerm((Address)new InternetAddress(this.sosMailProcessInboxOptions.mailFromFilter.getValue()));
            LOGGER.debug(String.format("looking for %1$s", this.sosMailProcessInboxOptions.mailFromFilter.getValue()));
            msgs2 = this.inFolder.search((SearchTerm)fromTerm, msgs);
            LOGGER.debug(String.format("%1$s messages found with from=%2$s", msgs2.length, this.sosMailProcessInboxOptions.mailSubjectFilter.getValue()));
        } else {
            msgs2 = msgs;
            LOGGER.debug(msgs2.length + " messages found, folder = " + messageFolder);
        }
        if (msgs2.length > 0) {
            for (Message messageElement : msgs2) {
                if (this.sosMailProcessInboxOptions.mailUseSeen.value() && messageElement.isSet(Flags.Flag.SEEN)) {
                    LOGGER.trace("message skipped, already seen: " + messageElement.getSubject());
                    continue;
                }
                try {
                    SOSMimeMessage sosMailItem = new SOSMimeMessage(messageElement, Boolean.valueOf(true));
                    if (this.sosMailProcessInboxOptions.mailSubjectPattern.isNotEmpty() && !subjectPattern.matcher(sosMailItem.getSubject()).find()) {
                        LOGGER.trace(String.format("message skipped, subject does not match [%1$s]: %2$s", this.sosMailProcessInboxOptions.mailSubjectPattern.getValue(), sosMailItem.getSubject()));
                        continue;
                    }
                    if (this.sosMailProcessInboxOptions.mailBodyPattern.isNotEmpty() && !bodyPattern.matcher(sosMailItem.getPlainTextBody()).find()) {
                        LOGGER.trace(String.format("message with subject %s skipped, body does not match [%s]", sosMailItem.getSubject()), (Object)this.sosMailProcessInboxOptions.mailBodyPattern.getValue());
                        continue;
                    }
                    sosMailItem.init();
                    this.executeMessage(sosMailItem);
                }
                catch (Exception e) {
                    LOGGER.info("message skipped, exception occured: " + messageElement.getSubject(), (Throwable)e);
                }
            }
        }
    }

    private void dumpMessage(SOSMimeMessage message, String directory) throws Exception {
        File messageFile = new File(directory, message.getMessageId());
        LOGGER.debug(String.format("dump message. subject=%s, date=%s, file=%s: ", message.getSubject(), message.getSentDateAsString(), messageFile));
        message.dumpMessageToFile(messageFile, true, false);
    }

    private void deleteMessage(SOSMimeMessage message) throws Exception {
        LOGGER.debug(String.format("deleting message. subject=%s, date=%s", message.getSubject(), message.getSentDateAsString()));
        message.deleteMessage();
    }

    private void copyAttachmentsToFile(SOSMimeMessage message) throws Exception {
        String directory = this.sosMailProcessInboxOptions.attachmentDirectoryName.getValue();
        LOGGER.debug(String.format("saving attachments. subject=%s, date=%s, directory=%s: ", message.getSubject(), message.getSentDateAsString(), directory));
        message.saveAttachments(message, this.sosMailProcessInboxOptions.attachmentFileNamePattern.getValue(), directory, this.sosMailProcessInboxOptions.saveBodyAsAttachments.value());
    }
}

