/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.messaging;

import com.sos.JSHelper.Basics.JSJobUtilitiesClass;
import com.sos.jitl.messaging.options.MessageConsumerOptions;
import com.sos.vfs.common.options.SOSProviderOptions;
import com.sos.vfs.jms.SOSJMS;
import java.util.HashMap;
import java.util.Map;
import javax.jms.Connection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageConsumerJob
extends JSJobUtilitiesClass<MessageConsumerOptions> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageConsumerJob.class);
    private static final String DEFAULT_QUEUE_NAME = "JobChainQueue";
    private static final String DEFAULT_PROTOCOL = "tcp";
    private String messageXml;
    private SOSJMS handler = new SOSJMS();

    public MessageConsumerJob() {
        super((Object)new MessageConsumerOptions());
    }

    public MessageConsumerJob execute() throws Exception {
        String message;
        String protocol = ((MessageConsumerOptions)((Object)this.objOptions)).getMessagingProtocol().getValue();
        if (protocol == null || protocol != null && protocol.isEmpty()) {
            protocol = DEFAULT_PROTOCOL;
        }
        String messageHost = ((MessageConsumerOptions)((Object)this.objOptions)).getMessagingServerHostName().getValue();
        String messagePort = ((MessageConsumerOptions)((Object)this.objOptions)).getMessagingServerPort().getValue();
        String queueName = ((MessageConsumerOptions)((Object)this.objOptions)).getMessagingQueueName().getValue();
        boolean executeXml = ((MessageConsumerOptions)((Object)this.objOptions)).getExecuteXml().value();
        boolean jobParams = ((MessageConsumerOptions)((Object)this.objOptions)).getJobParameters().value();
        boolean lastConsumer = ((MessageConsumerOptions)((Object)this.objOptions)).getLastReceiver().value();
        if (queueName == null || queueName != null && queueName.isEmpty()) {
            queueName = DEFAULT_QUEUE_NAME;
        }
        String connectionUrl = this.handler.createConnectionUrl(protocol, messageHost, messagePort);
        if (!this.handler.isConnected()) {
            this.connect();
        }
        Connection jmsConnection = this.handler.createConnection(connectionUrl);
        if (executeXml) {
            this.messageXml = this.handler.read(jmsConnection, queueName, Boolean.valueOf(lastConsumer));
        } else if (jobParams && (message = this.handler.read(jmsConnection, queueName, Boolean.valueOf(lastConsumer))) != null && !message.isEmpty()) {
            this.logReceivedParams(message);
        }
        return this;
    }

    public MessageConsumerOptions getOptions() {
        if (this.objOptions == null) {
            this.objOptions = new MessageConsumerOptions();
        }
        return (MessageConsumerOptions)((Object)this.objOptions);
    }

    public String getMessageXml() {
        return this.messageXml;
    }

    private Map<String, String> createParamMap(String message) {
        LOGGER.debug("************************Received Message: " + message);
        HashMap<String, String> paramMap = new HashMap<String, String>();
        String[] paramPairs = message.split("[" + ((MessageConsumerOptions)((Object)this.objOptions)).getParamPairDelimiter().getValue() + "]");
        LOGGER.debug("************************KeyValuePairs count: " + paramPairs.length);
        for (String keyValue : paramPairs) {
            String[] params = keyValue.split(((MessageConsumerOptions)((Object)this.objOptions)).getParamKeyValueDelimiter().getValue());
            paramMap.put(params[0], params[1]);
        }
        return paramMap;
    }

    private void logReceivedParams(String message) {
        Map<String, String> params = this.createParamMap(message);
        LOGGER.debug("****Example Output of Params received from message!****");
        for (String key : params.keySet()) {
            LOGGER.debug("KEY: " + key + " VALUE: " + params.get(key));
        }
    }

    public MessageConsumerJob connect() {
        SOSProviderOptions alternateOptions = this.getAlternateOptions();
        try {
            this.getOptions().checkMandatory();
            this.handler.connect(alternateOptions);
            LOGGER.debug("connection established");
        }
        catch (Exception e) {
            LOGGER.error("Error occurred trying to connect to VFS: ", (Throwable)e);
        }
        return this;
    }

    public SOSProviderOptions getAlternateOptions() {
        SOSProviderOptions alternateOptions = new SOSProviderOptions();
        alternateOptions.host.setValue(((MessageConsumerOptions)((Object)this.objOptions)).getMessagingServerHostName().getValue());
        alternateOptions.port.value(((MessageConsumerOptions)((Object)this.objOptions)).getMessagingServerPort().value());
        return alternateOptions;
    }
}

