/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.messaging;

import com.sos.JSHelper.Basics.JSJobUtilitiesClass;
import com.sos.JSHelper.Exceptions.JobSchedulerException;
import com.sos.jitl.messaging.options.MessageProducerOptions;
import com.sos.vfs.common.options.SOSProviderOptions;
import com.sos.vfs.jms.SOSJMS;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageProducerJob
extends JSJobUtilitiesClass<MessageProducerOptions> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageProducerJob.class);
    private static final String DEFAULT_QUEUE_NAME = "JobChainQueue";
    private static final String DEFAULT_PROTOCOL = "tcp";
    private boolean sentSuccesfull = false;
    private Map<String, String> allParams = new HashMap<String, String>();
    private SOSJMS handler = new SOSJMS();

    public MessageProducerJob() {
        super((Object)new MessageProducerOptions());
    }

    public MessageProducerJob execute() throws Exception {
        String protocol = ((MessageProducerOptions)((Object)this.objOptions)).getMessagingProtocol().getValue();
        if (protocol == null || protocol != null && protocol.isEmpty()) {
            protocol = DEFAULT_PROTOCOL;
        }
        String messageHost = ((MessageProducerOptions)((Object)this.objOptions)).getMessagingServerHostName().getValue();
        String messagePort = ((MessageProducerOptions)((Object)this.objOptions)).getMessagingServerPort().getValue();
        String message = ((MessageProducerOptions)((Object)this.objOptions)).getMessage().getValue();
        String queueName = ((MessageProducerOptions)((Object)this.objOptions)).getMessagingQueueName().getValue();
        boolean executeXml = ((MessageProducerOptions)((Object)this.objOptions)).getSendXml().value();
        boolean jobParams = ((MessageProducerOptions)((Object)this.objOptions)).getSendJobParameters().value();
        if (queueName == null || queueName != null && queueName.isEmpty()) {
            queueName = DEFAULT_QUEUE_NAME;
        }
        String connectionUrl = this.handler.createConnectionUrl(protocol, messageHost, messagePort);
        LOGGER.debug("*************Message from Option: " + message);
        if (!this.handler.isConnected()) {
            this.connect();
        }
        if (!executeXml && jobParams && (message == null || message.isEmpty())) {
            message = this.createParameterMessage();
            LOGGER.debug("*************Message dynamic created from params: " + message);
        }
        if (message == null || message.isEmpty()) {
            this.sentSuccesfull = false;
            throw new JobSchedulerException("Message is empty, nothing to send to message server");
        }
        this.handler.write(message, connectionUrl, queueName);
        this.sentSuccesfull = true;
        return this;
    }

    public MessageProducerOptions getOptions() {
        if (this.objOptions == null) {
            this.objOptions = new MessageProducerOptions();
        }
        return (MessageProducerOptions)((Object)this.objOptions);
    }

    public boolean isSentSuccesfull() {
        return this.sentSuccesfull;
    }

    private String createParameterMessage() {
        boolean first = true;
        StringBuilder strb = new StringBuilder();
        if (!this.allParams.isEmpty()) {
            for (String key : this.allParams.keySet()) {
                if (this.allParams.get(key) == null || this.allParams.get(key).isEmpty()) continue;
                if (!first) {
                    strb.append(((MessageProducerOptions)((Object)this.objOptions)).getParamPairDelimiter().getValue());
                } else {
                    first = false;
                }
                strb.append(key).append(((MessageProducerOptions)((Object)this.objOptions)).getParamKeyValueDelimiter().getValue()).append(this.allParams.get(key));
            }
        }
        return strb.toString();
    }

    public Map<String, String> getAllParams() {
        return this.allParams;
    }

    public void setAllParams(Map<String, String> allParams) {
        this.allParams = allParams;
    }

    public MessageProducerJob connect() {
        SOSProviderOptions alternateOptions = this.getAlternateOptions();
        try {
            this.getOptions().checkMandatory();
            this.handler.connect(alternateOptions);
            LOGGER.debug("connection established");
        }
        catch (Exception e) {
            LOGGER.error("Error occurred trying to connect to VFS: ", (Throwable)e);
        }
        return this;
    }

    public SOSProviderOptions getAlternateOptions() {
        SOSProviderOptions alternateOptions = new SOSProviderOptions();
        alternateOptions.host.setValue(((MessageProducerOptions)((Object)this.objOptions)).getMessagingServerHostName().getValue());
        alternateOptions.port.value(((MessageProducerOptions)((Object)this.objOptions)).getMessagingServerPort().value());
        return alternateOptions;
    }
}

