/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.notification.helper.elements.monitor;

import com.sos.jitl.notification.helper.NotificationXmlHelper;
import com.sos.jitl.notification.helper.elements.monitor.AElementNotificationMonitor;
import com.sos.jitl.notification.helper.elements.monitor.ElementNotificationInterface;
import com.sos.jitl.notification.helper.elements.monitor.cmd.ElementNotificationCommand;
import com.sos.jitl.notification.helper.elements.monitor.jms.ElementNotificationJMS;
import com.sos.jitl.notification.helper.elements.monitor.mail.ElementNotificationMail;
import com.sos.jitl.notification.jobs.notifier.SystemNotifierJobOptions;
import com.sos.jitl.notification.plugins.notifier.ISystemNotifierPlugin;
import org.w3c.dom.Node;

public class ElementNotificationMonitor
extends AElementNotificationMonitor {
    public static final String NOTIFICATION_INTERFACE = "NotificationInterface";
    public static final String NOTIFICATION_COMMAND = "NotificationCommand";
    public static final String NOTIFICATION_MAIL = "NotificationMail";
    public static final String NOTIFICATION_JMS = "NotificationJMS";
    private String serviceNameOnError;
    private String serviceNameOnSuccess;
    private String serviceStatusOnError;
    private String serviceStatusOnSuccess;
    private AElementNotificationMonitor monitorInterface;
    private ISystemNotifierPlugin pluginObject;
    private SystemNotifierJobOptions options;

    public ElementNotificationMonitor(Node node, SystemNotifierJobOptions opt) throws Exception {
        super(node);
        this.options = opt;
        this.serviceNameOnError = NotificationXmlHelper.getServiceNameOnError(this.getXmlElement());
        this.serviceNameOnSuccess = NotificationXmlHelper.getServiceNameOnSuccess(this.getXmlElement());
        this.serviceStatusOnError = NotificationXmlHelper.getServiceStatusOnError(this.getXmlElement());
        this.serviceStatusOnSuccess = NotificationXmlHelper.getServiceStatusOnSuccess(this.getXmlElement());
        Node notificationInterface = NotificationXmlHelper.selectNotificationInterface(this.getXmlElement(), NOTIFICATION_INTERFACE);
        if (notificationInterface != null) {
            this.monitorInterface = new ElementNotificationInterface(notificationInterface);
        }
        if (this.monitorInterface == null && (notificationInterface = NotificationXmlHelper.selectNotificationInterface(this.getXmlElement(), NOTIFICATION_COMMAND)) != null) {
            this.monitorInterface = new ElementNotificationCommand(notificationInterface);
        }
        if (this.monitorInterface == null && (notificationInterface = NotificationXmlHelper.selectNotificationInterface(this.getXmlElement(), NOTIFICATION_MAIL)) != null) {
            this.monitorInterface = new ElementNotificationMail(notificationInterface);
        }
        if (this.monitorInterface == null && (notificationInterface = NotificationXmlHelper.selectNotificationInterface(this.getXmlElement(), NOTIFICATION_JMS)) != null) {
            this.monitorInterface = new ElementNotificationJMS(notificationInterface);
        }
    }

    @Override
    public ISystemNotifierPlugin getOrCreatePluginObject() throws Exception {
        if (this.pluginObject == null && this.monitorInterface != null) {
            this.pluginObject = this.monitorInterface.getOrCreatePluginObject();
            if (this.pluginObject != null) {
                this.pluginObject.init(this, this.options);
            }
        }
        if (this.pluginObject == null) {
            throw new Exception("pluginObject is NULL");
        }
        return this.pluginObject;
    }

    public ISystemNotifierPlugin getPluginObject() {
        return this.pluginObject;
    }

    public String getServiceNameOnSuccess() {
        return this.serviceNameOnSuccess;
    }

    public void setServiceNameOnSuccess(String val) {
        this.serviceNameOnSuccess = val;
    }

    public String getServiceNameOnError() {
        return this.serviceNameOnError;
    }

    public String getServiceStatusOnError() {
        return this.serviceStatusOnError;
    }

    public String getServiceStatusOnSuccess() {
        return this.serviceStatusOnSuccess;
    }

    public AElementNotificationMonitor getMonitorInterface() {
        return this.monitorInterface;
    }
}

