/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.notification.helper.elements.objects;

import com.sos.jitl.notification.helper.NotificationXmlHelper;
import com.sos.jitl.notification.helper.elements.monitor.ElementNotificationMonitor;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import sos.util.SOSString;

public class ElementTimerRef {
    private ElementNotificationMonitor monitor;
    private Node xml;
    private String ref;
    private Long notifications;
    private boolean notifyOnError;

    public ElementTimerRef(ElementNotificationMonitor element, Node node) {
        this.monitor = element;
        this.xml = node;
        Element el = (Element)this.xml;
        this.ref = this.getValue(NotificationXmlHelper.getTimerRef(el));
        this.notifications = this.getLongValue(NotificationXmlHelper.getNotifications(el));
        this.setNotifyOnError(el);
    }

    private void setNotifyOnError(Element el) {
        this.notifyOnError = false;
        String noe = NotificationXmlHelper.getTimerNotifyOnError(el);
        try {
            this.notifyOnError = noe == null ? false : Boolean.parseBoolean(noe);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getValue(String val) {
        return SOSString.isEmpty((String)val) ? "*" : val;
    }

    private Long getLongValue(String val) {
        return SOSString.isEmpty((String)val) ? new Long(1L) : new Long(val);
    }

    public ElementNotificationMonitor getMonitor() {
        return this.monitor;
    }

    public Node getXml() {
        return this.xml;
    }

    public String getRef() {
        return this.ref;
    }

    public Long getNotifications() {
        return this.notifications;
    }

    public boolean getNotifyOnError() {
        return this.notifyOnError;
    }
}

