/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.notification.helper.elements.objects.jobchain;

import com.sos.jitl.notification.helper.NotificationXmlHelper;
import com.sos.jitl.notification.helper.elements.monitor.ElementNotificationMonitor;
import com.sos.jitl.notification.helper.elements.objects.jobchain.ElementNotifyRepeatedError;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import sos.util.SOSString;

public class ElementJobChain {
    public static String ELEMENT_NAME_NOTIFY_REPEATED_ERROR = "NotifyRepeatedError";
    private Node xml;
    private ElementNotificationMonitor monitor;
    private String schedulerId;
    private String name;
    private Long notifications;
    private String stepFrom;
    private String stepTo;
    private String returnCodeFrom;
    private String returnCodeTo;
    private ArrayList<String> excludedSteps;
    private String excludedStepsAsString;
    private ElementNotifyRepeatedError notifyRepeatedError;

    public ElementJobChain(ElementNotificationMonitor element, Node node) throws Exception {
        this.monitor = element;
        this.xml = node;
        Element el = (Element)this.xml;
        this.schedulerId = this.getValue(NotificationXmlHelper.getSchedulerId(el));
        this.name = this.getValue(NotificationXmlHelper.getJobChainName(el));
        this.notifications = this.getLongValue(NotificationXmlHelper.getNotifications(el));
        this.stepFrom = this.getValue(NotificationXmlHelper.getStepFrom(el));
        this.stepTo = this.getValue(NotificationXmlHelper.getStepTo(el));
        this.returnCodeFrom = this.getValue(NotificationXmlHelper.getReturnCodeFrom(el));
        this.returnCodeTo = this.getValue(NotificationXmlHelper.getReturnCodeTo(el));
        this.setExcludedSteps(el);
        Node n = NotificationXmlHelper.getChildNode(el, ELEMENT_NAME_NOTIFY_REPEATED_ERROR);
        if (n != null) {
            this.notifyRepeatedError = new ElementNotifyRepeatedError(n);
        }
    }

    private String getValue(String val) {
        return SOSString.isEmpty((String)val) ? "*" : val;
    }

    private Long getLongValue(String val) {
        return SOSString.isEmpty((String)val) ? new Long(1L) : new Long(val);
    }

    public ElementNotificationMonitor getMonitor() {
        return this.monitor;
    }

    public Node getXml() {
        return this.xml;
    }

    public String getSchedulerId() {
        return this.schedulerId;
    }

    public String getName() {
        return this.name;
    }

    public Long getNotifications() {
        return this.notifications;
    }

    public String getStepFrom() {
        return this.stepFrom;
    }

    public String getStepTo() {
        return this.stepTo;
    }

    public String getReturnCodeFrom() {
        return this.returnCodeFrom;
    }

    public String getReturnCodeTo() {
        return this.returnCodeTo;
    }

    private void setExcludedSteps(Element jobChain) {
        this.excludedSteps = new ArrayList();
        this.excludedStepsAsString = "";
        String es = NotificationXmlHelper.getExcludedSteps(jobChain);
        if (!SOSString.isEmpty((String)es)) {
            this.excludedStepsAsString = es;
            String[] arr = es.trim().split(";");
            for (int i = 0; i < arr.length; ++i) {
                if (arr[i].trim().isEmpty()) continue;
                this.excludedSteps.add(arr[i].trim());
            }
        }
    }

    public ArrayList<String> getExcludedSteps() {
        return this.excludedSteps;
    }

    public String getExcludedStepsAsString() {
        return this.excludedStepsAsString;
    }

    public ElementNotifyRepeatedError getNotifyRepeatedError() {
        return this.notifyRepeatedError;
    }
}

