/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.notification.jobs.cleanup;

import com.sos.JSHelper.Basics.JSJobUtilitiesClass;
import com.sos.hibernate.classes.SOSHibernateFactory;
import com.sos.hibernate.classes.SOSHibernateSession;
import com.sos.jitl.notification.db.DBLayer;
import com.sos.jitl.notification.jobs.cleanup.CleanupNotificationsJobOptions;
import com.sos.jitl.notification.model.cleanup.CleanupNotificationsModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CleanupNotificationsJob
extends JSJobUtilitiesClass<CleanupNotificationsJobOptions> {
    private static Logger LOGGER = LoggerFactory.getLogger(CleanupNotificationsJob.class);
    private final String className = CleanupNotificationsJob.class.getSimpleName();
    private SOSHibernateFactory factory;
    private SOSHibernateSession session;

    public CleanupNotificationsJob() {
        super((Object)new CleanupNotificationsJobOptions());
    }

    public void init() throws Exception {
        try {
            this.factory = new SOSHibernateFactory(this.getOptions().hibernate_configuration_file_reporting.getValue());
            this.factory.setAutoCommit(this.getOptions().connection_autocommit.value());
            this.factory.setTransactionIsolation(this.getOptions().connection_transaction_isolation.value());
            this.factory.addClassMapping(DBLayer.getNotificationClassMapping());
            this.factory.build();
        }
        catch (Exception ex) {
            throw new Exception(String.format("init connection: %s", ex.toString()), ex);
        }
    }

    public void openSession() throws Exception {
        this.session = this.factory.openStatelessSession();
    }

    public void closeSession() throws Exception {
        if (this.session != null) {
            this.session.close();
        }
    }

    public void exit() {
        if (this.factory != null) {
            this.factory.close();
        }
    }

    public CleanupNotificationsJob execute() throws Exception {
        String methodName = this.className + "::execute";
        LOGGER.debug(methodName);
        try {
            this.getOptions().checkMandatory();
            LOGGER.debug(this.getOptions().toString());
            CleanupNotificationsModel model = new CleanupNotificationsModel(this.session, this.getOptions());
            model.process();
        }
        catch (Exception e) {
            LOGGER.error(String.format("%s: %s", methodName, e.toString()), (Throwable)e);
            throw e;
        }
        return this;
    }

    public CleanupNotificationsJobOptions getOptions() {
        if (this.objOptions == null) {
            this.objOptions = new CleanupNotificationsJobOptions();
        }
        return (CleanupNotificationsJobOptions)((Object)this.objOptions);
    }
}

