/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.notification.model.internal;

import com.sos.hibernate.classes.SOSHibernateFactory;
import com.sos.hibernate.classes.SOSHibernateSession;
import com.sos.jitl.notification.db.DBItemReportingTaskAndOrder;
import com.sos.jitl.notification.db.DBItemSchedulerMonInternalNotifications;
import com.sos.jitl.notification.db.DBItemSchedulerMonNotifications;
import com.sos.jitl.notification.db.DBItemSchedulerMonSystemNotifications;
import com.sos.jitl.notification.exceptions.SOSSystemNotifierSendException;
import com.sos.jitl.notification.helper.EServiceMessagePrefix;
import com.sos.jitl.notification.helper.EServiceStatus;
import com.sos.jitl.notification.helper.NotificationMail;
import com.sos.jitl.notification.helper.NotificationXmlHelper;
import com.sos.jitl.notification.helper.elements.monitor.ElementNotificationMonitor;
import com.sos.jitl.notification.helper.elements.objects.internal.ElementInternal;
import com.sos.jitl.notification.helper.elements.objects.internal.ElementMasterMessage;
import com.sos.jitl.notification.helper.elements.objects.internal.ElementTaskIfLongerThan;
import com.sos.jitl.notification.helper.elements.objects.internal.ElementTaskIfShorterThan;
import com.sos.jitl.notification.helper.elements.objects.internal.ElementTaskWarning;
import com.sos.jitl.notification.helper.settings.InternalNotificationSettings;
import com.sos.jitl.notification.helper.settings.MailSettings;
import com.sos.jitl.notification.jobs.notifier.SystemNotifierJobOptions;
import com.sos.jitl.notification.model.NotificationModel;
import com.sos.jitl.notification.model.notifier.SystemNotifierModel;
import com.sos.jitl.notification.plugins.notifier.ISystemNotifierPlugin;
import com.sos.jitl.reporting.db.DBLayer;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import sos.util.SOSString;
import sos.xml.SOSXMLXPath;

public class ExecutorModel
extends NotificationModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecutorModel.class);
    private static final boolean isDebugEnabled = LOGGER.isDebugEnabled();
    private final Path configurationDirectory;
    private final Path hibernateConfiguration;
    private SOSHibernateFactory factory;
    private SystemNotifierJobOptions options = null;
    private boolean isNewSystemNotification = false;
    private InternalType internalType = null;

    public ExecutorModel(Path configDir, Path hibernateFile, MailSettings settings) {
        this.configurationDirectory = configDir;
        this.hibernateConfiguration = hibernateFile;
        this.options = new SystemNotifierJobOptions();
        this.options.scheduler_mail_settings.setValue(NotificationMail.getSchedulerMailOptions(settings));
        if (isDebugEnabled) {
            LOGGER.debug(String.format("[%s][%s]", this.configurationDirectory, this.hibernateConfiguration));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean process(InternalType type, InternalNotificationSettings settings) {
        String method = "process";
        this.internalType = type;
        boolean processed = false;
        try {
            if (SOSString.isEmpty((String)settings.getSchedulerId())) {
                throw new Exception("missing scheduler_id");
            }
            ArrayList<File> files = new ArrayList<File>();
            File defaultConfigFile = ExecutorModel.getDefaultNotificationXml();
            boolean useDefaultConfiguration = false;
            if (defaultConfigFile.exists()) {
                useDefaultConfiguration = true;
                files.add(defaultConfigFile);
                if (isDebugEnabled) {
                    LOGGER.debug(String.format("[%s][%s]use default system configuration file", method, ExecutorModel.normalizePath(defaultConfigFile)));
                }
            } else {
                Path notificationConfig;
                File[] notificationConfigFiles;
                if (isDebugEnabled) {
                    LOGGER.debug(String.format("[%s][%s]default system configuration file not found", method, ExecutorModel.normalizePath(defaultConfigFile)));
                }
                if ((notificationConfigFiles = ExecutorModel.getDirectoryFiles((notificationConfig = this.configurationDirectory.resolve("notification")).toFile())) != null && notificationConfigFiles.length > 0) {
                    files.addAll(Arrays.asList(notificationConfigFiles));
                    if (isDebugEnabled) {
                        LOGGER.debug(String.format("[%s][%s]found %s file(s)", method, ExecutorModel.normalizePath(notificationConfig.toFile()), files.size()));
                    }
                } else if (isDebugEnabled) {
                    LOGGER.debug(String.format("[%s][%s]files not found", method, ExecutorModel.normalizePath(notificationConfig.toFile())));
                }
            }
            if (files.size() == 0) {
                throw new Exception("missing configuration files");
            }
            Long notificationObjectType = null;
            Long taskId = null;
            switch (type) {
                case TASK_IF_LONGER_THAN: {
                    taskId = this.getTaskId(settings.getTaskId());
                    notificationObjectType = this.getTaskNotificationObjectType(taskId, com.sos.jitl.notification.db.DBLayer.NOTIFICATION_OBJECT_TYPE_INTERNAL_TASK_IF_LONGER_THAN);
                    break;
                }
                case TASK_IF_SHORTER_THAN: {
                    taskId = this.getTaskId(settings.getTaskId());
                    notificationObjectType = this.getTaskNotificationObjectType(taskId, com.sos.jitl.notification.db.DBLayer.NOTIFICATION_OBJECT_TYPE_INTERNAL_TASK_IF_SHORTER_THAN);
                    break;
                }
                case TASK_WARNING: {
                    taskId = this.getTaskId(settings.getTaskId());
                    notificationObjectType = this.getTaskNotificationObjectType(taskId, com.sos.jitl.notification.db.DBLayer.NOTIFICATION_OBJECT_TYPE_INTERNAL_TASK_WARNING);
                    break;
                }
                case MASTER_MESSAGE: {
                    notificationObjectType = com.sos.jitl.notification.db.DBLayer.NOTIFICATION_OBJECT_TYPE_INTERNAL_MASTER_MESSAGE;
                    break;
                }
                default: {
                    throw new Exception(String.format("[%s]not implemented yet", type.name()));
                }
            }
            this.buildFactory();
            for (int i = 0; i < files.size(); ++i) {
                boolean ok;
                File f = (File)files.get(i);
                if (isDebugEnabled) {
                    LOGGER.debug(String.format("[%s][%s][%s]%s", method, i + 1, type.name(), ExecutorModel.normalizePath(f)));
                }
                if (!(ok = this.handleConfigFile(useDefaultConfiguration, notificationObjectType, settings, f, taskId))) continue;
                processed = true;
            }
        }
        catch (Throwable ex) {
            LOGGER.error(String.format("[%s][%s]%s", method, type.name(), ex.toString()), ex);
        }
        finally {
            this.closeFactory();
        }
        if (isDebugEnabled) {
            LOGGER.debug(String.format("[%s][%s]processed=%s", method, type.name(), processed));
        }
        return processed;
    }

    private boolean handleConfigFile(boolean useDefaultConfiguration, Long notificationObjectType, InternalNotificationSettings settings, File xmlFile, Long taskId) throws Exception {
        String method = "handleConfigFile";
        String xmlFilePath = null;
        SOSXMLXPath xpath = null;
        Node node = null;
        boolean toNotify = false;
        ArrayList<ElementInternal> objects = new ArrayList<ElementInternal>();
        try {
            xmlFilePath = xmlFile.getCanonicalPath();
            xpath = new SOSXMLXPath(xmlFilePath);
            NodeList monitorList = NotificationXmlHelper.selectNotificationMonitorDefinitions(xpath);
            for (int i = 0; i < monitorList.getLength(); ++i) {
                ElementInternal el;
                Node n = monitorList.item(i);
                ElementNotificationMonitor monitor = new ElementNotificationMonitor(n, this.options);
                if (monitor.getMonitorInterface() == null) {
                    LOGGER.warn(String.format("[%s][%s][skip]missing Notification element", method, xmlFilePath));
                    continue;
                }
                if (SOSString.isEmpty((String)monitor.getServiceNameOnError())) {
                    LOGGER.warn(String.format("[%s][%s][skip]missing service_name_on_error", method, xmlFilePath));
                    continue;
                }
                if (notificationObjectType.equals(com.sos.jitl.notification.db.DBLayer.NOTIFICATION_OBJECT_TYPE_INTERNAL_TASK_IF_LONGER_THAN)) {
                    node = NotificationXmlHelper.selectNotificationMonitorInternalTaskIfLongerThan(xpath, n);
                    if (node == null) continue;
                    el = new ElementTaskIfLongerThan(monitor, node);
                    if (!SystemNotifierModel.checkDoNotifyInternal(0, settings.getSchedulerId(), el)) continue;
                    objects.add(el);
                    continue;
                }
                if (notificationObjectType.equals(com.sos.jitl.notification.db.DBLayer.NOTIFICATION_OBJECT_TYPE_INTERNAL_TASK_IF_SHORTER_THAN)) {
                    node = NotificationXmlHelper.selectNotificationMonitorInternalTaskIfShorterThan(xpath, n);
                    if (node == null) continue;
                    el = new ElementTaskIfShorterThan(monitor, node);
                    if (!SystemNotifierModel.checkDoNotifyInternal(0, settings.getSchedulerId(), el)) continue;
                    objects.add(el);
                    continue;
                }
                if (notificationObjectType.equals(com.sos.jitl.notification.db.DBLayer.NOTIFICATION_OBJECT_TYPE_INTERNAL_TASK_WARNING)) {
                    node = NotificationXmlHelper.selectNotificationMonitorInternalTaskWarning(xpath, n);
                    if (node == null) continue;
                    el = new ElementTaskWarning(monitor, node);
                    if (!SystemNotifierModel.checkDoNotifyInternal(0, settings.getSchedulerId(), el)) continue;
                    objects.add(el);
                    continue;
                }
                if (!notificationObjectType.equals(com.sos.jitl.notification.db.DBLayer.NOTIFICATION_OBJECT_TYPE_INTERNAL_MASTER_MESSAGE) || (node = NotificationXmlHelper.selectNotificationMonitorInternalMasterMessage(xpath, n)) == null) continue;
                el = new ElementMasterMessage(monitor, node);
                if (!SystemNotifierModel.checkDoNotifyInternal(0, settings.getSchedulerId(), el)) continue;
                objects.add(el);
            }
            if (objects.size() > 0) {
                String systemId = useDefaultConfiguration ? "MonitorSystem" : NotificationXmlHelper.getSystemMonitorNotificationSystemId(xpath);
                LOGGER.info(String.format("[%s][%s][%s][%s]%s definition(s)", method, this.internalType.name(), xmlFilePath, systemId, objects.size()));
                this.sendNotifications(settings, systemId, objects, notificationObjectType, taskId);
                toNotify = true;
            } else if (isDebugEnabled) {
                LOGGER.debug(String.format("[%s][%s]not found definitions", method, xmlFilePath));
            }
        }
        catch (Exception e) {
            throw new Exception(String.format("[%s][%s]%s", method, xmlFilePath, e.toString()), e);
        }
        return toNotify;
    }

    private void sendNotifications(InternalNotificationSettings settings, String systemId, List<ElementInternal> objects, Long notificationObjectType, Long taskId) throws Exception {
        String method = "sendNotifications";
        SOSHibernateSession session = null;
        try {
            session = this.factory.openStatelessSession();
            this.createDbLayer(session);
            DBItemSchedulerMonNotifications notification2send = this.getNotification2Send(settings, notificationObjectType, taskId);
            if (isDebugEnabled) {
                LOGGER.debug(String.format("[%s][notification2send]%s", method, NotificationModel.toString(notification2send)));
            }
            for (int i = 0; i < objects.size(); ++i) {
                this.notify(i + 1, settings, objects.get(i), notificationObjectType, systemId, notification2send);
            }
        }
        catch (Throwable ex) {
            try {
                if (session != null) {
                    session.rollback();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new Exception(String.format("[%s]%s", method, ex.toString()), ex);
        }
        finally {
            try {
                if (session != null) {
                    session.close();
                }
            }
            catch (Exception notification2send) {}
        }
    }

    private void notify(int currentCounter, InternalNotificationSettings settings, ElementInternal object, Long notificationObjectType, String systemId, DBItemSchedulerMonNotifications notification2send) throws Exception {
        String method = currentCounter + "][notify";
        ElementNotificationMonitor monitor = object.getMonitor();
        String serviceName = monitor.getServiceNameOnError();
        ISystemNotifierPlugin pl = monitor.getOrCreatePluginObject();
        if (pl.hasErrorOnInit()) {
            throw new Exception(String.format("[%s][%s][skip]due plugin init error: %s", method, serviceName, pl.getInitError()));
        }
        DBItemSchedulerMonSystemNotifications sn = this.getSystemNotification(settings, object, notificationObjectType, systemId, notification2send, serviceName);
        if (!this.isNewSystemNotification && sn.getMaxNotifications()) {
            LOGGER.info(String.format("[%s][%s][skip]maxNotifications=true", method, serviceName));
            if (isDebugEnabled) {
                LOGGER.debug(String.format("[%s]%s", method, NotificationModel.toString(sn)));
            }
            return;
        }
        if (sn.getCurrentNotification() >= object.getNotifications()) {
            this.closeSystemNotification(sn);
            LOGGER.info(String.format("[%s][%s][skip][%s]count notifications was reached", method, serviceName, object.getNotifications()));
            if (isDebugEnabled) {
                LOGGER.debug(String.format("[%s]%s", method, NotificationModel.toString(sn)));
            }
            return;
        }
        boolean originalMaxNotifications = this.isNewSystemNotification ? false : sn.getMaxNotifications();
        try {
            EServiceStatus serviceStatus = EServiceStatus.CRITICAL;
            EServiceMessagePrefix serviceMessagePrefix = EServiceMessagePrefix.ERROR;
            if (notification2send.getError()) {
                if (sn.getRecovered()) {
                    serviceStatus = EServiceStatus.OK;
                    serviceMessagePrefix = EServiceMessagePrefix.RECOVERED;
                }
            } else {
                serviceStatus = EServiceStatus.OK;
                serviceMessagePrefix = EServiceMessagePrefix.SUCCESS;
            }
            sn.setCurrentNotification(sn.getCurrentNotification() + 1L);
            if (sn.getCurrentNotification() >= object.getNotifications() || sn.getAcknowledged()) {
                sn.setMaxNotifications(true);
            }
            sn.setNotifications(object.getNotifications());
            sn.setModified(com.sos.jitl.notification.db.DBLayer.getCurrentDateTime());
            LOGGER.info(String.format("[%s][%s][%s]notification %s of %s. call plugin %s", method, this.internalType.name(), serviceName, sn.getCurrentNotification(), sn.getNotifications(), pl.getClass().getSimpleName()));
            pl.notifySystem(null, this.options, this.getDbLayer(), notification2send, sn, null, serviceStatus, serviceMessagePrefix);
        }
        catch (SOSSystemNotifierSendException ex) {
            sn.setCurrentNotification(sn.getCurrentNotification() - 1L);
            sn.setMaxNotifications(originalMaxNotifications);
            LOGGER.error(String.format("[%s][%s][error on message sending]%s", method, serviceName, ex.toString()), (Throwable)((Object)ex));
        }
        try {
            this.getDbLayer().getSession().beginTransaction();
            this.getDbLayer().getSession().update((Object)sn);
            this.getDbLayer().getSession().commit();
        }
        catch (Exception ex) {
            try {
                this.getDbLayer().getSession().rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private DBItemSchedulerMonNotifications getNotification2Send(InternalNotificationSettings settings, Long notificationObjectType, Long taskId) throws Exception {
        if (notificationObjectType.equals(com.sos.jitl.notification.db.DBLayer.NOTIFICATION_OBJECT_TYPE_INTERNAL_MASTER_MESSAGE)) {
            return this.getNotification2SendForMasterMessages(settings, notificationObjectType);
        }
        return this.getNotification2SendForTaskMessages(settings, notificationObjectType, taskId);
    }

    private DBItemSchedulerMonNotifications getNotification2SendForMasterMessages(InternalNotificationSettings settings, Long notificationObjectType) throws Exception {
        DBItemSchedulerMonNotifications notification2send = new DBItemSchedulerMonNotifications();
        notification2send.setSchedulerId(settings.getSchedulerId());
        notification2send.setError(true);
        notification2send.setErrorCode(settings.getMessageCode());
        notification2send.setErrorText(settings.getMessage());
        notification2send.setCreated(com.sos.jitl.notification.db.DBLayer.getCurrentDateTime());
        notification2send.setModified(notification2send.getCreated());
        this.getDbLayer().getSession().beginTransaction();
        DBItemSchedulerMonInternalNotifications internalNotification = this.createInternalNotification(notification2send, notificationObjectType);
        this.getDbLayer().getSession().save((Object)internalNotification);
        this.getDbLayer().getSession().commit();
        notification2send.setId(internalNotification.getId());
        return notification2send;
    }

    private DBItemSchedulerMonNotifications getNotification2SendForTaskMessages(InternalNotificationSettings settings, Long notificationObjectType, Long taskId) throws Exception {
        DBItemSchedulerMonInternalNotifications internalNotification;
        String method = "getNotification2SendForTaskMessages";
        DBItemSchedulerMonNotifications notification2send = new DBItemSchedulerMonNotifications();
        notification2send.setSchedulerId(settings.getSchedulerId());
        notification2send.setTaskId(taskId);
        notification2send.setError(true);
        notification2send.setErrorCode(settings.getMessageCode());
        notification2send.setErrorText(settings.getMessage());
        notification2send.setCreated(com.sos.jitl.notification.db.DBLayer.getCurrentDateTime());
        notification2send.setModified(notification2send.getCreated());
        this.getDbLayer().getSession().beginTransaction();
        List<DBItemReportingTaskAndOrder> results = this.getDbLayer().getReportingTaskAndOrder(settings.getSchedulerId(), taskId);
        for (int i = 0; i < results.size(); ++i) {
            DBItemReportingTaskAndOrder item = results.get(i);
            if (i > 0 && item.getOrderHistoryId() < notification2send.getOrderHistoryId()) continue;
            notification2send.setStandalone(!item.getIsOrder());
            notification2send.setJobChainName(item.getJobChainName());
            notification2send.setJobChainTitle(item.getJobChainTitle());
            notification2send.setOrderHistoryId(item.getOrderHistoryId());
            notification2send.setOrderId(item.getOrderId());
            notification2send.setOrderTitle(item.getOrderTitle());
            notification2send.setOrderStartTime(item.getOrderStartTime());
            notification2send.setOrderEndTime(item.getOrderEndTime());
            notification2send.setStep(item.getOrderStep());
            notification2send.setOrderStepState(item.getOrderStepState());
            notification2send.setOrderStepStartTime(item.getOrderStepStartTime());
            notification2send.setOrderStepEndTime(item.getOrderStepEndTime());
            notification2send.setJobName(item.getJobName());
            notification2send.setJobTitle(item.getJobTitle());
            notification2send.setTaskStartTime(item.getTaskStartTime());
            notification2send.setTaskEndTime(item.getTaskEndTime());
            notification2send.setReturnCode(new Long(item.getExitCode() == null ? 0L : (long)item.getExitCode().intValue()));
            notification2send.setAgentUrl(item.getAgentUrl());
            notification2send.setClusterMemberId(item.getClusterMemberId());
        }
        if (results.size() == 0) {
            LOGGER.warn(String.format("[%s][schedulerId=%s][taskId=%s]not found entries", method, settings.getSchedulerId(), taskId));
        }
        if ((internalNotification = this.getDbLayer().getInternalNotificationByTaskId(notification2send.getSchedulerId(), notification2send.getTaskId(), notificationObjectType)) == null) {
            internalNotification = this.createInternalNotification(notification2send, notificationObjectType);
            this.getDbLayer().getSession().save((Object)internalNotification);
        } else if (!this.isEquals(internalNotification, notification2send)) {
            internalNotification = this.updateInternalNotification(internalNotification, notification2send);
            this.getDbLayer().getSession().update((Object)internalNotification);
        }
        this.getDbLayer().getSession().commit();
        notification2send.setId(internalNotification.getId());
        return notification2send;
    }

    private DBItemSchedulerMonSystemNotifications getSystemNotification(InternalNotificationSettings settings, ElementInternal object, Long notificationObjectType, String systemId, DBItemSchedulerMonNotifications notification2send, String serviceName) throws Exception {
        Long checkId = new Long(0L);
        String stepFrom = "*";
        String stepTo = "*";
        String returnCodeFrom = "*";
        String returnCodeTo = "*";
        boolean isSuccess = false;
        this.isNewSystemNotification = false;
        this.getDbLayer().getSession().beginTransaction();
        DBItemSchedulerMonSystemNotifications sn = this.getDbLayer().getSystemNotification(systemId, serviceName, notification2send.getId(), checkId, notificationObjectType, isSuccess, stepFrom, stepTo, returnCodeFrom, returnCodeTo);
        if (sn == null) {
            sn = this.getDbLayer().createSystemNotification(systemId, serviceName, notification2send.getId(), checkId, returnCodeFrom, returnCodeTo, notificationObjectType, stepFrom, stepTo, notification2send.getTaskStartTime(), notification2send.getTaskEndTime(), new Long(0L), object.getNotifications(), false, false, isSuccess);
            if (!isSuccess && !SOSString.isEmpty((String)settings.getMessageTitle()) && settings.getMessageTitle().toLowerCase().contains(" recovered ")) {
                sn.setRecovered(true);
            }
            if (!SOSString.isEmpty((String)settings.getMessageTitle())) {
                String t = settings.getMessageTitle();
                if (t.startsWith("ERROR ")) {
                    t = t.substring(6);
                } else if (t.startsWith("[error] ")) {
                    t = t.substring(8);
                } else if (t.startsWith("[warning] ")) {
                    t = t.substring(10);
                }
                sn.setTitle(t.trim());
            }
            sn.setMaxNotifications(true);
            this.getDbLayer().getSession().save((Object)sn);
            this.isNewSystemNotification = true;
        }
        this.getDbLayer().getSession().commit();
        return sn;
    }

    private void closeSystemNotification(DBItemSchedulerMonSystemNotifications sn) throws Exception {
        this.getDbLayer().getSession().beginTransaction();
        this.getDbLayer().getSession().update((Object)sn);
        this.getDbLayer().getSession().commit();
    }

    private boolean isEquals(DBItemSchedulerMonInternalNotifications internalNotification, DBItemSchedulerMonNotifications notification) {
        return internalNotification.getOrderHistoryId().equals(notification.getOrderHistoryId());
    }

    private DBItemSchedulerMonInternalNotifications updateInternalNotification(DBItemSchedulerMonInternalNotifications internalNotification, DBItemSchedulerMonNotifications notification) {
        internalNotification.setStandalone(notification.getStandalone());
        internalNotification.setJobChainName(notification.getJobChainName());
        internalNotification.setJobChainTitle(notification.getJobChainTitle());
        internalNotification.setOrderHistoryId(notification.getOrderHistoryId());
        internalNotification.setOrderId(notification.getOrderId());
        internalNotification.setOrderTitle(notification.getOrderTitle());
        internalNotification.setOrderStartTime(notification.getOrderStartTime());
        internalNotification.setOrderEndTime(notification.getOrderEndTime());
        internalNotification.setStep(notification.getStep());
        internalNotification.setOrderStepState(notification.getOrderStepState());
        internalNotification.setOrderStepStartTime(notification.getOrderStepStartTime());
        internalNotification.setOrderStepEndTime(notification.getOrderStepEndTime());
        internalNotification.setJobName(notification.getJobName());
        internalNotification.setJobTitle(notification.getJobTitle());
        internalNotification.setTaskStartTime(notification.getTaskStartTime());
        internalNotification.setTaskEndTime(notification.getTaskEndTime());
        internalNotification.setReturnCode(notification.getReturnCode());
        internalNotification.setAgentUrl(notification.getAgentUrl());
        internalNotification.setClusterMemberId(notification.getClusterMemberId());
        internalNotification.setMessageCode(notification.getErrorCode());
        internalNotification.setMessage(notification.getErrorText());
        internalNotification.setModified(notification.getModified());
        return internalNotification;
    }

    private DBItemSchedulerMonInternalNotifications createInternalNotification(DBItemSchedulerMonNotifications notification, Long notificationObjectType) {
        DBItemSchedulerMonInternalNotifications internalNotification = new DBItemSchedulerMonInternalNotifications();
        internalNotification.setSchedulerId(notification.getSchedulerId());
        internalNotification.setObjectType(notificationObjectType);
        internalNotification.setStandalone(notification.getStandalone());
        internalNotification.setTaskId(notification.getTaskId());
        internalNotification.setStep(notification.getStep());
        internalNotification.setOrderHistoryId(notification.getOrderHistoryId());
        internalNotification.setJobChainName(notification.getJobChainName());
        internalNotification.setJobChainTitle(notification.getJobChainTitle());
        internalNotification.setOrderId(notification.getOrderId());
        internalNotification.setOrderTitle(notification.getOrderTitle());
        internalNotification.setOrderStartTime(notification.getOrderStartTime());
        internalNotification.setOrderEndTime(notification.getOrderEndTime());
        internalNotification.setOrderStepState(notification.getOrderStepState());
        internalNotification.setOrderStepStartTime(notification.getOrderStepStartTime());
        internalNotification.setOrderStepEndTime(notification.getOrderStepEndTime());
        internalNotification.setJobName(notification.getJobName());
        internalNotification.setJobTitle(notification.getJobTitle());
        internalNotification.setTaskStartTime(notification.getTaskStartTime());
        internalNotification.setTaskEndTime(notification.getTaskEndTime());
        internalNotification.setReturnCode(notification.getReturnCode());
        internalNotification.setAgentUrl(notification.getAgentUrl());
        internalNotification.setClusterMemberId(notification.getClusterMemberId());
        internalNotification.setError(notification.getError());
        internalNotification.setMessageCode(notification.getErrorCode());
        internalNotification.setMessage(notification.getErrorText());
        internalNotification.setCreated(notification.getCreated());
        internalNotification.setModified(notification.getModified());
        return internalNotification;
    }

    private Long getTaskId(String id) {
        Long taskId = null;
        if (!SOSString.isEmpty((String)id)) {
            try {
                taskId = Long.parseLong(id);
            }
            catch (Throwable ex) {
                LOGGER.warn(String.format("[getTaskId][%s]%s", id, ex.toString()), ex);
            }
        }
        return taskId;
    }

    private Long getTaskNotificationObjectType(Long taskId, Long notificationObjectType) {
        if (taskId == null) {
            LOGGER.info(String.format("switch from %s to %s", this.internalType.name(), InternalType.MASTER_MESSAGE.name()));
            this.internalType = InternalType.MASTER_MESSAGE;
            return com.sos.jitl.notification.db.DBLayer.NOTIFICATION_OBJECT_TYPE_INTERNAL_MASTER_MESSAGE;
        }
        return notificationObjectType;
    }

    private void buildFactory() throws Exception {
        if (this.factory == null) {
            this.factory = new SOSHibernateFactory(this.hibernateConfiguration);
            this.factory.setIdentifier("notification_internal");
            this.factory.setAutoCommit(false);
            this.factory.addClassMapping(com.sos.jitl.notification.db.DBLayer.getNotificationClassMapping());
            this.factory.addClassMapping(DBLayer.getReportingClassMapping());
            this.factory.build();
        }
    }

    private void closeFactory() {
        try {
            if (this.getDbLayer() != null && this.getDbLayer().getSession() != null) {
                this.getDbLayer().getSession().close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (this.factory != null) {
                this.factory.close();
                this.factory = null;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static enum InternalType {
        TASK_IF_LONGER_THAN,
        TASK_IF_SHORTER_THAN,
        TASK_WARNING,
        MASTER_MESSAGE;

    }
}

