/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.notification.plugins.notifier;

import com.sos.jitl.notification.db.DBItemSchedulerMonChecks;
import com.sos.jitl.notification.db.DBItemSchedulerMonNotifications;
import com.sos.jitl.notification.db.DBItemSchedulerMonSystemNotifications;
import com.sos.jitl.notification.db.DBLayerSchedulerMon;
import com.sos.jitl.notification.exceptions.SOSSystemNotifierSendException;
import com.sos.jitl.notification.helper.EServiceMessagePrefix;
import com.sos.jitl.notification.helper.EServiceStatus;
import com.sos.jitl.notification.helper.elements.monitor.ElementNotificationMonitor;
import com.sos.jitl.notification.jobs.notifier.SystemNotifierJobOptions;
import com.sos.jitl.notification.plugins.notifier.SystemNotifierPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.spooler.Spooler;

public abstract class SystemNotifierCustomPlugin
extends SystemNotifierPlugin {
    private static final Logger LOGGER = LoggerFactory.getLogger(SystemNotifierCustomPlugin.class);

    @Override
    public void init(ElementNotificationMonitor monitor, SystemNotifierJobOptions opt) throws Exception {
        super.init(monitor, opt);
        try {
            this.onInit();
        }
        catch (Throwable e) {
            this.setInitError(e.toString());
            throw e;
        }
    }

    @Override
    public int notifySystem(Spooler spooler, SystemNotifierJobOptions options, DBLayerSchedulerMon dbLayer, DBItemSchedulerMonNotifications notification, DBItemSchedulerMonSystemNotifications systemNotification, DBItemSchedulerMonChecks check, EServiceStatus status, EServiceMessagePrefix prefix) throws SOSSystemNotifierSendException {
        String method = "notifySystem";
        try {
            if (this.hasErrorOnInit()) {
                LOGGER.warn(String.format("[%s][%s][skip][due init error]%s", method, systemNotification.getServiceName(), this.getInitError()));
                return 0;
            }
            this.resetTableFields();
            this.onNotifySystem(systemNotification, notification, check, status, prefix);
            return 0;
        }
        catch (Throwable e) {
            throw new SOSSystemNotifierSendException(String.format("[%s]%s", method, e.toString()), e);
        }
    }

    @Override
    public void close() {
        this.onClose();
    }

    public abstract void onInit() throws Exception;

    public abstract void onClose();

    public abstract void onNotifySystem(DBItemSchedulerMonSystemNotifications var1, DBItemSchedulerMonNotifications var2, DBItemSchedulerMonChecks var3, EServiceStatus var4, EServiceMessagePrefix var5) throws Exception;
}

