/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.notification.plugins.notifier;

import com.sos.hibernate.classes.DbItem;
import com.sos.jitl.notification.db.DBItemSchedulerMonChecks;
import com.sos.jitl.notification.db.DBItemSchedulerMonNotifications;
import com.sos.jitl.notification.db.DBItemSchedulerMonSystemNotifications;
import com.sos.jitl.notification.db.DBLayer;
import com.sos.jitl.notification.db.DBLayerSchedulerMon;
import com.sos.jitl.notification.exceptions.SOSSystemNotifierSendException;
import com.sos.jitl.notification.helper.EServiceMessagePrefix;
import com.sos.jitl.notification.helper.EServiceStatus;
import com.sos.jitl.notification.helper.elements.monitor.ElementNotificationMonitor;
import com.sos.jitl.notification.jobs.notifier.SystemNotifierJobOptions;
import com.sos.jitl.notification.plugins.notifier.ISystemNotifierPlugin;
import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import javax.persistence.Column;
import sos.spooler.Spooler;
import sos.util.SOSString;

public class SystemNotifierPlugin
implements ISystemNotifierPlugin {
    private ElementNotificationMonitor notificationMonitor = null;
    private SystemNotifierJobOptions options;
    private String command;
    private Map<String, String> tableFields = null;
    private boolean hasErrorOnInit = false;
    private String initError = null;
    private boolean isWindows = false;
    public static final String VARIABLE_TABLE_PREFIX_NOTIFICATIONS = "MON_N";
    public static final String VARIABLE_TABLE_PREFIX_SYSNOTIFICATIONS = "MON_SN";
    public static final String VARIABLE_TABLE_PREFIX_CHECKS = "MON_C";
    public static final String VARIABLE_ENV_PREFIX = "SCHEDULER_MON";
    public static final String VARIABLE_ENV_PREFIX_TABLE_FIELD = "SCHEDULER_MON_TABLE";
    public static final String VARIABLE_SERVICE_NAME = "SERVICE_NAME";
    public static final String VARIABLE_SERVICE_MESSAGE_PREFIX = "SERVICE_MESSAGE_PREFIX";
    public static final String VARIABLE_SERVICE_STATUS = "SERVICE_STATUS";
    public static final String VARIABLE_JOC_HREF_JOB_CHAIN = "JOC_HREF_JOB_CHAIN";
    public static final String VARIABLE_JOC_HREF_ORDER = "JOC_HREF_ORDER";
    public static final String VARIABLE_JOC_HREF_JOB = "JOC_HREF_JOB";

    @Override
    public void init(ElementNotificationMonitor monitor, SystemNotifierJobOptions opt) throws Exception {
        this.notificationMonitor = monitor;
        this.options = opt;
        this.resetInitError();
        try {
            this.isWindows = System.getProperty("os.name").toLowerCase().contains("windows");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public int notifySystemReset(String serviceName, EServiceStatus status, EServiceMessagePrefix prefix, String command) throws Exception {
        return 0;
    }

    @Override
    public int notifySystem(Spooler spooler, SystemNotifierJobOptions options, DBLayerSchedulerMon dbLayer, DBItemSchedulerMonNotifications notification, DBItemSchedulerMonSystemNotifications systemNotification, DBItemSchedulerMonChecks check, EServiceStatus status, EServiceMessagePrefix prefix) throws SOSSystemNotifierSendException {
        return 0;
    }

    @Override
    public void close() {
    }

    @Override
    public boolean hasErrorOnInit() {
        return this.hasErrorOnInit;
    }

    @Override
    public String getInitError() {
        return this.initError;
    }

    public void setInitError(String err) {
        this.hasErrorOnInit = true;
        this.initError = err;
    }

    private void resetInitError() {
        this.hasErrorOnInit = false;
        this.initError = null;
    }

    public String getServiceStatusValue(EServiceStatus status) throws Exception {
        String method = "getServiceStatusValue";
        if (this.getNotificationMonitor() == null) {
            throw new Exception(String.format("%s: this.getNotificationMonitor() is NULL", method));
        }
        String serviceStatus = "0";
        serviceStatus = status.equals((Object)EServiceStatus.OK) ? (SOSString.isEmpty((String)this.getNotificationMonitor().getServiceStatusOnSuccess()) ? EServiceStatus.OK.name() : this.getNotificationMonitor().getServiceStatusOnSuccess()) : (SOSString.isEmpty((String)this.getNotificationMonitor().getServiceStatusOnError()) ? EServiceStatus.CRITICAL.name() : this.getNotificationMonitor().getServiceStatusOnError());
        return serviceStatus;
    }

    protected void resetTableFields() {
        this.tableFields = null;
    }

    protected void setTableFields(DbItem notification, DbItem systemNotification, DbItem check) throws Exception {
        if (notification == null) {
            throw new Exception("Cannot get table fields. DbItem notification is null");
        }
        if (systemNotification == null) {
            throw new Exception("Cannot get table fields. DbItem systemNotification is null");
        }
        this.tableFields = new HashMap<String, String>();
        this.setDbItemTableFields(notification, VARIABLE_TABLE_PREFIX_NOTIFICATIONS);
        this.setDbItemTableFields(systemNotification, VARIABLE_TABLE_PREFIX_SYSNOTIFICATIONS);
        this.setDbItemTableFields(check == null ? new DBItemSchedulerMonChecks() : check, VARIABLE_TABLE_PREFIX_CHECKS);
        this.setTableFieldElapsed("MON_N_ORDER_TIME_ELAPSED", "MON_N_ORDER_START_TIME", "MON_N_ORDER_END_TIME");
        this.setTableFieldElapsed("MON_N_TASK_TIME_ELAPSED", "MON_N_TASK_START_TIME", "MON_N_TASK_END_TIME");
        this.setTableFieldElapsed("MON_N_ORDER_STEP_TIME_ELAPSED", "MON_N_ORDER_STEP_START_TIME", "MON_N_ORDER_STEP_END_TIME");
        this.setTableFieldElapsed("MON_SN_STEP_TIME_ELAPSED", "MON_SN_STEP_FROM_START_TIME", "MON_SN_STEP_TO_END_TIME");
        this.setTableFieldObjectTypeName("MON_SN_OBJECT_TYPE_NAME", "MON_SN_OBJECT_TYPE");
        this.setTableFieldElapsed("MON_C_STEP_TIME_ELAPSED", "MON_C_STEP_FROM_START_TIME", "MON_C_STEP_TO_END_TIME");
    }

    private void setTableFieldElapsed(String newField, String startTimeField, String endTimeField) throws Exception {
        this.tableFields.put(newField, "");
        if (this.tableFields.containsKey(startTimeField) && this.tableFields.containsKey(endTimeField)) {
            String vnost = this.tableFields.get(startTimeField);
            String vnoet = this.tableFields.get(endTimeField);
            if (!SOSString.isEmpty((String)vnost) && !SOSString.isEmpty((String)vnoet)) {
                Date dnost = DBLayer.getDateFromString(vnost);
                Date dnoet = DBLayer.getDateFromString(vnoet);
                Long diffSeconds = dnoet.getTime() / 1000L - dnost.getTime() / 1000L;
                this.tableFields.put(newField, diffSeconds.toString());
            }
        }
    }

    private void setTableFieldObjectTypeName(String newField, String objectType) throws Exception {
        String ot;
        String name = "";
        this.tableFields.put(newField, name);
        if (this.tableFields.containsKey(objectType) && !SOSString.isEmpty((String)(ot = this.tableFields.get(objectType)))) {
            try {
                Long value = Long.parseLong(ot);
                if (value.equals(DBLayer.NOTIFICATION_OBJECT_TYPE_JOB)) {
                    name = "Job";
                } else if (value.equals(DBLayer.NOTIFICATION_OBJECT_TYPE_JOB_CHAIN)) {
                    name = "JobChain";
                } else if (value.equals(DBLayer.NOTIFICATION_OBJECT_TYPE_INTERNAL_MASTER_MESSAGE)) {
                    name = "MasterMessage";
                } else if (value.equals(DBLayer.NOTIFICATION_OBJECT_TYPE_INTERNAL_TASK_WARNING)) {
                    name = "TaskWarning";
                } else if (value.equals(DBLayer.NOTIFICATION_OBJECT_TYPE_INTERNAL_TASK_IF_LONGER_THAN)) {
                    name = "TaskIfLongerThan";
                } else if (value.equals(DBLayer.NOTIFICATION_OBJECT_TYPE_INTERNAL_TASK_IF_SHORTER_THAN)) {
                    name = "TaskIfShorterThan";
                }
                this.tableFields.put(newField, name);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void setDbItemTableFields(DbItem obj, String prefix) throws Exception {
        Method[] ms;
        for (Method m : ms = obj.getClass().getDeclaredMethods()) {
            Column c;
            if (!m.getName().startsWith("get") || (c = m.getAnnotation(Column.class)) == null) continue;
            String name = c.name().replaceAll("\\[", "").replaceAll("\\]", "");
            name = prefix + "_" + name;
            if (this.tableFields.containsKey(name)) continue;
            Object objVal = m.invoke((Object)obj, new Object[0]);
            String val = "";
            if (objVal != null) {
                val = objVal instanceof Timestamp ? DBLayer.getLocalDateAsString((Date)objVal) : (objVal instanceof Boolean ? ((Boolean)objVal != false ? "1" : "0") : objVal.toString());
            }
            this.tableFields.put(name, val);
        }
    }

    public String resolveAllVars(DBItemSchedulerMonSystemNotifications systemNotification, DBItemSchedulerMonNotifications notification, DBItemSchedulerMonChecks check, EServiceStatus status, EServiceMessagePrefix prefix, String msg) throws Exception {
        if (SOSString.isEmpty((String)msg)) {
            return msg;
        }
        String txt = msg;
        if (this.tableFields == null) {
            this.setTableFields(notification, systemNotification, check);
        }
        txt = this.resolveAllTableFieldVars(txt);
        txt = this.resolveVar(txt, VARIABLE_SERVICE_NAME, systemNotification.getServiceName());
        txt = this.resolveVar(txt, VARIABLE_SERVICE_STATUS, this.getServiceStatusValue(status));
        txt = this.resolveVar(txt, VARIABLE_SERVICE_MESSAGE_PREFIX, prefix == null ? null : prefix.name());
        txt = this.resolveEnvVars(txt, System.getenv());
        return txt;
    }

    protected void resolveCommandAllEnvVars() {
        this.command = this.resolveEnvVars(this.command, System.getenv());
    }

    protected String resolveEnvVars(String text, Map<String, String> envs) {
        if (text == null) {
            return null;
        }
        for (Map.Entry<String, String> entry : envs.entrySet()) {
            text = this.resolveEnvVar(text, entry.getKey(), entry.getValue());
        }
        return text;
    }

    private String resolveEnvVar(String cmd, String varName, String varValue) {
        String normalized;
        if (cmd == null) {
            return null;
        }
        String string = normalized = varValue == null ? "" : this.nl2sp(varValue);
        if (this.isWindows) {
            cmd = cmd.replaceAll("%(?i)" + varName + "%", Matcher.quoteReplacement(normalized));
        } else {
            cmd = cmd.replaceAll("\\$\\{(?i)" + varName + "\\}", Matcher.quoteReplacement(normalized));
            cmd = cmd.replaceAll("\\$(?i)" + varName, Matcher.quoteReplacement(normalized));
        }
        return cmd;
    }

    protected String resolveJocLinkJobChain(String val, String href) {
        return this.resolveVar(val, VARIABLE_JOC_HREF_JOB_CHAIN, href);
    }

    protected String resolveJocLinkOrder(String val, String href) {
        return this.resolveVar(val, VARIABLE_JOC_HREF_ORDER, href);
    }

    protected String resolveJocLinkJob(String val, String href) {
        return this.resolveVar(val, VARIABLE_JOC_HREF_JOB, href);
    }

    protected void resolveCommandServiceNameVar(String serviceName) {
        this.command = this.resolveVar(this.command, VARIABLE_SERVICE_NAME, serviceName);
    }

    protected void resolveCommandServiceMessagePrefixVar(String prefix) {
        this.command = this.resolveVar(this.command, VARIABLE_SERVICE_MESSAGE_PREFIX, prefix);
    }

    protected void resolveCommandJocLinks(String jocHrefJobChain, String jocHrefJob) {
        this.command = this.resolveJocLinkJobChain(this.command, jocHrefJobChain);
        this.command = this.resolveJocLinkJob(this.command, jocHrefJob);
    }

    protected void resolveCommandServiceStatusVar(String serviceStatus) {
        this.command = this.resolveVar(this.command, VARIABLE_SERVICE_STATUS, serviceStatus);
    }

    protected void resolveCommandAllTableFieldVars() throws Exception {
        this.command = this.resolveAllTableFieldVars(this.command);
    }

    protected String nl2sp(String value) {
        return value.replaceAll("\\r\\n|\\r|\\n", " ");
    }

    private String nl2br(String value) {
        return value.replaceAll("\\r\\n|\\r|\\n", "<br/>");
    }

    protected String resolveAllTableFieldVars(String text) throws Exception {
        if (text == null) {
            return null;
        }
        if (this.tableFields == null) {
            throw new Exception("tableFields is NULL");
        }
        for (Map.Entry<String, String> entry : this.tableFields.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            value = this.onResolveAllTableFieldVars(key, value);
            text = this.resolveVar(text, key, value);
        }
        return text;
    }

    public String onResolveAllTableFieldVars(String key, String value) {
        return value;
    }

    protected String resolveVar(String text, String varName, String varValue) {
        if (text == null) {
            return null;
        }
        String normalized = varValue == null ? "" : this.nl2sp(varValue);
        text = text.replaceAll("\\$\\{(?i)" + varName + "\\}", Matcher.quoteReplacement(normalized));
        return text.replaceAll("\\{(?i)" + varName + "\\}", Matcher.quoteReplacement(normalized));
    }

    protected void setCommand(String cmd) {
        this.command = cmd;
    }

    public ElementNotificationMonitor getNotificationMonitor() {
        return this.notificationMonitor;
    }

    protected String getCommand() {
        return this.command;
    }

    protected Map<String, String> getTableFields() {
        return this.tableFields;
    }

    public SystemNotifierJobOptions getOptions() {
        return this.options;
    }

    public boolean isWindows() {
        return this.isWindows;
    }
}

