/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.notification.plugins.notifier;

import com.sos.jitl.notification.db.DBItemSchedulerMonChecks;
import com.sos.jitl.notification.db.DBItemSchedulerMonNotifications;
import com.sos.jitl.notification.db.DBItemSchedulerMonSystemNotifications;
import com.sos.jitl.notification.db.DBLayerSchedulerMon;
import com.sos.jitl.notification.exceptions.SOSSystemNotifierSendException;
import com.sos.jitl.notification.helper.EServiceMessagePrefix;
import com.sos.jitl.notification.helper.EServiceStatus;
import com.sos.jitl.notification.helper.elements.monitor.ElementNotificationMonitor;
import com.sos.jitl.notification.helper.elements.monitor.cmd.ElementNotificationCommand;
import com.sos.jitl.notification.jobs.notifier.SystemNotifierJobOptions;
import com.sos.jitl.notification.plugins.notifier.SystemNotifierPlugin;
import java.util.Map;
import java.util.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.spooler.Spooler;
import sos.util.SOSString;

public class SystemNotifierProcessBuilderPlugin
extends SystemNotifierPlugin {
    private static final Logger LOGGER = LoggerFactory.getLogger(SystemNotifierProcessBuilderPlugin.class);
    private ElementNotificationCommand config = null;

    @Override
    public void init(ElementNotificationMonitor monitor, SystemNotifierJobOptions opt) throws Exception {
        super.init(monitor, opt);
        this.config = (ElementNotificationCommand)this.getNotificationMonitor().getMonitorInterface();
        if (this.config == null) {
            throw new Exception(String.format("[init]%s element is missing (not configured)", "NotificationCommand"));
        }
    }

    @Override
    public int notifySystemReset(String serviceName, EServiceStatus status, EServiceMessagePrefix prefix, String message) throws Exception {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int notifySystem(Spooler spooler, SystemNotifierJobOptions options, DBLayerSchedulerMon dbLayer, DBItemSchedulerMonNotifications notification, DBItemSchedulerMonSystemNotifications systemNotification, DBItemSchedulerMonChecks check, EServiceStatus status, EServiceMessagePrefix prefix) throws SOSSystemNotifierSendException {
        String method = "notifySystem";
        Process p = null;
        int exitCode = 0;
        try {
            this.setCommand(this.config.getCommand());
            String serviceStatus = this.getServiceStatusValue(status);
            String servicePrefix = prefix == null ? "" : prefix.name();
            this.setTableFields(notification, systemNotification, check);
            this.resolveCommandAllTableFieldVars();
            this.resolveCommandServiceNameVar(systemNotification.getServiceName());
            this.resolveCommandServiceStatusVar(serviceStatus);
            this.resolveCommandServiceMessagePrefixVar(servicePrefix);
            ProcessBuilder pb = new ProcessBuilder(new String[0]);
            pb.command(this.createProcessBuilderCommand(this.getCommand()));
            Map<String, String> env = pb.environment();
            env.put("SCHEDULER_MON_SERVICE_STATUS", serviceStatus);
            env.put("SCHEDULER_MON_SERVICE_NAME", systemNotification.getServiceName());
            env.put("SCHEDULER_MON_SERVICE_MESSAGE_PREFIX", servicePrefix.trim());
            env.put("SCHEDULER_MON_SERVICE_COMMAND", this.getCommand());
            if (this.getTableFields() != null) {
                for (Map.Entry<String, String> entry : this.getTableFields().entrySet()) {
                    env.put("SCHEDULER_MON_TABLE_" + entry.getKey().toUpperCase(), this.nl2sp(entry.getValue()));
                }
            }
            LOGGER.info(String.format("[%s-%s][command][preview]%s", serviceStatus, servicePrefix, this.resolveEnvVars(this.getCommand(), env)));
            LOGGER.info(String.format("[%s-%s][command][execute]%s", serviceStatus, servicePrefix, pb.command()));
            p = pb.start();
            if (p.waitFor() != 0) {
                exitCode = p.exitValue();
            }
            if (exitCode > 0) {
                String m;
                StringBuffer inputStream = new StringBuffer();
                StringBuffer errorStream = new StringBuffer();
                Scanner s = null;
                try {
                    s = new Scanner(p.getInputStream());
                    while (s.hasNext()) {
                        m = s.next();
                        if (m.trim().length() <= 0) continue;
                        inputStream.append(m.trim());
                        inputStream.append(" ");
                    }
                }
                catch (Exception ex) {
                    LOGGER.warn(String.format("error reading process input stream = %s", ex.toString()));
                }
                finally {
                    if (s != null) {
                        try {
                            s.close();
                        }
                        catch (Exception ex) {}
                    }
                }
                try {
                    s = new Scanner(p.getErrorStream());
                    while (s.hasNext()) {
                        m = s.next();
                        if (m.trim().length() <= 0) continue;
                        errorStream.append(m.trim());
                        errorStream.append(" ");
                    }
                }
                catch (Exception ex) {
                    LOGGER.warn(String.format("error reading process error stream = %s", ex.toString()));
                }
                finally {
                    if (s != null) {
                        try {
                            s.close();
                        }
                        catch (Exception exception) {}
                    }
                }
                if (inputStream.length() > 0 || errorStream.length() > 0) {
                    throw new Exception(String.format("[command executed][exitCode=%s][input stream=%s][error stream=%s]", exitCode, inputStream.toString(), errorStream.toString()));
                }
            }
            LOGGER.info(String.format("[%s-%s][command][executed]exitCode=%s", serviceStatus, servicePrefix, exitCode));
            int n = exitCode;
            return n;
        }
        catch (Throwable ex) {
            throw new SOSSystemNotifierSendException(String.format("[%s]%s", method, ex.toString()), ex);
        }
        finally {
            try {
                p.destroy();
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public String onResolveAllTableFieldVars(String key, String value) {
        switch (key) {
            case "MON_N_ERROR_TEXT": 
            case "MON_SN_TITLE": {
                if (SOSString.isEmpty((String)value)) break;
                if (this.isWindows()) {
                    value = this.mask4Windows(value);
                    break;
                }
                value = this.mask4Unix(value);
                break;
            }
        }
        return value;
    }

    private String[] createProcessBuilderCommand(String command) {
        String[] c = new String[3];
        if (this.isWindows()) {
            String executable = System.getenv("comspec");
            if (SOSString.isEmpty((String)executable)) {
                executable = "cmd.exe";
            }
            c[0] = executable;
            c[1] = "/C";
            c[2] = command;
        } else {
            String executable = System.getenv("SHELL");
            if (SOSString.isEmpty((String)executable)) {
                executable = "/bin/sh";
            }
            c[0] = executable;
            c[1] = "-c";
            c[2] = command;
        }
        return c;
    }

    private String mask4Windows(String s) {
        return s.replaceAll("<", "^<").replaceAll(">", "^>").replaceAll("%", "^%").replaceAll("&", "^&");
    }

    private String mask4Unix(String s) {
        return s.replaceAll("\"", "\\\\\"").replaceAll("<", "\\\\<").replaceAll(">", "\\\\>").replaceAll("%", "\\\\%").replaceAll("&", "\\\\&").replaceAll(";", "\\\\;").replaceAll("'", "\\\\'");
    }
}

