/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.reporting.db;

import com.sos.hibernate.classes.DbItem;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import sos.util.SOSString;

@Entity
@Table(name="INVENTORY_CALENDARS")
@SequenceGenerator(name="REPORTING_IC_ID_SEQ", sequenceName="REPORTING_IC_ID_SEQ", allocationSize=1)
public class DBItemCalendar
extends DbItem
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int TITLE_MAX_LENGTH = 255;
    private Long id;
    private Long instanceId;
    private String name;
    private String baseName;
    private String directory;
    private String category;
    private String type;
    private String title;
    private Date created;
    private Date modified;
    private String configuration;

    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="REPORTING_IC_ID_SEQ")
    @Column(name="[ID]", nullable=false)
    public Long getId() {
        return this.id;
    }

    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="REPORTING_IC_ID_SEQ")
    @Column(name="[ID]", nullable=false)
    public void setId(Long val) {
        this.id = val;
    }

    @Column(name="[INSTANCE_ID]", nullable=true)
    public void setInstanceId(Long val) {
        this.instanceId = val;
    }

    @Column(name="[INSTANCE_ID]", nullable=true)
    public Long getInstanceId() {
        return this.instanceId;
    }

    @Column(name="[NAME]", nullable=false)
    public void setName(String val) {
        this.name = val;
    }

    @Column(name="[NAME]", nullable=false)
    public String getName() {
        return this.name;
    }

    @Column(name="[BASENAME]", nullable=false)
    public void setBaseName(String val) {
        this.baseName = val;
    }

    @Column(name="[BASENAME]", nullable=false)
    public String getBaseName() {
        return this.baseName;
    }

    @Column(name="[DIRECTORY]", nullable=false)
    public void setDirectory(String val) {
        this.directory = val;
    }

    @Column(name="[DIRECTORY]", nullable=false)
    public String getDirectory() {
        return this.directory;
    }

    @Column(name="[CATEGORY]", nullable=true)
    public void setCategory(String val) {
        this.category = val;
    }

    @Column(name="[CATEGORY]", nullable=true)
    public String getCategory() {
        return this.category;
    }

    @Column(name="[TYPE]", nullable=false)
    public void setType(String val) {
        this.type = val;
    }

    @Column(name="[TYPE]", nullable=false)
    public String getType() {
        return this.type;
    }

    @Column(name="[TITLE]", nullable=true)
    public void setTitle(String val) {
        if (SOSString.isEmpty((String)val)) {
            val = null;
        } else if (val.length() > 255) {
            val = val.substring(0, 255);
        }
        this.title = val;
    }

    @Column(name="[TITLE]", nullable=true)
    public String getTitle() {
        return this.title;
    }

    @Column(name="[CONFIGURATION]", nullable=false)
    public void setConfiguration(String val) {
        this.configuration = val;
    }

    @Column(name="[CONFIGURATION]", nullable=false)
    public String getConfiguration() {
        return this.configuration;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="[CREATED]", nullable=false)
    public void setCreated(Date val) {
        this.created = val;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="[CREATED]", nullable=false)
    public Date getCreated() {
        return this.created;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="[MODIFIED]", nullable=false)
    public void setModified(Date val) {
        this.modified = val;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="[MODIFIED]", nullable=false)
    public Date getModified() {
        return this.modified;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.instanceId).append((Object)this.name).toHashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof DBItemCalendar)) {
            return false;
        }
        DBItemCalendar rhs = (DBItemCalendar)other;
        return new EqualsBuilder().append((Object)this.instanceId, (Object)rhs.instanceId).append((Object)this.name, (Object)rhs.name).isEquals();
    }
}

