/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.reporting.db;

import com.sos.hibernate.classes.DbItem;
import com.sos.jitl.reporting.db.DBLayer;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import sos.util.SOSString;

@Entity
@Table(name="INVENTORY_JOB_CHAIN_NODES")
@SequenceGenerator(name="REPORTING_IJCN_ID_SEQ", sequenceName="REPORTING_IJCN_ID_SEQ", allocationSize=1)
public class DBItemInventoryJobChainNode
extends DbItem
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long id;
    private Long instanceId;
    private Long jobChainId;
    private String jobName;
    private Long ordering;
    private String name;
    private String state;
    private String nextState;
    private String errorState;
    private String job;
    private Date created;
    private Date modified;
    private Long jobId;
    private String nestedJobChain;
    private String nestedJobChainName;
    private Long nestedJobChainId;
    private Integer nodeType;
    private String onError;
    private Integer delay;
    private String directory;
    private String regex;
    private Integer fileSinkOp;
    private String movePath;

    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="REPORTING_IJCN_ID_SEQ")
    @Column(name="[ID]", nullable=false)
    public Long getId() {
        return this.id;
    }

    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="REPORTING_IJCN_ID_SEQ")
    @Column(name="[ID]", nullable=false)
    public void setId(Long val) {
        this.id = val;
    }

    @Column(name="[INSTANCE_ID]", nullable=false)
    public Long getInstanceId() {
        return this.instanceId;
    }

    @Column(name="[INSTANCE_ID]", nullable=false)
    public void setInstanceId(Long val) {
        if (val == null) {
            val = DBLayer.DEFAULT_ID;
        }
        this.instanceId = val;
    }

    @Column(name="[JOB_CHAIN_ID]", nullable=false)
    public Long getJobChainId() {
        return this.jobChainId;
    }

    @Column(name="[JOB_CHAIN_ID]", nullable=false)
    public void setJobChainId(Long val) {
        if (val == null) {
            val = DBLayer.DEFAULT_ID;
        }
        this.jobChainId = val;
    }

    @Column(name="[JOB_NAME]", nullable=false)
    public void setJobName(String val) {
        if (SOSString.isEmpty((String)val)) {
            val = ".";
        }
        this.jobName = val;
    }

    @Column(name="[JOB_NAME]", nullable=false)
    public String getJobName() {
        return this.jobName;
    }

    @Column(name="[ORDERING]", nullable=false)
    public void setOrdering(Long val) {
        this.ordering = val;
    }

    @Column(name="[ORDERING]", nullable=false)
    public Long getOrdering() {
        return this.ordering;
    }

    @Column(name="[STATE]", nullable=true)
    public void setState(String val) {
        if (SOSString.isEmpty((String)val)) {
            val = null;
        }
        this.state = val;
    }

    @Column(name="[STATE]", nullable=true)
    public String getState() {
        return this.state;
    }

    @Column(name="[NEXT_STATE]", nullable=true)
    public void setNextState(String val) {
        if (SOSString.isEmpty((String)val)) {
            val = null;
        }
        this.nextState = val;
    }

    @Column(name="[NEXT_STATE]", nullable=true)
    public String getNextState() {
        return this.nextState;
    }

    @Column(name="[ERROR_STATE]", nullable=true)
    public void setErrorState(String val) {
        if (SOSString.isEmpty((String)val)) {
            val = null;
        }
        this.errorState = val;
    }

    @Column(name="[ERROR_STATE]", nullable=true)
    public String getErrorState() {
        return this.errorState;
    }

    @Column(name="[JOB]", nullable=true)
    public void setJob(String val) {
        if (SOSString.isEmpty((String)val)) {
            val = null;
        }
        this.job = val;
    }

    @Column(name="[JOB]", nullable=true)
    public String getJob() {
        return this.job;
    }

    @Column(name="[NAME]", nullable=false)
    public void setName(String val) {
        this.name = val;
    }

    @Column(name="[NAME]", nullable=false)
    public String getName() {
        return this.name;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="[CREATED]", nullable=false)
    public void setCreated(Date val) {
        this.created = val;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="[CREATED]", nullable=false)
    public Date getCreated() {
        return this.created;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="[MODIFIED]", nullable=false)
    public void setModified(Date val) {
        this.modified = val;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="[MODIFIED]", nullable=false)
    public Date getModified() {
        return this.modified;
    }

    @Column(name="[JOB_ID]", nullable=false)
    public Long getJobId() {
        return this.jobId;
    }

    @Column(name="[JOB_ID]", nullable=false)
    public void setJobId(Long jobId) {
        if (jobId == null) {
            jobId = DBLayer.DEFAULT_ID;
        }
        this.jobId = jobId;
    }

    @Column(name="[NESTED_JOB_CHAIN]", nullable=true)
    public String getNestedJobChain() {
        return this.nestedJobChain;
    }

    @Column(name="[NESTED_JOB_CHAIN]", nullable=true)
    public void setNestedJobChain(String nestedJobChain) {
        this.nestedJobChain = nestedJobChain;
    }

    @Column(name="[NESTED_JOB_CHAIN_NAME]", nullable=false)
    public String getNestedJobChainName() {
        return this.nestedJobChainName;
    }

    @Column(name="[NESTED_JOB_CHAIN_NAME]", nullable=false)
    public void setNestedJobChainName(String nestedJobChainName) {
        if (nestedJobChainName == null || nestedJobChainName.isEmpty()) {
            nestedJobChainName = ".";
        }
        this.nestedJobChainName = nestedJobChainName;
    }

    @Column(name="[NESTED_JOB_CHAIN_ID]", nullable=false)
    public Long getNestedJobChainId() {
        return this.nestedJobChainId;
    }

    @Column(name="[NESTED_JOB_CHAIN_ID]", nullable=false)
    public void setNestedJobChainId(Long nestedJobChainId) {
        if (nestedJobChainId == null) {
            nestedJobChainId = DBLayer.DEFAULT_ID;
        }
        this.nestedJobChainId = nestedJobChainId;
    }

    @Column(name="[NODE_TYPE]", nullable=false)
    public Integer getNodeType() {
        return this.nodeType;
    }

    @Column(name="[NODE_TYPE]", nullable=false)
    public void setNodeType(Integer nodeType) {
        this.nodeType = nodeType;
    }

    @Column(name="[ON_ERROR]", nullable=true)
    public String getOnError() {
        return this.onError;
    }

    @Column(name="[ON_ERROR]", nullable=true)
    public void setOnError(String onError) {
        this.onError = onError;
    }

    @Column(name="[DELAY]", nullable=true)
    public Integer getDelay() {
        return this.delay;
    }

    @Column(name="[DELAY]", nullable=true)
    public void setDelay(Integer delay) {
        this.delay = delay;
    }

    @Column(name="[DIRECTORY]", nullable=true)
    public String getDirectory() {
        return this.directory;
    }

    @Column(name="[DIRECTORY]", nullable=true)
    public void setDirectory(String directory) {
        this.directory = directory;
    }

    @Column(name="[REGEX]", nullable=true)
    public String getRegex() {
        return this.regex;
    }

    @Column(name="[REGEX]", nullable=true)
    public void setRegex(String regex) {
        this.regex = regex;
    }

    @Column(name="[FILE_SINK_OP]", nullable=true)
    public Integer getFileSinkOp() {
        return this.fileSinkOp;
    }

    @Column(name="[FILE_SINK_OP]", nullable=true)
    public void setFileSinkOp(Integer fileSinkOp) {
        this.fileSinkOp = fileSinkOp;
    }

    @Column(name="[MOVE_PATH]", nullable=true)
    public String getMovePath() {
        return this.movePath;
    }

    @Column(name="[MOVE_PATH]", nullable=true)
    public void setMovePath(String movePath) {
        this.movePath = movePath;
    }

    public int hashCode() {
        if ("file_order_source".equalsIgnoreCase(this.name)) {
            return new HashCodeBuilder().append((Object)this.instanceId).append((Object)this.jobChainId).append((Object)this.directory).append((Object)(this.regex == null || this.regex.isEmpty() ? ".*" : this.regex)).toHashCode();
        }
        return new HashCodeBuilder().append((Object)this.instanceId).append((Object)this.jobChainId).append((Object)this.name).append((Object)this.state).toHashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof DBItemInventoryJobChainNode)) {
            return false;
        }
        DBItemInventoryJobChainNode rhs = (DBItemInventoryJobChainNode)other;
        if ("file_order_source".equalsIgnoreCase(this.name)) {
            return new EqualsBuilder().append((Object)this.instanceId, (Object)rhs.instanceId).append((Object)this.jobChainId, (Object)rhs.jobChainId).append((Object)this.directory, (Object)rhs.directory).append((Object)(this.regex == null || this.regex.isEmpty() ? ".*" : this.regex), (Object)(rhs.regex == null || rhs.regex.isEmpty() ? ".*" : rhs.regex)).isEquals();
        }
        return new EqualsBuilder().append((Object)this.instanceId, (Object)rhs.instanceId).append((Object)this.jobChainId, (Object)rhs.jobChainId).append((Object)this.name, (Object)rhs.name).append((Object)this.state, (Object)rhs.state).isEquals();
    }
}

