/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.reporting.db;

import com.sos.hibernate.classes.SOSHibernateSession;
import com.sos.hibernate.classes.SearchStringHelper;
import com.sos.hibernate.exceptions.SOSHibernateException;
import com.sos.hibernate.layer.SOSHibernateIntervalDBLayer;
import com.sos.jitl.reporting.db.DBItemReportExecution;
import com.sos.jitl.reporting.db.filter.ReportExecutionFilter;
import com.sos.joc.model.common.Folder;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.TimeZone;
import javax.persistence.TemporalType;
import org.hibernate.query.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportExecutionsDBLayer
extends SOSHibernateIntervalDBLayer<DBItemReportExecution> {
    private static final String DBItemReportExecution = DBItemReportExecution.class.getName();
    protected ReportExecutionFilter filter = null;
    private static final Logger LOGGER = LoggerFactory.getLogger(ReportExecutionsDBLayer.class);
    private String lastQuery = "";

    public ReportExecutionsDBLayer(String configurationFilename) throws SOSHibernateException {
        this.setConfigurationFileName(configurationFilename);
        this.createStatelessConnection(this.getConfigurationFileName());
        this.resetFilter();
    }

    public ReportExecutionsDBLayer(File configurationFile) throws SOSHibernateException {
        try {
            this.createStatelessConnection(configurationFile.getCanonicalPath());
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            this.setConfigurationFileName("");
        }
        this.resetFilter();
    }

    public ReportExecutionsDBLayer(SOSHibernateSession conn) {
        this.sosHibernateSession = conn;
        this.resetFilter();
    }

    public DBItemReportExecution get(Long id) throws SOSHibernateException {
        return (DBItemReportExecution)this.sosHibernateSession.get(DBItemReportExecution.class, (Serializable)id);
    }

    public void resetFilter() {
        this.filter = new ReportExecutionFilter();
        this.filter.setDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
        this.filter.setOrderCriteria("startTime");
        this.filter.setSortMode("desc");
    }

    public ReportExecutionFilter getFilter() {
        return this.filter;
    }

    public void setFilter(ReportExecutionFilter filter_) {
        this.filter = filter_;
    }

    private String getStatusClause(String status) {
        if ("SUCCESSFUL".equals(status)) {
            return "(endTime is not null and error <> 1)";
        }
        if ("INCOMPLETE".equals(status)) {
            return "(startTime is not null and endTime is null)";
        }
        if ("FAILED".equals(status)) {
            return "(endTime is not null and error = 1)";
        }
        return "";
    }

    protected String getWhere() {
        String where = "";
        String and = "";
        if (this.filter.getSchedulerId() != null && !"".equals(this.filter.getSchedulerId())) {
            where = where + and + " schedulerId=:schedulerId";
            and = " and ";
        }
        if (this.filter.getOrderId() != null && !"".equals(this.filter.getOrderId())) {
            where = where + and + " name >= :orderId";
            and = " and ";
        }
        if (this.filter.getJobChain() != null && !"".equals(this.filter.getJobChain())) {
            where = where + String.format(and + " parentName %s :jobChain", SearchStringHelper.getSearchPathOperator((String)this.filter.getJobChain()));
            and = " and ";
        }
        if (this.filter.getStartTime() != null) {
            where = where + and + " startTime>= :startTime";
            and = " and ";
        }
        if (this.filter.getEndTime() != null) {
            where = where + and + " endTime < :endTime ";
            and = " and ";
        }
        if (this.filter.getListOfJobs() != null && this.filter.getListOfJobs().size() > 0) {
            where = where + and + SearchStringHelper.getStringListPathSql(this.filter.getListOfJobs(), (String)"name");
            and = " and ";
        } else if (this.filter.getStates() != null && this.filter.getStates().size() > 0) {
            where = where + and + "(";
            for (String state : this.filter.getStates()) {
                where = where + this.getStatusClause(state) + " or";
            }
            where = where + " 1=0)";
            and = " and ";
        }
        if (!"".equals(where.trim())) {
            where = "where " + where;
        }
        return where;
    }

    protected String getWhereFromTo() {
        return this.getWhereFromToStart();
    }

    protected String getWhereFromToStart() {
        return this.getWhereFromTo("startTime");
    }

    protected String getWhereFromToEnd() {
        return this.getWhereFromTo("endTime");
    }

    protected String getWhereFromTo(String fieldname_date_field) {
        String where = "";
        String and = "";
        if (this.filter.getSchedulerId() != null && !"".equals(this.filter.getSchedulerId())) {
            where = where + and + " schedulerId=:schedulerId";
            and = " and ";
        }
        if (this.filter.getExecutedFrom() != null) {
            where = where + and + fieldname_date_field + " >= :startTimeFrom";
            and = " and ";
        }
        if (this.filter.getExecutedTo() != null) {
            where = where + and + fieldname_date_field + " < :startTimeTo ";
            and = " and ";
        }
        if (this.filter.getListOfJobs() != null && this.filter.getListOfJobs().size() > 0) {
            where = where + and + SearchStringHelper.getStringListPathSql(this.filter.getListOfJobs(), (String)"name");
            and = " and ";
        } else {
            if (this.filter.getListOfExcludedJobs() != null && this.filter.getListOfExcludedJobs().size() > 0) {
                where = where + and + "(";
                for (String job : this.filter.getListOfExcludedJobs()) {
                    where = where + " name <> '" + job + "' and";
                }
                where = where + " 1=1)";
                and = " and ";
            }
            if (this.filter.getStates() != null && this.filter.getStates().size() > 0) {
                where = where + and + "(";
                for (String state : this.filter.getStates()) {
                    where = where + this.getStatusClause(state) + " or";
                }
                where = where + " 1=0)";
                and = " and ";
            }
            if (this.filter.getListOfFolders() != null && this.filter.getListOfFolders().size() > 0) {
                where = where + and + "(";
                for (Folder filterFolder : this.filter.getListOfFolders()) {
                    if (filterFolder.getRecursive().booleanValue()) {
                        String likeFolder = (filterFolder.getFolder() + "/%").replaceAll("//+", "/");
                        where = where + " (folder = '" + filterFolder.getFolder() + "' or folder like '" + likeFolder + "')";
                    } else {
                        where = where + " folder = '" + filterFolder.getFolder() + "'";
                    }
                    where = where + " or ";
                }
                where = where + " 0=1)";
                and = " and ";
            }
        }
        if (!"".equals(where.trim())) {
            where = "where " + where;
        }
        return where;
    }

    public long deleteInterval() throws SOSHibernateException {
        int row = 0;
        String hql = "delete from " + DBItemReportExecution + " " + this.getWhereFromTo();
        Query query = this.sosHibernateSession.createQuery(hql);
        if (this.filter.getExecutedFrom() != null) {
            query.setParameter("startTimeFrom", this.filter.getExecutedFrom(), TemporalType.TIMESTAMP);
        }
        if (this.filter.getExecutedTo() != null) {
            query.setParameter("startTimeTo", this.filter.getExecutedTo(), TemporalType.TIMESTAMP);
        }
        row = this.sosHibernateSession.executeUpdate(query);
        this.sosHibernateSession.commit();
        return row;
    }

    public int delete() throws SOSHibernateException {
        int row = 0;
        String hql = "delete from " + DBItemReportExecution + " " + this.getWhereFromTo();
        Query query = this.sosHibernateSession.createQuery(hql);
        if (this.filter.getSchedulerId() != null && !"".equalsIgnoreCase(this.filter.getSchedulerId())) {
            query.setParameter("schedulerId", (Object)this.filter.getSchedulerId());
        }
        if (this.filter.getExecutedFrom() != null) {
            query.setParameter("startTimeFrom", this.filter.getExecutedFrom(), TemporalType.TIMESTAMP);
        }
        if (this.filter.getExecutedTo() != null) {
            query.setParameter("startTimeTo", this.filter.getExecutedTo(), TemporalType.TIMESTAMP);
        }
        row = this.sosHibernateSession.executeUpdate(query);
        this.sosHibernateSession.commit();
        return row;
    }

    private List<DBItemReportExecution> executeQuery(Query<DBItemReportExecution> query, int limit) throws SOSHibernateException {
        this.lastQuery = query.getQueryString();
        if (this.filter.getSchedulerId() != null && !"".equals(this.filter.getSchedulerId())) {
            query.setParameter("schedulerId", (Object)this.filter.getSchedulerId());
        }
        if (this.filter.getExecutedFrom() != null) {
            query.setParameter("startTimeFrom", this.filter.getExecutedFrom(), TemporalType.TIMESTAMP);
        }
        if (this.filter.getExecutedTo() != null) {
            query.setParameter("startTimeTo", this.filter.getExecutedTo(), TemporalType.TIMESTAMP);
        }
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        return this.sosHibernateSession.getResultList(query);
    }

    public List<DBItemReportExecution> getOrderStepHistoryItems() throws SOSHibernateException {
        Query query = this.sosHibernateSession.createQuery(String.format("from %s where triggerHistoryId = %s order by step asc", DBItemReportExecution, this.filter.getOrderHistoryId()));
        return this.sosHibernateSession.getResultList(query);
    }

    public List<DBItemReportExecution> getSchedulerHistoryListFromTo() throws SOSHibernateException {
        int limit = this.getFilter().getLimit();
        Query query = this.sosHibernateSession.createQuery(String.format("from %s %s %s %s", DBItemReportExecution, this.getWhereFromTo(), this.filter.getOrderCriteria(), this.filter.getSortMode()));
        return this.executeQuery((Query<DBItemReportExecution>)query, limit);
    }

    public List<DBItemReportExecution> getUnassignedSchedulerHistoryListFromTo() throws SOSHibernateException {
        int limit = this.getFilter().getLimit();
        Query query = this.sosHibernateSession.createQuery("from " + DBItemReportExecution + " " + this.getWhereFromTo() + " and id NOT IN (select reportExecutionId from DailyPlanDBItem where reportExecutionId is not null and isAssigned=1 and schedulerId=:schedulerId) " + this.filter.getOrderCriteria() + this.filter.getSortMode());
        return this.executeQuery((Query<DBItemReportExecution>)query, limit);
    }

    public List<DBItemReportExecution> getSchedulerHistoryListFromToStart() throws SOSHibernateException {
        int limit = this.getFilter().getLimit();
        Query query = this.sosHibernateSession.createQuery(String.format("from %s %s %s %s", DBItemReportExecution, this.getWhereFromToStart(), this.filter.getOrderCriteria(), this.filter.getSortMode()));
        return this.executeQuery((Query<DBItemReportExecution>)query, limit);
    }

    public List<DBItemReportExecution> getSchedulerHistoryListFromToEnd() throws SOSHibernateException {
        int limit = this.getFilter().getLimit();
        Query query = this.sosHibernateSession.createQuery(String.format("from %s %s %s %s", DBItemReportExecution, this.getWhereFromToEnd(), this.filter.getOrderCriteria(), this.filter.getSortMode()));
        return this.executeQuery((Query<DBItemReportExecution>)query, limit);
    }

    public List<DBItemReportExecution> getSchedulerHistoryListSchedulersFromTo() throws SOSHibernateException {
        int limit = this.getFilter().getLimit();
        String q = "from " + DBItemReportExecution + " e where e.schedulerId IN (select distinct e.schedulerId from " + DBItemReportExecution + " " + this.getWhereFromTo() + ")";
        Query query = this.sosHibernateSession.createQuery(q);
        return this.executeQuery((Query<DBItemReportExecution>)query, limit);
    }

    public List<DBItemReportExecution> getHistoryItems() throws SOSHibernateException {
        int limit = this.getFilter().getLimit();
        List historyList = null;
        Query query = this.sosHibernateSession.createQuery(String.format("from %s %s %s %s", DBItemReportExecution, this.getWhere(), this.filter.getOrderCriteria(), this.filter.getSortMode()));
        if (this.filter.getSchedulerId() != null && !"".equalsIgnoreCase(this.filter.getSchedulerId())) {
            query.setParameter("schedulerId", (Object)this.filter.getSchedulerId());
        }
        if (this.filter.getStartTime() != null) {
            query.setParameter("startTime", this.filter.getStartTime(), TemporalType.TIMESTAMP);
        }
        if (this.filter.getEndTime() != null && !"".equals(this.filter.getEndTime())) {
            query.setParameter("endTime", this.filter.getEndTime(), TemporalType.TIMESTAMP);
        }
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        historyList = this.sosHibernateSession.getResultList(query);
        return historyList;
    }

    public DBItemReportExecution getHistoryItem() throws SOSHibernateException {
        this.filter.setLimit(1);
        Query query = this.sosHibernateSession.createQuery(String.format("from %s %s %s %s", DBItemReportExecution, this.getWhere(), this.filter.getOrderCriteria(), this.filter.getSortMode()));
        if (this.filter.getSchedulerId() != null && !"".equalsIgnoreCase(this.filter.getSchedulerId())) {
            query.setParameter("schedulerId", (Object)this.filter.getSchedulerId());
        }
        if (this.filter.getStartTime() != null) {
            query.setParameter("startTime", this.filter.getStartTime(), TemporalType.TIMESTAMP);
        }
        if (this.filter.getEndTime() != null && !"".equals(this.filter.getEndTime())) {
            query.setParameter("endTime", this.filter.getEndTime(), TemporalType.TIMESTAMP);
        }
        if (this.filter.getLimit() > 0) {
            query.setMaxResults(this.filter.getLimit());
        }
        return (DBItemReportExecution)this.sosHibernateSession.getSingleResult(query);
    }

    public String getLastQuery() {
        return this.lastQuery;
    }

    public void onAfterDeleting(DBItemReportExecution h) {
    }

    public List<DBItemReportExecution> getListOfItemsToDelete() throws SOSHibernateException {
        TimeZone.setDefault(TimeZone.getTimeZone("Etc/UTC"));
        int limit = this.getFilter().getLimit();
        Query query = this.sosHibernateSession.createQuery(String.format("from %s %s %s %s", DBItemReportExecution, this.getWhereFromTo(), this.filter.getOrderCriteria(), this.filter.getSortMode()));
        if (this.filter.getSchedulerId() != null && !"".equals(this.filter.getSchedulerId())) {
            query.setParameter("schedulerId", (Object)this.filter.getSchedulerId());
        }
        if (this.filter.getExecutedFrom() != null) {
            query.setParameter("startTimeFrom", this.filter.getExecutedFrom(), TemporalType.TIMESTAMP);
        }
        if (this.filter.getExecutedTo() != null) {
            query.setParameter("startTimeTo", this.filter.getExecutedTo(), TemporalType.TIMESTAMP);
        }
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        return this.sosHibernateSession.getResultList(query);
    }
}

