/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.reporting.db;

import com.sos.hibernate.classes.SOSHibernateSession;
import com.sos.hibernate.classes.SearchStringHelper;
import com.sos.hibernate.exceptions.SOSHibernateException;
import com.sos.hibernate.layer.SOSHibernateIntervalDBLayer;
import com.sos.jitl.reporting.db.DBItemReportTrigger;
import com.sos.jitl.reporting.db.filter.ReportTriggerFilter;
import com.sos.joc.model.common.Folder;
import java.io.Serializable;
import java.util.List;
import javax.persistence.TemporalType;
import org.hibernate.query.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportTriggerDBLayer
extends SOSHibernateIntervalDBLayer<DBItemReportTrigger> {
    private static final String DBItemReportTrigger = DBItemReportTrigger.class.getName();
    private ReportTriggerFilter filter = null;
    private static final Logger LOGGER = LoggerFactory.getLogger(ReportTriggerDBLayer.class);
    private String lastQuery = "";

    public ReportTriggerDBLayer(String configurationFilename) throws SOSHibernateException {
        this.setConfigurationFileName(configurationFilename);
        this.resetFilter();
        this.createStatelessConnection(this.getConfigurationFileName());
    }

    public ReportTriggerDBLayer(SOSHibernateSession conn) {
        this.sosHibernateSession = conn;
        this.resetFilter();
    }

    private String getStatusClause(String status) {
        if ("SUCCESSFUL".equals(status)) {
            return "(endTime != null and resultError <> 1)";
        }
        if ("INCOMPLETE".equals(status)) {
            return "(startTime != null and endTime is null)";
        }
        if ("FAILED".equals(status)) {
            return "(endTime != null and resultError = 1)";
        }
        return "";
    }

    public DBItemReportTrigger get(Long id) throws SOSHibernateException {
        if (id == null) {
            return null;
        }
        return (DBItemReportTrigger)this.sosHibernateSession.get(DBItemReportTrigger.class, (Serializable)id);
    }

    private String getWhere() {
        String where = "";
        String and = "";
        if (this.filter.getSchedulerId() != null && !"".equals(this.filter.getSchedulerId())) {
            where = where + and + " schedulerId=:schedulerId";
            and = " and ";
        }
        if (this.filter.getOrderId() != null && !"".equals(this.filter.getOrderId())) {
            where = where + and + " name = :orderId";
            and = " and ";
        }
        if (this.filter.getListOfJobchains() != null && this.filter.getListOfJobchains().size() > 0) {
            where = where + and + SearchStringHelper.getStringListPathSql(this.filter.getListOfJobchains(), (String)"parentName");
            and = " and ";
        }
        if (this.filter.getJobChain() != null && !"".equals(this.filter.getJobChain())) {
            where = where + String.format(and + " parentName %s :jobChain", SearchStringHelper.getSearchPathOperator((String)this.filter.getJobChain()));
            and = " and ";
        }
        if (this.filter.getStates() != null && this.filter.getStates().size() > 0) {
            where = where + and;
            if (this.filter.getStates().size() == 1) {
                where = where + this.getStatusClause(this.filter.getStates().get(0));
            } else {
                where = where + "(";
                for (String string : this.filter.getStates()) {
                    where = where + this.getStatusClause(string) + " or ";
                }
                where = where + " 1=0)";
            }
            and = " and ";
        }
        if (this.filter.getHistoryIds() != null && !this.filter.getHistoryIds().isEmpty()) {
            where = where + and + " historyId in (:historyIds)";
            and = " and ";
        }
        if (this.filter.getListOfReportItems() != null && this.filter.getListOfReportItems().size() > 0) {
            where = where + and + "(";
            String or = "";
            for (DBItemReportTrigger dbItemReportTrigger : this.filter.getListOfReportItems()) {
                if (dbItemReportTrigger.getHistoryId() != null) {
                    where = where + or + "historyId = " + dbItemReportTrigger.getHistoryId().toString() + " ";
                } else {
                    where = where + or + "parentName = '" + dbItemReportTrigger.getParentName() + "' ";
                    if (dbItemReportTrigger.getName() != null && !dbItemReportTrigger.getName().isEmpty()) {
                        where = where + "and name = '" + dbItemReportTrigger.getName() + "' ";
                    }
                }
                or = "or ";
            }
            where = where + ")";
            and = " and ";
        } else {
            if (this.filter.getListOfIgnoredItems() != null && this.filter.getListOfIgnoredItems().size() > 0) {
                where = where + and + "(";
                for (DBItemReportTrigger dBItemReportTrigger : this.filter.getListOfIgnoredItems()) {
                    where = dBItemReportTrigger.getName() != null && !dBItemReportTrigger.getName().isEmpty() ? where + " concat(concat(parentName,','),name) <> '" + String.format("%s,%s", dBItemReportTrigger.getParentName(), dBItemReportTrigger.getName()) + "' " : where + " parentName <> '" + dBItemReportTrigger.getParentName() + "'";
                    where = where + " and ";
                }
                where = where + " 1=1)";
                and = " and ";
            }
            if (this.filter.getListOfFolders() != null && this.filter.getListOfFolders().size() > 0) {
                where = where + and + "(";
                for (Folder folder : this.filter.getListOfFolders()) {
                    if (folder.getRecursive().booleanValue()) {
                        String likeFolder = (folder.getFolder() + "/%").replaceAll("//+", "/");
                        where = where + " (parentFolder = '" + folder.getFolder() + "' or parentFolder like '" + likeFolder + "')";
                    } else {
                        where = where + " parentFolder = '" + folder.getFolder() + "'";
                    }
                    where = where + " or ";
                }
                where = where + " 0=1)";
                and = " and ";
            }
        }
        if (this.filter.getExecutedFrom() != null) {
            where = where + and + " startTime>= :startTimeFrom";
            and = " and ";
        }
        if (this.filter.getExecutedTo() != null) {
            where = where + and + " startTime < :startTimeTo ";
            and = " and ";
        }
        if (this.filter.getFailed() != null) {
            if (this.filter.getFailed().booleanValue()) {
                where = where + and + " resultError = 1";
                and = " and ";
            } else {
                where = where + and + " resultError = 0";
                and = " and ";
            }
        }
        if (this.filter.getSuccess() != null) {
            if (this.filter.getSuccess().booleanValue()) {
                where = where + and + " resultError = 0";
                and = " and ";
            } else {
                where = where + and + " resultError = 1";
                and = " and ";
            }
        }
        where = !"".equals(where.trim()) ? " where " + where : " ";
        return where;
    }

    private <T> Query<T> bindParameters(Query<T> query) {
        this.lastQuery = query.getQueryString();
        if (this.filter.getExecutedFrom() != null) {
            query.setParameter("startTimeFrom", this.filter.getExecutedFrom(), TemporalType.TIMESTAMP);
        }
        if (this.filter.getExecutedTo() != null) {
            query.setParameter("startTimeTo", this.filter.getExecutedTo(), TemporalType.TIMESTAMP);
        }
        if (this.filter.getOrderId() != null && !"".equals(this.filter.getOrderId())) {
            query.setParameter("orderId", (Object)this.filter.getOrderId());
        }
        if (this.filter.getJobChain() != null && !"".equals(this.filter.getJobChain())) {
            query.setParameter("jobChain", (Object)SearchStringHelper.getSearchPathValue((String)this.filter.getJobChain()));
        }
        if (this.filter.getHistoryIds() != null && !this.filter.getHistoryIds().isEmpty()) {
            query.setParameterList("historyIds", this.filter.getHistoryIds());
        }
        if (this.filter.getSchedulerId() != null && !"".equals(this.filter.getSchedulerId())) {
            query.setParameter("schedulerId", (Object)this.filter.getSchedulerId());
        }
        return query;
    }

    public List<DBItemReportTrigger> getSchedulerOrderHistoryListFromTo() throws SOSHibernateException {
        int limit = this.filter.getLimit();
        Query query = this.sosHibernateSession.createQuery(" from " + DBItemReportTrigger + this.getWhere() + this.filter.getOrderCriteria() + this.filter.getSortMode());
        query = this.bindParameters(query);
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        return this.sosHibernateSession.getResultList(query);
    }

    public Long getCountSchedulerOrderHistoryListFromTo() throws SOSHibernateException {
        Query query = this.sosHibernateSession.createQuery("select count(*) from " + DBItemReportTrigger + this.getWhere());
        Long count = this.sosHibernateSession.getResultList(query = this.bindParameters(query)).size() > 0 ? (Long)this.sosHibernateSession.getResultList(query).get(0) : Long.valueOf(0L);
        return count;
    }

    public ReportTriggerFilter getFilter() {
        return this.filter;
    }

    public void resetFilter() {
        this.filter = new ReportTriggerFilter();
        this.filter.setDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
        this.filter.setOrderCriteria("startTime");
        this.filter.setSortMode("desc");
    }

    public String getLastQuery() {
        return this.lastQuery;
    }

    public void onAfterDeleting(DBItemReportTrigger h) throws SOSHibernateException {
    }

    public List<DBItemReportTrigger> getListOfItemsToDelete() throws SOSHibernateException {
        return null;
    }

    public long deleteInterval() throws SOSHibernateException {
        return 0L;
    }
}

