/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.reporting.yade;

import com.sos.hibernate.classes.SOSHibernateSession;
import com.sos.hibernate.exceptions.SOSHibernateException;
import com.sos.jade.db.DBItemYadeFiles;
import com.sos.jade.db.DBItemYadeProtocols;
import com.sos.jade.db.DBItemYadeTransfers;
import com.sos.jade.db.history.YadeEngineTransferResult;
import com.sos.jitl.reporting.db.DBItemSchedulerHistory;
import com.sos.yade.commons.Yade;
import com.sos.yade.commons.result.YadeTransferResultEntry;
import com.sos.yade.commons.result.YadeTransferResultProtocol;
import com.sos.yade.commons.result.YadeTransferResultSerializer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.hibernate.query.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.util.SOSString;

public class TransferHistoryHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransferHistoryHandler.class);
    private static final String DBITEM_YADE_PROTOCOLS = DBItemYadeProtocols.class.getSimpleName();
    private final ConcurrentHashMap<String, Long> protocols = new ConcurrentHashMap();
    private CopyOnWriteArrayList<Long> transferIds;

    public TransferHistoryHandler() {
        this.resetTransferIds();
    }

    public boolean process(SOSHibernateSession session, DBItemSchedulerHistory schedulerTask) throws SOSHibernateException {
        String serialized = schedulerTask.getTransferHistory();
        if (SOSString.isEmpty((String)serialized)) {
            return false;
        }
        String logMsg = String.format("[%s][job name=%s, taskId=%s", schedulerTask.getSpoolerId(), schedulerTask.getJobName(), schedulerTask.getId());
        try {
            YadeTransferResultSerializer serializer = new YadeTransferResultSerializer();
            ArrayList result = (ArrayList)serializer.deserialize(serialized);
            if (result == null) {
                return false;
            }
            for (YadeEngineTransferResult transfer : result) {
                Long transferId = this.saveTransfer(session, transfer);
                this.saveTransferEntries(session, transferId, transfer.getEntries());
                this.transferIds.add(transferId);
            }
            return true;
        }
        catch (SOSHibernateException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.error(String.format("[%s]%s", logMsg, e.toString()), (Throwable)e);
            return false;
        }
    }

    private Long saveTransfer(SOSHibernateSession session, YadeEngineTransferResult result) throws SOSHibernateException {
        DBItemYadeTransfers item = new DBItemYadeTransfers();
        item.setMandator(result.getMandator());
        item.setJobschedulerId(result.getJobschedulerId());
        item.setTaskId(result.getTaskId());
        item.setJob(result.getJob());
        item.setOrderId(result.getOrderId());
        item.setJobChain(result.getJobChain());
        item.setJobChainNode(result.getJobChainNode());
        item.setSourceProtocolId(this.getProtocolId(session, result.getSource()));
        item.setTargetProtocolId(this.getProtocolId(session, result.getTarget()));
        item.setJumpProtocolId(this.getProtocolId(session, result.getJump()));
        item.setMandator(result.getMandator());
        item.setOperation(Yade.TransferOperation.fromValue((String)result.getOperation()).intValue());
        item.setProfileName(result.getProfile());
        item.setStart(Date.from(result.getStart()));
        item.setEnd(Date.from(result.getEnd()));
        item.setNumOfFiles(Long.valueOf(result.getEntries() == null ? 0L : (long)result.getEntries().size()));
        item.setState(SOSString.isEmpty((String)result.getErrorMessage()) ? Yade.TransferState.SUCCESSFUL.intValue() : Yade.TransferState.FAILED.intValue());
        item.setErrorMessage(result.getErrorMessage());
        item.setModified(new Date());
        session.save((Object)item);
        return item.getId();
    }

    private void saveTransferEntries(SOSHibernateSession session, Long transferId, List<YadeTransferResultEntry> entries) throws SOSHibernateException {
        if (entries == null || entries.size() == 0) {
            return;
        }
        for (YadeTransferResultEntry entry : entries) {
            DBItemYadeFiles item = new DBItemYadeFiles();
            item.setTransferId(transferId);
            item.setInterventionTransferId(null);
            item.setSourcePath(entry.getSource());
            item.setTargetPath(entry.getTarget());
            item.setSize(Long.valueOf(entry.getSize()));
            item.setModificationDate(this.getUTCFromTimestamp(entry.getModificationDate()));
            item.setState(Yade.TransferEntryState.fromValue((String)entry.getState()).intValue());
            item.setIntegrityHash(entry.getIntegrityHash());
            item.setErrorMessage(entry.getErrorMessage());
            if (!SOSString.isEmpty((String)item.getErrorMessage())) {
                item.setErrorCode("ERRORCODE");
            }
            item.setModified(new Date());
            session.save((Object)item);
        }
    }

    private Long getProtocolId(SOSHibernateSession session, YadeTransferResultProtocol protocol) {
        if (protocol == null) {
            return null;
        }
        Integer protocolIntVal = Yade.TransferProtocol.fromValue((String)protocol.getProtocol()).intValue();
        String key = protocol.getHost() + protocol.getPort() + protocolIntVal + protocol.getAccount();
        if (this.protocols.containsKey(key)) {
            return this.protocols.get(key);
        }
        Long id = 0L;
        boolean run = true;
        int count = 0;
        while (run) {
            ++count;
            try {
                id = this.getProtocolId(session, protocol.getHost(), protocol.getPort(), protocolIntVal, protocol.getAccount());
                if (id == null) {
                    DBItemYadeProtocols item = new DBItemYadeProtocols();
                    item.setHostname(protocol.getHost());
                    item.setPort(protocol.getPort());
                    item.setProtocol(protocolIntVal);
                    item.setAccount(protocol.getAccount());
                    session.save((Object)item);
                    id = item.getId();
                }
                this.protocols.put(key, id);
                return id;
            }
            catch (SOSHibernateException e) {
                if (count >= 3) {
                    run = false;
                    continue;
                }
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return id;
    }

    private Long getProtocolId(SOSHibernateSession session, String hostname, Integer port, Integer protocol, String account) throws SOSHibernateException {
        StringBuilder hql = new StringBuilder("select id ");
        hql.append("from ").append(DBITEM_YADE_PROTOCOLS).append(" ");
        hql.append("where hostname=:hostname ");
        hql.append("and port=:port ");
        hql.append("and protocol=:protocol ");
        hql.append("and account=:account");
        Query query = session.createQuery(hql.toString());
        query.setParameter("hostname", (Object)hostname);
        query.setParameter("port", (Object)port);
        query.setParameter("protocol", (Object)protocol);
        query.setParameter("account", (Object)account);
        List result = session.getResultList(query);
        if (result != null && result.size() > 0) {
            return (Long)result.get(0);
        }
        return null;
    }

    private Date getUTCFromTimestamp(long timestamp) {
        if (timestamp < 0L) {
            return null;
        }
        return new Date(timestamp - (long)TimeZone.getDefault().getOffset(timestamp));
    }

    public CopyOnWriteArrayList<Long> getTransferIds() {
        return this.transferIds;
    }

    public void resetTransferIds() {
        this.transferIds = new CopyOnWriteArrayList();
    }
}

