/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.schedulerhistory.db;

import com.sos.hibernate.exceptions.SOSHibernateException;
import com.sos.hibernate.layer.SOSHibernateDBLayer;
import com.sos.jitl.schedulerhistory.SchedulerOrderStepHistoryFilter;
import com.sos.jitl.schedulerhistory.db.SchedulerOrderStepHistoryCompoundKey;
import com.sos.jitl.schedulerhistory.db.SchedulerOrderStepHistoryDBItem;
import java.io.File;
import java.io.Serializable;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.persistence.TemporalType;
import org.hibernate.query.Query;

public class SchedulerOrderStepHistoryDBLayer
extends SOSHibernateDBLayer {
    protected SchedulerOrderStepHistoryFilter filter = null;

    public SchedulerOrderStepHistoryDBLayer(File configurationFile) throws SOSHibernateException {
        this.setConfigurationFileName(configurationFile.getAbsolutePath());
        this.createStatelessConnection(configurationFile.getAbsolutePath());
        this.resetFilter();
    }

    public SchedulerOrderStepHistoryDBItem get(SchedulerOrderStepHistoryCompoundKey id) throws SOSHibernateException {
        return (SchedulerOrderStepHistoryDBItem)this.getSession().get(SchedulerOrderStepHistoryDBItem.class, (Serializable)id);
    }

    public void resetFilter() {
        this.filter = new SchedulerOrderStepHistoryFilter();
        this.filter.setDateFormat("yyyy-MM-dd HH:mm:ss");
        this.filter.setOrderCriteria("startTime");
        this.filter.setSortMode("desc");
    }

    protected String getWhereFromTo() {
        String where = "";
        String and = "";
        if (this.filter.getExecutedFromUtc() != null) {
            where = where + and + " startTime>= :startTimeFrom";
            and = " and ";
        }
        if (this.filter.getExecutedToUtc() != null) {
            where = where + and + " startTime <= :startTimeTo ";
            and = " and ";
        }
        if (!"".equals(where.trim())) {
            where = "where " + where;
        }
        return where;
    }

    protected String getWhere() {
        String where = "";
        String and = "";
        if (this.filter.getHistoryId() != null) {
            where = where + and + " id.historyId = :historyId";
            and = " and ";
        }
        if (this.filter.getStartTime() != null && !"".equals(this.filter.getStartTime())) {
            where = where + and + " startTime>= :startTime";
            and = " and ";
        }
        if (this.filter.getEndTime() != null && !"".equals(this.filter.getEndTime())) {
            where = where + and + " endTime <= :endTime ";
            and = " and ";
        }
        if (!"".equals(where.trim())) {
            where = "where " + where;
        }
        return where;
    }

    public int deleteFromTo() throws SOSHibernateException {
        this.sosHibernateSession.beginTransaction();
        String hql = "delete from SchedulerOrderStepHistoryDBItem " + this.getWhereFromTo();
        Query query = this.sosHibernateSession.createQuery(hql);
        query.setParameter("startTimeFrom", this.filter.getExecutedFromUtc(), TemporalType.TIMESTAMP);
        query.setParameter("startTimeTo", this.filter.getExecutedToUtc(), TemporalType.TIMESTAMP);
        return this.sosHibernateSession.executeUpdate(query);
    }

    public void deleteInterval(int interval) throws SOSHibernateException {
        GregorianCalendar now = new GregorianCalendar();
        now.add(6, -interval);
        this.filter.setExecutedTo(new Date());
        this.filter.setExecutedFrom(now.getTime());
        this.deleteFromTo();
    }

    public List<SchedulerOrderStepHistoryDBItem> getSchedulerOrderStepHistoryListFromTo(int limit) throws SOSHibernateException {
        Query query = this.sosHibernateSession.createQuery("from SchedulerOrderStepHistoryDBItem " + this.getWhereFromTo() + this.filter.getOrderCriteria() + this.filter.getSortMode());
        if (this.filter.getExecutedFromUtc() != null && !"".equals(this.filter.getExecutedFromUtc())) {
            query.setParameter("startTimeFrom", this.filter.getExecutedFromUtc(), TemporalType.TIMESTAMP);
        }
        if (this.filter.getExecutedToUtc() != null && !"".equals(this.filter.getExecutedToUtc())) {
            query.setParameter("startTimeTo", this.filter.getExecutedToUtc(), TemporalType.TIMESTAMP);
        }
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        return this.sosHibernateSession.getResultList(query);
    }

    public List<SchedulerOrderStepHistoryDBItem> getOrderStepHistoryItems(int limit, long historyId) throws SOSHibernateException {
        this.filter.setHistoryId(historyId);
        this.sosHibernateSession.beginTransaction();
        Query query = this.sosHibernateSession.createQuery("from SchedulerOrderStepHistoryDBItem " + this.getWhere());
        if (this.filter.getHistoryId() != null) {
            query.setParameter("historyId", (Object)this.filter.getHistoryId());
        }
        if (this.filter.getStartTime() != null && !"".equals(this.filter.getStartTime())) {
            query.setParameter("startTime", this.filter.getStartTime(), TemporalType.TIMESTAMP);
        }
        if (this.filter.getStartTime() != null && !"".equals(this.filter.getStartTime())) {
            query.setParameter("startTime", this.filter.getStartTime(), TemporalType.TIMESTAMP);
        }
        if (this.filter.getEndTime() != null && !"".equals(this.filter.getEndTime())) {
            query.setParameter("endTime", this.filter.getEndTime(), TemporalType.TIMESTAMP);
        }
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        List historyList = this.sosHibernateSession.getResultList(query);
        this.sosHibernateSession.commit();
        return historyList;
    }

    public SchedulerOrderStepHistoryFilter getFilter() {
        return this.filter;
    }
}

