/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.sync;

import com.sos.JSHelper.Exceptions.JobSchedulerException;
import com.sos.jitl.sync.JobSchedulerSynchronizeJobChainsOptions;
import com.sos.jitl.sync.SyncNodeContainer;
import com.sos.scheduler.messages.JSMessages;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobSchedulerSynchronizeJobChains {
    private final String conClassName = "JobSchedulerSynchronizeJobChains";
    private static final Logger LOGGER = LoggerFactory.getLogger(JobSchedulerSynchronizeJobChains.class);
    protected SyncNodeContainer syncNodeContainer;
    protected HashMap<String, String> schedulerParameters = new HashMap();
    private String orderId = "";
    private String jobChain = "";

    public JobSchedulerSynchronizeJobChains execute(JobSchedulerSynchronizeJobChainsOptions jobSchedulerSynchronizeJobChainsOptions) throws Exception {
        String conMethodName = "JobSchedulerSynchronizeJobChains::Execute";
        JSMessages.JSJ_I_110.toLog(new Object[]{"JobSchedulerSynchronizeJobChains::Execute"});
        try {
            jobSchedulerSynchronizeJobChainsOptions.checkMandatory();
            LOGGER.debug(jobSchedulerSynchronizeJobChainsOptions.dirtyString());
            this.syncNodeContainer = new SyncNodeContainer();
            this.syncNodeContainer.setIgnoreStoppedJobChains(jobSchedulerSynchronizeJobChainsOptions.ignore_stopped_jobchains.value());
            this.syncNodeContainer.setJobpath(jobSchedulerSynchronizeJobChainsOptions.jobpath.getValue());
            if (jobSchedulerSynchronizeJobChainsOptions.disable_sync_context.value()) {
                LOGGER.debug("Disable sync context");
                this.syncNodeContainer.setSyncNodeContext("", "");
            } else {
                LOGGER.debug(String.format("Set sync context: %s,%s", jobSchedulerSynchronizeJobChainsOptions.job_chain_name2synchronize.getValue(), jobSchedulerSynchronizeJobChainsOptions.job_chain_state2synchronize.getValue()));
                this.syncNodeContainer.setSyncNodeContext(jobSchedulerSynchronizeJobChainsOptions.job_chain_name2synchronize.getValue(), jobSchedulerSynchronizeJobChainsOptions.job_chain_state2synchronize.getValue());
            }
            String syncId = jobSchedulerSynchronizeJobChainsOptions.getsync_session_id().getValue();
            this.syncNodeContainer.getNodes(jobSchedulerSynchronizeJobChainsOptions.jobchains_answer.getValue());
            this.syncNodeContainer.getOrders(this.jobChain, this.orderId, syncId, jobSchedulerSynchronizeJobChainsOptions.orders_answer.getValue());
            this.syncNodeContainer.setRequiredOrders(this.schedulerParameters);
            if (this.syncNodeContainer.isReleased()) {
                LOGGER.debug("Release all orders");
            } else {
                LOGGER.debug("Suspending all orders");
            }
        }
        catch (Exception e) {
            throw new JobSchedulerException(JSMessages.JSJ_F_107.get(new Object[]{"JobSchedulerSynchronizeJobChains::Execute"}) + ":" + e.getMessage(), (Throwable)e);
        }
        JSMessages.JSJ_I_111.toLog(new Object[]{"JobSchedulerSynchronizeJobChains::Execute"});
        return this;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public void setJobChain(String jobChain) {
        this.jobChain = jobChain;
    }
}

