/*
 * Decompiled with CFR 0.152.
 */
package sos.scheduler.InstallationService.batchInstallationModel;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.scheduler.InstallationService.JSBatchInstaller;
import sos.scheduler.InstallationService.batchInstallationModel.JSInstallations;
import sos.scheduler.InstallationService.batchInstallationModel.JSXMLInstallationFile;
import sos.scheduler.InstallationService.batchInstallationModel.JSinstallation;
import sos.scheduler.InstallationService.batchInstallationModel.installations.Installation;
import sos.spooler.Job_chain;
import sos.spooler.Order;
import sos.spooler.Spooler;

public class JSBatchInstallerExecuter {
    private Order order = null;
    private JSBatchInstaller jsBatchInstaller = null;
    private File localDir;
    private File installationDefinitionFile;
    private String installationJobChain;
    private static final Logger LOGGER = LoggerFactory.getLogger(JSBatchInstallerExecuter.class);
    private boolean update;
    private String filterInstallHost = "";
    private String installationSetupFilename = "";
    private int filterInstallPort = 0;

    private void init() {
        this.localDir = new File(this.jsBatchInstaller.Options().getlocal_dir().getValue());
        this.installationDefinitionFile = new File(this.jsBatchInstaller.Options().getinstallation_definition_file().getValue());
        this.installationSetupFilename = this.jsBatchInstaller.Options().getinstallation_setup_filename().getValue();
        this.installationJobChain = this.jsBatchInstaller.Options().getinstallation_job_chain().getValue();
        this.update = this.jsBatchInstaller.Options().getupdate().isTrue();
        this.filterInstallHost = this.jsBatchInstaller.Options().getfilter_install_host().getValue();
        this.filterInstallPort = this.jsBatchInstaller.Options().getfilter_install_port().value();
    }

    private boolean filterNotSetOrFilterMatch(String value, String filter) {
        LOGGER.debug("Testing filter:" + value + "=" + filter);
        return value.equals(filter) || filter == null || "".equals(filter.trim());
    }

    private boolean filterNotSetOrFilterMatch(int value, int filter) {
        LOGGER.debug("Testing filter:" + value + "=" + filter);
        return value == filter || filter == 0;
    }

    private boolean checkFilter(JSinstallation jsInstallation) {
        boolean filterMatch = this.filterNotSetOrFilterMatch(jsInstallation.getHost(), this.filterInstallHost) && this.filterNotSetOrFilterMatch(jsInstallation.getSchedulerPort(), this.filterInstallPort);
        LOGGER.debug("FilterMatch: " + filterMatch);
        boolean installationNotExecuted = jsInstallation.getLastRun() == null || "".equals(jsInstallation.getLastRun());
        LOGGER.debug("installationNotExecuted: " + installationNotExecuted + "(lastRun=" + jsInstallation.getLastRun() + ")");
        if (filterMatch && (installationNotExecuted || this.update)) {
            return true;
        }
        if (!filterMatch) {
            LOGGER.info("Installation will not execute because filter does not match");
        }
        if (!installationNotExecuted) {
            LOGGER.info("Installation will not execute because already was executed");
        }
        return false;
    }

    private void updateLastRun(File installationsDefinitionFile) throws Exception {
        JSInstallations jsInstallationsUpdateFile = new JSInstallations(installationsDefinitionFile);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:MM");
        String now = dateFormat.format(new Date());
        while (!jsInstallationsUpdateFile.eof()) {
            Installation installationUpdate = jsInstallationsUpdateFile.nextInstallation();
            if (installationUpdate.getLastRun() != null && !"".equals(installationUpdate.getLastRun()) && !this.update) continue;
            installationUpdate.setLastRun(now);
        }
        jsInstallationsUpdateFile.writeFile(installationsDefinitionFile);
    }

    public void performInstallation(JSBatchInstaller jsBatchInstaller) throws Exception {
        this.jsBatchInstaller = jsBatchInstaller;
        this.init();
        this.installationDefinitionFile = new File(jsBatchInstaller.Options().getinstallation_definition_file().getValue());
        JSInstallations jsInstallations = new JSInstallations(this.installationDefinitionFile);
        while (!jsInstallations.eof()) {
            JSinstallation installation = jsInstallations.next();
            if (this.checkFilter(installation)) {
                this.createOrder(installation);
                continue;
            }
            installation.doReplacing();
            LOGGER.info(String.format("Skip creation of order for scheduler id %1$s", installation.getSchedulerId()));
        }
        this.updateLastRun(this.installationDefinitionFile);
    }

    private void createOrder(JSinstallation installation) throws Exception {
        Spooler spooler = (Spooler)this.jsBatchInstaller.getJSCommands().getSpoolerObject();
        File installationFile = installation.getInstallationFile(this.localDir);
        installation.doReplacing();
        LOGGER.info(String.format("Start to create order for scheduler id %1$s", installation.getSchedulerId()));
        JSXMLInstallationFile jsXMLInstallationFile = new JSXMLInstallationFile();
        jsXMLInstallationFile.setValues(installation);
        jsXMLInstallationFile.writeFile(installationFile);
        LOGGER.info("scheduler_id:" + installation.getSchedulerId());
        LOGGER.info("host:" + installation.getHost());
        LOGGER.info("install_path:" + installation.getInstallPath());
        LOGGER.info("licence:" + installation.getLicence());
        LOGGER.info("allowed_host:" + installation.getSchedulerAllowedHost());
        LOGGER.info("scheduler_port:" + installation.getSchedulerPort());
        LOGGER.info("userPathPanelElement:" + installation.getUserPathPanelElement());
        LOGGER.info("----------------------------------------------");
        if (spooler == null) {
            LOGGER.info("Creation of order is skipped because spooler object is NULL");
            return;
        }
        this.order = spooler.create_order();
        Job_chain jobchain = spooler.job_chain(this.installationJobChain);
        this.order.set_id(installation.getHost() + ":" + installation.getSchedulerPort());
        this.setParam("installation_file", installationFile.getName());
        this.setParam("installation_setup_filename", this.installationSetupFilename);
        this.setParam("ftp_user", installation.getFtp().getUser());
        this.setParam("ftp_local_dir", installation.getFtp().getLocalDir());
        this.setParam("ftp_host", installation.getHost());
        this.setParam("ftp_password", installation.getFtp().getPassword());
        this.setParam("ftp_remote_dir", installation.getFtp().getRemoteDir());
        this.setParam("TransferInstallationSetup/ftp_file_path", this.installationSetupFilename);
        this.setParam("TransferInstallationFile/ftp_local_dir", installationFile.getParent());
        this.setParam("TransferInstallationFile/ftp_file_path", installationFile.getName());
        this.setParam("ShutdownScheduler/host", String.valueOf(installation.getHost()));
        this.setParam("ShutdownScheduler/port", String.valueOf(installation.getSsh().getPort()));
        this.setParam("ShutdownScheduler/user", installation.getSsh().getUser());
        this.setParam("ShutdownScheduler/auth_method", installation.getSsh().getAuthMethod());
        this.setParam("ShutdownScheduler/password", installation.getSsh().getPassword());
        this.setParam("ShutdownScheduler/sudo_password", installation.getSsh().getSudoPassword());
        this.setParam("ShutdownScheduler/command", installation.getInstallPath() + "/" + installation.getSchedulerId() + "/bin/jobscheduler_agent.sh  stop");
        this.setParam("PerformInstall/host", String.valueOf(installation.getHost()));
        this.setParam("PerformInstall/port", String.valueOf(installation.getSsh().getPort()));
        this.setParam("PerformInstall/user", installation.getSsh().getUser());
        this.setParam("PerformInstall/auth_method", installation.getSsh().getAuthMethod());
        this.setParam("PerformInstall/password", installation.getSsh().getPassword());
        this.setParam("PerformInstall/sudo_password", installation.getSsh().getSudoPassword());
        this.setParam("PerformInstall/command", installation.getSsh().getCommand());
        jobchain.add_order(this.order);
    }

    private void setParam(String pstrParamName, String pstrParamValue) {
        if (pstrParamName.contains("password")) {
            LOGGER.info("ParamName = " + pstrParamName + ", Value = *****");
        } else {
            LOGGER.info("ParamName = " + pstrParamName + ", Value = " + pstrParamValue);
        }
        this.order.params().set_var(pstrParamName, pstrParamValue);
    }
}

