/*
 * Decompiled with CFR 0.152.
 */
package sos.scheduler.InstallationService.batchInstallationModel;

import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.scheduler.InstallationService.batchInstallationModel.JSBatchInstallerExecuter;
import sos.scheduler.InstallationService.batchInstallationModel.installations.Globals;
import sos.scheduler.InstallationService.batchInstallationModel.installations.Installation;

public class JSinstallation
extends Installation {
    protected Globals globals;
    private File installationFile = null;
    private static final Logger LOGGER = LoggerFactory.getLogger(JSBatchInstallerExecuter.class);

    private String getValue(String installationValue, String globalValue) {
        if (globalValue == null) {
            globalValue = "";
        }
        if (installationValue == null) {
            installationValue = "";
        }
        if (!installationValue.isEmpty() || "".equals(globalValue)) {
            return installationValue;
        }
        return globalValue;
    }

    private Short getValue(Short installationValue, Short globalValue) {
        if (globalValue == null) {
            globalValue = 0;
        }
        if (installationValue == null) {
            installationValue = 0;
        }
        if (installationValue != 0 || globalValue == 0) {
            return installationValue;
        }
        return globalValue;
    }

    public File getInstallationFile(File configurationPath) {
        if (this.installationFile == null) {
            this.installationFile = new File(configurationPath, this.getHost() + "_" + this.getSchedulerPort() + ".xml");
        }
        return this.installationFile;
    }

    private String replace(String parameterValue, String parameterName, String newValue) {
        return parameterValue.replaceAll("\\$\\{" + parameterName + "\\}", newValue);
    }

    private String replaceAll(String value) {
        if (value == null) {
            return value;
        }
        value = this.replace(value, "host", this.getHost());
        value = this.replace(value, "licence", this.getLicence());
        value = this.replace(value, "licence_options", this.getLicenceOptions());
        value = this.replace(value, "install_path", this.getInstallPath());
        value = this.replace(value, "scheduler_port", String.valueOf(this.getSchedulerPort()));
        value = this.replace(value, "scheduler_allowed_host", this.getSchedulerAllowedHost());
        value = this.replace(value, "scheduler_id", this.getSchedulerId());
        value = this.replace(value, "userPathPanelElement", this.getUserPathPanelElement());
        value = this.replace(value, "ftp_local_dir", this.getFtp().getLocalDir());
        value = this.replace(value, "ftp_password", this.getFtp().getPassword());
        value = this.replace(value, "ftp_port", String.valueOf(this.getFtp().getPort()));
        value = this.replace(value, "ftp_localDir", this.getFtp().getLocalDir());
        value = this.replace(value, "ftp_remote_dir", this.getFtp().getRemoteDir());
        value = this.replace(value, "ftp_user", this.getFtp().getUser());
        value = this.replace(value, "auth_method", this.getSsh().getAuthMethod());
        value = this.replace(value, "command", this.getSsh().getCommand());
        value = this.replace(value, "password", this.getSsh().getPassword());
        value = this.replace(value, "sudo_password", this.getSsh().getSudoPassword());
        value = this.replace(value, "port", String.valueOf(this.getSsh().getPort()));
        value = this.replace(value, "user", this.getSsh().getUser());
        if (this.installationFile == null) {
            LOGGER.debug("Installationfile is not set. Will not be replaces");
            this.installationFile = new File("");
        } else {
            value = this.replace(value, "installation_file", this.installationFile.getName());
        }
        return value;
    }

    public void doReplacing() {
        this.setHost(this.replaceAll(this.getHost()));
        this.setLicence(this.replaceAll(this.getLicence()));
        this.setLicenceOptions(this.replaceAll(this.getLicenceOptions()));
        this.setInstallPath(this.replaceAll(this.getInstallPath()));
        this.setSchedulerAllowedHost(this.replaceAll(this.getSchedulerAllowedHost()));
        this.setSchedulerId(this.replaceAll(this.getSchedulerId()));
        this.setUserPathPanelElement(this.replaceAll(this.getUserPathPanelElement()));
        this.getFtp().setLocalDir(this.replaceAll(this.getFtp().getLocalDir()));
        this.getFtp().setPassword(this.replaceAll(this.getFtp().getPassword()));
        this.getFtp().setRemoteDir(this.replaceAll(this.getFtp().getRemoteDir()));
        this.getFtp().setUser(this.replaceAll(this.getFtp().getUser()));
        this.getSsh().setAuthMethod(this.replaceAll(this.getSsh().getAuthMethod()));
        this.getSsh().setAuthFile(this.replaceAll(this.getSsh().getAuthFile()));
        this.getSsh().setCommand(this.replaceAll(this.getSsh().getCommand()));
        this.getSsh().setSudoPassword(this.replaceAll(this.getSsh().getSudoPassword()));
        this.getSsh().setPassword(this.replaceAll(this.getSsh().getPassword()));
        this.getSsh().setUser(this.replaceAll(this.getSsh().getUser()));
    }

    public void setValues(Installation installation) {
        this.setLicence(this.getValue(installation.getLicence(), this.globals.getLicence()));
        this.setLicenceOptions(this.getValue(installation.getLicenceOptions(), this.globals.getLicenceOptions()));
        this.setSchedulerPort(this.getValue(installation.getSchedulerPort(), this.globals.getSchedulerPort()));
        this.setInstallPath(this.getValue(installation.getInstallPath(), this.globals.getInstallPath()));
        this.setSchedulerAllowedHost(this.getValue(installation.getSchedulerAllowedHost(), this.globals.getSchedulerAllowedHost()));
        this.setSchedulerId(this.getValue(installation.getSchedulerId(), this.globals.getSchedulerId()));
        this.setUserPathPanelElement(this.getValue(installation.getUserPathPanelElement(), this.globals.getUserPathPanelElement()));
        this.setHost(installation.getHost());
        this.setLastRun(installation.getLastRun());
        installation.getFtp().setLocalDir(this.getValue(installation.getFtp().getLocalDir(), this.globals.getFtp().getLocalDir()));
        installation.getFtp().setPassword(this.getValue(installation.getFtp().getPassword(), this.globals.getFtp().getPassword()));
        installation.getFtp().setPort(this.getValue(installation.getFtp().getPort(), this.globals.getFtp().getPort()));
        installation.getFtp().setRemoteDir(this.getValue(installation.getFtp().getRemoteDir(), this.globals.getFtp().getRemoteDir()));
        installation.getFtp().setUser(this.getValue(installation.getFtp().getUser(), this.globals.getFtp().getUser()));
        this.setFtp(installation.getFtp());
        installation.getSsh().setAuthMethod(this.getValue(installation.getSsh().getAuthMethod(), this.globals.getSsh().getAuthMethod()));
        installation.getSsh().setCommand(this.getValue(installation.getSsh().getCommand(), this.globals.getSsh().getCommand()));
        installation.getSsh().setPassword(this.getValue(installation.getSsh().getPassword(), this.globals.getSsh().getPassword()));
        installation.getSsh().setSudoPassword(this.getValue(installation.getSsh().getSudoPassword(), this.globals.getSsh().getSudoPassword()));
        installation.getSsh().setPort(this.getValue(installation.getSsh().getPort(), this.globals.getSsh().getPort()));
        installation.getSsh().setUser(this.getValue(installation.getSsh().getUser(), this.globals.getSsh().getUser()));
        installation.getSsh().setAuthFile(this.getValue(installation.getSsh().getAuthFile(), this.globals.getSsh().getAuthFile()));
        this.setSsh(installation.getSsh());
    }
}

