/*
 * Decompiled with CFR 0.152.
 */
package sos.scheduler.file;

import com.sos.JSHelper.Exceptions.JobSchedulerException;
import com.sos.JSHelper.io.SOSFileSystemOperationsCopy;
import com.sos.i18n.annotation.I18NResourceBundle;
import com.sos.scheduler.messages.JSMessages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.scheduler.file.JobSchedulerFileOperationBase;

@I18NResourceBundle(baseName="com_sos_scheduler_messages", defaultLocale="en")
public class JobSchedulerCopyFile
extends JobSchedulerFileOperationBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobSchedulerCopyFile.class);
    private static final String CLASSNAME = "JobSchedulerCopyFile";

    private void doFileOperation(String strSource, String strTarget) throws Exception {
        this.noOfHitsInResultSet += this.sosFileOperations.copyFileCnt(strSource, strTarget, this.fileSpec, this.flags, 2, this.replacing, this.replacement, this.minFileAge, this.maxFileAge, this.minFileSize, this.maxFileSize, this.skipFirstFiles, this.skipLastFiles, this.sortCriteria, this.sortOrder);
        this.saveResultList();
    }

    public boolean spooler_process() {
        try {
            this.initialize();
            this.sosFileOperations = new SOSFileSystemOperationsCopy();
            this.checkMandatorySource();
            String[] fileSource = this.source.split(";");
            String[] fileTarget = null;
            if (this.isNotNull(this.target) && fileSource.length != (fileTarget = this.target.split(";")).length) {
                String strM = JSMessages.JSJ_F_0011.params(new Object[]{fileSource.length, fileTarget.length});
                LOGGER.error(strM);
                throw new JobSchedulerException(strM);
            }
            String[] fileSpecs = this.fileSpec.split(";");
            boolean flgPathAndSpecHasSameNumberOfItems = fileSource.length == fileSpecs.length;
            this.fileSpec = fileSpecs[0];
            for (int i = 0; i < fileSource.length; ++i) {
                String strSource = fileSource[i];
                String strTarget = null;
                if (this.isNotNull(this.target)) {
                    strTarget = fileTarget[i];
                }
                if (this.isNotEmpty(this.fileSpec) && flgPathAndSpecHasSameNumberOfItems) {
                    this.fileSpec = fileSpecs[i];
                }
                this.doFileOperation(strSource, strTarget);
            }
            this.flgOperationWasSuccessful = this.noOfHitsInResultSet > 0;
            return this.setReturnResult(this.spooler_task.order(), this.flgOperationWasSuccessful);
        }
        catch (Exception e) {
            String strM = JSMessages.JSJ_F_0010.params(new Object[]{CLASSNAME, e.getMessage()});
            LOGGER.error(strM + "\n" + e.toString(), (Throwable)e);
            throw new JobSchedulerException(strM, (Throwable)e);
        }
    }
}

