/*
 * Decompiled with CFR 0.152.
 */
package sos.scheduler.file;

import com.sos.JSHelper.Exceptions.JobSchedulerException;
import com.sos.JSHelper.io.Files.JSFile;
import com.sos.JSHelper.io.SOSFileSystemOperationsImpl;
import com.sos.i18n.annotation.I18NResourceBundle;
import com.sos.scheduler.messages.JSMessages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.scheduler.file.JobSchedulerFileOperationBase;

@I18NResourceBundle(baseName="com.sos.scheduler.messages", defaultLocale="en")
public class JobSchedulerCreateFiles
extends JobSchedulerFileOperationBase {
    private static final String PARAMETER_FILE_AGE = "file_age";
    private static final String PARAMETER_FILE_SIZE = "file_size";
    private static final String PARAMETER_CREATE_FILE = "create_file";
    private static final String CLASSNAME = "JobSchedulerCreateFiles";
    private static final Logger LOGGER = LoggerFactory.getLogger(JobSchedulerCreateFiles.class);

    public boolean spooler_process() {
        try {
            long fileAge;
            int fileSize;
            this.initialize();
            this.sosFileOperations = new SOSFileSystemOperationsImpl();
            String strCreateFile = this.getParamValue(PARAMETER_CREATE_FILE);
            if (this.isNotEmpty(strCreateFile)) {
                fileSize = this.getParamInteger(PARAMETER_FILE_SIZE, 10);
                fileAge = this.getFileAge(this.getParamValue(PARAMETER_FILE_AGE));
                this.populateFile(new JSFile(strCreateFile), fileSize, fileAge);
            }
            for (int i = 0; i < 20; ++i) {
                String strFileName2Create = this.getParamValue("create_file_" + i);
                if (!this.isNotEmpty(strFileName2Create)) continue;
                fileSize = this.getParamInteger("file_size_" + i, 10);
                fileAge = this.getFileAge(this.getParamValue("file_age_" + i));
                this.populateFile(new JSFile(strFileName2Create), fileSize, fileAge);
            }
            return this.signalSuccess(this.spooler_task.order());
        }
        catch (Exception e) {
            String strM = JSMessages.JSJ_F_0010.params(new Object[]{CLASSNAME, e.getMessage()});
            LOGGER.error(strM);
            throw new JobSchedulerException(strM);
        }
    }

    public long getFileAge(String pstrFileAge) {
        long fileAge = System.currentTimeMillis();
        if (this.isNotEmpty(pstrFileAge)) {
            fileAge = System.currentTimeMillis() - 1000L * Long.parseLong(this.spooler_task.order().params().var(PARAMETER_FILE_AGE));
        }
        return fileAge;
    }

    public void populateFile(JSFile file1, int fileSize, long lastModified) throws Exception {
        try {
            LOGGER.info("populating file: " + file1.getName() + "   " + file1.getAbsolutePath());
            file1.write(new StringBuffer(fileSize));
        }
        catch (Exception e) {
            throw new Exception("could not populate file [" + file1.getAbsolutePath() + "]: " + e.getMessage());
        }
        finally {
            try {
                file1.close();
                file1.setLastModified(lastModified);
            }
            catch (Exception exception) {}
        }
    }
}

