/*
 * Decompiled with CFR 0.152.
 */
package sos.scheduler.xsl;

import com.sos.JSHelper.Basics.JSJobUtilitiesClass;
import com.sos.JSHelper.Exceptions.JobSchedulerException;
import com.sos.JSHelper.io.Files.JSFile;
import com.sos.JSHelper.io.Files.JSXMLFile;
import com.sos.scheduler.messages.JSMessages;
import java.io.File;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.scheduler.xsl.JobSchedulerXslTransformOptions;

public class JobSchedulerXslTransform
extends JSJobUtilitiesClass<JobSchedulerXslTransformOptions> {
    protected HashMap<String, String> hsmParameters = null;
    private static final Logger LOGGER = LoggerFactory.getLogger(JobSchedulerXslTransform.class);

    public JobSchedulerXslTransform() {
        super((Object)new JobSchedulerXslTransformOptions());
    }

    public JobSchedulerXslTransformOptions getOptions() {
        if (this.objOptions == null) {
            this.objOptions = new JobSchedulerXslTransformOptions();
        }
        return (JobSchedulerXslTransformOptions)((Object)this.objOptions);
    }

    public JobSchedulerXslTransform Execute() throws Exception {
        String methodName = "JobSchedulerXslTransform::Execute";
        LOGGER.debug(JSMessages.JSJ_I_110.get(new Object[]{"JobSchedulerXslTransform::Execute"}));
        try {
            this.getOptions().checkMandatory();
            LOGGER.debug(this.getOptions().dirtyString());
            JSXMLFile objXMLFile = new JSXMLFile(this.getOptions().FileName.getValue());
            if (this.getOptions().XslFileName.IsEmpty()) {
                LOGGER.info("no xslt-file specified. copy xml file only");
                String strXML = objXMLFile.getContent();
                JSFile outFile = new JSFile(this.getOptions().OutputFileName.getValue());
                outFile.setCharSet4OutputFile("UTF-8");
                outFile.write(strXML);
                outFile.close();
            } else {
                objXMLFile.setParameters(this.hsmParameters);
                objXMLFile.transform(new File(this.getOptions().XslFileName.getValue()), new File(this.getOptions().OutputFileName.getValue()));
            }
        }
        catch (Exception e) {
            throw new JobSchedulerException(JSMessages.JSJ_F_107.get(new Object[]{"JobSchedulerXslTransform::Execute"}) + ": " + e.getMessage(), (Throwable)e);
        }
        JSMessages.JSJ_I_111.toLog(new Object[]{"JobSchedulerXslTransform::Execute"});
        return this;
    }

    public void init() {
        this.doInitialize();
    }

    public void setParameters(HashMap<String, String> pobjHshMap) {
        this.hsmParameters = pobjHshMap;
    }

    private void doInitialize() {
    }
}

