/*
 * Decompiled with CFR 0.152.
 */
package com.sos.scheduler.model.objects;

import com.sos.JSHelper.Exceptions.JobSchedulerException;
import com.sos.scheduler.model.SchedulerHotFolder;
import com.sos.scheduler.model.SchedulerObjectFactory;
import com.sos.vfs.common.interfaces.ISOSProviderFile;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.math.BigInteger;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.annotation.XmlTransient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlTransient
public class JSObjBase
implements Comparable<JSObjBase> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JSObjBase.class);
    protected static final String conEMPTY = "";
    protected static final String conNO = "no";
    protected static final String conYES = "yes";
    protected static final String conHtmlBR = "<br/>";
    @XmlTransient
    protected SchedulerObjectFactory objFactory = null;
    @XmlTransient
    private ISOSProviderFile hotFolderSrc = null;
    @XmlTransient
    protected JAXBElement<JSObjBase> objJAXBElement = null;
    @XmlTransient
    private boolean flgIsDirty = false;
    @XmlTransient
    protected String strFileNameExtension = "";
    @XmlTransient
    protected ISOSProviderFile objVirtualFile = null;
    @XmlTransient
    protected boolean flgIsInit = false;

    @XmlTransient
    public void setInit(boolean flgF) {
        this.flgIsInit = flgF;
    }

    public boolean canUpdate() {
        return !this.flgIsInit;
    }

    @XmlTransient
    public void setDirty(boolean flgF) {
        this.flgIsDirty = flgF;
    }

    public boolean isEmpty(String value) {
        return value == null || value.isEmpty();
    }

    public void setDirty() {
        this.flgIsDirty = true;
    }

    public boolean isDirty() {
        return this.flgIsDirty;
    }

    public void setParent(SchedulerObjectFactory objParent) {
        this.objFactory = objParent;
    }

    public Object unMarshal(File pobjFile) {
        return this.objFactory.unMarshall(pobjFile);
    }

    public Object unMarshal(InputStream pobjInputStream) {
        return this.objFactory.unMarshall(pobjInputStream);
    }

    public Object unMarshal(String pobjString) {
        return this.objFactory.unMarshall(pobjString);
    }

    public Object unMarshal(ISOSProviderFile pobjVirtualFile) {
        return this.objFactory.unMarshall(pobjVirtualFile);
    }

    public Object marshal(Object objO, File objF) {
        return this.objFactory.marshal(objO, objF);
    }

    public Object marshal(File objF) {
        JAXBElement<JSObjBase> objO = null;
        if (this.objJAXBElement == null) {
            objO = this;
        } else {
            this.objJAXBElement.setValue((Object)this);
            objO = this.objJAXBElement;
        }
        return this.marshal((Object)objO, objF);
    }

    public String marshal() {
        JAXBElement<JSObjBase> objO = null;
        if (this.objJAXBElement == null) {
            objO = this;
        } else {
            this.objJAXBElement.setValue((Object)this);
            objO = this.objJAXBElement;
        }
        return this.objFactory.marshal(objO);
    }

    public Object toXMLFile(Object objO, ISOSProviderFile pobjVirtualFile) {
        return this.objFactory.toXMLFile(objO, pobjVirtualFile);
    }

    public Object toXMLFile(ISOSProviderFile pobjVirtualFile) {
        JAXBElement<JSObjBase> objO = null;
        if (this.objJAXBElement == null) {
            objO = this;
        } else {
            this.objJAXBElement.setValue((Object)this);
            objO = this.objJAXBElement;
        }
        return this.toXMLFile((Object)objO, pobjVirtualFile);
    }

    public Object save() {
        return this.toXMLFile(this.hotFolderSrc);
    }

    public Object saveAs(String pstrSaveAsFileName) {
        return null;
    }

    public Object rename(String pstrRenameFileName) {
        return null;
    }

    public Object toXMLFile() {
        return this.toXMLFile(this.hotFolderSrc);
    }

    public String toXMLString(Object objO) {
        return this.objFactory.toXMLString(objO);
    }

    public String toXMLString() {
        String xmlString = null;
        if (this.objJAXBElement == null) {
            xmlString = this.objFactory.toXMLString(this);
        } else {
            this.objJAXBElement.setValue((Object)this);
            xmlString = this.objFactory.toXMLString(this.objJAXBElement);
        }
        return xmlString;
    }

    @XmlTransient
    public void setHotFolderSrc(ISOSProviderFile pobjVirtualFile) {
        this.hotFolderSrc = pobjVirtualFile;
    }

    public ISOSProviderFile getHotFolderSrc() {
        return this.hotFolderSrc;
    }

    @Override
    public int compareTo(JSObjBase o) {
        int compareRet = 0;
        boolean thisIsFolder = "SchedulerHotFolder".equals(this.getClass().getSimpleName());
        boolean oIsFolder = o instanceof SchedulerHotFolder;
        if (thisIsFolder && !oIsFolder) {
            compareRet = -1;
        } else if (!thisIsFolder && oIsFolder) {
            compareRet = 1;
        } else if (this.getHotFolderSrc() == null) {
            compareRet = 1;
        } else if (o.getHotFolderSrc() == null) {
            compareRet = -1;
        } else {
            String hotFolderSrcName1 = this.getHotFolderSrc().getName().toLowerCase();
            String hotFolderSrcName2 = o.getHotFolderSrc().getName().toLowerCase();
            compareRet = hotFolderSrcName1.compareTo(hotFolderSrcName2);
        }
        return compareRet;
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public void setObjectFieldsFrom(JSObjBase origObj) {
        Field[] fields;
        Class<?> origClass = origObj.getClass();
        if (!origClass.isAssignableFrom(this.getClass())) {
            throw new JobSchedulerException(String.format("%1$s must be a subclass of %2$s", this.getClass().getName(), origClass.getName()));
        }
        for (Field field : fields = origClass.getDeclaredFields()) {
            try {
                field.setAccessible(true);
                if (!field.isAccessible()) continue;
                field.set(this, field.get(origObj));
            }
            catch (IllegalArgumentException e) {
                LOGGER.error(conEMPTY, (Throwable)new JobSchedulerException("IllegalArgumentException", (Throwable)e));
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    public boolean getYesOrNo(String yesOrNo) {
        if (yesOrNo != null) {
            String work = yesOrNo.toLowerCase();
            return "1".equals(work) || conYES.equals(work) || "true".equals(work) || "ja".equals(work);
        }
        return false;
    }

    public String setYesOrNo(boolean pflgV) {
        if (pflgV) {
            return conYES;
        }
        return conNO;
    }

    public String getObjectName() {
        String name = this.getHotFolderSrc().getName();
        int i = name.indexOf(this.strFileNameExtension);
        if (i != -1) {
            name = name.substring(0, name.indexOf(this.strFileNameExtension));
        }
        name = new File(name).getName();
        return name;
    }

    public String getObjectNameAndTitle() {
        String strT = this.getObjectName();
        String strV = this.getTitle();
        if (strV != null && !strV.isEmpty()) {
            strT = strT + " - " + this.getTitle();
        }
        return strT;
    }

    public static String notNull(String pstrS) {
        String strR = pstrS;
        if (strR == null) {
            strR = conEMPTY;
        }
        return strR;
    }

    public String getTitle() {
        return conEMPTY;
    }

    public boolean isEnabled() {
        return true;
    }

    protected void changeSourceName(String pstrName) {
        ISOSProviderFile objF = this.getHotFolderSrc();
        if (objF != null) {
            String name = objF.getName();
            name = name.replace(this.getObjectName(), pstrName);
            ISOSProviderFile objNF = objF.getProvider().getFile(name);
            this.setHotFolderSrc(objNF);
        }
    }

    protected String avoidNull(String pstrV) {
        if (pstrV == null) {
            return conEMPTY;
        }
        return pstrV;
    }

    protected String bigInt2String(BigInteger pbigI) {
        if (pbigI != null) {
            long lngT = pbigI.longValue();
            return String.valueOf(lngT);
        }
        return conEMPTY;
    }

    protected BigInteger int2BigInteger(int pintVal) {
        return BigInteger.valueOf(pintVal);
    }

    protected String getQuoted(String pstrVal) {
        return "\"" + pstrVal.trim() + "\"";
    }

    public static final String escapeHTML(String s) {
        StringBuilder sb = new StringBuilder();
        int n = s.length();
        block45: for (int i = 0; i < n; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    continue block45;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block45;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block45;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block45;
                }
                case '\u00e0': {
                    sb.append("&agrave;");
                    continue block45;
                }
                case '\u00c0': {
                    sb.append("&Agrave;");
                    continue block45;
                }
                case '\u00e2': {
                    sb.append("&acirc;");
                    continue block45;
                }
                case '\u00c2': {
                    sb.append("&Acirc;");
                    continue block45;
                }
                case '\u00e4': {
                    sb.append("&auml;");
                    continue block45;
                }
                case '\u00c4': {
                    sb.append("&Auml;");
                    continue block45;
                }
                case '\u00e5': {
                    sb.append("&aring;");
                    continue block45;
                }
                case '\u00c5': {
                    sb.append("&Aring;");
                    continue block45;
                }
                case '\u00e6': {
                    sb.append("&aelig;");
                    continue block45;
                }
                case '\u00c6': {
                    sb.append("&AElig;");
                    continue block45;
                }
                case '\u00e7': {
                    sb.append("&ccedil;");
                    continue block45;
                }
                case '\u00c7': {
                    sb.append("&Ccedil;");
                    continue block45;
                }
                case '\u00e9': {
                    sb.append("&eacute;");
                    continue block45;
                }
                case '\u00c9': {
                    sb.append("&Eacute;");
                    continue block45;
                }
                case '\u00e8': {
                    sb.append("&egrave;");
                    continue block45;
                }
                case '\u00c8': {
                    sb.append("&Egrave;");
                    continue block45;
                }
                case '\u00ea': {
                    sb.append("&ecirc;");
                    continue block45;
                }
                case '\u00ca': {
                    sb.append("&Ecirc;");
                    continue block45;
                }
                case '\u00eb': {
                    sb.append("&euml;");
                    continue block45;
                }
                case '\u00cb': {
                    sb.append("&Euml;");
                    continue block45;
                }
                case '\u00ef': {
                    sb.append("&iuml;");
                    continue block45;
                }
                case '\u00cf': {
                    sb.append("&Iuml;");
                    continue block45;
                }
                case '\u00f4': {
                    sb.append("&ocirc;");
                    continue block45;
                }
                case '\u00d4': {
                    sb.append("&Ocirc;");
                    continue block45;
                }
                case '\u00f6': {
                    sb.append("&ouml;");
                    continue block45;
                }
                case '\u00d6': {
                    sb.append("&Ouml;");
                    continue block45;
                }
                case '\u00f8': {
                    sb.append("&oslash;");
                    continue block45;
                }
                case '\u00d8': {
                    sb.append("&Oslash;");
                    continue block45;
                }
                case '\u00df': {
                    sb.append("&szlig;");
                    continue block45;
                }
                case '\u00f9': {
                    sb.append("&ugrave;");
                    continue block45;
                }
                case '\u00d9': {
                    sb.append("&Ugrave;");
                    continue block45;
                }
                case '\u00fb': {
                    sb.append("&ucirc;");
                    continue block45;
                }
                case '\u00db': {
                    sb.append("&Ucirc;");
                    continue block45;
                }
                case '\u00fc': {
                    sb.append("&uuml;");
                    continue block45;
                }
                case '\u00dc': {
                    sb.append("&Uuml;");
                    continue block45;
                }
                case '\u00ae': {
                    sb.append("&reg;");
                    continue block45;
                }
                case '\u00a9': {
                    sb.append("&copy;");
                    continue block45;
                }
                case '\u20ac': {
                    sb.append("&euro;");
                    continue block45;
                }
                case ' ': {
                    sb.append("&nbsp;");
                    continue block45;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    protected String[] arrayListToStringArray(List<String> pobjArray) {
        String[] strA = new String[pobjArray.size()];
        return pobjArray.toArray(strA);
    }
}

