/*
 * Decompiled with CFR 0.152.
 */
package com.sos.scheduler.model.objects;

import com.sos.scheduler.model.ISOSJsObjStartTimes;
import com.sos.scheduler.model.SchedulerObjectFactory;
import com.sos.scheduler.model.objects.JSObjPeriod;
import com.sos.scheduler.model.objects.JSObjRunTime;
import com.sos.scheduler.model.objects.Period;
import com.sos.scheduler.model.objects.RunTime;
import com.sos.scheduler.model.objects.WhenHoliday;
import com.sos.scheduler.model.tools.RunTimeElement;
import com.sos.scheduler.model.tools.RunTimeElements;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class JSObjDate
extends RunTime.Date
implements ISOSJsObjStartTimes {
    public JSObjDate(SchedulerObjectFactory schedulerObjectFactory) {
        this.objFactory = schedulerObjectFactory;
    }

    public DateTime getDtDate() {
        DateTimeFormatter fmtDate = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
        return fmtDate.parseDateTime(this.getDate());
    }

    @Override
    public RunTimeElements getRunTimeElements(Interval timeRange) {
        RunTimeElements result = new RunTimeElements(timeRange);
        for (Period p : this.getPeriod()) {
            JSObjPeriod period = new JSObjPeriod(this.objFactory);
            period.setObjectFieldsFrom(p);
            DateTime singleStart = period.getDtSingleStartOrNull(this.getDtDate());
            if (singleStart == null || !timeRange.contains((ReadableInstant)singleStart)) continue;
            result.add(new RunTimeElement(singleStart, period.getWhenHoliday()));
        }
        return result;
    }

    @Override
    public List<Period> getPeriod() {
        List<Period> list = super.getPeriod();
        WhenHoliday h = list != null && !list.isEmpty() ? list.get(0).getWhenHoliday() : WhenHoliday.SUPPRESS;
        return this.objFactory.useDefaultPeriod() ? JSObjRunTime.getDefaultPeriod(this.objFactory, h) : list;
    }
}

