/*
 * Decompiled with CFR 0.152.
 */
package com.sos.scheduler.model.objects;

import com.sos.JSHelper.Exceptions.JobSchedulerException;
import com.sos.scheduler.model.LanguageDescriptorList;
import com.sos.scheduler.model.SchedulerObjectFactory;
import com.sos.scheduler.model.objects.JSObjParams;
import com.sos.scheduler.model.objects.JSObjRunTime;
import com.sos.scheduler.model.objects.Job;
import com.sos.scheduler.model.objects.JobSettings;
import com.sos.scheduler.model.objects.LogLevel;
import com.sos.scheduler.model.objects.RunTime;
import com.sos.scheduler.model.objects.Script;
import com.sos.vfs.common.interfaces.ISOSProviderFile;
import java.io.File;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSObjJob
extends Job {
    private static final Logger LOGGER = LoggerFactory.getLogger(JSObjJob.class);
    private Script objScript = null;
    public static final String[] ValidLanguages4Job = LanguageDescriptorList.getLanguages4APIJobs();
    public static final String[] ValidLanguages4Monitor = LanguageDescriptorList.getLanguages4Monitor();
    public static final String InternalAPIMethodNames = "spooler_process_before;spooler_process_after;spooler_task_before;spooler_task_after;";
    public static final String MonitorMethodNames = "spooler_task_before;spooler_task_after;spooler_process_before;spooler_process_after";
    public static final String fileNameExtension = ".job.xml";
    public static final String[] ValidLogLevels = new String[]{"info", "debug1", "debug2", "debug3", "debug4", "debug5", "debug6", "debug7", "debug8", "debug9", ""};
    JobSettings objSettings = null;

    public JSObjJob(SchedulerObjectFactory schedulerObjectFactory) {
        this.objFactory = schedulerObjectFactory;
        this.strFileNameExtension = fileNameExtension;
    }

    public JSObjJob(SchedulerObjectFactory schedulerObjectFactory, Job origOrder) {
        this.objFactory = schedulerObjectFactory;
        this.strFileNameExtension = fileNameExtension;
        this.setObjectFieldsFrom(origOrder);
        this.afterUnmarshal();
    }

    public JSObjJob(SchedulerObjectFactory schedulerObjectFactory, ISOSProviderFile pobjVirtualFile) {
        this.strFileNameExtension = fileNameExtension;
        this.objFactory = schedulerObjectFactory;
        Job objJob = (Job)this.unMarshal(pobjVirtualFile);
        this.setObjectFieldsFrom(objJob);
        this.setHotFolderSrc(pobjVirtualFile);
    }

    private void afterUnmarshal() {
        if (this.getDescription() != null) {
            this.removeEmptyContentsFrom(this.getDescription().getContent());
        }
        if (this.getScript() != null) {
            this.removeEmptyContentsFrom(this.getScript().getContent());
        }
        if (this.getMonitor() != null) {
            for (Job.Monitor objMonitor : this.getMonitor()) {
                if (objMonitor.getScript() == null) continue;
                this.removeEmptyContentsFrom(objMonitor.getScript().getContent());
            }
        }
    }

    public boolean hasDescription() {
        return this.description != null;
    }

    @Override
    public Job.Description getDescription() {
        if (this.description == null) {
            this.description = this.objFactory.createJobDescription();
            this.setDirty();
        }
        return this.description;
    }

    @Override
    public Script getScript() {
        if (this.script == null) {
            this.script = this.objScript = this.objFactory.createScript();
            this.setDirty();
        } else {
            this.objScript = this.script;
        }
        return this.script;
    }

    private void removeEmptyContentsFrom(List<Object> objList) {
        ArrayList<String> emptyContents = new ArrayList<String>();
        for (Object listItem : objList) {
            if (!(listItem instanceof String) || !((String)listItem).trim().isEmpty()) continue;
            emptyContents.add((String)listItem);
        }
        objList.removeAll(emptyContents);
    }

    public void setOrder(boolean pflgIsOrder) {
        if (!this.canUpdate()) {
            return;
        }
        this.setDirty();
        if (pflgIsOrder) {
            this.setOrder("yes");
        } else {
            this.setOrder("no");
        }
    }

    public void setForceIdleTimeout(boolean pflgIsForcedIdleTimeout) {
        if (!this.canUpdate()) {
            return;
        }
        this.setDirty();
        if (pflgIsForcedIdleTimeout) {
            this.setForceIdleTimeout("yes");
        } else {
            this.setForceIdleTimeout("no");
        }
    }

    public void setTemporary(boolean pflgIsTemporary) {
        if (!this.canUpdate()) {
            return;
        }
        this.setDirty();
        if (pflgIsTemporary) {
            this.setTemporary("yes");
        } else {
            this.setTemporary("no");
        }
        this.setDirty();
    }

    public boolean isScriptEmpty() {
        boolean flgIsEmpty = true;
        if (this.script != null && !this.script.getContent().isEmpty()) {
            flgIsEmpty = false;
        }
        return flgIsEmpty;
    }

    public boolean hasScript() {
        this.objScript = this.getScript();
        if (this.objScript == null) {
            JobSchedulerException objJSException = new JobSchedulerException("Job has no script.");
            LOGGER.error("", (Throwable)objJSException);
            throw objJSException;
        }
        return true;
    }

    public boolean getEnabled() {
        return true;
    }

    public boolean isJobChainJob() {
        return this.isOrderDrivenJob();
    }

    public boolean isOrderDrivenJob() {
        if (this.order == null) {
            return false;
        }
        return this.getYesOrNo(this.order);
    }

    @Override
    public String getProcessClass() {
        String strT = this.processClass;
        if (strT == null || strT.isEmpty()) {
            strT = "";
        }
        return this.avoidNull(strT);
    }

    @Override
    public JSObjParams getParams() {
        return new JSObjParams(this.objFactory, super.getParams());
    }

    @Override
    public Job.Process getProcess() {
        Job.Process objP = super.getProcess();
        if (objP == null) {
            super.setProcess(new Job.Process());
            objP = super.getProcess();
            this.setDirty();
        }
        return objP;
    }

    public void setTasks(String pstrV) {
        if (!this.canUpdate()) {
            return;
        }
        this.setDirty();
        BigInteger intT = new BigInteger(pstrV);
        super.setTasks(intT);
    }

    public String getMintasks() {
        return this.bigInt2String(super.getMinTasks());
    }

    public String getTasksAsString() {
        return this.bigInt2String(super.getTasks());
    }

    public void setMintasks(String mintasks) {
        if (!this.canUpdate()) {
            return;
        }
        this.setDirty();
        BigInteger bigI = new BigInteger(mintasks);
        super.setMinTasks(bigI);
    }

    @Override
    public RunTime getRunTime() {
        RunTime objP = super.getRunTime();
        if (objP == null) {
            super.setRunTime(new RunTime());
            objP = super.getRunTime();
            this.setDirty();
        }
        return objP;
    }

    public JSObjRunTime getRunTimeObj() {
        RunTime objP = super.getRunTime();
        if (objP == null) {
            super.setRunTime(new RunTime());
            objP = super.getRunTime();
            this.setDirty();
        }
        return new JSObjRunTime(this.objFactory, objP);
    }

    public String getJobName() {
        String name = this.getHotFolderSrc().getName();
        name = name.substring(0, name.indexOf(fileNameExtension));
        name = new File(name).getName();
        return name;
    }

    public String getJobNameAndTitle() {
        String strV;
        String strT = this.getJobName();
        if (this.isDisabled()) {
            strT = strT + " (disabled)";
        }
        if ((strV = this.getTitle()) != null && !strV.isEmpty()) {
            strT = strT + " - " + this.getTitle();
        }
        return strT;
    }

    public boolean isDisabled() {
        return false;
    }

    @Override
    public void setVisible(String visible) {
        if (!this.canUpdate()) {
            return;
        }
        this.setDirty();
        super.setVisible(visible);
    }

    @Override
    public void setWarnIfLongerThan(String warnIfLongerThan) {
        if (!this.canUpdate()) {
            return;
        }
        this.setDirty();
        super.setWarnIfLongerThan(warnIfLongerThan);
    }

    @Override
    public void setWarnIfShorterThan(String pstrWarnIfShorterThan) {
        if (!this.canUpdate()) {
            return;
        }
        this.setDirty();
        super.setWarnIfShorterThan(pstrWarnIfShorterThan);
    }

    public int languageAsInt(String language) {
        if (language != null) {
            String strT = language.toLowerCase();
            for (int i = 0; i < ValidLanguages4Job.length; ++i) {
                if (!ValidLanguages4Job[i].equalsIgnoreCase(strT)) continue;
                return i;
            }
        }
        return 0;
    }

    private String languageAsString(int language) {
        String strR = "";
        if (language >= 0) {
            strR = ValidLanguages4Job[language];
        }
        return strR;
    }

    public String getLanguage(int language) {
        return ValidLanguages4Job[language];
    }

    public int getLanguage() {
        return this.languageAsInt(this.getScript().getLanguage());
    }

    public String getLanguageAsString(int language) {
        return this.languageAsString(language);
    }

    public void setLanguage(String pstrLanguage) {
        if (!this.canUpdate()) {
            return;
        }
        this.setDirty();
        this.setLanguage(this.languageAsInt(pstrLanguage));
    }

    public void setLanguage(int language) {
        if (!this.canUpdate()) {
            return;
        }
        this.setDirty();
        this.getScript().setLanguage(this.languageAsString(language));
    }

    public boolean isJava() {
        return "java".equalsIgnoreCase(this.languageAsString(this.getLanguage()));
    }

    public boolean isInternalAPIJob() {
        return !"shell".equalsIgnoreCase(this.languageAsString(this.getLanguage()));
    }

    @Override
    public void setName(String name) {
        if (!this.canUpdate()) {
            return;
        }
        this.setDirty();
        super.setName(name);
    }

    public void setJavaClass(String javaClass) {
        if (!this.canUpdate()) {
            return;
        }
        this.setDirty();
        this.getScript().setJavaClass(javaClass);
    }

    public void setClasspath(String classpath) {
        if (!this.canUpdate()) {
            return;
        }
        this.setDirty();
        this.getScript().setJavaClassPath(classpath);
    }

    public void setHistoryOnProcess(String pstrValue) {
        this.setSettings().setHistoryOnProcess(pstrValue);
        this.setDirty();
    }

    public void setHistory(String pstrValue) {
        if (!this.canUpdate()) {
            return;
        }
        this.setDirty();
        this.setSettings().setHistory(pstrValue);
    }

    public void setHistoryWithLog(String pstrValue) {
        if (!this.canUpdate()) {
            return;
        }
        this.setDirty();
        this.setSettings().setHistoryWithLog(pstrValue);
    }

    public void setOrdering(String ordering) {
        if (!this.canUpdate()) {
            return;
        }
        this.setDirty();
        this.getMonitor().get(0).setOrdering(new BigInteger(ordering));
    }

    private String getYesNoText(String pstrS) {
        String strR = pstrS;
        if (strR == null || strR.trim().isEmpty()) {
            strR = "no";
        }
        return strR;
    }

    public void setMailOnError(String text) {
        if (!this.canUpdate()) {
            return;
        }
        this.setDirty();
        this.setSettings().setMailOnError(this.getYesNoText(text));
    }

    public void setMailOnWarning(String text) {
        if (!this.canUpdate()) {
            return;
        }
        this.setDirty();
        this.setSettings().setMailOnWarning(this.getYesNoText(text));
    }

    public void setMailOnSuccess(String text) {
        if (!this.canUpdate()) {
            return;
        }
        this.setDirty();
        this.setSettings().setMailOnSuccess(this.getYesNoText(text));
    }

    public void setMailOnProcess(String text) {
        if (!this.canUpdate()) {
            return;
        }
        this.setDirty();
        this.setSettings().setMailOnProcess(this.getYesNoText(text));
    }

    public void setMailOnDelayAfterError(String text) {
        if (!this.canUpdate()) {
            return;
        }
        this.setSettings().setMailOnDelayAfterError(this.getYesNoText(text));
    }

    public void setLogMailTo(String text) {
        if (!this.canUpdate()) {
            return;
        }
        this.setSettings().setLogMailTo(this.getYesNoText(text));
    }

    public void setLogMailBcc(String text) {
        if (!this.canUpdate()) {
            return;
        }
        this.setSettings().setLogMailBcc(this.getYesNoText(text));
    }

    public void setLogMailCc(String text) {
        if (!this.canUpdate()) {
            return;
        }
        this.setSettings().setLogMailCc(this.getYesNoText(text));
    }

    public String getLogLevel() {
        LogLevel objL;
        JobSettings objS = this.getSettings();
        if (objS != null && (objL = objS.getLogLevel()) != null) {
            return objL.value();
        }
        return "";
    }

    public void setLogLevel(String text) {
        if (!this.canUpdate()) {
            return;
        }
        this.setSettings().setLogLevel(LogLevel.fromValue(text));
    }

    @Override
    public void setIdleTimeout(String idleTimeout) {
        if (!this.canUpdate()) {
            return;
        }
        super.setIdleTimeout(idleTimeout);
    }

    public void setForceIdletimeout(boolean forceIdleTimeout) {
        if (!this.canUpdate()) {
            return;
        }
        super.setTimeout(this.setYesOrNo(forceIdleTimeout));
    }

    public void setStopOnError(boolean stopOnError) {
        if (!this.canUpdate()) {
            return;
        }
        this.setDirty();
        super.setStopOnError(this.setYesOrNo(stopOnError));
    }

    public void setReplace(boolean replace) {
        if (!this.canUpdate()) {
            return;
        }
        this.setDirty();
        super.setReplace(this.setYesOrNo(replace));
    }

    public boolean isReplace() {
        return this.getYesOrNo(super.getReplace());
    }

    public void setTemporary1(boolean temporary) {
        if (!this.canUpdate()) {
            return;
        }
        this.setDirty();
        super.setTemporary(this.setYesOrNo(temporary));
    }

    public boolean isTemporary() {
        return this.getYesOrNo(super.getTemporary());
    }

    public void setVisible1(String visible) {
        if (!this.canUpdate()) {
            return;
        }
        this.setDirty();
        super.setVisible(visible);
    }

    @Override
    public String getVisible() {
        return this.avoidNull(super.getVisible());
    }

    public void setFile(String file) {
        if (!this.canUpdate()) {
            return;
        }
        this.setDirty();
        this.getProcess().setFile(file);
    }

    public String getHistoryWithLog() {
        if (this.getSettings() != null) {
            return this.avoidNull(this.getSettings().getHistoryWithLog());
        }
        return "";
    }

    public String getHistory() {
        if (this.getSettings() != null) {
            return this.avoidNull(this.avoidNull(this.getSettings().getHistory()));
        }
        return "";
    }

    public String getHistoryOnProcess() {
        if (this.getSettings() != null) {
            return this.avoidNull(this.getSettings().getHistoryOnProcess());
        }
        return "";
    }

    public String getMonitorName() {
        return "";
    }

    public void setMonitorName(String name) {
    }

    public void setMailOnError(String pstrValue, String pstrDefaultValue) {
        this.getSettings().setMailOnError(this.oneOfUs(pstrValue, pstrDefaultValue));
        this.setDirty();
    }

    @Override
    public JobSettings getSettings() {
        JobSettings objS = super.getSettings();
        if (objS == null) {
            throw new JobSchedulerException("is null");
        }
        return objS;
    }

    public JobSettings setSettings() {
        if (this.settings == null) {
            this.settings = new JobSettings();
        }
        this.setDirty();
        return this.settings;
    }

    public String getMailOnError() {
        try {
            return this.avoidNull(this.getSettings().getMailOnError());
        }
        catch (Exception exception) {
            return "";
        }
    }

    public void setMailOnWarning(String pstrValue, String pstrDefaultValue) {
        this.setSettings().setMailOnWarning(this.oneOfUs(pstrValue, pstrDefaultValue));
        this.setDirty();
    }

    public String getMailOnWarning() {
        try {
            return this.avoidNull(this.getSettings().getMailOnWarning());
        }
        catch (Exception exception) {
            return "";
        }
    }

    public void setMailOnProcess(String pstrValue, String pstrDefaultValue) {
        this.setSettings().setMailOnProcess(this.oneOfUs(pstrValue, pstrDefaultValue));
        this.setDirty();
    }

    public String getMailOnProcess() {
        try {
            return this.avoidNull(this.getSettings().getMailOnProcess());
        }
        catch (Exception exception) {
            return "";
        }
    }

    public void setMailOnSuccess(String pstrValue, String pstrDefaultValue) {
        this.setSettings().setMailOnSuccess(this.oneOfUs(pstrValue, pstrDefaultValue));
        this.setDirty();
    }

    public String getMailOnSuccess() {
        try {
            return this.avoidNull(this.getSettings().getMailOnSuccess());
        }
        catch (Exception exception) {
            return "";
        }
    }

    public void setMailOnDelayAfterError(String pstrValue, String pstrDefaultValue) {
        this.setSettings().setMailOnDelayAfterError(this.oneOfUs(pstrValue, pstrDefaultValue));
        this.setDirty();
    }

    public String getMailOnDelayAfterError() {
        try {
            return this.avoidNull(this.getSettings().getMailOnDelayAfterError());
        }
        catch (Exception exception) {
            return "";
        }
    }

    public void setLogMailTo(String pstrValue, String pstrDefaultValue) {
        this.setSettings().setLogMailTo(this.oneOfUs(pstrValue, pstrDefaultValue));
        this.setDirty();
    }

    public String getLogMailTo() {
        try {
            return this.avoidNull(this.getSettings().getLogMailTo());
        }
        catch (Exception exception) {
            return "";
        }
    }

    public void setLogMailCC(String pstrValue, String pstrDefaultValue) {
        this.setSettings().setLogMailCc(this.oneOfUs(pstrValue, pstrDefaultValue));
        this.setDirty();
    }

    public String getLogMailCC() {
        try {
            return this.avoidNull(this.getSettings().getLogMailCc());
        }
        catch (Exception exception) {
            return "";
        }
    }

    public void setLogMailBcc(String pstrValue, String pstrDefaultValue) {
        this.setSettings().setLogMailBcc(this.oneOfUs(pstrValue, pstrDefaultValue));
        this.setDirty();
    }

    public String getLogMailBCC() {
        try {
            return this.avoidNull(this.getSettings().getLogMailBcc());
        }
        catch (Exception exception) {
            return "";
        }
    }

    public String oneOfUs(String pstrValue, String pstrDefaultValue) {
        if (this.isNotEmpty(pstrValue)) {
            return pstrValue;
        }
        return pstrDefaultValue;
    }

    public boolean isSetbackDelay() {
        return !this.getDelayOrderAfterSetback().isEmpty();
    }

    public boolean isNotEmpty(String pstrValue) {
        return pstrValue != null && !pstrValue.trim().isEmpty();
    }

    public static enum enuVisibilityTypes {
        enuIsVisible,
        enuIsNotVisible,
        enuIsNeverVisible;

        private static final String[] VISIBILITY_TEXT;
        public static boolean isMandatory;
        public static String i18nKey;

        public static String[] getTexts() {
            return VISIBILITY_TEXT;
        }

        static {
            VISIBILITY_TEXT = new String[]{"", "yes", "no", "never"};
            isMandatory = false;
            i18nKey = "job.visible";
        }
    }
}

