/*
 * Decompiled with CFR 0.152.
 */
package com.sos.scheduler.model.objects;

import com.sos.JSHelper.Options.SOSOptionString;
import com.sos.scheduler.model.SchedulerObjectFactory;
import com.sos.scheduler.model.objects.JobChain;
import com.sos.scheduler.model.objects.JobChainNodeEnd;
import com.sos.vfs.common.SOSVFSFactory;
import com.sos.vfs.common.interfaces.ISOSProvider;
import com.sos.vfs.common.interfaces.ISOSProviderFile;
import com.sos.vfs.common.options.SOSBaseOptions;
import java.io.File;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSObjJobChain
extends JobChain {
    private static final Logger LOGGER = LoggerFactory.getLogger(JSObjJobChain.class);
    public static final String fileNameExtension = ".job_chain.xml";
    public static final String conFileNameExtension4NodeParameterFile = ".config.xml";

    public JSObjJobChain(SchedulerObjectFactory schedulerObjectFactory) {
        this.objFactory = schedulerObjectFactory;
        this.strFileNameExtension = fileNameExtension;
    }

    public JSObjJobChain(SchedulerObjectFactory schedulerObjectFactory, JobChain origOrder) {
        this(schedulerObjectFactory);
        this.setObjectFieldsFrom(origOrder);
    }

    public JSObjJobChain(SchedulerObjectFactory schedulerObjectFactory, ISOSProviderFile pobjVirtualFile) {
        this(schedulerObjectFactory);
        this.objVirtualFile = pobjVirtualFile;
        this.setHotFolderSrc(this.objVirtualFile);
        this.loadObject();
    }

    public void loadObject() {
        JobChain objJobChain = (JobChain)this.unMarshal(this.objVirtualFile);
        this.setObjectFieldsFrom(objJobChain);
        this.setHotFolderSrc(this.objVirtualFile);
    }

    public void loadObject(File file) {
        JobChain jobChain = (JobChain)this.unMarshal(file);
        this.setObjectFieldsFrom(jobChain);
        if (this.objVirtualFile == null) {
            try {
                ISOSProviderFile virtualFile;
                SOSBaseOptions vfsOptions = new SOSBaseOptions();
                ISOSProvider sosVFSFileTransfer = SOSVFSFactory.getProvider((String)"local", (SOSOptionString)vfsOptions.ssh_provider, (SOSOptionString)vfsOptions.webdav_provider, (SOSOptionString)vfsOptions.smb_provider);
                this.objVirtualFile = virtualFile = sosVFSFileTransfer.getFile(file.getAbsolutePath());
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        this.setHotFolderSrc(this.objVirtualFile);
    }

    public void loadObject(String xml) {
        JobChain jobChain = (JobChain)this.unMarshal(xml);
        this.setObjectFieldsFrom(jobChain);
    }

    public void setNameIfNotEmpty(String value) {
        if (!this.isEmpty(value)) {
            this.setName(value);
        }
    }

    public void setDistributedNotEmpty(String value) {
        if (!this.isEmpty(value)) {
            this.setDistributed(value);
        }
    }

    public void setMaxOrdersIfNotEmpty(String value) {
        if (!this.isEmpty(value)) {
            this.setMaxorders(value);
        }
    }

    public void setOrdersRecoverableIfNotEmpty(String value) {
        if (!this.isEmpty(value)) {
            this.setOrdersRecoverable(value);
        }
    }

    public void setVisibleIfNotEmpty(String value) {
        if (!this.isEmpty(value)) {
            this.setVisible(value);
        }
    }

    public void setTitleIfNotEmpty(String value) {
        if (!this.isEmpty(value)) {
            this.setTitle(value);
        }
    }

    public boolean isNestedJobChain() {
        boolean flgR = false;
        if (this.jobChainNodeJobChain != null) {
            flgR = true;
        }
        return flgR;
    }

    public void setOrdersRecoverable(boolean pflgIsOrdersRecoverable) {
        if (this.canUpdate() && pflgIsOrdersRecoverable != this.getYesOrNo(this.getOrdersRecoverable())) {
            if (pflgIsOrdersRecoverable) {
                this.setOrdersRecoverable("yes");
            } else {
                this.setOrdersRecoverable("no");
            }
            this.setDirty();
        }
    }

    public void setVisible(boolean pflgIsVisible) {
        if (this.canUpdate()) {
            if (pflgIsVisible) {
                this.setVisible("yes");
            } else {
                this.setVisible("no");
            }
            this.setDirty();
        }
    }

    public void setDistributed(boolean pflgIsDistributed) {
        if (this.canUpdate() && this.getYesOrNo(super.getDistributed()) != pflgIsDistributed) {
            if (pflgIsDistributed) {
                this.setDistributed("yes");
            } else {
                this.setDistributed("no");
            }
            this.setDirty();
        }
    }

    public String createFileName(String pstrPathName) {
        String strT = "";
        strT = pstrPathName + "/" + this.getName() + fileNameExtension;
        return strT;
    }

    @Override
    public String getObjectName() {
        if (this.getHotFolderSrc() == null) {
            return "";
        }
        String name = this.getHotFolderSrc().getName();
        if (name == null) {
            name = "???";
        } else {
            name = name.substring(0, name.indexOf(fileNameExtension));
            name = new File(name).getName();
        }
        return name;
    }

    @Override
    public String getObjectNameAndTitle() {
        String strT = this.getObjectName();
        String strV = this.getTitle();
        if (strV != null && !strV.isEmpty()) {
            strT = strT + " - " + this.getTitle();
        }
        return strT;
    }

    @Override
    public void setName(String pstrName) {
        if (!this.canUpdate()) {
            return;
        }
        String strOldName = this.getObjectName();
        if (!strOldName.equals(pstrName)) {
            this.changeSourceName(pstrName);
            super.setName(pstrName);
            this.setDirty();
        }
    }

    @Override
    public String getTitle() {
        String strT = "";
        strT = this.title == null ? this.getObjectName() : this.title;
        return strT;
    }

    @Override
    public void setTitle(String pstrTitle) {
        if (!this.canUpdate()) {
            return;
        }
        String strOldTitle = this.getTitle();
        if (!strOldTitle.equals(pstrTitle)) {
            super.setTitle(pstrTitle);
            this.setDirty();
        }
    }

    public void setMaxorders(String strMaxOrders) {
        if (!this.canUpdate()) {
            return;
        }
        try {
            BigInteger maxOrders = new BigInteger(strMaxOrders);
            this.setMaxorders(maxOrders);
        }
        catch (NumberFormatException e) {
            BigInteger maxOrders = new BigInteger("0");
        }
    }

    public void setMaxorders(BigInteger maxOrders) {
        this.maxOrders = maxOrders;
        this.setDirty();
    }

    public boolean isDistributed() {
        return this.getYesOrNo(this.distributed);
    }

    public boolean isRecoverable() {
        return this.getYesOrNo(this.getOrdersRecoverable());
    }

    public boolean isVisible() {
        return this.getYesOrNo(this.getVisible());
    }

    public String getMaxOrders() {
        BigInteger intM = this.getmaxOrders();
        String strM = "";
        if (intM != null) {
            strM = String.valueOf(intM);
        }
        return strM;
    }

    @Override
    public BigInteger getmaxOrders() {
        if (this.maxOrders == null) {
            return new BigInteger("0");
        }
        return this.maxOrders;
    }

    public List<JobChain.FileOrderSink> getFileOrderSinkList() {
        ArrayList<JobChain.FileOrderSink> objList = new ArrayList<JobChain.FileOrderSink>();
        for (Object objO : this.getJobChainNodeOrFileOrderSinkOrJobChainNodeEnd()) {
            if (!(objO instanceof JobChain.FileOrderSink)) continue;
            objList.add((JobChain.FileOrderSink)objO);
        }
        return objList;
    }

    public List<JobChain.FileOrderSource> getFileOrderSourceList() {
        ArrayList<JobChain.FileOrderSource> objList = new ArrayList<JobChain.FileOrderSource>();
        for (JobChain.FileOrderSource objO : this.getFileOrderSource()) {
            if (!(objO instanceof JobChain.FileOrderSource)) continue;
            objList.add(objO);
        }
        return objList;
    }

    public List<JobChain.JobChainNode> getJobChainNodeList() {
        ArrayList<JobChain.JobChainNode> objList = new ArrayList<JobChain.JobChainNode>();
        for (Object objO : this.getJobChainNodeOrFileOrderSinkOrJobChainNodeEnd()) {
            if (!(objO instanceof JobChain.JobChainNode)) continue;
            objList.add((JobChain.JobChainNode)objO);
        }
        return objList;
    }

    public boolean isStateDefined(String state) {
        for (String _state : this.getAllStates()) {
            if (!_state.equals(state)) continue;
            return true;
        }
        return false;
    }

    public String[] getAllStates() {
        return this.getStates();
    }

    public String[] getStates() {
        ArrayList<String> strStatesList = new ArrayList<String>();
        for (JobChain.JobChainNode objNode : this.getJobChainNodeList()) {
            this.addToList(strStatesList, objNode.errorState);
            this.addToList(strStatesList, objNode.nextState);
            this.addToList(strStatesList, objNode.state);
        }
        return this.arrayListToStringArray(strStatesList);
    }

    public String[] getErrorStates() {
        ArrayList<String> strStatesList = new ArrayList<String>();
        for (JobChain.JobChainNode objNode : this.getJobChainNodeList()) {
            this.addToList(strStatesList, objNode.errorState);
        }
        return this.arrayListToStringArray(strStatesList);
    }

    public String[] getNextStates() {
        ArrayList<String> strStatesList = new ArrayList<String>();
        for (JobChain.JobChainNode objNode : this.getJobChainNodeList()) {
            this.addToList(strStatesList, objNode.nextState);
        }
        return this.arrayListToStringArray(strStatesList);
    }

    private void addToList(List<String> pobjL, String pstrS) {
        if (pstrS != null && !pobjL.contains(pstrS)) {
            pobjL.add(pstrS);
        }
    }

    public List<JobChainNodeEnd> getJobChainNodeEndList() {
        ArrayList<JobChainNodeEnd> objList = new ArrayList<JobChainNodeEnd>();
        for (Object objO : this.getJobChainNodeOrFileOrderSinkOrJobChainNodeEnd()) {
            if (!(objO instanceof JobChainNodeEnd)) continue;
            objList.add((JobChainNodeEnd)objO);
        }
        return objList;
    }
}

