/*
 * Decompiled with CFR 0.152.
 */
package com.sos.scheduler.model.objects;

import com.sos.scheduler.model.ISOSJsObjStartTimes;
import com.sos.scheduler.model.SchedulerObjectFactory;
import com.sos.scheduler.model.objects.JSObjMonthdaysDay;
import com.sos.scheduler.model.objects.JSObjWeekday;
import com.sos.scheduler.model.objects.Monthdays;
import com.sos.scheduler.model.tools.RunTimeElements;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.Interval;

public class JSObjMonthdays
extends Monthdays
implements ISOSJsObjStartTimes {
    public JSObjMonthdays(SchedulerObjectFactory schedulerObjectFactory) {
        this.objFactory = schedulerObjectFactory;
    }

    @Override
    public RunTimeElements getRunTimeElements(Interval timeRange) {
        RunTimeElements result = new RunTimeElements(timeRange);
        result.putAll(this.getDtWeekdays(timeRange));
        result.putAll(this.getDtDays(timeRange));
        return result;
    }

    public List<JSObjMonthdaysDay> getJsObjMonthdaysDay() {
        ArrayList<JSObjMonthdaysDay> result = new ArrayList<JSObjMonthdaysDay>();
        for (Object o : this.getDayOrWeekday()) {
            if (!(o instanceof Monthdays.Day)) continue;
            Monthdays.Day d = (Monthdays.Day)o;
            JSObjMonthdaysDay day = new JSObjMonthdaysDay(this.objFactory);
            day.setObjectFieldsFrom(d);
            day.setHotFolderSrc(this.getHotFolderSrc());
            result.add(day);
        }
        return result;
    }

    public List<JSObjWeekday> getJsObjWeekday() {
        ArrayList<JSObjWeekday> result = new ArrayList<JSObjWeekday>();
        for (Object o : this.getDayOrWeekday()) {
            if (!(o instanceof Monthdays.Weekday)) continue;
            Monthdays.Weekday w = (Monthdays.Weekday)o;
            JSObjWeekday weekday = new JSObjWeekday(this.objFactory);
            weekday.setObjectFieldsFrom(w);
            weekday.setHotFolderSrc(this.getHotFolderSrc());
            result.add(weekday);
        }
        return result;
    }

    public RunTimeElements getDtWeekdays(Interval timeRange) {
        RunTimeElements result = new RunTimeElements(timeRange);
        for (JSObjWeekday weekday : this.getJsObjWeekday()) {
            result.putAll(weekday.getRunTimeElements(timeRange));
        }
        return result;
    }

    public RunTimeElements getDtDays(Interval timeRange) {
        RunTimeElements result = new RunTimeElements(timeRange);
        for (JSObjMonthdaysDay day : this.getJsObjMonthdaysDay()) {
            result.putAll(day.getRunTimeElements(timeRange));
        }
        return result;
    }
}

