/*
 * Decompiled with CFR 0.152.
 */
package com.sos.scheduler.model.objects;

import com.sos.scheduler.model.ISOSJsObjStartTimes;
import com.sos.scheduler.model.SchedulerObjectFactory;
import com.sos.scheduler.model.objects.JSObjPeriod;
import com.sos.scheduler.model.objects.JSObjRunTime;
import com.sos.scheduler.model.objects.Monthdays;
import com.sos.scheduler.model.objects.Period;
import com.sos.scheduler.model.objects.WhenHoliday;
import com.sos.scheduler.model.tools.JodaTools;
import com.sos.scheduler.model.tools.RunTimeElement;
import com.sos.scheduler.model.tools.RunTimeElements;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;

public class JSObjMonthdaysDay
extends Monthdays.Day
implements ISOSJsObjStartTimes {
    public JSObjMonthdaysDay(SchedulerObjectFactory schedulerObjectFactory) {
        this.objFactory = schedulerObjectFactory;
    }

    @Override
    public RunTimeElements getRunTimeElements(Interval timeRange) {
        RunTimeElements result = new RunTimeElements(timeRange);
        block0: for (int day : this.getDay()) {
            DateTime date = JodaTools.getDayInIntervalOrNull(timeRange, day);
            while (date != null) {
                for (Period p : this.getPeriod()) {
                    JSObjPeriod period = new JSObjPeriod(this.objFactory);
                    period.setObjectFieldsFrom(p);
                    DateTime start = period.getDtSingleStartOrNull(date);
                    if (start == null || !timeRange.contains((ReadableInstant)start)) continue;
                    result.add(new RunTimeElement(start, period.getWhenHoliday()));
                }
                DateTime start = JodaTools.getStartOfMonth(date.plusMonths(1));
                if (!timeRange.contains((ReadableInstant)start)) continue block0;
                Interval i = new Interval((ReadableInstant)start, (ReadableInstant)timeRange.getEnd());
                date = JodaTools.getDayInIntervalOrNull(i, day);
            }
        }
        return result;
    }

    @Override
    public List<Period> getPeriod() {
        List<Period> list = super.getPeriod();
        WhenHoliday h = list != null && !list.isEmpty() ? list.get(0).getWhenHoliday() : WhenHoliday.SUPPRESS;
        return this.objFactory.useDefaultPeriod() ? JSObjRunTime.getDefaultPeriod(this.objFactory, h) : list;
    }
}

