/*
 * Decompiled with CFR 0.152.
 */
package com.sos.scheduler.model.objects;

import com.sos.JSHelper.Exceptions.JobSchedulerException;
import com.sos.scheduler.model.ISOSJsObjStartTimes;
import com.sos.scheduler.model.SchedulerObjectFactory;
import com.sos.scheduler.model.objects.IntervalConstants;
import com.sos.scheduler.model.objects.Period;
import com.sos.scheduler.model.objects.PeriodType;
import com.sos.scheduler.model.tools.RunTimeElement;
import com.sos.scheduler.model.tools.RunTimeElements;
import java.util.Date;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class JSObjPeriod
extends Period
implements ISOSJsObjStartTimes {
    public JSObjPeriod(SchedulerObjectFactory schedulerObjectFactory) {
        this.objFactory = schedulerObjectFactory;
    }

    public JSObjPeriod(SchedulerObjectFactory schedulerObjectFactory, String xmlContent) {
        this.objFactory = schedulerObjectFactory;
        Period p = (Period)super.unMarshal(xmlContent);
        this.setObjectFieldsFrom(p);
    }

    public PeriodType getPeriodType() {
        if (this.hasSingleStart()) {
            return PeriodType.SINGLE_START;
        }
        if (this.hasStartStartInterval()) {
            return PeriodType.START_START_INTERVAL;
        }
        if (this.hasEndStartInterval()) {
            return PeriodType.END_START_INTERVAL;
        }
        throw new JobSchedulerException("the period type of '" + this.toXMLString() + "' is not valid.");
    }

    public boolean hasSingleStart() {
        return this.getSingleStart() != null;
    }

    public boolean hasStartStartInterval() {
        return this.getAbsoluteRepeat() != null;
    }

    public boolean hasEndStartInterval() {
        return this.getRepeat() != null;
    }

    @Override
    public String getBegin() {
        return JSObjPeriod.normalizeTime(super.getBegin());
    }

    @Override
    public String getEnd() {
        return JSObjPeriod.normalizeTime(super.getEnd());
    }

    @Override
    public String getSingleStart() {
        return JSObjPeriod.normalizeTime(super.getSingleStart());
    }

    public static String normalizeTime(String timeString) {
        return timeString == null || "".equals(timeString) ? null : (timeString.length() < 8 ? timeString + ":00" : timeString);
    }

    public boolean isInPeriod(Date timeStamp) {
        DateTime d = new DateTime((Object)timeStamp);
        return this.isInPeriod(d);
    }

    public boolean isInPeriod(DateTime timeStamp) {
        if (this.hasSingleStart()) {
            return true;
        }
        Interval p = this.getPeriodOrNull(timeStamp);
        return p.contains((ReadableInstant)timeStamp);
    }

    public Interval getPeriodOrNull(DateTime date) {
        Interval result = null;
        if (this.getBegin() != null && this.getEnd() != null) {
            DateTime begin = JSObjPeriod.getDate(date, this.getBegin());
            DateTime end = JSObjPeriod.getDate(date, this.getEnd());
            result = new Interval((ReadableInstant)begin, (ReadableInstant)end);
        }
        return result;
    }

    private static DateTime getDate(DateTime baseDate, String timeString) {
        DateTimeFormatter fmtDate = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
        DateTimeFormatter fmtDateTime = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss");
        String dateString = fmtDate.print((ReadableInstant)baseDate) + " ";
        return fmtDateTime.parseDateTime(dateString + timeString);
    }

    public DateTime getDtSingleStartOrNull(DateTime date) {
        DateTime result = null;
        if (this.hasSingleStart()) {
            result = JSObjPeriod.getDate(date, this.getSingleStart());
        }
        return result;
    }

    public DateTime getDtBeginOrNull(DateTime date) {
        DateTime result = null;
        if (!this.hasSingleStart()) {
            result = JSObjPeriod.getDate(date, this.getBegin());
        }
        return result;
    }

    public DateTime getDtEndOrNull(DateTime date) {
        DateTime result = null;
        if (!this.hasSingleStart()) {
            result = JSObjPeriod.getDate(date, this.getEnd());
        }
        return result;
    }

    @Override
    public RunTimeElements getRunTimeElements(Interval timeRange) {
        RunTimeElements result = new RunTimeElements(timeRange);
        DateTime dt = this.getDtSingleStartOrNull(timeRange.getStart());
        if (dt != null) {
            result = new RunTimeElements(timeRange);
            if (!timeRange.contains((ReadableInstant)dt)) {
                dt = dt.plusDays(1);
            }
            while (timeRange.contains((ReadableInstant)dt)) {
                result.add(new RunTimeElement(dt, this.getWhenHoliday()));
                dt = dt.plusDays(1);
            }
        }
        return result;
    }

    public DateTime getDtNextSingleStartOrNull() {
        RunTimeElements result = this.getRunTimeElements(IntervalConstants.NEXT_24H.getInterval());
        return result.isEmpty() ? null : result.getStartTimes().get(0);
    }
}

