/*
 * Decompiled with CFR 0.152.
 */
package sos.net.ssh;

import com.sos.JSHelper.Annotations.JSOptionDefinition;
import com.sos.JSHelper.Exceptions.JSExceptionMandatoryOptionMissing;
import com.sos.JSHelper.Options.JSOptionsClass;
import com.sos.JSHelper.Options.SOSOptionInFileName;
import com.sos.JSHelper.Options.SOSOptionPassword;
import com.sos.JSHelper.Options.SOSOptionString;
import com.sos.keepass.SOSKeePassDatabase;
import java.util.HashMap;
import sos.net.ssh.SOSSSHJobOptionsSuperClass;

public class SOSSSHJobOptions
extends SOSSSHJobOptionsSuperClass {
    private static final long serialVersionUID = 2072083231341151442L;
    private static final String CLASS_NAME = SOSSSHJobOptions.class.getSimpleName();
    @JSOptionDefinition(name="credential_store_fileName", description="", key="credential_store_fileName", type="SOSOptionInFileName", mandatory=false)
    public SOSOptionInFileName credential_store_filename = new SOSOptionInFileName((JSOptionsClass)this, CLASS_NAME + ".credential_store_fileName", "", "", "", false);
    @JSOptionDefinition(name="credential_store_key_filename", description="", key="credential_store_key_filename", type="SOSOptionInFileName", mandatory=false)
    public SOSOptionInFileName credential_store_key_filename = new SOSOptionInFileName((JSOptionsClass)this, CLASS_NAME + ".credential_store_key_filename", "", "", "", false);
    @JSOptionDefinition(name="credential_store_password", description="", key="credential_store_password", type="SOSOptionPassword", mandatory=false)
    public SOSOptionPassword credential_store_password = new SOSOptionPassword((JSOptionsClass)this, CLASS_NAME + ".credential_store_password", "", "", "", false);
    @JSOptionDefinition(name="credential_store_entry_path", description="", key="credential_store_entry_path", type="SOSOptionString", mandatory=false)
    public SOSOptionString credential_store_entry_path = new SOSOptionString((JSOptionsClass)this, CLASS_NAME + ".credential_store_entry_path", "", "", "", false);
    @JSOptionDefinition(name="credential_store_keepass_module", description="", key="credential_store_keepass_module", type="SOSOptionString", mandatory=false)
    public SOSOptionString credential_store_keepass_module = new SOSOptionString((JSOptionsClass)this, CLASS_NAME + ".credential_store_keepass_module", "", SOSKeePassDatabase.DEFAULT_MODULE.name(), SOSKeePassDatabase.DEFAULT_MODULE.name(), false);

    public SOSSSHJobOptions() {
        this.init();
    }

    private void init() {
        this.currentClass = ((Object)((Object)this)).getClass();
    }

    public SOSSSHJobOptions(HashMap<String, String> JSSettings) throws Exception {
        super(JSSettings);
        this.init();
        this.setChildClasses(JSSettings, "");
    }

    @Override
    public void setChildClasses(HashMap<String, String> pobjJSSettings, String pstrPrefix) throws Exception {
        super.setChildClasses(pobjJSSettings, pstrPrefix);
    }

    @Override
    public void checkMandatory() {
        this.command.command_delimiter.setValue(this.commandDelimiter.getValue());
        super.checkMandatory();
        if (!this.authMethod.isPassword() && !this.authMethod.isPublicKey()) {
            throw new JSExceptionMandatoryOptionMissing("ErrSSH010 invalid or no AuthenticationMethod specified");
        }
        if (this.authMethod.isPassword() && this.password.IsEmpty()) {
            throw new JSExceptionMandatoryOptionMissing("ErrSSH020 AuthenticationMethod 'password' requires a Password, but no password was specified");
        }
        if (this.authMethod.isPublicKey()) {
            if (this.authFile.isNotEmpty()) {
                this.authFile.checkMandatory(true);
            } else {
                throw new JSExceptionMandatoryOptionMissing("ErrSSH050 AuthenticationMethod 'publickey' requires a keyfile, but no keyfile was specified");
            }
        }
    }

    public boolean commandSpecified() {
        return this.command.isDirty() && this.commandScript.isDirty() && this.commandScriptFile.isDirty();
    }

    public boolean isScript() throws Exception {
        return !this.commandScript.IsEmpty() || !this.commandScriptFile.IsEmpty();
    }
}

