/*
 * Decompiled with CFR 0.152.
 */
package sos.scheduler.job.impl;

import com.google.common.base.Joiner;
import com.sos.JSHelper.Exceptions.JobSchedulerException;
import com.sos.JSHelper.Options.SOSOptionTransferType;
import com.sos.vfs.common.SOSCommandResult;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.net.ssh.SOSSSHJobOptions;
import sos.scheduler.job.impl.SOSSSHJob;

public class SOSSSHCheckRemotePidJob
extends SOSSSHJob {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSSSHCheckRemotePidJob.class);
    private static final String DEFAULT_LINUX_GET_ACTIVE_PROCESSES_COMMAND = "/bin/ps -ef | grep ${pid} | grep ${user} | grep -v grep";
    private static final String DEFAULT_WINDOWS_GET_ACTIVE_PROCESSES_COMMAND = "Qprocess ${pid}";
    private String activeProcessesCommand = "/bin/ps -ef | grep ${pid} | grep ${user} | grep -v grep";
    private String pids = null;

    @Override
    public void execute() throws Exception {
        List<Integer> paramPids = this.getParamPids();
        ArrayList<Integer> pidsStillRunning = new ArrayList<Integer>();
        try {
            this.connect(SOSOptionTransferType.TransferTypes.ssh);
            this.setActiveProcessesCommand();
            for (Integer pid : paramPids) {
                SOSCommandResult result;
                String checkPidCommand = null;
                if (this.activeProcessesCommand.contains("${user}")) {
                    checkPidCommand = this.activeProcessesCommand.replace("${user}", ((SOSSSHJobOptions)((Object)this.objOptions)).user.getValue());
                }
                if (this.activeProcessesCommand.contains("${pid}")) {
                    checkPidCommand = checkPidCommand.replace("${pid}", pid.toString());
                }
                if ((result = this.getHandler().executeResultCommand(checkPidCommand)).getExitCode() == 0) {
                    pidsStillRunning.add(pid);
                    LOGGER.debug("PID " + pid + " is still running");
                    continue;
                }
                LOGGER.debug("PID " + pid + " is not running anymore");
            }
            if (pidsStillRunning.isEmpty()) {
                this.pids = null;
                LOGGER.debug("no still running PIDs found");
            } else {
                this.pids = Joiner.on((String)",").join(pidsStillRunning);
                LOGGER.debug("all still running PIDs to kill: " + this.pids);
            }
        }
        catch (JobSchedulerException ex) {
            if (pidsStillRunning.isEmpty()) {
                LOGGER.debug("Overriding PIDS_TO_KILL param with empty String");
                this.objJSJobUtilities.setJSParam("PIDS_TO_KILL", "");
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.disconnect();
        }
    }

    private void setActiveProcessesCommand() {
        this.activeProcessesCommand = ((SOSSSHJobOptions)((Object)this.objOptions)).sshJobGetActiveProcessesCommand.isDirty() && !((SOSSSHJobOptions)((Object)this.objOptions)).sshJobGetActiveProcessesCommand.getValue().isEmpty() ? ((SOSSSHJobOptions)((Object)this.objOptions)).sshJobGetActiveProcessesCommand.getValue() : (this.isWindowsShell() ? DEFAULT_WINDOWS_GET_ACTIVE_PROCESSES_COMMAND : DEFAULT_LINUX_GET_ACTIVE_PROCESSES_COMMAND);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("[activeProcessesCommand]%s", this.activeProcessesCommand));
        }
    }

    public String getPids() {
        return this.pids;
    }
}

