#!/bin/sh
#
# ------------------------------------------------------------
# Company: Software- und Organisations-Service GmbH
# Author : Oliver Haufe <oliver.haufe@sos-berlin.com>
# ------------------------------------------------------------
#

if [ -z "$LANG" ]
then
  locale_bin=$(which locale 2>/dev/null || echo "")
  if [ -n "${locale_bin}" ]
  then
    LANG="$(locale -a | grep -i "en_us.utf" | head -n 1)"
    export LANG
  fi
fi

if [ -z "$HOSTNAME" ]
then
  HOSTNAME="$(hostname 2>/dev/null)"
  export HOSTNAME
fi

##########################
# hide passw and read -java-options, -log-level 
YADE_ARGS=
LAST_ARG=
YADE_JAVA_OPTIONS="${JAVA_OPTIONS}"
LOG_LEVEL="INFO"
VERBOSE_PARAM=
WITH_SETTINGS=
WITH_RETURNVALUES=
for param in "$@"
do
  if [ -z "${LAST_ARG}" ]
  then
    case "${param}" in
      -java-options=*)    YADE_JAVA_OPTIONS="$(echo "${param}" | sed 's/-java-options=//')"
                          ;;
      -log-level=*)       LOG_LEVEL="$(echo "${param}" | sed 's/-log-level=//')"
                          ;;
      -settings=*)        WITH_SETTINGS=1
                          YADE_ARGS="${YADE_ARGS} ${param}"
                          ;;
      -return-values=*)   WITH_RETURNVALUES=1
                          YADE_ARGS="${YADE_ARGS} ${param}"
                          ;;
      -*password=*)       YADE_ARG="$(echo "${param}" | sed 's/\(password=\).*/\1***/')"
                          YADE_ARGS="${YADE_ARGS} ${YADE_ARG}"
                          ;;
      -*auth_file=*)      YADE_ARG="$(echo "${param}" | sed 's/\(auth_file=\).*/\1***/')"
                          YADE_ARGS="${YADE_ARGS} ${YADE_ARG}"
                          ;;
      -*=*)               YADE_ARGS="${YADE_ARGS} ${param}"
                          ;;
      -*)                 LAST_ARG="${param}"
                          ;;
    esac
  else
    case "${LAST_ARG}" in
      -java-options)      YADE_JAVA_OPTIONS="${param}"
                          ;;
      -log-level)         LOG_LEVEL="${param}"
                          ;;
      -settings)          WITH_SETTINGS=1
                          YADE_ARGS="${YADE_ARGS} ${LAST_ARG} ${param}"
                          ;;
      -return-values)     WITH_RETURNVALUES=1
                          YADE_ARGS="${YADE_ARGS} ${LAST_ARG} ${param}"
                          ;;
      -*password)         YADE_ARGS="${YADE_ARGS} ${LAST_ARG} ***"
                          ;;
      -*auth_file)        YADE_ARGS="${YADE_ARGS} ${LAST_ARG} ***"
                          ;;
      -*)                 YADE_ARGS="${YADE_ARGS} ${LAST_ARG} ${param}"
                          ;;
    esac
    LAST_ARG=
  fi
done

SETTINGS_PARAM=
if [ -z "${WITH_SETTINGS}" ] && [ -n "${JS7_YADE_CONFIG_DIR}" ] 
then
  SETTINGS_PARAM=" -settings \"${JS7_YADE_CONFIG_DIR}/yade.xml\""
  YADE_ARGS="${YADE_ARGS}""${SETTINGS_PARAM}"
fi

RETURNVALUES_PARAM=
if [ -z "${WITH_RETURNVALUES}" ] 
then
  if [ -n "${JS7_RETURN_VALUES}" ]
  then
    RETURNVALUES_PARAM=" -return-values \"${JS7_RETURN_VALUES}\""
    YADE_ARGS="${YADE_ARGS}""${RETURNVALUES_PARAM}"
  fi
  if [ -n "${SCHEDULER_RETURN_VALUES}" ]
  then
    RETURNVALUES_PARAM=" -return-values \"${SCHEDULER_RETURN_VALUES}\""
    YADE_ARGS="${YADE_ARGS}""${RETURNVALUES_PARAM}"
  fi
fi 

echo " "
echo "+ + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + +"
echo "+                     START  : YADE4DMZ.SH                        +"
echo "+                     --------------------                        +"
printf "+ DATE     : %-52s +\n" "$(date)"
printf "+ HOSTNAME : %-52s +\n" "${HOSTNAME}"
printf "+ USER     : %-52s +\n" "${USER}"
printf "+ CALL     : %-52s +\n" "$0${YADE_ARGS}"
echo "+                                                                 +"
echo "+ + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + +"
echo " "


if [ $# -eq 0 ] || [ "$1" = "-?" ] || [ "$1" = "/?" ] || [ "$1" = "-h" ] || [ "$1" = "--help" ]
then
  echo "YADE requires parameters. Please check"
  echo "https://kb.sos-berlin.com/display/PKB/JADE+-+Documentation"
  echo " "
  exit 1
fi

##########################
# set environment variables
YADE_BIN="$(dirname "$0")"
YADE_BIN="$(cd "${YADE_BIN}" >/dev/null && pwd)"
YADE_HOME="$(cd "${YADE_BIN}/.." >/dev/null && pwd)"
test -z "${TEMP}" && TEMP="/tmp"
YADE_LOGS="${TEMP}/${USER}"
test -z "${JS7_AGENT_LOGS}" || YADE_LOGS="${JS7_AGENT_LOGS}"
YADE_TZ="Etc/UTC"
test -z "${JS7_AGENT_TZ}" || YADE_TZ="${JS7_AGENT_TZ}"
LOG_LEVEL="$(echo "${LOG_LEVEL}" | tr '[:lower:]' '[:upper:]')"
YADE_LOG_LEVEL="INFO"
if [ "DEBUG" = "${LOG_LEVEL}" ]
then 
  YADE_LOG_LEVEL="${LOG_LEVEL}"
  VERBOSE_PARAM="-verbose 3"
fi
if [ "TRACE" = "${LOG_LEVEL}" ]
then 
  YADE_LOG_LEVEL="${LOG_LEVEL}"
  VERBOSE_PARAM="-verbose 9"
fi

export YADE_HOME
export YADE_BIN
export YADE_LOGS
export YADE_TZ
export YADE_LOG_LEVEL
export TEMP

##########################
# set java class path
if [ ! -d "${YADE_HOME}"/lib ]
then
  echo "Directory ${YADE_HOME}/lib with Java libraries not found."
  exit 1
fi
CP="${YADE_HOME}/lib/patches/*:${YADE_HOME}/lib/user_lib/*:${YADE_HOME}/lib/3rd-party/*:${YADE_HOME}/lib/sos/*"

test -z "${LOG4JPROP}" && test -f "${YADE_HOME}"/lib/log4j2.xml && LOG4JPROP="-Dlog4j.configurationFile=file://${YADE_HOME}/lib/log4j2.xml"

##########################
# set and check java
JAVABIN="$(which java 2>/dev/null)"
test -n "${JAVA_HOME}" && test -x "${JAVA_HOME}"/bin/java && JAVABIN="${JAVA_HOME}"/bin/java
if [ -z "${JAVABIN}" ]
then
  echo "...Java environment could not be determined"
  echo "...please set JAVA_HOME environment variable"
  exit 5
fi

echo "${YADE_JAVA_OPTIONS}" | grep "\-Xmx" >/dev/null 2>/dev/null
test $? -eq 0 || YADE_JAVA_OPTIONS="${YADE_JAVA_OPTIONS} -Xmx32m"

"${JAVABIN}" ${LOG4JPROP} ${YADE_JAVA_OPTIONS} -classpath "${CP}" com.sos.DataExchange.SOSDataExchangeEngine4DMZMain "$@" ${VERBOSE_PARAM}${SETTINGS_PARAM}${RETURNVALUES_PARAM} -current_pid=$$ -ppid=$PPID
YADE_EXIT=$?

echo " "
echo "+ + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + +"
echo "+                       END  : YADE4DMZ.SH                        +"
echo "+                       ------------------                        +"
printf "+ DATE     : %-52s +\n" "$(date)"
printf "+ HOSTNAME : %-52s +\n" "${HOSTNAME}"
printf "+ USER     : %-52s +\n" "${USER}"
printf "+ CALL     : %-52s +\n" "$0${YADE_ARGS}"
printf "+ EXIT     : %-52s +\n" "${YADE_EXIT}"
echo "+                                                                 +"
echo "+ + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + +"
echo " "


exit ${YADE_EXIT}
