/*
 * Decompiled with CFR 0.152.
 */
package sos.net;

import com.sos.JSHelper.Exceptions.JSNotImplementedException;
import com.sos.JSHelper.interfaces.ISOSSmtpMailOptions;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.AuthenticationFailedException;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.net.SOSMailAttachment;
import sos.net.SOSMailAuthenticator;
import sos.net.SOSMimeBase64;
import sos.settings.SOSSettings;
import sos.util.SOSClassUtil;
import sos.util.SOSDate;

public class SOSMail {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSMail.class);
    protected String host = "";
    protected String port = "25";
    protected String user = "";
    protected String password = "";
    protected int timeout = 30000;
    protected String subject = "";
    protected String from = "";
    protected String fromName = "";
    protected String replyTo = "";
    protected String queueDir = "";
    protected String body = "";
    protected String alternativeBody = "";
    protected String language = "de";
    protected String dateFormat = "dd.MM.yyyy";
    protected String datetimeFormat = "dd.MM.yyyy HH:mm";
    protected HashMap<String, String> dateFormats = new HashMap();
    protected HashMap<String, String> datetimeFormats = new HashMap();
    protected String attachmentCharset = "iso-8859-1";
    protected String charset = "iso-8859-1";
    protected String alternativeCharset = "iso-8859-1";
    protected String contentType = "text/plain";
    protected String alternativeContentType = "text/html";
    protected String encoding = "7bit";
    protected String alternativeEncoding = "7bit";
    protected String attachmentEncoding = "Base64";
    protected String attachmentContentType = "application/octet-stream";
    protected LinkedList<String> toList = new LinkedList();
    protected LinkedList<String> ccList = new LinkedList();
    protected LinkedList<String> bccList = new LinkedList();
    protected TreeMap<String, SOSMailAttachment> attachmentList = new TreeMap();
    protected Properties templates = new Properties();
    protected SOSSettings sosSettings = null;
    protected String tableSettings = "SETTINGS";
    protected String applicationMail = "email";
    protected String sectionMail = "mail_server";
    protected String applicationMailTemplates = "email_templates";
    protected String sectionMailTemplates = "mail_templates";
    protected String applicationMailScripts = "email";
    protected String sectionMailScripts = "mail_start_scripts_factory";
    protected String applicationMailTemplatesFactory = "email_templates_factory";
    protected String sectionMailTemplatesFactory = "mail_templates";
    private boolean sendToOutputStream = false;
    private byte[] messageBytes;
    private MimeMessage message = null;
    private SOSMailAuthenticator authenticator = null;
    private final ArrayList<FileInputStream> file_input_streams = new ArrayList();
    private ByteArrayOutputStream raw_email_byte_stream = null;
    private String lastError = "";
    private boolean changed = false;
    private final String queuePattern = "yyyy-MM-dd.HHmmss.S";
    private String queuePraefix = "sos.";
    private String queueFailedPraefix = "failed.";
    private String lastGeneratedFileName = "";
    private String loadedMessageId = "";
    private boolean messageReady = false;
    private boolean queueMailOnError = true;
    private int priority = -1;
    private String securityProtocol = "";
    private Session session = null;
    public static String tableMails = "MAILS";
    public static String tableMailAttachments = "MAIL_ATTACHMENTS";
    public static String mailsSequence = "MAILS_ID_SEQ";
    public static final int PRIORITY_HIGHEST = 1;
    public static final int PRIORITY_HIGH = 2;
    public static final int PRIORITY_NORMAL = 3;
    public static final int PRIORITY_LOW = 4;
    public static final int PRIORITY_LOWEST = 5;

    public SOSMail(String host) throws Exception {
        if (host != null) {
            this.host = host;
        }
        this.init();
    }

    public SOSMail(String host, String user, String password) throws Exception {
        if (host != null) {
            this.host = host;
        }
        if (user != null) {
            this.user = user;
        }
        if (password != null) {
            this.password = password;
        }
        this.init();
    }

    public SOSMail(String host, String port, String user, String password) throws Exception {
        if (host != null) {
            this.host = host;
        }
        if (port != null) {
            this.port = port;
        }
        if (user != null) {
            this.user = user;
        }
        if (password != null) {
            this.password = password;
        }
        this.init();
    }

    public SOSMail(SOSSettings sosSettings) throws Exception {
        this.getSettings(sosSettings);
        this.init();
    }

    public SOSMail(SOSSettings sosSettings, String language) throws Exception {
        this.getSettings(sosSettings, language);
        this.init();
    }

    private void initPriority() throws MessagingException {
        switch (this.priority) {
            case 1: {
                this.setPriorityHighest();
                break;
            }
            case 2: {
                this.setPriorityHigh();
                break;
            }
            case 4: {
                this.setPriorityLow();
                break;
            }
            case 5: {
                this.setPriorityLowest();
                break;
            }
        }
    }

    public void init() throws Exception {
        this.dateFormats.put("de", "dd.MM.yyyy");
        this.dateFormats.put("en", "MM/dd/yyyy");
        this.datetimeFormats.put("de", "dd.MM.yyyy HH:mm");
        this.datetimeFormats.put("en", "MM/dd/yyyy HH:mm");
        this.initLanguage();
        this.initMessage();
        this.clearRecipients();
        this.clearAttachments();
    }

    public void setProperties(Properties smtpProperties) {
        System.getProperties().putAll((Map<?, ?>)smtpProperties);
    }

    public void initMessage() throws Exception {
        this.createMessage(this.createSession());
        this.initPriority();
    }

    public Session createSession() throws Exception {
        Properties props = System.getProperties();
        props.put("mail.host", this.host);
        props.put("mail.smtp.port", this.port);
        props.put("mail.smtp.timeout", String.valueOf(this.timeout));
        props.put("mail.transport.protocol", "smtp");
        props.put("mail.smtp.class", "com.sun.mail.SMTPTransport");
        if (!this.user.isEmpty()) {
            props.put("mail.smtp.auth", "true");
        } else {
            props.put("mail.smtp.auth", "false");
        }
        if ("ssl".equalsIgnoreCase(this.securityProtocol)) {
            props.put("mail.smtp.ssl.enable", "true");
            props.put("mail.transport.protocol", "smtps");
        } else if ("starttls".equalsIgnoreCase(this.securityProtocol)) {
            props.put("mail.smtp.starttls.enable", "true");
            props.put("mail.transport.protocol", "smtps");
        }
        this.authenticator = new SOSMailAuthenticator(this.user, this.password);
        this.session = Session.getInstance((Properties)props, (Authenticator)this.authenticator);
        return this.session;
    }

    public String getSecurityProtocol() {
        return this.securityProtocol;
    }

    public void setSecurityProtocol(String securityProtocol) throws Exception {
        this.securityProtocol = securityProtocol;
        this.initMessage();
    }

    public void createMessage(Session session) throws Exception {
        this.message = new MimeMessage(session);
    }

    public void initLanguage() throws Exception {
        if (this.dateFormats.containsKey(this.getLanguage()) && this.datetimeFormats.containsKey(this.getLanguage())) {
            this.setDateFormat(this.dateFormats.get(this.getLanguage()).toString());
            this.setDatetimeFormat(this.datetimeFormats.get(this.getLanguage()).toString());
        } else {
            this.setDateFormat(this.dateFormats.get("de").toString());
            this.setDatetimeFormat(this.datetimeFormats.get("de").toString());
        }
    }

    private void getSettings(SOSSettings sosSettings, String language) throws Exception {
        if (language != null) {
            this.setLanguage(language);
        }
        this.getSettings(sosSettings);
    }

    private String getEntry(String val, Properties entries, String key) {
        String erg = val;
        if (entries.containsKey(key) && !entries.getProperty(key).isEmpty()) {
            erg = entries.getProperty(key);
        }
        return erg;
    }

    private void getSettings(SOSSettings sosSettings) throws Exception {
        if (sosSettings == null) {
            throw new Exception(SOSClassUtil.getMethodName() + ": missing settings object.");
        }
        this.sosSettings = sosSettings;
        Properties entries = this.sosSettings.getSection(this.applicationMail, this.sectionMail);
        if (entries.isEmpty()) {
            throw new Exception(SOSClassUtil.getMethodName() + ": missing settings entries in section \"" + this.sectionMail + "\".");
        }
        this.host = this.getEntry(this.host, entries, "host");
        this.port = this.getEntry(this.port, entries, "port");
        this.user = this.getEntry(this.user, entries, "smtp_user");
        this.password = this.getEntry(this.password, entries, "smtp_pass");
        this.from = this.getEntry(this.from, entries, "from");
        this.from = this.getEntry(this.from, entries, "mail_from");
        this.fromName = this.getEntry(this.fromName, entries, "from_name");
        this.fromName = this.getEntry(this.fromName, entries, "mail_from_name");
        this.replyTo = this.getEntry(this.replyTo, entries, "reply_to");
        this.replyTo = this.getEntry(this.replyTo, entries, "mail_reply_to");
        this.queueDir = this.getEntry(this.queueDir, entries, "queue_directory");
        this.queueDir = this.getEntry(this.queueDir, entries, "mail_queue_directory");
        String priorityStr = new String("1");
        this.priority = Integer.parseInt(this.getEntry(priorityStr, entries, "priority"));
        this.language = this.getEntry(this.language, entries, "language");
        this.subject = this.getEntry(this.subject, entries, "subject");
        this.contentType = this.getEntry(this.contentType, entries, "content_type");
        this.charset = this.getEntry(this.charset, entries, "charset");
        this.encoding = this.getEntry(this.encoding, entries, "encoding");
        this.attachmentEncoding = this.getEntry(this.attachmentEncoding, entries, "attachment_encoding");
        this.attachmentEncoding = this.getEntry(this.attachmentEncoding, entries, "file_encoding");
        if (entries.getProperty("smtp_timeout") != null && !entries.getProperty("smtp_timeout").isEmpty()) {
            this.timeout = 1000 * Integer.parseInt(entries.getProperty("smtp_timeout"));
        }
        if (this.from == null && entries.containsKey("mail_from") && !entries.getProperty("mail_from").isEmpty()) {
            this.from = entries.getProperty("mail_from");
        }
    }

    public boolean getTemplates(SOSSettings sosSettings, String language) throws Exception {
        if (language != null) {
            this.setLanguage(language);
        }
        return this.getTemplates(sosSettings);
    }

    public boolean getTemplates(SOSSettings sosSettings) throws Exception {
        if (sosSettings == null) {
            throw new Exception(SOSClassUtil.getMethodName() + ": missing settings object.");
        }
        this.sosSettings = sosSettings;
        this.templates = this.sosSettings.getSection(this.getApplicationMailTemplates(), this.getSectionMailTemplates() + "_" + this.language);
        if (this.templates.isEmpty()) {
            throw new Exception(SOSClassUtil.getMethodName() + ": missing settings entries for application \"" + this.applicationMailTemplates + "\" in section \"" + this.sectionMailTemplates + "\".");
        }
        return true;
    }

    public String substituteSubject(String template, Map<String, String> replacements) throws Exception {
        if (!this.templates.containsKey(template + "_subject")) {
            throw new Exception("substituteSubject(): template does not exist: " + template + "_subject");
        }
        return this.substitute(this.templates.get(template + "_subject").toString(), replacements, false);
    }

    public String substituteBody(String template, Map<String, String> replacements, boolean nl2br) throws Exception {
        if (!this.templates.containsKey(template + "_body")) {
            throw new Exception("substituteBody(): template does not exist: " + template + "_body");
        }
        return this.substitute(this.templates.get(template + "_body").toString(), replacements, nl2br);
    }

    public String substituteBody(String template, Map<String, String> replacements) throws Exception {
        if (!this.templates.containsKey(template + "_body")) {
            throw new Exception("substituteBody(): template does not exist: " + template + "_body");
        }
        return this.substitute(this.templates.get(template + "_body").toString(), replacements, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    private String substitute(String content, Map<String, String> replacements, boolean nl2br) throws Exception {
        String key2 = null;
        String value = null;
        if ("de".equalsIgnoreCase(this.getLanguage())) {
            this.setDateFormat("dd.MM.yyyy");
            this.setDatetimeFormat("dd.MM.yyyy HH:mm");
        } else if ("en".equalsIgnoreCase(this.getLanguage())) {
            this.setDateFormat("MM/dd/yyyy");
            this.setDatetimeFormat("MM/dd/yyyy HH:mm");
        }
        content = content.replaceAll("&\\(date\\)", SOSDate.getCurrentDateAsString((String)this.getDateFormat()));
        content = content.replaceAll("&\\(datetime\\)", SOSDate.getCurrentTimeAsString((String)this.getDatetimeFormat()));
        content = content.replaceAll("&\\#\\(date\\)", SOSDate.getCurrentDateAsString((String)this.getDateFormat()));
        content = content.replaceAll("&\\#\\#\\(datetime\\)", SOSDate.getCurrentTimeAsString((String)this.getDatetimeFormat()));
        if (nl2br) {
            content = content.replaceAll("\n", "<br/>");
        }
        if (replacements != null) {
            for (String key2 : replacements.keySet()) {
                if (key2 == null || (value = replacements.get(key2)) == null) continue;
                try {
                    content = content.replaceAll("&\\#\\(" + key2 + "\\)", SOSDate.getDateAsString((Date)SOSDate.getDate((String)value.toString()), (String)this.getDateFormat()));
                    content = content.replaceAll("&\\#\\#\\(" + key2 + "\\)", SOSDate.getDateTimeAsString((Date)SOSDate.getDate((String)value.toString()), (String)this.getDatetimeFormat()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Locale defaultLocale = Locale.getDefault();
                try {
                    double doubleValue = Double.parseDouble(value);
                    if ("de".equalsIgnoreCase(this.getLanguage())) {
                        Locale.setDefault(Locale.GERMAN);
                    } else if ("en".equalsIgnoreCase(this.getLanguage())) {
                        Locale.setDefault(Locale.US);
                    }
                    DecimalFormat formatter = new DecimalFormat("#,###.00");
                    content = content.replaceAll("&\\$\\(" + key2 + "\\)", formatter.format(doubleValue).toString());
                }
                catch (Exception exception) {
                }
                finally {
                    Locale.setDefault(defaultLocale);
                }
                content = content.replaceAll("&\\(" + key2.toString() + "\\)", value.toString());
            }
        }
        content = content.replaceAll("&\\#\\(.*\\)", "");
        content = content.replaceAll("&\\#\\#\\(.*\\)", "");
        content = content.replaceAll("&\\$\\(.*\\)", "");
        return content.replaceAll("&\\(.*\\)", "");
    }

    public void addRecipient(String recipient) throws Exception {
        String token = "";
        this.warn("addRecipient", recipient);
        if (recipient == null) {
            throw new Exception(SOSClassUtil.getMethodName() + ": recipient has no value.");
        }
        recipient = recipient.replace(',', ';');
        StringTokenizer t = new StringTokenizer(recipient, ";");
        while (t.hasMoreTokens()) {
            token = t.nextToken();
            if (!this.toList.contains(token)) {
                this.toList.add(token);
            }
            LOGGER.debug(SOSClassUtil.getMethodName() + "-->" + token);
        }
        this.changed = true;
    }

    public void addCC(String recipient) throws Exception {
        String token = "";
        this.warn("addCC", recipient);
        if (recipient == null) {
            throw new Exception(SOSClassUtil.getMethodName() + ": CC recipient has no value.");
        }
        recipient = recipient.replace(',', ';');
        StringTokenizer t = new StringTokenizer(recipient, ";");
        while (t.hasMoreTokens()) {
            token = t.nextToken();
            if (!this.toList.contains(token) && !this.ccList.contains(token)) {
                this.ccList.add(token);
                LOGGER.debug(SOSClassUtil.getMethodName() + "-->" + token);
                continue;
            }
            LOGGER.debug(SOSClassUtil.getMethodName() + "--> Ignored:" + token);
        }
        this.changed = true;
    }

    public void addBCC(String recipient) throws Exception {
        String token = "";
        this.warn("addBCC", recipient);
        if (recipient == null) {
            throw new Exception(SOSClassUtil.getMethodName() + ": BCC recipient has no value.");
        }
        recipient = recipient.replace(',', ';');
        StringTokenizer t = new StringTokenizer(recipient, ";");
        while (t.hasMoreTokens()) {
            token = t.nextToken();
            if (!(this.ccList.contains(token) || this.toList.contains(token) || this.bccList.contains(token))) {
                this.bccList.add(token);
                LOGGER.debug(SOSClassUtil.getMethodName() + "-->" + token);
                continue;
            }
            LOGGER.debug(SOSClassUtil.getMethodName() + "--> Ignored:" + token);
        }
        this.changed = true;
    }

    private void closeAttachments() throws Exception {
        Exception exception = null;
        for (int i = 0; i < this.file_input_streams.size(); ++i) {
            try {
                this.file_input_streams.get(i).close();
                continue;
            }
            catch (Exception x) {
                if (exception != null) continue;
                exception = x;
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    public void addAttachment(SOSMailAttachment att) throws Exception {
        this.warn("addAttachment", att.getFile().getAbsolutePath());
        this.attachmentList.put(att.getFile().getAbsolutePath(), att);
        this.changed = true;
    }

    public void setQueueMailOnError(boolean queueMailOnError) {
        this.queueMailOnError = queueMailOnError;
    }

    public void addAttachment(String filename) throws Exception {
        this.warn("addAttachment", filename);
        File f = new File(filename);
        SOSMailAttachment att = new SOSMailAttachment(this, f);
        att.setCharset(this.getAttachmentCharset());
        att.setEncoding(this.getAttachmentEncoding());
        att.setContentType(this.getAttachmentContentType());
        this.attachmentList.put(filename, att);
        this.changed = true;
    }

    public void addAttachment(String filename, String params) throws Exception {
        String name = "";
        String value = "";
        String token = "";
        int counter = 0;
        this.warn("addAttachment", filename + "(" + params + ")");
        StringTokenizer t = new StringTokenizer(params, ",");
        File f = new File(filename);
        SOSMailAttachment att = new SOSMailAttachment(this, f);
        while (t.hasMoreTokens()) {
            token = t.nextToken();
            StringTokenizer vv = new StringTokenizer(token, "=");
            if (vv.countTokens() == 1) {
                name = "content-type";
                value = vv.nextToken();
                ++counter;
            } else {
                name = vv.nextToken().trim();
                try {
                    value = vv.nextToken().trim();
                }
                catch (NoSuchElementException e) {
                    value = "";
                }
            }
            if ("content-type".equalsIgnoreCase(name)) {
                att.setContentType(value);
            } else if ("charset".equalsIgnoreCase(name)) {
                att.setCharset(value);
            } else if ("encoding".equalsIgnoreCase(name)) {
                att.setEncoding(value);
            } else {
                throw new Exception("USING of .addAttachment is wrong. ==> " + params + ", rigth using is: [content-type-value],[content-type=<value>],[charset=<value>],[encoding=<value>]");
            }
            if (counter <= 1) continue;
            throw new Exception("USING of .addAttachment is wrong. ==> " + params + ", rigth using is: [content-type-value],[content-type=<value>],[charset=<value>],[encoding=<value>]");
        }
        this.attachmentList.put(filename, att);
        this.changed = true;
    }

    private void addFile(SOSMailAttachment att) throws Exception {
        Object m;
        if (!att.getFile().exists()) {
            throw new Exception("Datei " + att.getFile().getAbsolutePath() + " fehlt");
        }
        MimeBodyPart attachment = new MimeBodyPart();
        FileDataSource data_source = new FileDataSource(att.getFile(), att.getContentType());
        DataHandler data_handler = new DataHandler((DataSource)data_source);
        attachment.setDataHandler(data_handler);
        attachment.setFileName(att.getFile().getName());
        if (att.getContentType().startsWith("text/")) {
            int c;
            String s = "";
            FileReader fr = new FileReader(att.getFile());
            while ((c = fr.read()) != -1) {
                s = s + (char)c;
            }
            attachment.setContent((Object)s, att.getContentType() + ";charset= " + att.getCharset());
            fr.close();
        }
        if (!((m = this.message.getContent()) instanceof MimeMultipart)) {
            throw new RuntimeException(this.getClass().getName() + "mime_message.getContent() liefert nicht MimeMultiPart");
        }
        ((MimeMultipart)m).addBodyPart((BodyPart)attachment);
        attachment.setHeader("Content-Transfer-Encoding", att.getEncoding());
    }

    public void loadFile(File messageFile) throws Exception {
        try (FileInputStream messageInputStream = null;){
            messageInputStream = new FileInputStream(messageFile);
            this.message = new MimeMessage(this.createSession(), (InputStream)messageInputStream);
            this.loadedMessageId = this.message.getMessageID();
            this.raw_email_byte_stream = new ByteArrayOutputStream();
            this.message.writeTo((OutputStream)this.raw_email_byte_stream);
            this.messageBytes = this.raw_email_byte_stream.toByteArray();
            this.messageReady = true;
        }
    }

    public void unloadMessage() {
        this.messageReady = false;
        this.loadedMessageId = "";
        this.message = null;
    }

    public boolean send() throws Exception {
        return this.sendJavaMail();
    }

    public boolean send(boolean send) throws Exception {
        if (send) {
            return this.send();
        }
        return this.prepareJavaMail();
    }

    private boolean sendJavaMail() throws Exception {
        block20: {
            try {
                String sBCC;
                this.prepareJavaMail();
                String sTO = this.getRecipientsAsString();
                String logMessage = SOSClassUtil.getMethodName() + "-->sending email:   host:port=" + this.host + ":" + this.port + "   to=" + sTO;
                String sCC = this.getCCsAsString();
                if (!"".equals(sCC)) {
                    logMessage = logMessage + "   sCC=" + sCC;
                }
                if (!"".equals(sBCC = this.getBCCsAsString())) {
                    logMessage = logMessage + "   sBCC=" + sBCC;
                }
                LOGGER.info(logMessage);
                LOGGER.debug(SOSClassUtil.getMethodName() + "-->Subject=" + this.subject);
                LOGGER.debug(SOSClassUtil.getMethodName() + "-->" + this.dumpHeaders());
                LOGGER.debug(SOSClassUtil.getMethodName() + "-->" + this.dumpMessageAsString(false));
                if (!this.sendToOutputStream) {
                    Transport t = "ssl".equalsIgnoreCase(this.securityProtocol) || "starttls".equalsIgnoreCase(this.securityProtocol) ? this.session.getTransport("smtps") : this.session.getTransport("smtp");
                    this.message.setSentDate(new Date());
                    System.setProperty("mail.smtp.port", this.port);
                    System.setProperty("mail.smtp.host", this.host);
                    if (this.user.isEmpty()) {
                        t.connect();
                    } else {
                        t.connect(this.host, this.user, this.password);
                    }
                    t.sendMessage((Message)this.message, this.message.getAllRecipients());
                    t.close();
                    this.raw_email_byte_stream = new ByteArrayOutputStream();
                    this.message.writeTo((OutputStream)this.raw_email_byte_stream);
                    this.messageBytes = this.raw_email_byte_stream.toByteArray();
                    this.changed = true;
                }
                return true;
            }
            catch (AuthenticationFailedException ee) {
                this.lastError = "AuthenticationFailedException while connecting to " + this.host + ":" + this.port + " " + this.user + "/******** -->" + ee.getMessage();
                if (this.queueMailOnError) {
                    try {
                        this.dumpFailedMessageToFile(true);
                    }
                    catch (Exception e) {
                        LOGGER.warn(SOSClassUtil.getMethodName() + ":" + e.getMessage());
                    }
                    return false;
                }
                throw new Exception(SOSClassUtil.getMethodName() + ":" + this.lastError + ": error occurred on send: " + ee.toString());
            }
            catch (MessagingException e) {
                if (this.queueMailOnError) {
                    if (!this.queueDir.isEmpty() && e.getMessage().startsWith("Could not connect to SMTP host") || e.getMessage().startsWith("Unknown SMTP host") || e.getMessage().startsWith("Read timed out") || e.getMessage().startsWith("Exception reading response")) {
                        this.lastError = e.getMessage() + " ==> " + this.host + ":" + this.port + " " + this.user + "/********";
                        try {
                            this.dumpFailedMessageToFile(true);
                        }
                        catch (Exception ee) {
                            LOGGER.warn(SOSClassUtil.getMethodName() + ":" + e.getMessage());
                        }
                        return false;
                    }
                    throw new Exception(SOSClassUtil.getMethodName() + ": error occurred on send: " + e.toString());
                }
                throw new Exception(SOSClassUtil.getMethodName() + ": error occurred on send: " + e.toString());
            }
            catch (SocketTimeoutException e) {
                if (!this.queueMailOnError) break block20;
                if (!this.queueDir.isEmpty()) {
                    this.lastError = e.getMessage() + " ==> " + this.host + ":" + this.port + " " + this.user + "/********";
                    try {
                        this.dumpFailedMessageToFile(true);
                    }
                    catch (Exception ee) {
                        LOGGER.warn(SOSClassUtil.getMethodName() + ":" + e.getMessage());
                    }
                    return false;
                }
                throw new Exception(SOSClassUtil.getMethodName() + ": error occurred on send: " + e.toString());
            }
            catch (Exception e) {
                throw new Exception(SOSClassUtil.getMethodName() + ": error occurred on send: " + e.toString());
            }
        }
        return true;
    }

    private boolean haveAlternative() {
        return !"".equals(this.alternativeBody) && this.attachmentList.isEmpty();
    }

    protected boolean prepareJavaMail() throws Exception {
        try {
            ListIterator e;
            int i;
            InternetAddress[] toAddrs;
            if (this.messageReady) {
                this.message.saveChanges();
                return true;
            }
            if (!this.changed) {
                return true;
            }
            this.changed = false;
            this.body = "text/html".equals(this.getContentType()) ? this.body.replaceAll("\\\\n", "<br>") : this.body.replaceAll("\\\\n", "\n");
            String t = "";
            if (this.toList.isEmpty()) {
                throw new Exception(SOSClassUtil.getMethodName() + ": no recipient specified.");
            }
            if (this.from == null || this.from.isEmpty()) {
                throw new Exception(SOSClassUtil.getMethodName() + ": no sender specified.");
            }
            if (this.fromName != null && !this.fromName.isEmpty()) {
                this.message.setFrom((Address)new InternetAddress(this.from, this.fromName));
            } else {
                this.message.setFrom((Address)new InternetAddress(this.from));
            }
            this.message.setSentDate(new Date());
            if (this.replyTo != null && !this.replyTo.isEmpty()) {
                InternetAddress[] fromAddrs = new InternetAddress[]{new InternetAddress(this.replyTo)};
                this.message.setReplyTo((Address[])fromAddrs);
            }
            if (!this.toList.isEmpty()) {
                toAddrs = new InternetAddress[this.toList.size()];
                i = 0;
                e = this.toList.listIterator();
                while (e.hasNext()) {
                    t = (String)e.next();
                    toAddrs[i++] = new InternetAddress(t);
                }
                this.message.setRecipients(MimeMessage.RecipientType.TO, (Address[])toAddrs);
            }
            toAddrs = new InternetAddress[this.ccList.size()];
            i = 0;
            e = this.ccList.listIterator();
            while (e.hasNext()) {
                t = (String)e.next();
                toAddrs[i++] = new InternetAddress(t);
            }
            this.message.setRecipients(MimeMessage.RecipientType.CC, (Address[])toAddrs);
            toAddrs = new InternetAddress[this.bccList.size()];
            i = 0;
            e = this.bccList.listIterator();
            while (e.hasNext()) {
                t = (String)e.next();
                toAddrs[i++] = new InternetAddress(t);
            }
            this.message.setRecipients(MimeMessage.RecipientType.BCC, (Address[])toAddrs);
            if (this.subject != null) {
                this.message.setSubject(this.subject);
            }
            if (!this.attachmentList.isEmpty() || !"".equals(this.alternativeBody)) {
                MimeBodyPart bodypart = null;
                MimeBodyPart alternativeBodypart = null;
                MimeMultipart multipart = null;
                multipart = this.haveAlternative() ? new MimeMultipart("alternative") : new MimeMultipart();
                bodypart = new MimeBodyPart();
                if (this.contentType.startsWith("text/")) {
                    bodypart.setContent((Object)this.body, this.contentType + ";charset= " + this.charset);
                } else {
                    bodypart.setContent((Object)this.body, this.contentType);
                }
                multipart.addBodyPart((BodyPart)bodypart);
                if (this.haveAlternative()) {
                    alternativeBodypart = new MimeBodyPart();
                    if (this.contentType.startsWith("text/")) {
                        alternativeBodypart.setContent((Object)this.alternativeBody, this.alternativeContentType + ";charset= " + this.alternativeCharset);
                    } else {
                        alternativeBodypart.setContent((Object)this.alternativeBody, this.alternativeContentType);
                    }
                    multipart.addBodyPart((BodyPart)alternativeBodypart);
                }
                this.message.setContent((Multipart)multipart);
                bodypart.setHeader("Content-Transfer-Encoding", this.encoding);
                if (alternativeBodypart != null) {
                    alternativeBodypart.setHeader("Content-Transfer-Encoding", this.alternativeEncoding);
                }
                for (SOSMailAttachment attachment : this.attachmentList.values()) {
                    if (attachment.getContentType() == null) {
                        throw new Exception("content_type ist null");
                    }
                    LOGGER.debug(SOSClassUtil.getMethodName() + "-->Attachment=" + attachment.getFile());
                    this.addFile(attachment);
                }
            } else {
                this.message.setHeader("Content-Transfer-Encoding", this.encoding);
                if (this.contentType.startsWith("text/")) {
                    this.message.setContent((Object)this.body, this.contentType + "; charset=" + this.charset);
                } else {
                    this.message.setContent((Object)this.body, this.contentType);
                }
            }
            this.message.saveChanges();
            this.closeAttachments();
            return true;
        }
        catch (Exception e) {
            throw new Exception(SOSClassUtil.getMethodName() + ": error occurred on send: " + e.getMessage(), e);
        }
    }

    public String dumpHeaders() throws IOException, MessagingException {
        String s = "";
        Enumeration e = this.message.getAllHeaders();
        while (e.hasMoreElements()) {
            Header header = (Header)e.nextElement();
            s = s + "\n" + header.getName() + ": " + header.getValue();
        }
        return s;
    }

    private ByteArrayOutputStream messageRemoveAttachments() throws Exception {
        ByteArrayOutputStream raw_email_byte_stream_without_attachment = new ByteArrayOutputStream();
        MimeMessage mm = new MimeMessage(this.message);
        Object mmpo = mm.getContent();
        if (mmpo instanceof MimeMultipart) {
            MimeMultipart mmp = (MimeMultipart)mmpo;
            if (mm.isMimeType("multipart/*")) {
                mmp = (MimeMultipart)mm.getContent();
                for (int i = 1; i < mmp.getCount(); ++i) {
                    mmp.removeBodyPart(i);
                    --i;
                }
            }
            mm.setContent((Multipart)mmp);
            mm.saveChanges();
        }
        mm.writeTo((OutputStream)raw_email_byte_stream_without_attachment);
        return raw_email_byte_stream_without_attachment;
    }

    public String dumpMessageAsString() throws Exception {
        return this.dumpMessageAsString(false);
    }

    private void dumpFailedMessageToFile(boolean withAttachment) throws Exception {
        Date d = new Date();
        StringBuffer bb = new StringBuffer();
        SimpleDateFormat s = new SimpleDateFormat("yyyy-MM-dd.HHmmss.S");
        FieldPosition fp = new FieldPosition(0);
        StringBuffer b = s.format(d, bb, fp);
        this.lastGeneratedFileName = this.queueDir + "/" + this.queueFailedPraefix + "sos." + b + ".email";
        File f = new File(this.lastGeneratedFileName);
        while (f.exists()) {
            b = s.format(d, bb, fp);
            this.lastGeneratedFileName = this.queueDir + "/" + this.queueFailedPraefix + "sos." + b + ".email";
            f = new File(this.lastGeneratedFileName);
        }
        this.dumpMessageToFile(f, withAttachment);
    }

    public void dumpMessageToFile(String filename, boolean withAttachment) throws Exception {
        this.dumpMessageToFile(new File(filename), withAttachment);
    }

    public void dumpMessageToFile(File file, boolean withAttachment) throws Exception {
        try {
            this.prepareJavaMail();
            File myFile = new File(file.getAbsolutePath() + "~");
            FileOutputStream out = new FileOutputStream(myFile, true);
            out.write(this.dumpMessage(withAttachment));
            out.close();
            String newFilename = myFile.getAbsolutePath().substring(0, myFile.getAbsolutePath().length() - 1);
            File f = new File(newFilename);
            f.delete();
            myFile.renameTo(f);
        }
        catch (Exception e) {
            throw new Exception(SOSClassUtil.getMethodName() + ": error occurred on dump: " + e.toString());
        }
    }

    public String dumpMessageAsString(boolean withAttachment) throws Exception {
        ByteArrayOutputStream raw_email_byte_stream_without_attachment = null;
        this.prepareJavaMail();
        if (!withAttachment) {
            raw_email_byte_stream_without_attachment = this.messageRemoveAttachments();
        }
        this.raw_email_byte_stream = new ByteArrayOutputStream();
        this.message.writeTo((OutputStream)this.raw_email_byte_stream);
        byte[] bytes = withAttachment || raw_email_byte_stream_without_attachment == null ? this.raw_email_byte_stream.toByteArray() : raw_email_byte_stream_without_attachment.toByteArray();
        return new String(bytes);
    }

    public byte[] dumpMessage() throws Exception {
        return this.dumpMessage(true);
    }

    public byte[] dumpMessage(boolean withAttachment) throws Exception {
        ByteArrayOutputStream raw_email_byte_stream_without_attachment = null;
        this.prepareJavaMail();
        if (!withAttachment) {
            raw_email_byte_stream_without_attachment = this.messageRemoveAttachments();
        }
        this.raw_email_byte_stream = new ByteArrayOutputStream();
        this.message.writeTo((OutputStream)this.raw_email_byte_stream);
        byte[] bytes = withAttachment || raw_email_byte_stream_without_attachment == null ? this.raw_email_byte_stream.toByteArray() : raw_email_byte_stream_without_attachment.toByteArray();
        return bytes;
    }

    public LinkedList<String> getRecipients() {
        return this.toList;
    }

    public String getRecipientsAsString() throws MessagingException {
        String s;
        block3: {
            block2: {
                s = " ";
                if (!this.messageReady) break block2;
                Address[] addresses = this.message.getRecipients(MimeMessage.RecipientType.TO);
                if (addresses == null) break block3;
                for (Address aktAddress : addresses) {
                    s = s + aktAddress.toString() + ",";
                }
                break block3;
            }
            ListIterator i = this.toList.listIterator();
            while (i.hasNext()) {
                s = s + (String)i.next() + ",";
            }
        }
        return s.substring(0, s.length() - 1).trim();
    }

    public LinkedList<String> getCCs() {
        return this.ccList;
    }

    public String getCCsAsString() throws MessagingException {
        String s;
        block3: {
            block2: {
                s = " ";
                if (!this.messageReady) break block2;
                Address[] addresses = this.message.getRecipients(MimeMessage.RecipientType.CC);
                if (addresses == null) break block3;
                for (Address aktAddress : addresses) {
                    s = s + aktAddress.toString() + ",";
                }
                break block3;
            }
            ListIterator i = this.ccList.listIterator();
            while (i.hasNext()) {
                s = s + (String)i.next() + ",";
            }
        }
        return s.substring(0, s.length() - 1).trim();
    }

    public LinkedList<String> getBCCs() {
        return this.bccList;
    }

    public String getBCCsAsString() throws MessagingException {
        String s;
        block3: {
            block2: {
                s = " ";
                if (!this.messageReady) break block2;
                Address[] addresses = this.message.getRecipients(MimeMessage.RecipientType.BCC);
                if (addresses == null) break block3;
                for (Address aktAddress : addresses) {
                    s = s + aktAddress.toString() + ",";
                }
                break block3;
            }
            ListIterator i = this.bccList.listIterator();
            while (i.hasNext()) {
                s = s + (String)i.next() + ",";
            }
        }
        return s.substring(0, s.length() - 1).trim();
    }

    public void clearRecipients() throws Exception {
        LOGGER.debug(SOSClassUtil.getMethodName());
        this.toList.clear();
        this.ccList.clear();
        this.bccList.clear();
        this.changed = true;
    }

    public void clearAttachments() {
        this.attachmentList.clear();
        this.changed = true;
    }

    private void sendLine(BufferedReader in, BufferedWriter out, String s) throws Exception {
        try {
            out.write(s + "\r\n");
            out.flush();
            s = in.readLine();
        }
        catch (Exception e) {
            throw new Exception(SOSClassUtil.getMethodName() + ": error occurred on sendLine: " + e.toString());
        }
    }

    private void sendLine(BufferedWriter out, String s) throws Exception {
        try {
            out.write(s + "\r\n");
            out.flush();
        }
        catch (Exception e) {
            throw new Exception(SOSClassUtil.getMethodName() + ": error occurred on sendLine: " + e.toString());
        }
    }

    public String getQuotedName(String name) {
        if (name.indexOf(60) > -1 && name.indexOf(62) > -1) {
            return name;
        }
        return '<' + name + '>';
    }

    public void setTimeout(int timeout) throws Exception {
        this.timeout = timeout;
        this.initMessage();
    }

    public int getTimeout() {
        return this.timeout;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) throws Exception {
        this.language = language;
        this.initLanguage();
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public String getDatetimeFormat() {
        return this.datetimeFormat;
    }

    public void setDatetimeFormat(String datetimeFormat) {
        this.datetimeFormat = datetimeFormat;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
        this.warn("encoding", encoding);
        this.changed = true;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setCharset(String charset) {
        this.charset = charset;
        this.warn("charset", charset);
        this.changed = true;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
        this.warn("contentType", contentType);
        this.changed = true;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setAttachmentContentType(String attachmentContentType) {
        this.attachmentContentType = attachmentContentType;
        this.warn("attachmentContentType", attachmentContentType);
        this.changed = true;
    }

    public String getAttachmentContentType() {
        return this.attachmentContentType;
    }

    public String getHost() {
        return this.host;
    }

    public String getPort() {
        return this.port;
    }

    public void setQueueDir(String queueDir) {
        this.queueDir = queueDir;
    }

    public String getQueueDir() {
        return this.queueDir;
    }

    public void setSubject(String subject) {
        this.subject = subject;
        this.warn("subject", subject);
        this.changed = true;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setFrom(String from) {
        this.from = from;
        this.warn("from", from);
        this.changed = true;
    }

    public String getFrom() {
        return this.from;
    }

    public String getFromName() {
        return this.fromName;
    }

    public void setFromName(String fromName) {
        this.fromName = fromName;
        this.warn("fromName", fromName);
        this.changed = true;
    }

    public void setReplyTo(String replyTo) {
        this.replyTo = replyTo;
        this.warn("replyTo", replyTo);
        this.changed = true;
    }

    public String getReplyTo() {
        return this.replyTo;
    }

    public void setBody(String body) {
        this.body = body;
        this.warn("body", body);
        this.changed = true;
    }

    public String getBody() {
        return this.body;
    }

    public void setApplicationMail(String applicationMail) {
        this.applicationMail = applicationMail;
    }

    public String getApplicationMail() {
        return this.applicationMail;
    }

    public void setSectionMail(String sectionMail) {
        this.sectionMail = sectionMail;
    }

    public String getSectionMail() {
        return this.sectionMail;
    }

    public void setApplicationMailTemplates(String applicationMailTemplates) {
        this.applicationMailTemplates = applicationMailTemplates;
    }

    public String getApplicationMailTemplates() {
        return this.applicationMailTemplates;
    }

    public void setApplicationMailTemplatesFactory(String applicationMailTemplates) {
        this.applicationMailTemplatesFactory = applicationMailTemplates;
    }

    public String getApplicationMailTemplatesFactory() {
        return this.applicationMailTemplatesFactory;
    }

    public void setSectionMailTemplates(String sectionMailTemplates) {
        this.sectionMailTemplates = sectionMailTemplates;
    }

    public String getSectionMailTemplates() {
        return this.sectionMailTemplates;
    }

    public void setSectionMailTemplatesFactory(String sectionMailTemplatesFactory) {
        this.sectionMailTemplatesFactory = sectionMailTemplatesFactory;
    }

    public String getSectionMailTemplatesFactory() {
        return this.sectionMailTemplatesFactory;
    }

    public void setSectionMailScripts(String sectionMailScripts) {
        this.sectionMailScripts = sectionMailScripts;
    }

    public String getSectionMailScripts() {
        return this.sectionMailScripts;
    }

    public void setApplicationMailScripts(String applicationMailScripts) {
        this.applicationMailScripts = applicationMailScripts;
    }

    public String getApplicationMailScripts() {
        return this.applicationMailScripts;
    }

    public void setTableSettings(String tableSettings) {
        this.tableSettings = tableSettings;
    }

    public String getTableSettings() {
        return this.tableSettings;
    }

    public byte[] getMessageBytes() {
        return this.messageBytes;
    }

    public void setSendToOutputStream(boolean sendToOutputStream) {
        this.sendToOutputStream = sendToOutputStream;
    }

    public void setattachmentEncoding(String attachmentEncoding) {
        this.attachmentEncoding = attachmentEncoding;
        this.warn("attachmentEncoding", attachmentEncoding);
        this.changed = true;
    }

    public MimeMessage getMessage() {
        return this.message;
    }

    public String getLastError() {
        return this.lastError;
    }

    public String getAttachmentEncoding() {
        return this.attachmentEncoding;
    }

    public String getAttachmentCharset() {
        return this.attachmentCharset;
    }

    public void setAttachmentCharset(String attachmentCharset) {
        this.attachmentCharset = attachmentCharset;
        this.warn("attachmentCharset", attachmentCharset);
        this.changed = true;
    }

    public void setAttachmentEncoding(String attachmentEncoding) {
        this.attachmentEncoding = attachmentEncoding;
        this.warn("attachmentEncoding", attachmentEncoding);
        this.changed = true;
    }

    public void setHost(String host) throws Exception {
        this.host = host;
        this.initMessage();
    }

    public void setPassword(String password) throws Exception {
        this.password = password;
        this.initMessage();
    }

    public void setUser(String user) throws Exception {
        this.user = user;
        this.initMessage();
    }

    public void setPort(String port) throws Exception {
        this.port = port;
        this.initMessage();
    }

    public void setPriorityHighest() throws MessagingException {
        this.message.setHeader("Priority", "urgent");
        this.message.setHeader("X-Priority", "1 (Highest)");
        this.message.setHeader("X-MSMail-Priority", "Highest");
        this.changed = true;
    }

    public void setPriorityHigh() throws MessagingException {
        this.message.setHeader("Priority", "urgent");
        this.message.setHeader("X-Priority", "2 (High)");
        this.message.setHeader("X-MSMail-Priority", "Highest");
        this.changed = true;
    }

    public void setPriorityNormal() throws MessagingException {
        this.message.setHeader("Priority", "normal");
        this.message.setHeader("X-Priority", "3 (Normal)");
        this.message.setHeader("X-MSMail-Priority", "Normal");
        this.changed = true;
    }

    public void setPriorityLow() throws MessagingException {
        this.message.setHeader("Priority", "non-urgent");
        this.message.setHeader("X-Priority", "4 (Low)");
        this.message.setHeader("X-MSMail-Priority", "Low");
        this.changed = true;
    }

    public void setPriorityLowest() throws MessagingException {
        this.message.setHeader("Priority", "non-urgent");
        this.message.setHeader("X-Priority", "5 (Lowest)");
        this.message.setHeader("X-MSMail-Priority", "Low");
        this.changed = true;
    }

    public void setAlternativeBody(String alternativeBody) {
        this.alternativeBody = alternativeBody;
    }

    public void setAlternativeCharset(String alternativeCharset) {
        this.alternativeCharset = alternativeCharset;
    }

    public void setAlternativeContentType(String alternativeContentType) {
        this.alternativeContentType = alternativeContentType;
    }

    public String getQueuePraefix() {
        return this.queuePraefix;
    }

    public String getLastGeneratedFileName() {
        return this.lastGeneratedFileName;
    }

    public void setQueuePraefix(String queuePraefix) {
        this.queuePraefix = queuePraefix;
    }

    public String getLoadedMessageId() {
        return this.loadedMessageId;
    }

    private void warn(String n, String v) {
        if (this.messageReady) {
            try {
                LOGGER.warn("...setting of " + n + "=" + v + " will not be used. Loaded Message will be sent unchanged.");
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Deprecated
    public String sendNative() throws Exception {
        Socket socket = null;
        String boundary = "DataSeparatorString";
        StringBuilder sb = new StringBuilder();
        try {
            ListIterator e;
            if (this.host == null || this.host.isEmpty()) {
                throw new Exception(SOSClassUtil.getMethodName() + ": host has no value.");
            }
            if (this.port == null || this.port.isEmpty()) {
                throw new Exception(SOSClassUtil.getMethodName() + ": port has no value.");
            }
            if (this.toList.isEmpty()) {
                throw new Exception(SOSClassUtil.getMethodName() + ": no recipient specified.");
            }
            if (this.from == null || this.from.isEmpty()) {
                throw new Exception(SOSClassUtil.getMethodName() + ": no sender specified.");
            }
            socket = new Socket(this.host, Integer.parseInt(this.port));
            BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream(), "8859_1"));
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream(), "8859_1"));
            this.sendLine(in, out, "HELO " + this.host);
            if (this.fromName != null && !this.fromName.isEmpty() && this.from != null && !this.from.isEmpty()) {
                this.sendLine(in, out, "MAIL FROM: " + this.fromName + this.getQuotedName(this.from));
            } else if (this.from != null && !this.from.isEmpty()) {
                this.sendLine(in, out, "MAIL FROM: " + this.getQuotedName(this.from));
            }
            this.sendLine(in, out, "DATA");
            this.sendLine(out, "MIME-Version: 1.0");
            if (this.fromName != null && !this.fromName.isEmpty() && this.from != null && !this.from.isEmpty()) {
                this.sendLine(out, "From: " + this.fromName + this.getQuotedName(this.from));
            } else if (this.from != null && !this.from.isEmpty()) {
                this.sendLine(out, "From: " + this.getQuotedName(this.from));
            }
            if (this.replyTo != null && !this.replyTo.isEmpty()) {
                this.sendLine(out, "Reply-To: " + this.getQuotedName(this.replyTo));
            }
            if (!this.toList.isEmpty()) {
                sb = new StringBuilder();
                e = this.toList.listIterator();
                while (e.hasNext()) {
                    sb.append(this.getQuotedName((String)e.next()));
                    if (!e.hasNext()) continue;
                    sb.append(",");
                }
                this.sendLine(out, "To: " + sb);
            }
            if (!this.ccList.isEmpty()) {
                sb = new StringBuilder();
                e = this.ccList.listIterator();
                while (e.hasNext()) {
                    sb.append(this.getQuotedName((String)e.next()));
                    if (!e.hasNext()) continue;
                    sb.append(",");
                }
                this.sendLine(out, "Cc: " + sb);
            }
            if (!this.bccList.isEmpty()) {
                sb = new StringBuilder();
                e = this.bccList.listIterator();
                while (e.hasNext()) {
                    sb.append(this.getQuotedName((String)e.next()));
                    if (!e.hasNext()) continue;
                    sb.append(",");
                }
                this.sendLine(out, "Bcc: " + sb);
            }
            if (this.subject != null) {
                this.sendLine(out, "Subject: " + this.subject);
            }
            this.sendLine(out, "Content-Type: multipart/mixed; boundary=\"" + boundary + "\"");
            this.sendLine(out, "\r\n--" + boundary);
            if (this.contentType != null && !this.contentType.isEmpty()) {
                this.sendLine(out, "Content-Type: text/html; charset=\"" + this.charset + "\"");
            }
            if (this.encoding != null) {
                this.sendLine(out, "Content-Transfer-Encoding: " + this.encoding);
            }
            this.sendLine(out, "\r\n" + this.body + "\r\n\r\n");
            if (!this.attachmentList.isEmpty()) {
                for (SOSMailAttachment sosMailAttachment : this.attachmentList.values()) {
                    this.sendLine(out, "\r\n--" + boundary);
                    this.sendLine(out, "Content-Type: " + sosMailAttachment.getContentType() + "; name=\"" + new File(sosMailAttachment.getFilename()) + "\"");
                    this.sendLine(out, "Content-Disposition: attachment; filename=\"" + sosMailAttachment.getFilename() + "\"");
                    this.sendLine(out, "Content-Transfer-Encoding: " + this.attachmentEncoding + "\r\n");
                    SOSMimeBase64.encode(sosMailAttachment.getFilename(), out);
                }
            }
            this.sendLine(out, "\r\n\r\n--" + boundary + "--\r\n");
            this.sendLine(in, out, ".");
            this.sendLine(in, out, "QUIT");
        }
        catch (Exception e) {
            throw new Exception(SOSClassUtil.getMethodName() + ": error occurred on send: " + e.toString());
        }
        finally {
            if (socket != null) {
                socket.close();
            }
        }
        return sb.toString();
    }

    @Deprecated
    public String sendHostware() throws Exception {
        throw new JSNotImplementedException("hostware is no longer supported");
    }

    public static void main(String[] args) throws Exception {
        SOSMail sosMail = new SOSMail("smtp.sos");
        sosMail.setPriorityLowest();
        sosMail.setQueueDir("c:/");
        sosMail.setFrom("xyz@sos-berlin.com");
        sosMail.setEncoding("8bit");
        sosMail.setattachmentEncoding("Base64");
        sosMail.setAttachmentCharset("UTF-8");
        sosMail.setSubject("Betreff");
        sosMail.setAttachmentContentType("text/html");
        sosMail.setReplyTo("xyz@sos-berlin.com");
        File attachmentFile = new File("c:/temp/1.txt");
        SOSMailAttachment attachment = new SOSMailAttachment(sosMail, attachmentFile);
        attachment.setCharset(sosMail.getAttachmentCharset());
        attachment.setEncoding(sosMail.getAttachmentEncoding());
        attachment.setContentType(sosMail.getAttachmentContentType());
        sosMail.addAttachment(attachment);
        String s = "Hello\\nWorld";
        sosMail.setBody(s);
        sosMail.addRecipient("xyz@sos-berlin.com");
        sosMail.setPriorityLowest();
        if (!sosMail.send()) {
            LOGGER.warn(SOSClassUtil.getMethodName() + "-->" + sosMail.getLastError());
        }
        sosMail.clearRecipients();
    }

    public File getNewQueueDirectoryFile() {
        Date d = new Date();
        StringBuffer bb = new StringBuffer();
        SimpleDateFormat s = new SimpleDateFormat("yyyy-MM-dd.HHmmss.S");
        FieldPosition fp = new FieldPosition(0);
        StringBuffer b = s.format(d, bb, fp);
        String fn = this.queueDir + "/" + this.queuePraefix + b + ".email";
        File f = new File(fn);
        while (f.exists()) {
            b = s.format(d, bb, fp);
            fn = this.queueDir + "/" + this.queuePraefix + b + ".email";
            f = new File(this.lastGeneratedFileName);
        }
        return f;
    }

    public void sendMail(ISOSSmtpMailOptions options) throws Exception {
        this.sendMail(options, false, false);
    }

    public void sendMail(ISOSSmtpMailOptions options, boolean queueOnly) throws Exception {
        this.sendMail(options, queueOnly, false);
    }

    public void sendMail(ISOSSmtpMailOptions options, boolean queueOnly, boolean withAttachment) throws Exception {
        String delims = ",|;";
        try {
            String strAttachments;
            String recipientBCC;
            String[] recipients;
            SOSMail sosMail = this;
            sosMail.init();
            sosMail.setHost(options.getHost().getValue());
            sosMail.setPort(options.getPort().getValue());
            sosMail.setQueueDir(options.getQueueDirectory().getValue());
            sosMail.setFrom(options.getFrom().getValue());
            sosMail.setFromName(options.getFromName().getValue());
            sosMail.setContentType(options.getContentType().getValue());
            sosMail.setEncoding(options.getEncoding().getValue());
            String recipient = options.getTo().getValue();
            for (String recipient2 : recipients = recipient.trim().split(",|;")) {
                sosMail.addRecipient(recipient2.trim());
            }
            String recipientCC = options.getCc().getValue();
            if (!recipientCC.trim().isEmpty()) {
                String[] recipientsCC;
                for (String element : recipientsCC = recipientCC.trim().split(",|;")) {
                    sosMail.addCC(element.trim());
                }
            }
            if (!(recipientBCC = options.getBcc().getValue().trim()).isEmpty()) {
                String[] recipientsBCC;
                for (String element : recipientsBCC = recipientBCC.trim().split(",|;")) {
                    sosMail.addBCC(element.trim());
                }
            }
            if (!(strAttachments = options.getAttachment().getValue().trim()).isEmpty()) {
                String[] strAttachmentsA;
                for (String element : strAttachmentsA = strAttachments.trim().split(",|;")) {
                    sosMail.addAttachment(element.trim());
                }
            }
            sosMail.setSubject(options.getSubject().getValue());
            sosMail.setBody(options.getBody().getValue());
            if (queueOnly) {
                File f = this.getNewQueueDirectoryFile();
                LOGGER.debug(String.format("[%s]queue mail: \n %s", f.getCanonicalPath(), sosMail.dumpMessageAsString()));
                this.dumpMessageToFile(f, withAttachment);
            } else {
                LOGGER.debug("sending mail: \n" + sosMail.dumpMessageAsString());
                if (!sosMail.send()) {
                    LOGGER.warn("mail server is unavailable, mail for recipient [" + recipient + "] is queued in local directory [" + sosMail.getQueueDir() + "]:" + sosMail.getLastError());
                }
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new Exception("error occurred sendMail: " + e.getMessage());
        }
    }

    public void setQueueFailedPraefix(String queueFailedPraefix) {
        this.queueFailedPraefix = queueFailedPraefix;
    }

    class FileDataSource
    extends MydataSource {
        final File file;

        public FileDataSource(File file, String content_type) {
            super(file, content_type);
            this.file = file;
        }

        public InputStream getInputStream() throws IOException {
            FileInputStream f = new FileInputStream(this.file);
            SOSMail.this.file_input_streams.add(f);
            return f;
        }
    }

    abstract class MydataSource
    implements DataSource {
        final String name;
        final String content_type;

        public MydataSource(File new_filename, String content_type) {
            this.name = new_filename.getName();
            this.content_type = content_type;
        }

        public String getContentType() {
            return this.content_type;
        }

        public String getName() {
            return this.name;
        }

        public OutputStream getOutputStream() {
            throw new RuntimeException(this.getClass().getName() + " has no OutputStream");
        }
    }
}

