/*
 * Decompiled with CFR 0.152.
 */
package sos.net;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.connection.SOSConnection;
import sos.net.SOSMail;
import sos.net.SOSMailAttachment;
import sos.settings.SOSConnectionSettings;
import sos.settings.SOSSettings;
import sos.textprocessor.SOSPlainTextProcessor;
import sos.util.SOSClassUtil;
import sos.util.SOSDate;

public class SOSMailOrder
extends SOSMail {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSMailOrder.class);
    protected SOSConnection sosConnection;
    protected boolean hasLocalizedTemplates = true;
    protected SOSPlainTextProcessor mailPlainTextProcessor = null;
    private int mailingId = 0;
    private int jobId;
    private String messageId;
    private String topic = null;
    private String topicIdentifier = null;
    private String clientIdentifier = null;
    private String reference = null;
    private String subjectTemplate = null;
    private int subjectTemplateType;
    private String bodyTemplate = null;
    private int bodyTemplateType;
    private int id = -1;
    private String modifiedBy = "SOSMailOrder";
    private Map<String, String> replacements = new HashMap<String, String>();
    private int status = 0;
    private String statusText = null;
    private Date targeted = null;
    private Date delivered = null;
    public static final int TEMPLATE_TYPE_PLAIN = 0;
    public static final int TEMPLATE_TYPE_FACTORY = 1;
    public static final int TEMPLATE_TYPE_PLAIN_FILE = 100;
    public static final int TEMPLATE_TYPE_FACTORY_FILE = 101;
    public static final int EMAIL_STATUS_REQUESTED = 0;
    public static final int EMAIL_STATUS_DELIVERED = 1;
    public static final int EMAIL_STATUS_WITH_ERRORS = 1001;

    public SOSMailOrder(SOSSettings sosSettings, SOSConnection conn) throws Exception {
        super(sosSettings);
        this.sosConnection = conn;
    }

    public SOSMailOrder(SOSSettings sosSettings, String language, SOSConnection conn) throws Exception {
        super(sosSettings, language);
        this.sosConnection = conn;
    }

    public SOSMailOrder(String host, SOSConnection conn) throws Exception {
        super(host);
        this.sosConnection = conn;
    }

    public SOSMailOrder(String host, String user, String password, SOSConnection conn) throws Exception {
        super(host, user, password);
        this.sosConnection = conn;
    }

    public SOSMailOrder(String host, String port, String user, String password, SOSConnection conn) throws Exception {
        super(host, port, user, password);
        this.sosConnection = conn;
    }

    public void initProcessors() throws Exception {
        try {
            if (this.sosSettings != null && this.sosSettings instanceof SOSConnectionSettings) {
                this.mailPlainTextProcessor = new SOSPlainTextProcessor((SOSConnectionSettings)this.sosSettings);
                this.mailPlainTextProcessor.setHasLocalizedTemplates(this.hasLocalizedTemplates());
                this.mailPlainTextProcessor.getTemplates(this.getSectionMailTemplates(), this.getApplicationMailTemplates());
                this.mailPlainTextProcessor.getScripts(this.getSectionMailScripts(), this.getApplicationMailScripts());
            }
        }
        catch (Exception e) {
            throw new Exception("failed to initialize processors: " + e);
        }
    }

    public void load(int id) throws Exception {
        Map data = new HashMap();
        try {
            int tt;
            data = this.sosConnection.getSingle("SELECT \"MAILING_ID\", \"JOB_ID\", \"MESSAGE_ID\", \"TOPIC\", \"TOPIC_IDENTIFIER\", \"CLIENT_IDENTIFIER\", \"REFERENCE\", \"MAIL_FROM\", \"FROM_NAME\", \"MAIL_TO\", \"CC_TO\", \"BCC_TO\", \"REPLY_TO\", \"PRIORITY\", \"SUBJECT\", \"SUBJECT_TEMPLATE\", \"SUBJECT_TEMPLATE_TYPE\", \"BODY_TEMPLATE\", \"BODY_TEMPLATE_TYPE\", \"REPLACEMENTS\", \"LANGUAGE\", \"CHARSET\", \"ENCODING\", \"CONTENT_TYPE\", \"STATUS\", \"STATUS_TEXT\", \"TARGETED\", \"DELIVERED\" FROM " + SOSMail.tableMails + " WHERE \"ID\"=" + id);
            if (data.isEmpty()) {
                throw new Exception("Mail not found.");
            }
            this.setMailingId(Integer.parseInt(((String)data.get("mailing_id")).toString()));
            this.setJobId(Integer.parseInt(((String)data.get("job_id")).toString()));
            if (data.get("message_id") != null) {
                this.setMessageId((String)data.get("message_id"));
            }
            if (data.get("topic") != null) {
                this.setTopic((String)data.get("topic"));
            }
            if (data.get("topic_identifier") != null) {
                this.setTopicIdentifier((String)data.get("topic_identifier"));
            }
            if (data.get("client_identifier") != null) {
                this.setClientIdentifier((String)data.get("client_identifier"));
            }
            if (data.get("reference") != null) {
                this.setReference((String)data.get("reference"));
            }
            if (data.get("mail_from") != null) {
                this.setFrom((String)data.get("mail_from"));
            }
            if (data.get("from_name") != null) {
                this.setFromName((String)data.get("from_name"));
            }
            if (data.get("mail_to") != null) {
                this.addRecipient((String)data.get("mail_to"));
            }
            if (data.get("cc_to") != null) {
                this.addCC((String)data.get("cc_to"));
            }
            if (data.get("bcc_to") != null) {
                this.addBCC((String)data.get("bcc_to"));
            }
            if (data.get("reply_to") != null) {
                this.setReplyTo((String)data.get("reply_to"));
            }
            int priority = Integer.parseInt((String)data.get("priority"));
            switch (priority) {
                case 1: {
                    this.setPriorityHighest();
                    break;
                }
                case 2: {
                    this.setPriorityHigh();
                    break;
                }
                case 4: {
                    this.setPriorityLow();
                    break;
                }
                case 5: {
                    this.setPriorityLowest();
                    break;
                }
                default: {
                    this.setPriorityNormal();
                }
            }
            if (data.get("subject") != null) {
                this.setSubject((String)data.get("subject"));
            }
            if (data.get("subject_template") != null) {
                this.setSubjectTemplate((String)data.get("subject_template"));
            }
            if (data.get("subject_template_type") != null) {
                tt = Integer.parseInt((String)data.get("subject_template_type"));
                this.setSubjectTemplateType(tt);
            }
            if (data.get("body_template") != null) {
                this.setBodyTemplate((String)data.get("body_template"));
            }
            if (data.get("body_template_type") != null) {
                tt = Integer.parseInt((String)data.get("body_template_type"));
                this.setBodyTemplateType(tt);
            }
            this.clearReplacements();
            if (data.get("replacements") != null && !((String)data.get("replacements")).isEmpty()) {
                String[] replacementList = ((String)data.get("replacements")).split("\\|");
                for (int i = 0; i < replacementList.length; ++i) {
                    String[] replacementEntry = replacementList[i].split("\\^");
                    if (replacementEntry.length != 2) continue;
                    this.addReplacement(replacementEntry[0], replacementEntry[1]);
                }
            }
            if (data.get("language") != null && !((String)data.get("language")).isEmpty()) {
                this.setLanguage((String)data.get("language"));
            }
            if (data.get("charset") != null && !((String)data.get("charset")).isEmpty()) {
                this.setCharset((String)data.get("charset"));
            }
            if (data.get("encoding") != null && !((String)data.get("encoding")).isEmpty()) {
                this.setEncoding((String)data.get("encoding"));
            }
            if (data.get("content_type") != null && !((String)data.get("content_type")).isEmpty()) {
                this.setContentType((String)data.get("content_type"));
            }
            if (data.get("status") != null) {
                int st = Integer.parseInt((String)data.get("status"));
                this.setStatus(st);
            }
            if (data.get("status_text") != null) {
                this.setStatusText((String)data.get("status_text"));
            }
            if (data.get("targeted") != null && !((String)data.get("targeted")).isEmpty()) {
                this.setTargeted(SOSDate.getTime((String)((String)data.get("targeted"))));
            }
            if (data.get("delivered") != null && !((String)data.get("delivered")).isEmpty()) {
                this.setDelivered(SOSDate.getTime((String)((String)data.get("delivered"))));
            }
            String body = this.sosConnection.getClob("SELECT \"BODY\" FROM " + SOSMail.tableMails + " WHERE \"ID\"=" + id);
            this.setBody(body);
            this.id = id;
            this.loadAttachments();
        }
        catch (Exception e) {
            throw new Exception(SOSClassUtil.getMethodName() + ": could not load mail [" + id + "]: " + e);
        }
    }

    private void loadAttachments() throws Exception {
        List data = new ArrayList();
        try {
            data = this.sosConnection.getArray("SELECT \"FILENAME\", \"CHARSET\",  \"ENCODING\", \"CONTENT_TYPE\" FROM " + SOSMail.tableMailAttachments + " WHERE \"ID\"=" + this.id);
            if (data != null) {
                LOGGER.debug("Found " + data.size() + " attachments.");
                for (Map att : data) {
                    String filename = (String)att.get("filename");
                    File file = new File(filename);
                    SOSMailAttachment attachment = new SOSMailAttachment(this, file);
                    if (att.get("charset") != null && !((String)att.get("charset")).isEmpty()) {
                        attachment.setCharset((String)att.get("charset"));
                    }
                    if (att.get("encoding") != null && !((String)att.get("encoding")).isEmpty()) {
                        attachment.setEncoding((String)att.get("encoding"));
                    }
                    if (att.get("content_type") != null && !((String)att.get("content_type")).isEmpty()) {
                        attachment.setContentType((String)att.get("content_type"));
                    }
                    this.addAttachment(attachment);
                }
            }
        }
        catch (Exception e) {
            throw new Exception("Error occured loading attachments: " + e, e);
        }
    }

    public void store() throws Exception {
        if (this.id == -1) {
            this.create();
        }
        String statement = "UPDATE " + SOSMail.tableMails + " SET ";
        statement = statement + SOSMailOrder.updateField("MAILING_ID", this.getMailingId());
        statement = statement + SOSMailOrder.updateField("JOB_ID", this.getJobId());
        statement = statement + SOSMailOrder.updateField("MESSAGE_ID", this.getMessageId());
        statement = statement + SOSMailOrder.updateField("TOPIC", this.getTopic());
        statement = statement + SOSMailOrder.updateField("TOPIC_IDENTIFIER", this.getTopicIdentifier());
        statement = statement + SOSMailOrder.updateField("CLIENT_IDENTIFIER", this.getClientIdentifier());
        statement = statement + SOSMailOrder.updateField("REFERENCE", this.getReference());
        statement = statement + SOSMailOrder.updateField("MAIL_FROM", this.getFrom());
        statement = statement + SOSMailOrder.updateField("FROM_NAME", this.getFromName());
        statement = statement + SOSMailOrder.updateField("MAIL_TO", this.getRecipientsAsString());
        statement = statement + SOSMailOrder.updateField("CC_TO", this.getCCsAsString());
        statement = statement + SOSMailOrder.updateField("BCC_TO", this.getBCCsAsString());
        statement = statement + SOSMailOrder.updateField("REPLY_TO", this.getReplyTo());
        String prio = this.getMessage().getHeader("X-Priority", null);
        if (prio != null && !prio.isEmpty()) {
            try {
                int iPrio = Integer.parseInt(prio.substring(0, 1));
                statement = statement + SOSMailOrder.updateField("PRIORITY", iPrio);
            }
            catch (Exception iPrio) {
                // empty catch block
            }
        }
        statement = statement + SOSMailOrder.updateField("SUBJECT", this.getSubject());
        statement = statement + SOSMailOrder.updateField("SUBJECT_TEMPLATE", this.getSubjectTemplate());
        statement = statement + SOSMailOrder.updateField("SUBJECT_TEMPLATE_TYPE", this.getSubjectTemplateType());
        statement = statement + SOSMailOrder.updateField("BODY_TEMPLATE", this.getBodyTemplate());
        statement = statement + SOSMailOrder.updateField("BODY_TEMPLATE_TYPE", this.getBodyTemplateType());
        statement = statement + SOSMailOrder.updateField("REPLACEMENTS", this.getReplacementsAsString());
        statement = statement + SOSMailOrder.updateField("LANGUAGE", this.getLanguage());
        statement = statement + SOSMailOrder.updateField("CHARSET", this.getCharset());
        statement = statement + SOSMailOrder.updateField("ENCODING", this.getEncoding());
        statement = statement + SOSMailOrder.updateField("CONTENT_TYPE", this.getContentType());
        statement = statement + SOSMailOrder.updateField("STATUS", this.getStatus());
        statement = statement + SOSMailOrder.updateField("STATUS_TEXT", this.getStatusText(), 250);
        statement = statement + SOSMailOrder.updateField("TARGETED", this.getTargeted());
        statement = statement + SOSMailOrder.updateField("DELIVERED", this.getDelivered());
        statement = statement + SOSMailOrder.updateField("MODIFIED_BY", this.getModifiedBy());
        statement = statement + "\"MODIFIED\"=%now WHERE \"ID\"=" + this.id;
        try {
            this.sosConnection.execute(statement);
            if (this.getBody() != null && !this.getBody().isEmpty()) {
                this.sosConnection.updateClob(SOSMail.tableMails, "BODY", this.getBody(), "\"ID\"=" + this.id);
            }
            this.storeAttachments();
            this.sosConnection.commit();
        }
        catch (Exception e) {
            try {
                this.sosConnection.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new Exception("Error occured storing mail: " + e.getMessage(), e);
        }
    }

    private static final String updateField(String fieldname, int value) {
        return "\"" + fieldname + "\"=" + value + ", ";
    }

    private static final String updateField(String fieldname, Date value) throws Exception {
        if (value == null) {
            return "\"" + fieldname + "\"=NULL, ";
        }
        try {
            return "\"" + fieldname + "\"=%timestamp_iso('" + SOSDate.getTimeAsString((Date)value) + "'), ";
        }
        catch (Exception e) {
            throw new Exception("Error occured creating date: " + e);
        }
    }

    private static final String updateField(String fieldname, String value) {
        if (value == null) {
            return "";
        }
        value = value.replaceAll("'", "''");
        return "\"" + fieldname + "\"='" + value + "', ";
    }

    private static final String updateField(String fieldname, String value, int limit) {
        if (value == null) {
            return "";
        }
        value = value.length() > limit ? value.substring(value.length() - limit) : value;
        return SOSMailOrder.updateField(fieldname, value);
    }

    private void storeAttachments() throws Exception {
        this.sosConnection.execute("DELETE FROM " + SOSMail.tableMailAttachments + " WHERE \"ID\"=" + this.id);
        Iterator iter = this.attachmentList.values().iterator();
        try {
            while (iter.hasNext()) {
                SOSMailAttachment attachment = (SOSMailAttachment)iter.next();
                String statement = "INSERT INTO " + tableMailAttachments + " (\"ID\", \"FILENAME\", \"CHARSET\", \"ENCODING\", \"CONTENT_TYPE\", \"CREATED\", \"CREATED_BY\",  \"MODIFIED\", \"MODIFIED_BY\") VALUES  (" + this.id + ", '" + attachment.getFile().getAbsolutePath() + "', '" + attachment.getCharset() + "', '" + attachment.getEncoding() + "', '" + attachment.getContentType() + "', %now, '" + this.getClass().getName() + "', %now, '" + this.getClass().getName() + "')";
                this.sosConnection.execute(statement);
            }
        }
        catch (Exception e) {
            throw new Exception("Error occured storing attachments: " + e, e);
        }
    }

    protected void create() throws Exception {
        String statement = "INSERT INTO " + SOSMail.tableMails + "  (\"CREATED\", \"CREATED_BY\", \"MODIFIED\", \"MODIFIED_BY\") VALUES (%now, '" + this.getClass().getName() + "', %now, '" + this.getClass().getName() + "')";
        try {
            int iVal;
            this.sosConnection.execute(statement);
            String val = this.sosConnection.getLastSequenceValue(SOSMail.mailsSequence);
            this.id = iVal = Integer.parseInt(val);
        }
        catch (Exception e) {
            throw new Exception("Error occured creating Mail order: " + e, e);
        }
    }

    public int getJobId() {
        return this.jobId;
    }

    public void setJobId(int jobId) {
        this.jobId = jobId;
    }

    public int getMailingId() {
        return this.mailingId;
    }

    public void setMailingId(int mailingId) {
        this.mailingId = mailingId;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public String getTopicIdentifier() {
        return this.topicIdentifier;
    }

    public void setTopicIdentifier(String topicIdentifier) {
        this.topicIdentifier = topicIdentifier;
    }

    public String getMessageId() {
        return this.messageId;
    }

    protected void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    @Override
    public boolean send() throws Exception {
        String message = "";
        boolean rc = false;
        try {
            rc = super.send();
            this.setStatus(1);
            this.setMessageId(this.getMessage().getMessageID());
            this.setDelivered(SOSDate.getCurrentTime());
            if (!rc) {
                message = "mail was NOT sent but stored for later dequeueing, reason was: " + this.getLastError();
            }
            this.setStatusText(message);
        }
        catch (Exception e) {
            this.setStatus(1001);
            if (e.getMessage() != null) {
                this.setStatusText(e.getMessage());
            } else {
                this.setStatusText(e.toString());
            }
            this.setDelivered(null);
            this.store();
            throw e;
        }
        this.store();
        return rc;
    }

    @Override
    protected boolean prepareJavaMail() throws Exception {
        if (this.getSubject() == null || this.getSubject().trim().isEmpty()) {
            this.processSubject();
        }
        if (this.getBody() == null || this.getBody().trim().isEmpty()) {
            this.processBody();
        }
        return super.prepareJavaMail();
    }

    @Override
    public void setSectionMailScripts(String sectionMailScripts) {
        this.mailPlainTextProcessor = null;
        super.setSectionMailScripts(sectionMailScripts);
    }

    @Override
    public void setSectionMailTemplates(String sectionMailTemplates) {
        this.mailPlainTextProcessor = null;
        super.setSectionMailTemplates(sectionMailTemplates);
    }

    @Override
    public void setSectionMailTemplatesFactory(String sectionMailTemplatesFactory) {
        this.mailPlainTextProcessor = null;
        super.setSectionMailTemplatesFactory(sectionMailTemplatesFactory);
    }

    private void processSubject() throws Exception {
        if (this.getSubjectTemplate() != null && !this.getSubjectTemplate().isEmpty()) {
            if (this.mailPlainTextProcessor == null) {
                this.initProcessors();
            }
            SOSPlainTextProcessor processor = null;
            processor = this.mailPlainTextProcessor;
            if (this.getSubjectTemplateType() == 101 || this.getSubjectTemplateType() == 100) {
                File subjectTemplateFile = new File(this.getSubjectTemplate());
                processor.setLanguage(this.getLanguage());
                this.setSubject(processor.process(this.readFile(subjectTemplateFile), this.replacements));
            } else {
                if (!this.getLanguage().equals(processor.getLanguage())) {
                    processor.setLanguage(this.getLanguage());
                    processor.setForceReload(true);
                    processor.getTemplates();
                }
                this.setSubject(processor.process(processor.getTemplate(this.getSubjectTemplate()), this.replacements));
            }
        }
    }

    private void processBody() throws Exception {
        if (this.getBodyTemplate() != null && !this.getBodyTemplate().trim().isEmpty()) {
            if (this.mailPlainTextProcessor == null) {
                this.initProcessors();
            }
            SOSPlainTextProcessor processor = null;
            processor = this.mailPlainTextProcessor;
            if (this.getBodyTemplateType() == 101 || this.getBodyTemplateType() == 100) {
                File bodyTemplateFile = new File(this.getBodyTemplate());
                processor.setLanguage(this.getLanguage());
                this.setBody(processor.process(this.readFile(bodyTemplateFile), this.replacements));
            } else {
                if (!this.getLanguage().equals(processor.getLanguage())) {
                    processor.setLanguage(this.getLanguage());
                    processor.setForceReload(true);
                    processor.getTemplates();
                }
                this.setBody(processor.process(processor.getTemplate(this.getBodyTemplate()), this.replacements));
            }
        }
    }

    private String readFile(File file) throws Exception {
        int bytesRead;
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
        StringBuilder content = new StringBuilder();
        byte[] buffer = new byte[1024];
        while ((bytesRead = in.read(buffer)) != -1) {
            content.append(new String(buffer, 0, bytesRead));
        }
        in.close();
        return content.toString();
    }

    protected String getClientIdentifier() {
        return this.clientIdentifier;
    }

    protected void setClientIdentifier(String clientIdentifier) {
        this.clientIdentifier = clientIdentifier;
    }

    protected String getReference() {
        return this.reference;
    }

    protected void setReference(String reference) {
        this.reference = reference;
    }

    public void setSubjectTemplate(String subjectTemplate) {
        this.subjectTemplate = subjectTemplate;
    }

    public int getSubjectTemplateType() {
        return this.subjectTemplateType;
    }

    public void setSubjectTemplateType(int subjectTemplateType) {
        this.subjectTemplateType = subjectTemplateType;
    }

    public String getSubjectTemplate() {
        return this.subjectTemplate;
    }

    public String getBodyTemplate() {
        return this.bodyTemplate;
    }

    public void setBodyTemplate(String bodyTemplate) {
        this.bodyTemplate = bodyTemplate;
    }

    public int getBodyTemplateType() {
        return this.bodyTemplateType;
    }

    public void setBodyTemplateType(int bodyTemplateType) {
        this.bodyTemplateType = bodyTemplateType;
    }

    public void addReplacement(String key, String value) {
        this.replacements.put(key, value);
    }

    public String getReplacement(String key) {
        String value = this.replacements.get(key);
        if (value != null) {
            return value.toString();
        }
        return null;
    }

    protected String getReplacementsAsString() {
        String rc = "";
        Iterator<String> keys = this.replacements.keySet().iterator();
        while (keys.hasNext()) {
            String key = keys.next();
            rc = rc + key + "^" + this.replacements.get(key);
            if (!keys.hasNext()) continue;
            rc = rc + "|";
        }
        return rc;
    }

    public void clearReplacements() {
        this.replacements.clear();
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public String getStatusText() {
        return this.statusText;
    }

    public void setStatusText(String statusText) {
        this.statusText = statusText;
    }

    public Date getDelivered() {
        return this.delivered;
    }

    public void setDelivered(Date delivered) {
        this.delivered = delivered;
    }

    public Date getTargeted() {
        return this.targeted;
    }

    public void setTargeted(Date targeted) {
        this.targeted = targeted;
    }

    public int getId() {
        return this.id;
    }

    public void initOrder() throws Exception {
        super.init();
        this.delivered = null;
        this.id = -1;
        this.mailingId = 0;
        this.messageId = "";
        this.reference = null;
        this.clearReplacements();
        this.status = 0;
        this.statusText = "";
        this.targeted = null;
        this.topic = null;
        this.topicIdentifier = null;
    }

    public boolean hasLocalizedTemplates() {
        return this.hasLocalizedTemplates;
    }

    public void setHasLocalizedTemplates(boolean hasLocalizedTemplates) {
        this.hasLocalizedTemplates = hasLocalizedTemplates;
    }

    public String getModifiedBy() {
        return this.modifiedBy;
    }

    public void setModifiedBy(String modifiedBy) {
        this.modifiedBy = modifiedBy;
    }
}

