/*
 * Decompiled with CFR 0.152.
 */
package sos.net;

import com.sos.JSHelper.Exceptions.JobSchedulerException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.mail.BodyPart;
import javax.mail.Flags;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.net.SOSMailAttachment;
import sos.util.SOSClassUtil;
import sos.util.SOSDate;

public class SOSMimeMessage {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSMimeMessage.class);
    protected ByteArrayOutputStream raw_email_byte_stream = null;
    protected String queueDir = "";
    private MimeMessage mimeMessage = null;
    private String localDateFormat = "dd.MM.yyyy HH:mm:ss";
    private String sentDateAsString;
    private String from;
    private String fromName;
    private String fromAddress;
    private final String queuePattern = "yyyy-MM-dd.HHmmss.S";
    private final String queuePraefix = "sos.";
    private String dumpedFileName = "";
    Vector<SOSMailAttachment> sosMailAttachmentList = new Vector();

    public SOSMimeMessage(Message message) throws Exception {
        this((MimeMessage)message);
    }

    public SOSMimeMessage(Message message, Boolean harmless) throws Exception {
        this.mimeMessage = (MimeMessage)message;
    }

    public SOSMimeMessage(MimeMessage mimeMessage) throws Exception {
        this.mimeMessage = mimeMessage;
        this.init();
    }

    public MimeMessage getMessage() {
        return this.mimeMessage;
    }

    public void init() throws Exception {
        if (this.mimeMessage != null) {
            this.setSentDateAsString();
            this.setFrom();
            this.setFromName();
            this.setFromAddress();
            this.processAttachment((Part)this.mimeMessage);
        }
    }

    public String getFrom() throws Exception {
        return this.from;
    }

    private final void setFrom() throws Exception {
        if (this.mimeMessage.getFrom() == null || this.mimeMessage.getFrom().length <= 0) {
            throw new JobSchedulerException("From is empty or null!");
        }
        this.from = this.mimeMessage.getFrom()[0].toString();
    }

    public void setFromName() throws Exception {
        this.fromName = ((InternetAddress)this.mimeMessage.getFrom()[0]).getPersonal();
    }

    public String getFromName() throws Exception {
        return this.fromName;
    }

    private void setFromAddress() throws Exception {
        this.fromAddress = ((InternetAddress)this.mimeMessage.getFrom()[0]).getAddress();
    }

    public String getFromAddress() throws Exception {
        return this.fromAddress;
    }

    public String getSubject() throws Exception {
        String subject = "";
        if (this.mimeMessage.getSubject() != null) {
            subject = MimeUtility.decodeText((String)this.mimeMessage.getSubject());
        }
        return subject;
    }

    public String getSentDateAsString(String dateFormat) throws Exception {
        return SOSDate.getDateAsString((Date)this.mimeMessage.getSentDate(), (String)dateFormat);
    }

    public final void setSentDateAsString() throws Exception {
        if (this.mimeMessage.getSentDate() != null) {
            this.sentDateAsString = SOSDate.getDateAsString((Date)this.mimeMessage.getSentDate(), (String)this.localDateFormat);
        }
    }

    public String getSentDateAsString() {
        return this.sentDateAsString;
    }

    public void deleteMessage() throws Exception {
        this.mimeMessage.setFlag(Flags.Flag.DELETED, true);
        LOGGER.debug("[" + this.mimeMessage.getMessageID() + "] marked for delete.");
    }

    public Date getSentDate() throws MessagingException {
        return this.mimeMessage.getSentDate();
    }

    public int getMessageNumber() {
        return this.mimeMessage.getMessageNumber();
    }

    public String getMessageId() throws MessagingException {
        return this.mimeMessage.getMessageID().replaceAll("(^<?)|(>?$)", "");
    }

    public List<String> getRecipientAddress(String recipientType) throws Exception {
        Vector<String> recipientAddressList = new Vector<String>();
        InternetAddress[] internetAddress = null;
        if ("TO".equals(recipientType = recipientType.toUpperCase())) {
            internetAddress = (InternetAddress[])this.mimeMessage.getRecipients(Message.RecipientType.TO);
        } else if ("CC".equals(recipientType)) {
            internetAddress = (InternetAddress[])this.mimeMessage.getRecipients(Message.RecipientType.CC);
        } else if ("BCC".equals(recipientType)) {
            internetAddress = (InternetAddress[])this.mimeMessage.getRecipients(Message.RecipientType.BCC);
        } else {
            throw new Exception("Invalid recipient type!!");
        }
        if (internetAddress != null) {
            for (InternetAddress internetAddres : internetAddress) {
                if (internetAddres.getAddress() == null) continue;
                recipientAddressList.add(MimeUtility.decodeText((String)internetAddres.getAddress()));
            }
        }
        return recipientAddressList;
    }

    public String getLocalDateFormat() {
        return this.localDateFormat;
    }

    public void setLocalDateFormat(String localDateFormat) throws Exception {
        this.localDateFormat = localDateFormat;
        this.setSentDateAsString();
    }

    public List<String> getBodyText() throws MessagingException, IOException {
        return this.getBodyText((Part)this.mimeMessage);
    }

    private List<String> getBodyText(Part part) throws MessagingException, IOException {
        Object content = part.getContent();
        String disposition = part.getDisposition();
        Vector<String> textContent = new Vector<String>();
        if (content instanceof String && disposition != null && !disposition.equalsIgnoreCase("attachment")) {
            textContent.addAll(SOSMimeMessage.toList((String)content));
            return SOSMimeMessage.toList((String)content);
        }
        if (content instanceof Multipart) {
            int count = ((Multipart)content).getCount();
            for (int i = 0; i < count; ++i) {
                BodyPart bodyPart = ((Multipart)content).getBodyPart(i);
                textContent.addAll(this.getBodyText((Part)bodyPart));
            }
            return textContent;
        }
        return new Vector<String>();
    }

    public String getPlainTextBody() throws Exception {
        Object content = this.mimeMessage.getContent();
        if (this.mimeMessage.isMimeType("text/plain")) {
            return (String)content;
        }
        if (this.mimeMessage.isMimeType("multipart/*")) {
            Multipart mp = (Multipart)this.mimeMessage.getContent();
            int numParts = mp.getCount();
            for (int i = 0; i < numParts; ++i) {
                if (mp.getBodyPart(i).isMimeType("text/plain")) {
                    if (mp.getBodyPart(i).getContent() == null) {
                        return "";
                    }
                    return (String)mp.getBodyPart(i).getContent();
                }
                if (!mp.getBodyPart(i).isMimeType("multipart/*")) continue;
                MimeMultipart mmp = (MimeMultipart)mp.getBodyPart(i).getContent();
                int numBodyParts = mmp.getCount();
                for (int j = 0; j < numBodyParts; ++j) {
                    if (!mmp.getBodyPart(j).isMimeType("text/plain")) continue;
                    if (mmp.getBodyPart(j).getContent() == null) {
                        return "";
                    }
                    return (String)mmp.getBodyPart(j).getContent();
                }
            }
            return "";
        }
        return "";
    }

    public boolean isBounce() throws Exception {
        boolean emptyReturnPath = false;
        if (this.mimeMessage.getHeader("Return-Path") != null) {
            emptyReturnPath = this.mimeMessage.getHeader("Return-Path")[0].matches("(.*)(\\s*\\<\\s*\\>\\s*)(.*)");
        }
        return this.mimeMessage.isMimeType("multipart/report") && emptyReturnPath;
    }

    public static String arrayToString(String[] array) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < array.length; ++i) {
            sb.append(array[i]);
            if (i >= array.length - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    public SOSMimeMessage getAttachedSosMimeMessage(Session session, byte[] messageContent) throws Exception {
        if (messageContent == null) {
            throw new Exception("messageContent has null value!!");
        }
        ByteArrayInputStream messageInputStream = new ByteArrayInputStream(messageContent);
        return new SOSMimeMessage(new MimeMessage(session, (InputStream)messageInputStream));
    }

    public Vector<SOSMailAttachment> getSosMailAttachments() throws Exception {
        return this.sosMailAttachmentList;
    }

    public int getSosMailAttachmentsCount() throws Exception {
        return this.sosMailAttachmentList.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getByteArray(InputStream in) throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            byte[] buffer = new byte[8192];
            int count = 0;
            while ((count = in.read(buffer)) >= 0) {
                bos.write(buffer, 0, count);
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (bos != null) {
                    bos.close();
                }
            }
            catch (Exception exception) {}
        }
        return bos.toByteArray();
    }

    public void processAttachment(Part part) throws Exception {
        String extension = "";
        boolean hasAttachment = false;
        String fileName = null;
        if (part.isMimeType("multipart/*")) {
            Multipart multipart = (Multipart)part.getContent();
            int count = multipart.getCount();
            for (int i = 0; i < count; ++i) {
                this.processAttachment((Part)multipart.getBodyPart(i));
            }
        } else if (part.isMimeType("message/rfc822")) {
            hasAttachment = true;
            extension = ".eml";
        } else if (part.isMimeType("text/html")) {
            extension = ".html";
            hasAttachment = true;
        } else {
            hasAttachment = true;
        }
        if (hasAttachment) {
            SOSMailAttachment sosMailAttachment = new SOSMailAttachment();
            String disposition = part.getDisposition();
            if (disposition == null || disposition.equalsIgnoreCase("attachment")) {
                fileName = part.getFileName();
            }
            if (fileName != null) {
                sosMailAttachment.setFilename(MimeUtility.decodeText((String)part.getFileName()));
            } else {
                sosMailAttachment.setFilename(fileName);
            }
            sosMailAttachment.setContentType(part.getContentType());
            sosMailAttachment.setContent(this.getByteArray(part.getInputStream()));
            sosMailAttachment.setFileExtension(extension);
            this.sosMailAttachmentList.add(sosMailAttachment);
        }
    }

    private static List<String> toList(String string) {
        Vector<String> list = new Vector<String>();
        list.add(string);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveFile(File file, byte[] input) throws Exception {
        FileOutputStream fos = null;
        BufferedOutputStream bos = null;
        File saveFile = file;
        try {
            int i = 0;
            while (file.exists()) {
                file = new File(saveFile.getAbsolutePath() + "_" + i);
                ++i;
            }
            fos = new FileOutputStream(file);
            bos = new BufferedOutputStream(fos);
            bos.write(input);
        }
        finally {
            if (bos != null) {
                try {
                    bos.flush();
                }
                catch (Exception exception) {}
            }
            if (bos != null) {
                try {
                    bos.close();
                    bos = null;
                }
                catch (Exception exception) {}
            }
        }
    }

    public void saveAttachment(SOSMailAttachment sosMailAttachment, String targetFolderName) throws Exception {
        String attachmentFileName = null;
        LOGGER.debug("Calling " + SOSClassUtil.getMethodName());
        if (!new File(targetFolderName).exists()) {
            throw new Exception("File [" + targetFolderName + "] does not exists!");
        }
        attachmentFileName = sosMailAttachment.getFilename();
        if (attachmentFileName == null) {
            attachmentFileName = "attach";
        }
        attachmentFileName = targetFolderName + File.separator + attachmentFileName;
        this.saveFile(new File(attachmentFileName), sosMailAttachment.getContent());
        LOGGER.debug(".. saving attachment file [" + sosMailAttachment.getFilename() + " successfully done.");
    }

    private String normalize(String f) {
        f = f.replace(":", "_");
        f = f.replace("\\", "_");
        return f;
    }

    public void saveAttachments(SOSMimeMessage message, String attachmentFileNamePattern, String targetFolderName, boolean saveFilesWithoutFilename) throws Exception {
        String attachmentFileName = null;
        if (attachmentFileNamePattern == null || attachmentFileNamePattern.isEmpty()) {
            attachmentFileNamePattern = "${filename}";
        }
        LOGGER.debug("Calling " + SOSClassUtil.getMethodName());
        if (!new File(targetFolderName).exists()) {
            throw new Exception("File [" + targetFolderName + "] does not exists!!");
        }
        Iterator<SOSMailAttachment> it = this.sosMailAttachmentList.iterator();
        int count = 0;
        while (it.hasNext()) {
            SOSMailAttachment attachment = it.next();
            LOGGER.debug(".. attachment count byte [" + attachment.getContent().length + "]");
            attachmentFileName = attachment.getFilename();
            if (attachmentFileName == null && saveFilesWithoutFilename) {
                attachmentFileName = "attach";
            }
            if (attachmentFileName == null) continue;
            attachmentFileName = attachmentFileNamePattern.replace("${filename}", attachmentFileName);
            attachmentFileName = attachmentFileName.replace("${messageId}", message.getMessageId());
            attachmentFileName = attachmentFileName.replace("${subject}", message.getSubject());
            attachmentFileName = this.normalize(attachmentFileName);
            File fileToSave = new File(targetFolderName, attachmentFileName);
            this.saveFile(fileToSave, attachment.getContent());
            ++count;
            LOGGER.debug(".. attachment file [" + attachment.getFilename() + "] successfully saved.");
        }
        LOGGER.debug(".. [" + count + "] Attachment(s) saved to " + targetFolderName);
    }

    public void dumpMessage(File file, boolean append) throws Exception {
        this.dumpFile(file, this.mimeMessage.getInputStream(), append);
    }

    public void setFlag(Flags.Flag flag, boolean set) throws MessagingException {
        this.mimeMessage.setFlag(flag, set);
    }

    public Object getContent() throws IOException, MessagingException {
        return this.mimeMessage.getContent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void dumpFile(File file, InputStream input, boolean append) throws Exception {
        FileOutputStream fos = null;
        BufferedOutputStream bos = null;
        BufferedInputStream bis = null;
        try {
            int b;
            fos = new FileOutputStream(file, append);
            bos = new BufferedOutputStream(fos);
            bis = new BufferedInputStream(input);
            while ((b = bis.read()) != -1) {
                bos.write(b);
            }
        }
        finally {
            if (bos != null) {
                bos.flush();
                bos.close();
            }
            if (fos != null) {
                fos.close();
            }
            if (bis != null) {
                bis.close();
            }
        }
    }

    public Enumeration<Header> getHeaders() throws Exception {
        return this.mimeMessage.getAllHeaders();
    }

    public String dumpHeaders() throws IOException, MessagingException {
        StringBuilder sb = new StringBuilder();
        Header header = null;
        Enumeration e = this.mimeMessage.getAllHeaders();
        while (e.hasMoreElements()) {
            header = (Header)e.nextElement();
            sb.append("\n").append(header.getName()).append(": ").append(header.getValue());
        }
        return sb.toString();
    }

    public void dumpMessageToFile(File file, boolean withAttachment, boolean append) throws Exception {
        FileOutputStream out = null;
        try {
            File tmpFile = new File(file.getAbsolutePath() + "~");
            out = new FileOutputStream(file, append);
            out.write(this.dumpMessage(withAttachment));
            File targetFile = new File(file.getAbsolutePath().replaceFirst("~$", ""));
            tmpFile.delete();
            tmpFile.renameTo(targetFile);
        }
        catch (Exception e) {
            throw new Exception(SOSClassUtil.getMethodName() + ": An error occurred on dumping: " + e.toString());
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public final MimeMessage getMimeMessage() {
        return this.mimeMessage;
    }

    private ByteArrayOutputStream messageRemoveAttachments() throws Exception {
        ByteArrayOutputStream raw_email_byte_stream_without_attachment = new ByteArrayOutputStream();
        Object mmpo = this.mimeMessage.getContent();
        if (mmpo instanceof MimeMultipart) {
            MimeMultipart mmp = (MimeMultipart)mmpo;
            if (this.mimeMessage.isMimeType("multipart/*")) {
                mmp = (MimeMultipart)this.mimeMessage.getContent();
                for (int i = 1; i < mmp.getCount(); ++i) {
                    BodyPart part = mmp.getBodyPart(i);
                    mmp.removeBodyPart(i);
                    --i;
                }
            }
            this.mimeMessage.setContent((Multipart)mmp);
        }
        this.mimeMessage.writeTo((OutputStream)raw_email_byte_stream_without_attachment);
        return raw_email_byte_stream_without_attachment;
    }

    public String dumpMessageAsString() throws Exception {
        return this.dumpMessageAsString(false);
    }

    public void dumpMessageToFile(boolean withAttachment, boolean append) throws Exception {
        Date d = new Date();
        StringBuffer bb = new StringBuffer();
        SimpleDateFormat s = new SimpleDateFormat("yyyy-MM-dd.HHmmss.S");
        FieldPosition fp = new FieldPosition(0);
        StringBuffer b = s.format(d, bb, fp);
        this.dumpedFileName = this.queueDir + "sos." + b + ".email";
        File file = new File(this.dumpedFileName);
        while (file.exists()) {
            b = s.format(d, bb, fp);
            this.dumpedFileName = this.queueDir + "/" + "sos." + b + ".email";
            file = new File(this.dumpedFileName);
        }
        this.dumpMessageToFile(file, withAttachment, append);
    }

    public void dumpMessageToFile(String filename, boolean withAttachment, boolean append) throws Exception {
        this.dumpMessageToFile(new File(filename), withAttachment, append);
    }

    public String dumpMessageAsString(boolean withAttachment) throws Exception {
        ByteArrayOutputStream raw_email_byte_stream_without_attachment = null;
        if (!withAttachment) {
            raw_email_byte_stream_without_attachment = this.messageRemoveAttachments();
        }
        this.raw_email_byte_stream = new ByteArrayOutputStream();
        this.mimeMessage.writeTo((OutputStream)this.raw_email_byte_stream);
        byte[] bytes = withAttachment || raw_email_byte_stream_without_attachment == null ? this.raw_email_byte_stream.toByteArray() : raw_email_byte_stream_without_attachment.toByteArray();
        String s = new String(bytes);
        return s;
    }

    public byte[] dumpMessage() throws Exception {
        return this.dumpMessage(true);
    }

    public byte[] dumpMessage(boolean withAttachment) throws Exception {
        ByteArrayOutputStream raw_email_byte_stream_without_attachment = null;
        if (!withAttachment) {
            raw_email_byte_stream_without_attachment = this.messageRemoveAttachments();
        }
        this.raw_email_byte_stream = new ByteArrayOutputStream();
        this.mimeMessage.writeTo((OutputStream)this.raw_email_byte_stream);
        byte[] bytes = withAttachment || raw_email_byte_stream_without_attachment == null ? this.raw_email_byte_stream.toByteArray() : raw_email_byte_stream_without_attachment.toByteArray();
        return bytes;
    }

    public String getQueueDir() {
        return this.queueDir;
    }

    public void setQueueDir(String queueDir) {
        if (!queueDir.endsWith("/")) {
            queueDir = queueDir + "/";
        }
        this.queueDir = queueDir;
    }

    public int incrementHeader(String headerName) throws MessagingException {
        Header header = null;
        int value = -1;
        Enumeration e = this.mimeMessage.getAllHeaders();
        while (e.hasMoreElements()) {
            header = (Header)e.nextElement();
            if (!header.getName().equalsIgnoreCase(headerName) || header.getValue() == null || !header.getValue().trim().matches("^[0-9]+$")) continue;
            this.mimeMessage.setHeader(headerName, "" + (value += Integer.parseInt(header.getValue())));
        }
        return value;
    }

    public void setHeader(String headerName, String HeaderValue) throws MessagingException {
        this.mimeMessage.setHeader(headerName, HeaderValue);
    }

    public String getHeaderValue(String headerName) throws Exception {
        Header header = null;
        Enumeration e = this.mimeMessage.getAllHeaders();
        while (e.hasMoreElements()) {
            header = (Header)e.nextElement();
            if (!header.getName().equalsIgnoreCase(headerName)) continue;
            return header.getValue();
        }
        return null;
    }

    public String getDumpedFileName() {
        return this.dumpedFileName;
    }

    public void setDumpedFileName(String dumpedFileName) {
        this.dumpedFileName = dumpedFileName;
    }

    public String getFirstToRecipient() throws Exception {
        return this.getRecipient("TO", 0);
    }

    public String getToRecipient(int index) throws Exception {
        return this.getRecipient("TO", index);
    }

    public String getFirstCCRecipient() throws Exception {
        return this.getRecipient("CC", 0);
    }

    public String getCCRecipient(int index) throws Exception {
        return this.getRecipient("CC", index);
    }

    public String getFirstBCCRecipient() throws Exception {
        return this.getRecipient("BCC", 0);
    }

    public String getBCCRecipient(int index) throws Exception {
        return this.getRecipient("BCC", index);
    }

    public String getRecipient(String type, int index) throws Exception {
        List<String> l = this.getRecipientAddress(type);
        if (l.size() > index) {
            return l.get(index);
        }
        return "";
    }

    public String getFirstRecipient(String type) throws Exception {
        List<String> l = this.getRecipientAddress(type);
        if (l.size() > 0) {
            return l.get(0);
        }
        return "";
    }
}

