/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import jakarta.persistence.TemporalType;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.compare.CalendarComparator;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractTemporalJavaType;
import org.hibernate.type.descriptor.java.CalendarDateJavaType;
import org.hibernate.type.descriptor.java.CalendarTimeJavaType;
import org.hibernate.type.descriptor.java.ClockHelper;
import org.hibernate.type.descriptor.java.DateJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.MutableMutabilityPlan;
import org.hibernate.type.descriptor.java.TemporalJavaType;
import org.hibernate.type.descriptor.java.VersionJavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;
import org.hibernate.type.spi.TypeConfiguration;

public class CalendarJavaType
extends AbstractTemporalJavaType<Calendar>
implements VersionJavaType<Calendar> {
    public static final CalendarJavaType INSTANCE = new CalendarJavaType();

    protected CalendarJavaType() {
        super(Calendar.class, CalendarMutabilityPlan.INSTANCE, CalendarComparator.INSTANCE);
    }

    @Override
    public TemporalType getPrecision() {
        return TemporalType.TIMESTAMP;
    }

    @Override
    public JdbcType getRecommendedJdbcType(JdbcTypeIndicators context) {
        return context.getJdbcType(93);
    }

    @Override
    protected <X> TemporalJavaType<X> forTimestampPrecision(TypeConfiguration typeConfiguration) {
        return this;
    }

    @Override
    protected <X> TemporalJavaType<X> forDatePrecision(TypeConfiguration typeConfiguration) {
        return CalendarDateJavaType.INSTANCE;
    }

    @Override
    protected <X> TemporalJavaType<X> forTimePrecision(TypeConfiguration typeConfiguration) {
        return CalendarTimeJavaType.INSTANCE;
    }

    @Override
    public String toString(Calendar value) {
        return DateJavaType.INSTANCE.toString(value.getTime());
    }

    @Override
    public Calendar fromString(CharSequence string) {
        GregorianCalendar result = new GregorianCalendar();
        result.setTime(DateJavaType.INSTANCE.fromString(string.toString()));
        return result;
    }

    @Override
    public boolean areEqual(Calendar one, Calendar another) {
        if (one == another) {
            return true;
        }
        if (one == null || another == null) {
            return false;
        }
        return one.get(14) == another.get(14) && one.get(13) == another.get(13) && one.get(12) == another.get(12) && one.get(11) == another.get(11) && one.get(5) == another.get(5) && one.get(2) == another.get(2) && one.get(1) == another.get(1);
    }

    @Override
    public int extractHashCode(Calendar value) {
        int hashCode = 1;
        hashCode = 31 * hashCode + value.get(14);
        hashCode = 31 * hashCode + value.get(13);
        hashCode = 31 * hashCode + value.get(12);
        hashCode = 31 * hashCode + value.get(11);
        hashCode = 31 * hashCode + value.get(5);
        hashCode = 31 * hashCode + value.get(2);
        hashCode = 31 * hashCode + value.get(1);
        return hashCode;
    }

    @Override
    public <X> X unwrap(Calendar value, Class<X> type, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (Calendar.class.isAssignableFrom(type)) {
            return (X)value;
        }
        if (Date.class.isAssignableFrom(type)) {
            return (X)new Date(value.getTimeInMillis());
        }
        if (Time.class.isAssignableFrom(type)) {
            return (X)new Time(value.getTimeInMillis());
        }
        if (Timestamp.class.isAssignableFrom(type)) {
            return (X)new Timestamp(value.getTimeInMillis());
        }
        if (java.util.Date.class.isAssignableFrom(type)) {
            return (X)new java.util.Date(value.getTimeInMillis());
        }
        throw this.unknownUnwrap(type);
    }

    @Override
    public <X> Calendar wrap(X value, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (value instanceof Calendar) {
            return (Calendar)value;
        }
        if (!(value instanceof java.util.Date)) {
            throw this.unknownWrap(value.getClass());
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime((java.util.Date)value);
        return cal;
    }

    @Override
    public boolean isWider(JavaType<?> javaType) {
        switch (javaType.getTypeName()) {
            case "java.util.Date": 
            case "java.sql.Date": 
            case "java.sql.Timestamp": {
                return true;
            }
        }
        return false;
    }

    @Override
    public int getDefaultSqlPrecision(Dialect dialect, JdbcType jdbcType) {
        return dialect.getDefaultTimestampPrecision();
    }

    @Override
    public Calendar next(Calendar current, Long length, Integer precision, Integer scale, SharedSessionContractImplementor session) {
        return this.seed(length, precision, scale, session);
    }

    @Override
    public Calendar seed(Long length, Integer precision, Integer scale, SharedSessionContractImplementor session) {
        return GregorianCalendar.from(ZonedDateTime.now(ClockHelper.forPrecision(precision, session, 3)));
    }

    public static class CalendarMutabilityPlan
    extends MutableMutabilityPlan<Calendar> {
        public static final CalendarMutabilityPlan INSTANCE = new CalendarMutabilityPlan();

        @Override
        public Calendar deepCopyNotNull(Calendar value) {
            return (Calendar)value.clone();
        }
    }
}

