/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.jobs.checkhistory.classes;

import com.sos.commons.exception.SOSException;
import com.sos.js7.job.OrderProcessStepLogger;

public class ParameterResolver {
    private OrderProcessStepLogger logger;
    private static final int EQ = 1;
    private static final int GE = 2;
    private static final int GT = 3;
    private static final int LE = 4;
    private static final int LT = 5;
    private boolean paramStartedFrom = false;
    private boolean paramStartedTo = false;
    private boolean paramCompletedFrom = false;
    private boolean paramCompletedTo = false;
    private boolean paramCount = false;
    private String startedFrom = "0d";
    private String startedTo = "0d";
    private String completedFrom = "0d";
    private String completedTo = "0d";
    protected int countCommand = 0;
    protected int count = 0;

    public ParameterResolver(OrderProcessStepLogger logger) {
        this.logger = logger;
    }

    public void resolveParameter(String parameter) throws SOSException {
        String[] parameters = parameter.split(",");
        this.startedFrom = "0d";
        this.startedTo = "0d";
        this.completedFrom = "0d";
        this.completedTo = "0d";
        if (parameters.length > 0) {
            block16: for (String parameterAssignment : parameters) {
                String[] p = parameterAssignment.split("=");
                String pName = p[0].trim();
                if (pName.startsWith("count")) {
                    pName = "count";
                }
                String pValue = "";
                if (p.length > 1) {
                    pValue = p[1].trim();
                }
                switch (pName.toLowerCase()) {
                    case "startedfrom": {
                        this.paramStartedFrom = true;
                        this.startedFrom = pValue;
                        this.logger.debug((Object)("startedFrom=" + this.startedFrom));
                        continue block16;
                    }
                    case "startedto": {
                        this.paramStartedTo = true;
                        this.startedTo = pValue;
                        this.logger.debug((Object)("startedTo=" + this.startedTo));
                        continue block16;
                    }
                    case "completedfrom": {
                        this.paramCompletedFrom = true;
                        this.completedFrom = pValue;
                        this.logger.debug((Object)("completedFrom=" + this.completedFrom));
                        continue block16;
                    }
                    case "completedto": {
                        this.paramCompletedTo = true;
                        this.completedTo = pValue;
                        this.logger.debug((Object)("completedto=" + this.completedTo));
                        continue block16;
                    }
                    case "count": {
                        try {
                            String[] pEq = parameterAssignment.split("=");
                            String[] pLe = parameterAssignment.split("<=");
                            String[] pLt = parameterAssignment.split("<");
                            String[] pGe = parameterAssignment.split(">=");
                            String[] pGt = parameterAssignment.split(">");
                            if (pEq.length > 1) {
                                this.count = Integer.valueOf(pEq[1]);
                                this.countCommand = 1;
                            }
                            if (pLe.length > 1) {
                                this.count = Integer.valueOf(pLe[1]);
                                this.countCommand = 4;
                            }
                            if (pLt.length > 1) {
                                this.count = Integer.valueOf(pLt[1]);
                                this.countCommand = 5;
                            }
                            if (pGe.length > 1) {
                                this.count = Integer.valueOf(pGe[1]);
                                this.countCommand = 2;
                            }
                            if (pGt.length > 1) {
                                this.count = Integer.valueOf(pGt[1]);
                                this.countCommand = 3;
                            }
                            this.paramCount = true;
                        }
                        catch (NumberFormatException e) {
                            this.logger.info((Object)("Not a valid number:" + pValue));
                            this.count = 0;
                        }
                        this.logger.debug((Object)("completedto=" + this.completedTo));
                        continue block16;
                    }
                    default: {
                        if (pName.isEmpty()) continue block16;
                        throw new SOSException("unknown parameter name: " + pName);
                    }
                }
            }
        }
    }

    public boolean isParamStartedFrom() {
        return this.paramStartedFrom;
    }

    public boolean isParamStartedTo() {
        return this.paramStartedTo;
    }

    public boolean isParamCompletedFrom() {
        return this.paramCompletedFrom;
    }

    public boolean isParamCompletedTo() {
        return this.paramCompletedTo;
    }

    public boolean isParamCount() {
        return this.paramCount;
    }

    public int getCountCommand() {
        return this.countCommand;
    }

    public int getCount() {
        return this.count;
    }

    public String getStartedFrom() {
        return this.startedFrom;
    }

    public String getStartedTo() {
        return this.startedTo;
    }

    public String getCompletedFrom() {
        return this.completedFrom;
    }

    public String getCompletedTo() {
        return this.completedTo;
    }

    public boolean getCountResult(int countHistory, boolean historyResult) throws SOSException {
        boolean result = historyResult;
        if (this.isParamCount() && historyResult) {
            switch (this.getCountCommand()) {
                case 1: {
                    result = countHistory == this.count;
                    break;
                }
                case 2: {
                    result = countHistory >= this.count;
                    break;
                }
                case 3: {
                    result = countHistory > this.count;
                    break;
                }
                case 4: {
                    result = countHistory <= this.count;
                    break;
                }
                case 5: {
                    result = countHistory < this.count;
                    break;
                }
                default: {
                    throw new SOSException("unknown operator in count parameter");
                }
            }
        }
        return result;
    }
}

