/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.jobs.db.oracle;

import com.sos.commons.credentialstore.CredentialStoreArguments;
import com.sos.commons.util.SOSShell;
import com.sos.commons.util.common.ASOSArguments;
import com.sos.commons.util.common.SOSArgumentHelper;
import com.sos.js7.job.JobArgument;
import com.sos.js7.job.JobArguments;
import com.sos.js7.job.exception.JobRequiredArgumentMissingException;

public class SQLPlusJobArguments
extends JobArguments {
    private JobArgument<String> shellCommand = new JobArgument("shell_command", false, (Object)"sqlplus");
    private JobArgument<String> ignoreOraMessages = new JobArgument("ignore_ora_messages", false, (Object)"");
    private JobArgument<String> ignoreSp2Messages = new JobArgument("ignore_sp2_messages", false, (Object)"");
    private JobArgument<String> commandScriptFile = new JobArgument("command_script_file", false, (Object)"");
    private JobArgument<String> command = new JobArgument("command", false, (Object)"");
    private JobArgument<Integer> timeout = new JobArgument("timeout", false, (Object)0);
    private JobArgument<String> commandLineOptions = new JobArgument("command_line_options", false, (Object)"");
    private JobArgument<String> includeFiles = new JobArgument("include_files", false, (Object)"");
    private JobArgument<String> sqlError = new JobArgument("sql_error", false);
    private JobArgument<String> dbPassword = new JobArgument("db_password", false, SOSArgumentHelper.DisplayMode.MASKED);
    private JobArgument<String> dbUser = new JobArgument("db_user", false);
    private JobArgument<String> dbUrl = new JobArgument("db_url", false);
    private JobArgument<String> variableParserRegExpr = new JobArgument("variable_parser_reg_expr", false, (Object)"^SET\\s+([^\\s]+)\\s*IS\\s+(.*)$");

    public SQLPlusJobArguments() {
        super(new ASOSArguments[]{new CredentialStoreArguments()});
    }

    public String getVariableParserRegExpr() {
        return (String)this.variableParserRegExpr.getValue();
    }

    public void setVariableParserRegExpr(String variableParserRegExpr) {
        this.variableParserRegExpr.setValue((Object)variableParserRegExpr);
    }

    public JobArgument<String> getDbPassword() {
        return this.dbPassword;
    }

    public void setDbPassword(String dbPassword) {
        this.dbPassword.setValue((Object)dbPassword);
    }

    public String getDbUrl() {
        return (String)this.dbUrl.getValue();
    }

    public void setDbUrl(String dbUrl) {
        this.dbUrl.setValue((Object)dbUrl);
    }

    public String getDbUser() {
        return (String)this.dbUser.getValue();
    }

    public void setDbUser(String dbUser) {
        this.dbUser.setValue((Object)dbUser);
    }

    public String getShellCommand() {
        return (String)this.shellCommand.getValue();
    }

    public void setShellCommand(String shellCommand) {
        this.shellCommand.setValue((Object)shellCommand);
    }

    public Integer getTimeout() {
        return (Integer)this.timeout.getValue();
    }

    public void setTimeout(Integer timeout) {
        this.timeout.setValue((Object)timeout);
    }

    public String getIgnoreOraMessages() {
        return (String)this.ignoreOraMessages.getValue();
    }

    public void setIgnoreOraMessages(String ignoreOraMessages) {
        this.ignoreOraMessages.setValue((Object)ignoreOraMessages);
    }

    public String getIgnoreSp2Messages() {
        return (String)this.ignoreSp2Messages.getValue();
    }

    public void setIgnoreSp2Messages(String ignoreSp2Messages) {
        this.ignoreSp2Messages.setValue((Object)ignoreSp2Messages);
    }

    public String getCommandScriptFile() {
        return (String)this.commandScriptFile.getValue();
    }

    public void setCommandScriptFile(String commandScriptFile) {
        this.commandScriptFile.setValue((Object)commandScriptFile);
    }

    public String getCommandLineOptions() {
        return (String)this.commandLineOptions.getValue();
    }

    public void setCommandLineOptions(String commandLineOptions) {
        this.commandLineOptions.setValue((Object)commandLineOptions);
    }

    public String getIncludeFiles() {
        return (String)this.includeFiles.getValue();
    }

    public void setIncludeFiles(String includeFiles) {
        this.includeFiles.setValue((Object)includeFiles);
    }

    public String getSqlError() {
        return (String)this.sqlError.getValue();
    }

    public void setSqlError(String sqlError) {
        this.sqlError.setValue((Object)sqlError);
    }

    public String getCommand() {
        return (String)this.command.getValue();
    }

    public void setCommand(String command) {
        this.command.setValue((Object)command);
    }

    public String getConnectionString() {
        Object connectionString = "";
        connectionString = this.getDbUser() != null && !this.getDbUser().isEmpty() ? this.getDbUser() + "/" + (String)this.getDbPassword().getValue() + "@" + this.getDbUrl() : "/@" + this.getDbUrl();
        return connectionString;
    }

    private String getCommandParams(String tempFileName) {
        Object commandParams = "";
        String dbConnectionString = this.getConnectionString();
        if (!dbConnectionString.isEmpty()) {
            commandParams = (String)commandParams + " " + dbConnectionString;
        }
        commandParams = (String)commandParams + " @" + tempFileName;
        return commandParams;
    }

    public String getCommandLine(String tempFileName) {
        Object shellCommand = this.getShellCommand();
        if (SOSShell.IS_WINDOWS) {
            shellCommand = "echo 1 | " + (String)shellCommand;
        }
        if (!this.getCommandLineOptions().isEmpty()) {
            shellCommand = (String)shellCommand + " " + this.getCommandLineOptions();
        }
        return (String)shellCommand + " " + this.getCommandParams(tempFileName);
    }

    public String getCommandLineForLog(String tempFileName) {
        String savPassword = (String)this.getDbPassword().getValue();
        this.setDbPassword(this.getDbPassword().getDisplayValue());
        String commandLine = this.getCommandLine(tempFileName);
        this.setDbPassword(savPassword);
        return commandLine;
    }

    public void checkRequired() throws JobRequiredArgumentMissingException {
        if ((this.command.getValue() == null || ((String)this.command.getValue()).isEmpty()) && (this.commandScriptFile.getValue() == null || ((String)this.commandScriptFile.getValue()).isEmpty())) {
            throw new JobRequiredArgumentMissingException(this.command.getName() + " or " + this.commandScriptFile.getName());
        }
        if (this.shellCommand.getValue() == null || ((String)this.shellCommand.getValue()).isEmpty()) {
            throw new JobRequiredArgumentMissingException(this.dbUrl.getName());
        }
        if (this.dbUrl.getValue() == null || ((String)this.dbUrl.getValue()).isEmpty()) {
            throw new JobRequiredArgumentMissingException(this.dbUrl.getName());
        }
        if ((this.dbUser.getValue() == null || ((String)this.dbUser.getValue()).isEmpty()) && this.dbPassword.getValue() != null && !((String)this.dbPassword.getValue()).isEmpty()) {
            throw new JobRequiredArgumentMissingException(this.dbUser.getName());
        }
    }
}

