/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.jobs.examples;

import com.sos.commons.credentialstore.CredentialStoreArguments;
import com.sos.commons.util.SOSString;
import com.sos.commons.util.common.SOSCommandResult;
import com.sos.commons.util.common.logger.ISOSLogger;
import com.sos.commons.vfs.ssh.SSHProvider;
import com.sos.commons.vfs.ssh.common.SSHProviderArguments;
import com.sos.jitl.jobs.ssh.SSHJobArguments;
import com.sos.js7.job.Job;
import com.sos.js7.job.OrderProcessStep;
import java.util.List;

public class SSHJob
extends Job<SSHJobArguments> {
    public void processOrder(OrderProcessStep<SSHJobArguments> step) throws Exception {
        SSHProviderArguments providerArgs = (SSHProviderArguments)step.getIncludedArguments(SSHProviderArguments.class);
        if (providerArgs != null) {
            providerArgs.setCredentialStore((CredentialStoreArguments)step.getIncludedArguments(CredentialStoreArguments.class));
        }
        SSHProvider provider = new SSHProvider((ISOSLogger)step.getLogger(), providerArgs);
        step.addCancelableResource(provider);
        try {
            provider.connect();
            if (!((SSHJobArguments)step.getDeclaredArguments()).getCommand().isEmpty()) {
                this.executeCommand(provider, step);
            }
            Integer testExitCode = 0;
            if (((SSHJobArguments)step.getDeclaredArguments()).getExitCodesToIgnore().getValue() != null) {
                step.getLogger().info((Object)("[getExitCodesToIgnore.size=]" + ((List)((SSHJobArguments)step.getDeclaredArguments()).getExitCodesToIgnore().getValue()).size()));
                for (Object o : (List)((SSHJobArguments)step.getDeclaredArguments()).getExitCodesToIgnore().getValue()) {
                    step.getLogger().info((Object)("[getExitCodesToIgnore]" + o.getClass() + "=" + o));
                }
                step.getLogger().info((Object)("[getExitCodesToIgnore.contains(" + testExitCode + ")]" + ((List)((SSHJobArguments)step.getDeclaredArguments()).getExitCodesToIgnore().getValue()).contains(testExitCode)));
            }
        }
        catch (Throwable e) {
            throw e;
        }
        finally {
            if (provider != null) {
                provider.disconnect();
            }
        }
    }

    private void executeCommand(SSHProvider provider, OrderProcessStep<SSHJobArguments> step) {
        step.getLogger().info("[execute command]%s", new Object[]{((SSHJobArguments)step.getDeclaredArguments()).getCommand().getDisplayValue()});
        SOSCommandResult r = provider.executeCommand((String)((SSHJobArguments)step.getDeclaredArguments()).getCommand().getValue());
        step.getLogger().info("[exitCode]%s", new Object[]{r.getExitCode()});
        if (!SOSString.isEmpty((String)r.getStdOut())) {
            step.getLogger().info("[stdOut]%s", new Object[]{r.getStdOut()});
        }
        if (!SOSString.isEmpty((String)r.getStdErr())) {
            step.getLogger().info("[stdErr]%s", new Object[]{r.getStdErr()});
        }
        if (r.getException() != null) {
            step.getLogger().info("[exception]%s", new Object[]{r.getException()});
        }
    }
}

